/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.message.IMsgSendRecord;
import com.kingdee.eas.base.message.MsgSendRecordFactory;
import com.kingdee.eas.base.message.MsgSendRecordInfo;
import com.kingdee.eas.base.message.client.AbstractMsgSendRecordUI;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class MsgSendRecordUI
extends AbstractMsgSendRecordUI {
    private static final Logger logger = CoreUIObject.getLogger(MsgSendRecordUI.class);
    MsgSendRecordInfo msrInfo;
    AttachmentClientManager aManager = null;
    private Border border;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setOprtState(OprtState.VIEW);
        this.initUIData();
        this.initAttachment();
        this.initProperty();
        this.border = this.msgContent.getBorder();
        this.msgContent.setBorder(null);
        this.kDScrollPane1.setBorder(KingdeeBorders.createEditorBorder());
    }

    private void initProperty() {
        this.msgContent.setEditable(false);
        this.msgTitle.setEditable(false);
        this.priorityComboBox.setEnabled(false);
    }

    private void initUIData() {
        String id = this.getUIContext().get("ID").toString();
        IMsgSendRecord iMsgSendRecord = null;
        try {
            iMsgSendRecord = (IMsgSendRecord)this.getBizInterface();
            this.msrInfo = iMsgSendRecord.getSendInfo(id);
            this.receiversText.setText(this.msrInfo.getReciever());
            this.priorityComboBox.setSelectedItem((Object)this.msrInfo.getPriority());
            this.msgTitle.setText(this.msrInfo.getTitle());
            this.msgContent.setText(this.msrInfo.getBody());
        }
        catch (Exception e) {
            logger.error((Object)"initUIData failed!", (Throwable)e);
        }
    }

    private void initAttachment() {
        AttachmentUIContextInfo info = new AttachmentUIContextInfo();
        info.setBoID(this.msrInfo.getId().toString());
        if (this.getOprtState() == OprtState.VIEW) {
            info.setEdit(false);
            int attachCount = 0;
            try {
                attachCount = BoAttchAssoFactory.getRemoteInstance().getAttchCountByBoID(this.msrInfo.getId().toString());
            }
            catch (BOSException e1) {
                logger.error((Object)"\u83b7\u5f97\u9644\u4ef6\u6570\u91cf\u62a5\u9519", (Throwable)e1);
            }
            if (attachCount > 0) {
                this.aManager = new AttachmentClientManager();
                try {
                    this.aManager.showAttachInContainter(this.attContainer, info);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else {
                this.cancel.setBounds(new Rectangle(516, 224, 73, 21));
                this.add((Component)this.cancel, new KDLayout.Constraints(516, 224, 73, 21, 0));
                this.kDSeparator2.setBounds(new Rectangle(5, 212, 590, 11));
                this.add((Component)this.kDSeparator2, new KDLayout.Constraints(5, 212, 590, 11, 0));
                this.setPreferredSize(new Dimension(600, 250));
                this.attContainer.setVisible(false);
            }
        } else {
            info.setEdit(true);
            boolean hasAttachPerm = false;
            try {
                IPermission iPermission = PermissionFactory.getRemoteInstance();
                String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                hasAttachPerm = iPermission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(userid), (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId()), "bs_message_attach");
            }
            catch (Exception e) {
                logger.error((Object)"\u83b7\u5f97\u6d88\u606f\u4e2d\u5fc3\u53d1\u9001\u9644\u4ef6\u6743\u9650\u62a5\u9519", (Throwable)e);
            }
            if (hasAttachPerm) {
                this.aManager = new AttachmentClientManager();
                try {
                    this.aManager.showAttachInContainter(this.attContainer, info);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else {
                this.cancel.setBounds(new Rectangle(516, 224, 73, 21));
                this.add((Component)this.cancel, new KDLayout.Constraints(516, 224, 73, 21, 0));
                this.kDSeparator2.setBounds(new Rectangle(5, 212, 590, 11));
                this.add((Component)this.kDSeparator2, new KDLayout.Constraints(5, 212, 590, 11, 0));
                this.setPreferredSize(new Dimension(600, 250));
                this.attContainer.setVisible(false);
            }
        }
    }

    @Override
    protected void cancel_actionPerformed(ActionEvent e) throws Exception {
        super.cancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MsgSendRecordFactory.getRemoteInstance();
    }

    @Override
    protected void msgContent_focusGained(FocusEvent e) throws Exception {
        this.kDScrollPane1.setBorder(this.border);
    }

    @Override
    protected void msgContent_focusLost(FocusEvent e) throws Exception {
        this.kDScrollPane1.setBorder(KingdeeBorders.createEditorBorder());
    }
}

