/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfoSelector;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.attachment.util.VariousAttachmentInfoMaker;
import com.kingdee.eas.base.forewarn.OrgUserInfo;
import com.kingdee.eas.base.message.EmailInfo;
import com.kingdee.eas.base.message.IMessageCenter;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.message.client.AbstractSendEmailUI;
import com.kingdee.eas.base.message.client.ReceiversListUI;
import com.kingdee.eas.base.message.util.MessageInputUtils;
import com.kingdee.eas.base.message.util.PersonItem;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.receiver.BasReleaseInfo;
import com.kingdee.eas.base.receiver.IReceiversFacade;
import com.kingdee.eas.base.receiver.ReceiversFacadeFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SendEmailUI
extends AbstractSendEmailUI {
    private String resource = "com.kingdee.eas.base.message.client.MessageCenter";
    private static final Logger logger = CoreUIObject.getLogger(SendEmailUI.class);
    private Map map = new HashMap();
    protected IUIWindow currOrgTreeDialog;
    Map ctx = new HashMap();
    private final int DEFAULTATTACHS = 9;
    private BOSUuid emailBosID;
    private static final long serialVersionUID = 3247896926679380322L;
    private BasReleaseInfo receiverInfo = null;
    private BasReleaseInfo senderInfo = null;
    private MessageInputUtils miu1 = new MessageInputUtils();
    private MessageInputUtils miu2 = new MessageInputUtils();
    public static String RECEIVER_INFO = "receiverInfo";
    private KDTree orgTree;

    public SendEmailUI() throws Exception {
        this.getUIContext().put("receivers", "");
        this.getUIContext().put("receivers_sec", "");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtReceiver1.setRequired(true);
        if (this.receiverInfo == null) {
            this.receiverInfo = new BasReleaseInfo();
        }
        this.miu1.initData(this.txtReceiver1, this.receiverInfo);
        this.miu1.setUserPhoneOrMail(true);
        if (this.senderInfo == null) {
            this.senderInfo = new BasReleaseInfo();
        }
        this.miu2.initData(this.txtReceiver2, this.senderInfo);
        this.miu2.setUserPhoneOrMail(true);
        if (this.email == null) {
            this.email = new EmailInfo();
        }
        this.emailBosID = this.email.getId();
        if (this.emailBosID == null) {
            this.emailBosID = BOSUuid.create((BOSObjectType)this.email.getBOSType());
        }
        this.ctx.put("All_Admins", "YES");
        Object obj = this.getUIContext().get("attachs");
        if (obj != null && obj instanceof File[]) {
            File[] attachs = (File[])obj;
            int num = attachs.length;
            for (int i = 0; i < num; ++i) {
                this.map.put(attachs[i].getName(), attachs[i]);
            }
        }
        this.initAttachmentPanel();
        this.btnSendEmail.setIcon(EASResource.getIcon((String)"imgTbtn_send"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void loadRcrAndRcr_sec() {
        String receivers = this.txtReceiver1.getText().trim();
        if (!receivers.equals("")) {
            String subStr = receivers.substring(receivers.length() - 1);
            if (subStr.equals(";")) {
                this.txtReceiver1.setText(receivers + this.getUIContext().get("receivers").toString());
            } else {
                this.txtReceiver1.setText(receivers + ";" + this.getUIContext().get("receivers").toString());
            }
        } else {
            this.txtReceiver1.setText(this.getUIContext().get("receivers").toString());
        }
        String receivers_sec = this.txtReceiver2.getText().trim();
        if (!receivers_sec.equals("")) {
            String subStr = receivers_sec.substring(receivers_sec.length() - 1);
            if (subStr.equals(";")) {
                this.txtReceiver2.setText(receivers_sec + this.getUIContext().get("receivers_sec").toString());
            } else {
                this.txtReceiver2.setText(receivers_sec + ";" + this.getUIContext().get("receivers_sec").toString());
            }
        } else {
            this.txtReceiver2.setText(this.getUIContext().get("receivers_sec").toString());
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionAddAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentManagerFactory.getClientManager().showAttachmentListUIByBoID(this.emailBosID.toString(), (Object)this);
        this.initAttachmentPanel();
    }

    @Override
    protected void btnReceiver1_actionPerformed(ActionEvent e) throws Exception {
        this.miu1.showReceiverUI((Object)this);
    }

    @Override
    protected void btnReceiver2_actionPerformed(ActionEvent e) throws Exception {
        this.miu2.showReceiverUI((Object)this);
    }

    private IUIWindow getReceiversListUIInstance(BasReleaseInfo info) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)RECEIVER_INFO, (Object)info);
        uiContext.put((Object)"NewSendEmailUI", (Object)"");
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ReceiversListUI.class.getName(), (Map)uiContext, null, null);
        return window;
    }

    public String filter(String str1, String str2) {
        int i;
        String[] strArray1 = str1.split(";");
        String[] strArray2 = str2.split(";");
        HashMap hashMap = new HashMap();
        int size = strArray1.length;
        for (i = 0; i < size; ++i) {
            hashMap.put(strArray1[i], null);
        }
        size = strArray2.length;
        for (i = 0; i < size; ++i) {
            hashMap.containsKey(strArray2[i]);
            hashMap.remove(strArray2[i]);
        }
        Iterator ids = hashMap.keySet().iterator();
        str1 = "";
        while (ids.hasNext()) {
            str1 = str1 + (String)ids.next() + ";";
        }
        return str1;
    }

    private Map parseInputTxt(String[] txtNames) {
        HashMap map = new HashMap();
        KDTree tempOrgTree = this.getOrgTree();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tempOrgTree.getModel().getRoot();
        this.deepViewOrgTreeWithInputText(root, Arrays.asList(txtNames), map);
        return map;
    }

    private void deepViewOrgTreeWithInputText(DefaultKingdeeTreeNode node, List inputList, Map map) {
        this.isSelectedNode(node, inputList, map);
        Enumeration children = node.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)children.nextElement();
            this.isSelectedNode(tempNode, inputList, map);
            if (tempNode.isLeaf()) continue;
            this.deepViewOrgTreeWithInputText(tempNode, inputList, map);
        }
    }

    private void isSelectedNode(DefaultKingdeeTreeNode node, List inputList, Map map) {
        logger.info((Object)("=" + node.getUserObject().getClass()));
        OrgUserInfo info = this.createOrgUserInfo(node);
        if (info != null && inputList.contains(info.getOrgUserName())) {
            map.put(info.getOrgUserName(), info);
        }
    }

    private OrgUserInfo createOrgUserInfo(DefaultKingdeeTreeNode node) {
        Object object = node.getUserObject();
        if (object instanceof OrgStructureInfo) {
            OrgStructureInfo orgInfo = (OrgStructureInfo)object;
            OrgUserInfo info = new OrgUserInfo();
            info.setOrgUserID(orgInfo.getUnit().getId().toString());
            info.setUserOrOrg("0");
            info.setOrgUserName(orgInfo.getUnit().getName());
            return info;
        }
        if (object instanceof PersonItem) {
            PersonItem personInfo = (PersonItem)((Object)object);
            OrgUserInfo info = new OrgUserInfo();
            info.setUserOrOrg("1");
            info.setOrgUserID(personInfo.getId().toString());
            info.setOrgUserName(personInfo.getName_l2());
            return info;
        }
        return null;
    }

    private String getLongNumberByOrgUnitID(String orgID, IFullOrgUnit fullOrgUnit) {
        FullOrgUnitInfo info = null;
        try {
            info = fullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
        }
        catch (BOSException e) {
            logger.error((Object)"getLongNumberByOrgUnitID failed", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"getLongNumberByOrgUnitID failed", (Throwable)e);
        }
        return info.getLongNumber();
    }

    private FullOrgUnitCollection getAllSubOrgIDByLongNumber(String longNumber, IFullOrgUnit fullOrgUnit) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        FullOrgUnitCollection col = null;
        try {
            col = fullOrgUnit.getFullOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)"getAllSubOrgIDByLongNumber failed", (Throwable)e);
        }
        return col;
    }

    private String getReceiversByOrgIDs(FullOrgUnitCollection col, IUser user) {
        StringBuffer strBuffer = new StringBuffer();
        int num = col.size();
        for (int i = 0; i < num; ++i) {
            FullOrgUnitInfo info = col.get(i);
            String orgID = info.getId().toString();
            this.getReceiversByOrgIDs(orgID, strBuffer, user);
        }
        return strBuffer.toString();
    }

    private String getReceiversByOrgIDs(String orgID, StringBuffer strBuffer, IUser user) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("defOrgUnit", (Object)orgID, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        UserCollection col = null;
        try {
            col = user.getUserCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)"getReceiversByOrgIDs failed", (Throwable)e);
        }
        int num = col.size();
        for (int i = 0; i < num; ++i) {
            UserInfo info = col.get(i);
            strBuffer.append(info.getName());
            strBuffer.append(";");
        }
        return strBuffer.toString();
    }

    private String getReceivers(Map map, String[] txtNames) throws BOSException {
        IFullOrgUnit fullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        IUser user = UserFactory.getRemoteInstance();
        StringBuffer strBuffer = new StringBuffer();
        for (String key : txtNames) {
            Object val = map.get(key);
            if (val == null) {
                if (this.isEmailAddress(key)) continue;
                strBuffer.append(key);
                strBuffer.append(";");
                continue;
            }
            OrgUserInfo info = (OrgUserInfo)val;
            String flag = info.getUserOrOrg();
            if (flag.equals("1")) {
                strBuffer.append(key);
                strBuffer.append(";");
                continue;
            }
            if (!flag.equals("0")) continue;
            String longNumber = this.getLongNumberByOrgUnitID(info.getOrgUserID(), fullOrgUnit);
            strBuffer.append(this.getReceiversByOrgIDs(this.getAllSubOrgIDByLongNumber(longNumber, fullOrgUnit), user));
        }
        return strBuffer.toString();
    }

    private boolean isEmailAddress(String inputStr) {
        int index = inputStr.indexOf("@");
        return index > 0;
    }

    private String getNoMailPerson(Set set) {
        Object[] ob = null;
        if (set != null) {
            ob = set.toArray();
        }
        if (ob == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ob.length; ++i) {
            if (i == 0) {
                sb.append(ob[i]).append("\u3001");
                continue;
            }
            if (i == ob.length) {
                sb.append(ob[i]).append("\u3002");
                continue;
            }
            sb.append(ob[i]).append("\u3001");
        }
        return sb.toString();
    }

    private String getMail(Set set) {
        Object[] ob = null;
        if (set != null) {
            ob = set.toArray();
        }
        if (ob == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ob.length; ++i) {
            sb.append(ob[i]).append(";");
        }
        return sb.toString();
    }

    @Override
    public void actionSendEmail_actionPerformed(ActionEvent e) throws Exception {
        String emailContent;
        IMessageCenter messageCenter = MessageCenterFactory.getRemoteInstance();
        String txtReceiver1 = this.txtReceiver1.getText().trim();
        String txtReceiver2 = this.txtReceiver1.getText().trim();
        if (StringUtils.isEmpty((String)txtReceiver1) && StringUtils.isEmpty((String)txtReceiver2)) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"mailrecnotnull"));
            this.txtReceiver1.requestFocus();
            return;
        }
        Iterator itr = this.map.keySet().iterator();
        while (itr.hasNext()) {
            this.addAttachFromOrg((File)this.map.get(itr.next()));
        }
        this.map.clear();
        String[] attachmentIDs = AttachmentManagerFactory.getClientManager().getAttachmentIDsByBoID(this.emailBosID.toString());
        String emailTitle = this.kdEmailTitle.getText();
        if (emailTitle == null || emailTitle.equals("")) {
            emailTitle = "";
        }
        if ((emailContent = this.kdEmailContent.getText()) == null || emailContent.equals("")) {
            emailContent = "";
        }
        IReceiversFacade irf = ReceiversFacadeFactory.getRemoteInstance();
        Set reSet1 = irf.getHaveNoMail(this.receiverInfo);
        Set reSet2 = irf.getHaveNoMail(this.senderInfo);
        String str1 = this.getNoMailPerson(reSet1);
        String str2 = this.getNoMailPerson(reSet2);
        if (!StringUtils.isEmpty((String)str1)) {
            MsgBox.showInfo((String)(EASResource.getString((String)this.resource, (String)"mail_rec_1_null_mail") + " " + str1));
        }
        if (!StringUtils.isEmpty((String)str2)) {
            MsgBox.showInfo((String)(EASResource.getString((String)this.resource, (String)"mail_rec_2_null_mail") + " " + str2));
        }
        String receiver1 = this.getMail(irf.getMailByReleaseInfo(this.receiverInfo)) + this.getMail(this.miu1.getPhoneNumberOrMail());
        String receiver2 = this.getMail(irf.getMailByReleaseInfo(this.senderInfo)) + this.getMail(this.miu2.getPhoneNumberOrMail());
        try {
            if (messageCenter.sendEmail(emailTitle, emailContent, receiver1, receiver2, attachmentIDs)) {
                MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"send_success"));
                this.getUIWindow().close();
            }
        }
        catch (EASBizException ex) {
            MsgBox.showInfo((String)EASResource.getString((String)this.resource, (String)"connection_error"));
        }
    }

    private void addAttachFromOrg(File file) throws Exception {
        String fullname = file.getName();
        String mainname = StringUtil4File.getMainFileName((String)fullname);
        String extname = StringUtil4File.getExtendedFileName((String)fullname);
        byte[] content = FileGetter.getBytesFromFile((File)file);
        SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
        sai.setMainName(mainname);
        sai.setExtName(extname);
        sai.setContent(content);
        IAttachment attachment = AttachmentFactory.getRemoteInstance();
        AttachmentInfo attachmentInfo = VariousAttachmentInfoMaker.makeAttachmentInfo((IAttachment)attachment, (String)this.emailBosID.toString(), (SimpleAttachmentInfo)sai);
        attachment.addnew(attachmentInfo).toString();
    }

    private void initAttachmentPanel() {
        int i;
        String fileName;
        KDLabelContainer lalName;
        int n = 0;
        ComplexAttachmentInfo[] attachInfos = null;
        try {
            String[] attachIDs = AttachmentManagerFactory.getClientManager().getAttachmentIDsByBoID(this.emailBosID.toString());
            n = attachIDs.length;
            attachInfos = new ComplexAttachmentInfo[n];
            ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
            cais.needMainName();
            cais.needExtName();
            cais.needID();
            for (int i2 = 0; i2 < n; ++i2) {
                attachInfos[i2] = AttachmentManagerFactory.getClientManager().getComplexAttachmentInfo(attachIDs[i2], cais);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.kdEmailAttachmentPanel.setLayout((LayoutManager)new FlowLayout(0));
        this.kdEmailAttachmentPanel.removeAll();
        int num = this.map.size();
        if (num != 0) {
            Iterator itr = this.map.keySet().iterator();
            int i3 = 0;
            while (itr.hasNext()) {
                lalName = new KDLabelContainer();
                String tempFileName = itr.next().toString();
                fileName = i3 + 1 + "." + tempFileName;
                lalName.setMaximumSize(new Dimension(fileName.length() * 8, 19));
                lalName.setPreferredSize(new Dimension(fileName.length() * 8, 19));
                lalName.setName(tempFileName);
                lalName.setBoundLabelText(fileName);
                lalName.setBoundLabelLength(fileName.length() * 2);
                lalName.setBoundLabelUnderline(true);
                lalName.getBoundLabel().addMouseListener(new MyMouseListener((Component)((Object)this)));
                this.kdEmailAttachmentPanel.add((Component)lalName);
                ++i3;
            }
        }
        for (i = 0; i < n; ++i) {
            lalName = new KDLabelContainer();
            fileName = num + i + 1 + "." + attachInfos[i].getMainName();
            if (!StringUtils.isEmpty((String)attachInfos[i].getExtName())) {
                fileName = fileName + "." + attachInfos[i].getExtName();
            }
            lalName.setMaximumSize(new Dimension(fileName.length() * 8, 19));
            lalName.setPreferredSize(new Dimension(fileName.length() * 8, 19));
            lalName.setName(attachInfos[i].getId());
            lalName.setToolTipText(attachInfos[i].getMainName() + " " + attachInfos[i].getDescription());
            lalName.setBoundLabelText(fileName);
            lalName.setBoundLabelLength(fileName.length() * 2);
            lalName.setBoundLabelUnderline(true);
            lalName.getBoundLabel().addMouseListener(new MyMouseListener((Component)((Object)this)));
            this.kdEmailAttachmentPanel.add((Component)lalName);
        }
        for (i = n; i < 9; ++i) {
            lalName = new KDLabelContainer();
            this.kdEmailAttachmentPanel.add((Component)lalName);
        }
        this.kdEmailAttachmentPanel.revalidate();
    }

    private void _setCursor(Component cp, Cursor cursor) {
        cp.setCursor(cursor);
        if (cp instanceof Container) {
            Container cc = (Container)cp;
            int n = cc.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component curComponent = cc.getComponent(i);
                if (!curComponent.isFocusable()) continue;
                this._setCursor(curComponent, cursor);
            }
        }
    }

    private String extractEmailAddress(String txtReceiver) {
        if (txtReceiver == null || txtReceiver.equals("")) {
            return "";
        }
        StringBuffer strBuffer = new StringBuffer();
        String[] array = txtReceiver.split(";");
        int num = array.length;
        for (int i = 0; i < num; ++i) {
            if (array[i].indexOf("@") <= 0) continue;
            strBuffer.append(array[i]);
            strBuffer.append(";");
        }
        return strBuffer.toString();
    }

    public KDTree getOrgTree() {
        if (this.orgTree == null) {
            try {
                IUIWindow window = this.getReceiversListUIInstance(new BasReleaseInfo());
                ReceiversListUI receiversListUI = (ReceiversListUI)window.getUIObject();
            }
            catch (Exception e) {
                logger.error((Object)"getOrgTree failed", (Throwable)e);
            }
        }
        return this.orgTree;
    }

    public void setOrgTree(KDTree orgTree) {
        this.orgTree = orgTree;
    }

    class MyMouseListener
    extends MouseAdapter {
        Component owner;

        public MyMouseListener(Component owner) {
            this.owner = owner;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SendEmailUI.this._setCursor(this.owner, Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SendEmailUI.this._setCursor(this.owner, Cursor.getPredefinedCursor(0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            SendEmailUI.this._setCursor(this.owner, Cursor.getPredefinedCursor(3));
            OutputStreamWriter writer = null;
            try {
                if (e.getButton() == 1 && e.getComponent() != null && e.getComponent().getParent() instanceof KDLabelContainer) {
                    KDLabelContainer con = (KDLabelContainer)e.getComponent().getParent();
                    StringBuffer fileName = new StringBuffer();
                    if (SendEmailUI.this.map.keySet().contains(con.getName())) {
                        File memoryFile = (File)SendEmailUI.this.map.get(con.getName());
                        fileName.append("start /d \"");
                        fileName.append(memoryFile.getParent());
                        fileName.append("\" ");
                        fileName.append(memoryFile.getName());
                    } else {
                        fileName.append("start ");
                        fileName.append(AttachmentManagerFactory.getClientManager().downloadAttachment(con.getName()));
                    }
                    File batCommandFile = File.createTempFile("temp", ".bat");
                    writer = new FileWriter(batCommandFile);
                    writer.write(fileName.toString());
                    Runtime.getRuntime().exec(batCommandFile.getPath());
                }
            }
            catch (Exception es) {
                logger.error((Object)"mouseClicked failed", (Throwable)es);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e1) {
                        logger.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                }
                SendEmailUI.this._setCursor(this.owner, Cursor.getPredefinedCursor(0));
            }
        }
    }
}

