/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.exception.ActivityIsNotRunningException;
import com.kingdee.bos.workflow.exception.AlreadySuspendedException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.message.IWebViewMessageFacade;
import com.kingdee.eas.base.message.WebViewMessageFacadeFactory;
import com.kingdee.eas.base.message.client.AbstractUndisposeTaskListUI;
import com.kingdee.eas.base.message.client.MessageUtil;
import com.kingdee.eas.base.uiframe.client.NewWinMainUI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.sso.SSOHandleFacadeFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class UndisposeTaskListUI
extends AbstractUndisposeTaskListUI {
    private static final Logger logger = CoreUIObject.getLogger(UndisposeTaskListUI.class);
    private static final String SOURCEID_NAME = "sourceID";
    private static final String RESOURCE = "com.kingdee.eas.base.message.client.MessageCenter";
    private int oldSelectedRowIndex = -1;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
    }

    private void initTable() {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    if (e.getSelectBlock() != null) {
                        UndisposeTaskListUI.this.oldSelectedRowIndex = e.getSelectBlock().getBeginRow();
                    }
                }
                catch (Exception exc) {
                    UndisposeTaskListUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        } else if (e.getType() == 1) {
            if (this.tblMain.getSelectManager().get() == null) {
                return;
            }
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                this.disposeTask();
            }
        }
    }

    private void disposeTask() {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList != null) {
            if (idList.size() == 1) {
                try {
                    int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
                    String sourceId = this.tblMain.getRow(rowIndex).getCell(SOURCEID_NAME).getValue().toString();
                    AssignmentInfo info = (AssignmentInfo)ActionCache.get((Object)"WfAssignmentInfo");
                    if (info == null) {
                        IEnactmentService wfService = EnactmentServiceFactory.createRemoteEnactService();
                        info = wfService.getAssignmentById(sourceId);
                    }
                    if (info.getBizObjectIdArray() != null) {
                        String billID = info.getBizObjectIdArray()[0];
                        if (StringUtils.isEmpty((String)billID)) {
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"noBillOrDeleted"));
                            return;
                        }
                        boolean webSupportOnly = MessageUtil.isWebSupportOnly(billID);
                        if (!webSupportOnly) {
                            boolean ifRefresh = MessageUtil.showBusinessUINew(this.getWorkflowClient(), sourceId, (Object)this);
                            if (ifRefresh) {
                                this.tblMain.refresh();
                                this.selectNextMsg(this.oldSelectedRowIndex, this.tblMain);
                                this.oldSelectedRowIndex = -1;
                            }
                        } else {
                            IWebViewMessageFacade webViewFacade = WebViewMessageFacadeFactory.getRemoteInstance();
                            String toUrl = webViewFacade.getUrlByAssignID(sourceId);
                            String serverURL = System.getProperty("EASPORTAL_ROOT");
                            if (StringUtils.isEmpty((String)serverURL)) {
                                serverURL = "http://localhost:6888/easportal";
                            }
                            if (!StringUtils.isEmpty((String)toUrl)) {
                                toUrl = "/workflow/WFServlet?UIStatus=&forwordURL=" + URLEncoder.encode(toUrl, "utf-8") + "&assignmentID=" + sourceId + "&billID=" + billID;
                                String url = SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(URLEncoder.encode(toUrl, "utf-8"), true, SysContext.getSysContext().getLocale().toString(), SysContext.getSysContext().getDCNumber());
                                url = serverURL + "/" + url;
                                url = this.replaceAllStr(url, "&", "^&");
                                NewWinMainUI.gotoSite((String)url);
                            } else {
                                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"can.not.surrport.open"));
                            }
                        }
                    } else {
                        boolean ifRefresh = MessageUtil.showBusinessUINew(this.getWorkflowClient(), sourceId, (Object)this);
                        if (ifRefresh) {
                            this.tblMain.refresh();
                            this.selectNextMsg(this.oldSelectedRowIndex, this.tblMain);
                            this.oldSelectedRowIndex = -1;
                        }
                    }
                }
                catch (AlreadySuspendedException ale) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"flowAlreadyHangUp"));
                }
                catch (ActivityIsNotRunningException ex) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"ActivityIsNotRunning"));
                }
                catch (WfException e1) {
                    ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"disposeTaskFail"), (Throwable)e1);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"disposeTaskFail"), (Throwable)ex);
                }
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)"\u591a\u4efb\u52a1\u5904\u7406\u8bf7\u5230\u6d88\u606f\u4e2d\u5fc3");
            }
        }
    }

    private EASWfServiceClient getWorkflowClient() {
        return new EASWfServiceClient();
    }

    private void selectNextMsg(int rowIndex, KDTable table) {
        int rowCount = table.getRowCount();
        if (rowCount <= 0 || rowIndex < 0) {
            return;
        }
        if (rowIndex >= rowCount - 1) {
            rowIndex = rowCount - 1;
        }
        table.getSelectManager().select(rowIndex, 0);
        table.scrollToVisible(rowIndex, 0);
    }

    private String replaceAllStr(String strSource, String strFrom, String strTo) {
        int intPos;
        if (strFrom == null || strFrom.equals("")) {
            return strSource;
        }
        String strDest = "";
        int intFromLen = strFrom.length();
        while ((intPos = strSource.indexOf(strFrom)) != -1) {
            strDest = strDest + strSource.substring(0, intPos);
            strDest = strDest + strTo;
            strSource = strSource.substring(intPos + intFromLen);
        }
        strDest = strDest + strSource;
        return strDest;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        EntityViewInfo execCondition = viewInfo == null ? new EntityViewInfo() : (EntityViewInfo)viewInfo.clone();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("receiver", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), CompareType.EQUALS));
        if (execCondition.getFilter() != null && !StringUtils.isEmpty((String)execCondition.getFilter().toString())) {
            try {
                execCondition.getFilter().mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            execCondition.setFilter(filter);
        }
        SorterItemInfo sorterItemInfo = null;
        sorterItemInfo = new SorterItemInfo("receiveTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        execCondition.getSorter().add(sorterItemInfo);
        IQueryExecutor exec = super.getQueryExecutor(queryPK, execCondition);
        return exec;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.oldSelectedRowIndex = -1;
        this.tblMain.refresh();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }
}

