/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.base.message.content.Content;
import com.kingdee.eas.base.message.content.ContentDetail;
import com.kingdee.eas.base.message.content.ContentHeader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class WfCommonProcessContentUI
extends KDPanel {
    private Content content;

    public WfCommonProcessContentUI(Content content) throws Exception {
        this.content = content;
        this.initUI();
    }

    private void initUI() throws Exception {
        ContentHeader header = this.content.getHeader();
        ContentDetail[] details = this.content.getDetails();
        if (header == null && details == null) {
            throw new Exception("Content have no header and details.");
        }
        KDPanel headerPanel = null;
        if (header != null) {
            headerPanel = new KDPanel();
            this.initHeaderPanel(headerPanel, header);
        }
        JComponent detailComponent = null;
        if (details != null && details.length > 0) {
            if (details.length == 1) {
                KDPanel detailPanel = new KDPanel();
                ContentDetail detail = details[0];
                this.initDetailPanel(detailPanel, detail);
                detailComponent = detailPanel;
            } else {
                KDTabbedPane tabbedPane = new KDTabbedPane();
                for (int i = 0; i < details.length; ++i) {
                    KDPanel detailPanel = new KDPanel();
                    ContentDetail detail = details[i];
                    this.initDetailPanel(detailPanel, detail);
                    tabbedPane.addTab(detail.getCaption(), (Component)detailPanel);
                }
                detailComponent = tabbedPane;
            }
        }
        this.setLayout(new BorderLayout());
        if (headerPanel != null) {
            this.add((Component)headerPanel, "North");
        }
        if (detailComponent != null) {
            detailComponent.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
            this.add(detailComponent, "Center");
        }
    }

    private void initDetailPanel(KDPanel panel, ContentDetail detail) {
        String[] captions = detail.getColumnCaptions();
        KDTable table = new KDTable();
        table.setAutoscrolls(true);
        table.addColumns(captions.length);
        table.setColumnsAutoResizeMode(4);
        IRow headerRow = table.addHeadRow();
        for (int i = 0; i < captions.length; ++i) {
            headerRow.getCell(i).setValue((Object)captions[i]);
        }
        Iterator<String[]> iter = detail.getRowIterator();
        while (iter.hasNext()) {
            String[] values = iter.next();
            IRow row = table.addRow();
            for (int i = 0; i < values.length; ++i) {
                row.getCell(i).setValue((Object)values[i]);
            }
        }
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)table, (Object)"Center");
    }

    private void initHeaderPanel(KDPanel panel, ContentHeader header) {
        String[] keys = header.getItemKeys();
        int rows = keys.length / 3 + 1;
        panel.setLayout((LayoutManager)new GridLayout(rows, 3, 50, 10));
        for (int i = 0; i < keys.length; ++i) {
            panel.add((Component)this.createItemComponent(keys[i], header.getItemValue(keys[i])));
        }
    }

    private JComponent createItemComponent(String key, String value) {
        KDLabelContainer lc = new KDLabelContainer();
        lc.setBoundLabelLength(100);
        lc.setBoundLabelUnderline(true);
        lc.setBoundLabelText(key);
        lc.setName("lc" + key);
        KDTextField tf = new KDTextField();
        tf.setName("tf" + key);
        tf.setMaxLength(100);
        tf.setText(value);
        lc.setBoundEditor((JComponent)tf);
        return lc;
    }
}

