/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util;

import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.message.util.MCManagerModel;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class MessageCenterManager {
    private static MessageCenterManager manager = null;
    private MCManagerModel model = null;
    MessageCenterUI msgUI = null;

    private MessageCenterManager() {
    }

    private MessageCenterUI getMessageCenterUI() {
        IUIObject obj;
        IUIObject[] uiObjects = UIFrameUtil.findUIObject((String)MessageCenterUI.class.getName());
        if (uiObjects != null && uiObjects.length > 0 && (obj = uiObjects[0]) != null && obj instanceof MessageCenterUI) {
            return (MessageCenterUI)obj;
        }
        return null;
    }

    public void freshMessageCenter() throws RuntimeException {
        this.msgUI = this.getMessageCenterUI();
        if (this.msgUI == null) {
            return;
        }
        int delayTime = this.getModel().getRefreshTime();
        Timer timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MessageCenterManager.this.msgUI == null) {
                    return;
                }
                MessageCenterManager.this.msgUI.refresh();
            }
        });
        timer.setRepeats(false);
        timer.setInitialDelay(1000 * delayTime);
        timer.start();
    }

    public MCManagerModel getModel() {
        return this.model;
    }

    public void setModel(MCManagerModel model) {
        this.model = model;
    }

    public static MessageCenterManager getInstance() {
        if (manager == null) {
            manager = new MessageCenterManager();
        }
        return manager;
    }
}

