/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.message.MessageViewConfig;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;

public class MessageUtil {
    static Logger logger = Logger.getLogger(MessageUtil.class);
    public static final String MAGICCODE = "###PACKER4.0.1###";

    private static int readMagic(ByteArrayInputStream input) {
        if (input == null) {
            return 0;
        }
        int len = MAGICCODE.length();
        for (int m = 0; m < len; ++m) {
            if (MAGICCODE.charAt(m) == (char)input.read()) continue;
            return Integer.MAX_VALUE;
        }
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            int sz = input.read();
            if (sz < 0) {
                return 0;
            }
            if (i > 0) {
                res <<= 8;
            }
            res |= sz;
        }
        return res;
    }

    public static byte[] unpack(byte[] source) throws IOException {
        int len;
        if (source == null || source.length < 1) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(source);
        int count = MessageUtil.readMagic(bin);
        if (count == Integer.MAX_VALUE) {
            bin.close();
            return source;
        }
        if (count < 1) {
            bin.close();
            return null;
        }
        GZIPInputStream zin = new GZIPInputStream(bin);
        byte[] res = new byte[count];
        int num = 0;
        while ((len = count - num) >= 0) {
            int n;
            if (len > 4096) {
                len = 4096;
            }
            if ((n = zin.read(res, num, len)) <= 0) break;
            num += n;
        }
        zin.close();
        bin.close();
        return num != count ? null : res;
    }

    public static boolean isFD(Context ctx) {
        String paramValue = null;
        try {
            paramValue = ctx == null ? ParamManager.getParamValue(null, null, (String)"BG007") : ParamManager.getParamValue((Context)ctx, null, (String)"BG007");
        }
        catch (EASBizException e) {
            logger.error((Object)"isFD failed", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"isFD failed", (Throwable)e);
        }
        if (paramValue == null || paramValue.trim().equals("")) {
            return false;
        }
        return Boolean.valueOf(paramValue);
    }

    public static boolean ifShowBillBtn(MsgType msgType, MsgBizType bizType, String sourceId, String sourceIds) {
        boolean result = false;
        if (StringUtils.isEmpty((String)sourceId) && StringUtils.isEmpty((String)sourceIds)) {
            return result;
        }
        if (msgType.equals((Object)MsgType.TASK)) {
            if (!StringUtils.isEmpty((String)sourceId) && sourceId.endsWith("WFWKITEM")) {
                result = true;
            }
        } else if (msgType.equals((Object)MsgType.NOTICE)) {
            if (!StringUtils.isEmpty((String)sourceIds)) {
                if (bizType.equals((Object)MsgBizType.WORKFLOW)) {
                    if (sourceIds.startsWith("|")) {
                        String billId;
                        String[] array = sourceIds.split("\\|");
                        if (array.length > 2 && !StringUtils.isEmpty((String)(billId = array[2])) && !"null".equals(billId)) {
                            result = true;
                        }
                    } else if (sourceIds.indexOf("PASS::") >= 0) {
                        if (!StringUtils.isEmpty((String)sourceId)) {
                            result = true;
                        }
                    } else {
                        result = false;
                    }
                } else if (sourceIds.startsWith("(") && bizType.equals((Object)MsgBizType.FORWARN)) {
                    result = true;
                } else if (sourceIds.startsWith("|")) {
                    String billId;
                    String[] array = sourceIds.split("\\|");
                    if (array.length > 2 && !StringUtils.isEmpty((String)(billId = array[2])) && !"null".equals(billId)) {
                        result = true;
                    }
                } else if (sourceIds.indexOf("::") > 0 && !sourceIds.startsWith("PASS")) {
                    Map map;
                    String prefix = sourceIds.substring(0, sourceIds.indexOf("::"));
                    Object configObj = MessageViewConfig.getInstance(true).getConfigByPrefix(prefix);
                    result = configObj != null ? !MessageUtil.isValueEmpty((map = (Map)configObj).get("billweb")) : false;
                } else {
                    result = false;
                }
            } else if (!StringUtils.isEmpty((String)sourceId) && !bizType.equals((Object)MsgBizType.FORWARN)) {
                result = true;
            }
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isValueEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            String temp = o.toString();
            return StringUtils.isEmpty((String)temp);
        }
        if (o instanceof Map) {
            Map temp = (Map)o;
            return temp == null || temp.isEmpty();
        }
        if (o instanceof List) {
            List temp = (List)o;
            return temp == null || temp.isEmpty();
        }
        if (o instanceof Set) {
            Set temp = (Set)o;
            return temp == null || temp.isEmpty();
        }
        return false;
    }
}

