/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util.sendmsg;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.util.sendmsg.WFNoticeAdapter;
import com.kingdee.eas.base.message.util.sendmsg.WFProcessinstAdapter;
import com.kingdee.eas.base.message.util.sendmsg.hrcloud.HRCloudServiceFacade;
import com.kingdee.eas.base.message.util.sendmsg.hrcloud.KDCloudServiceConfig;
import com.kingdee.eas.base.message.util.sendmsg.pa.api.IMessageAdapter;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class WFNoticeListener
implements MessageListener {
    private static Logger logger = Logger.getLogger(WFNoticeListener.class);

    public int onMessage(Message message) {
        try {
            if (StringUtils.isEmpty((String)KDCloudServiceConfig.getInstance().getPropertiesItem("isSendCloudMsg")) || "false".equalsIgnoreCase(KDCloudServiceConfig.getInstance().getPropertiesItem("isSendCloudMsg"))) {
                logger.info((Object)"Cloud messages : is setting unsending msg");
                return 1;
            }
            logger.info((Object)"HR-cloud Messages :: receive message.....");
            Context ctx = WFNoticeListener.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
            if (StringUtils.isEmpty((String)KDCloudServiceConfig.getInstance().getPropertiesItem("hrCloudUrl"))) {
                logger.info((Object)"HR-cloud Messages :: WFMessage is disabled!please settiong hrCloudUrl");
                return 1;
            }
            List<Message> messages = this.parseMessage(message);
            if (messages != null && messages.size() > 0) {
                ArrayList<IMessageAdapter> passlist = new ArrayList<IMessageAdapter>();
                Message msg = null;
                for (int i = 0; i < messages.size(); ++i) {
                    IMessageAdapter adapter;
                    msg = messages.get(i);
                    if (!StringUtils.isEmpty((String)msg.getStringHeader("ProcessInstId")) && !StringUtils.isEmpty((String)msg.getStringHeader("assignid"))) {
                        adapter = new WFProcessinstAdapter(messages.get(i));
                        passlist.add(adapter);
                        logger.info((Object)("XT Messages :: receviers " + adapter.getUsers()));
                        logger.info((Object)("XT Messages :: content " + adapter.getContent()));
                        logger.info((Object)("XT Messages :: type " + (Object)((Object)adapter.getType())));
                        continue;
                    }
                    adapter = new WFNoticeAdapter(messages.get(i));
                    passlist.add(adapter);
                    logger.info((Object)("XT Messages :: receviers " + adapter.getUsers()));
                    logger.info((Object)("XT Messages :: content " + adapter.getContent()));
                    logger.info((Object)("XT Messages :: type " + (Object)((Object)adapter.getType())));
                }
                logger.info((Object)"XT Messages :: send starting......");
                boolean bResultPass = HRCloudServiceFacade.pushMessage(ctx, passlist);
                logger.info((Object)("XT Messages send result :: " + bResultPass));
                logger.info((Object)"WX Messages :: send starting......");
                logger.info((Object)("WX Messages send result :: " + bResultPass));
                if (bResultPass) {
                    return 1;
                }
                return 1;
            }
            return 1;
        }
        catch (Exception e) {
            logger.error((Object)"XT Messages send failed!", (Throwable)e);
            return 1;
        }
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }

    private List<Message> parseMessage(Message message) {
        ArrayList<Message> messages = new ArrayList<Message>();
        String receivers = message.getStringHeader("receiver");
        MsgType type = MsgType.getEnum(message.getIntHeader("type"));
        MsgBizType bizType = MsgBizType.getEnum(message.getIntHeader("bizType"));
        if (bizType != MsgBizType.WORKFLOW && bizType != MsgBizType.URGENT) {
            return null;
        }
        List<String> receiverIDs = this.parseReceivers(receivers);
        int receiverSize = receiverIDs.size();
        if (receiverSize == 0) {
            return null;
        }
        if (receiverSize == 1) {
            if (type.equals((Object)MsgType.NOTICE)) {
                message.setStringHeader("receiver", String.valueOf(receiverIDs.get(0)));
                messages.add(message);
                return messages;
            }
        } else if (type.equals((Object)MsgType.NOTICE)) {
            for (int i = 0; i < receiverSize; ++i) {
                Message newMessage = this.copyMessage(message);
                newMessage.setStringHeader("receiver", receiverIDs.get(i).toString());
                messages.add(newMessage);
            }
        }
        return messages;
    }

    private List<String> parseReceivers(String str) {
        ArrayList<String> receiverIDs = new ArrayList<String>();
        if (str != null && !str.trim().equalsIgnoreCase("")) {
            if (str.indexOf(";") != -1) {
                StringTokenizer stReveivers = null;
                stReveivers = new StringTokenizer(str, ";");
                while (stReveivers.hasMoreTokens()) {
                    receiverIDs.add(stReveivers.nextToken());
                }
            } else {
                receiverIDs.add(str);
            }
        }
        return receiverIDs;
    }

    private Message copyMessage(Message message) {
        Message newMessage = MessageFactory.newMessage();
        newMessage.setStringHeader("databaseCenter", message.getStringHeader("databaseCenter"));
        newMessage.setStringHeader("solution", message.getStringHeader("solution"));
        newMessage.setStringHeader("receiver", message.getStringHeader("receiver"));
        newMessage.setStringHeader("sourceID", message.getStringHeader("sourceID"));
        newMessage.setStringHeader("sourceIDs", message.getStringHeader("sourceIDs"));
        for (int i = 1; i < 4; ++i) {
            String localString = "L" + i;
            Locale locale = new Locale(localString);
            newMessage.setLocaleStringHeader("title", message.getLocaleStringHeader("title", locale), locale);
            newMessage.setLocaleStringHeader("body", message.getLocaleStringHeader("body", locale), locale);
        }
        return newMessage;
    }
}

