/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util.sendmsg.pa.api;

import com.kingdee.eas.base.message.util.JSONUtil;
import com.kingdee.eas.base.message.util.sendmsg.hrcloud.KDCloudServiceConfig;
import com.kingdee.eas.base.message.util.sendmsg.pa.api.AbstractMessage;
import com.kingdee.eas.base.message.util.sendmsg.pa.api.ITalkTransfer;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractTransfer
implements ITalkTransfer {
    private static Logger logger = Logger.getLogger((String)AbstractTransfer.class.getName());
    private String response = null;
    private boolean status = false;
    private AbstractMessage message = null;

    public AbstractTransfer(AbstractMessage message) {
        this.message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String pushMessage() {
        if (this.message != null && this.message.hasReady()) {
            this.status = false;
            HttpClient http = new HttpClient();
            http.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            http.getHttpConnectionManager().getParams().setSoTimeout(5000);
            PostMethod post = null;
            GetMethod get = null;
            String url = this.getConnectServerURL();
            try {
                String eid = KDCloudServiceConfig.getInstance().getPropertiesItem("cust3gNo");
                String cloudKey = KDCloudServiceConfig.getInstance().getPropertiesItem("cloudKey");
                Date timestamp = new Date();
                String timeStr = "" + timestamp.getTime();
                Object[] data = new String[]{eid, timeStr, cloudKey};
                Arrays.sort(data);
                String opentoken = DigestUtils.shaHex((String)StringUtils.join((Object[])data));
                String getUrl = url + "/open/login?eid=" + eid + "&timestamp=" + timeStr + "&opentoken=" + opentoken + "&authPattern=eid_credential";
                logger.error((Object)getUrl);
                get = new GetMethod(getUrl);
                http.executeMethod((HttpMethod)get);
                if (get.getStatusCode() != 200) return this.response;
                String respose = get.getResponseBodyAsString();
                get.releaseConnection();
                logger.error((Object)("repsosemsg=" + respose));
                Map repData = JSONUtil.getMap4Json(respose);
                String token = ((Map)repData.get("data")).get("token").toString();
                String postUrl = url + "/openapi/pushMessage";
                post = new PostMethod(postUrl);
                post.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
                post.addParameter("token", token);
                post.addRequestHeader("token", token);
                logger.error((Object)("message=" + this.message.toString()));
                post.addParameter("msgdatas", this.message.toString());
                logger.info((Object)("starting push message to XT, push address is :" + url));
                logger.info((Object)("starting push message to XT, push message.toString() is :" + this.message.toString()));
                http.executeMethod((HttpMethod)post);
                if (post.getStatusCode() == 200) {
                    this.status = true;
                }
                this.response = new String(post.getResponseBodyAsString().getBytes("UTF-8"));
                post.releaseConnection();
                return this.response;
            }
            catch (Throwable e) {
                logger.error((Object)"error message", e);
                this.status = false;
                this.response = "send exception:" + e.getMessage();
                return this.response;
            }
            finally {
                if (get != null) {
                    get.releaseConnection();
                }
                if (post != null) {
                    post.releaseConnection();
                }
            }
        } else {
            this.status = false;
            this.response = this.message == null ? "message object was not initialized" : "message object was not ready";
        }
        return this.response;
    }

    @Override
    public boolean isSucceed() {
        return this.status;
    }

    public void setMessage(AbstractMessage message) {
        this.message = message;
    }

    public AbstractMessage getMessage() {
        return this.message;
    }

    protected abstract String getConnectServerURL();

    protected abstract String getConnectContentType();
}

