/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util.sendmsg.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;

public class ConfigUtil {
    private Configuration cfg;

    protected PropertiesConfiguration getConfiguration() {
        return (PropertiesConfiguration)this.cfg;
    }

    protected ConfigUtil(String fileName) {
        this(fileName, null);
    }

    protected ConfigUtil(String fileName, String encoding) {
        this.cfg = this.buildConfiguration(fileName, encoding);
    }

    public static ConfigUtil getConfiguration(String fileName, String encoding) {
        return new ConfigUtil(fileName, encoding);
    }

    public String getString(String key, boolean assertExist) {
        String value = this.getString(key);
        if (value == null && assertExist) {
            throw new RuntimeException(String.format("\u914d\u7f6e\u6587\u4ef6[%s]\u672a\u914d\u7f6e[%s]", this.getFileName(), key));
        }
        return value;
    }

    public String getStringWithExt(String key, String keyExt) {
        if (keyExt == null) {
            return this.getString(key);
        }
        String value = this.getString(key + "_" + keyExt);
        if (value == null) {
            value = this.getString(key);
        }
        return value;
    }

    public String getFileName() {
        return this.getConfiguration().getFileName();
    }

    public boolean getBoolean(String key) {
        return this.cfg.getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.cfg.getBoolean(key, defaultValue);
    }

    public int getInt(String key) {
        return this.cfg.getInt(key);
    }

    public String getString(String key) {
        return this.cfg.getString(key);
    }

    public String[] getStringArray(String key) {
        return this.cfg.getStringArray(key);
    }

    public Object getProperty(String key) {
        return this.cfg.getProperty(key);
    }

    private final Configuration buildConfiguration(String fileName, String encoding) {
        if (fileName == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            PropertiesConfiguration cfg = new PropertiesConfiguration(fileName);
            cfg.setEncoding(encoding);
            cfg.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
            return cfg;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(String.format("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6[%s]\u5931\u8d25!", fileName));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("\u521b\u5efa\u6587\u4ef6[%s]\u5931\u8d25!", fileName));
        }
    }
}

