/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util.sendmsg.util.image;

import com.kingdee.eas.base.message.util.sendmsg.util.StringUtil;
import com.kingdee.eas.base.message.util.sendmsg.util.image.IImageByteConverter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.imageio.ImageIO;

public class ImageUtil {
    private ImageUtil() {
    }

    public static byte[] crop(byte[] imgData, int maxWidth, int maxHeight, String format) {
        byte[] out = null;
        BufferedImage bi = ImageUtil.getBufferedImageFromByte(imgData);
        int srcWidth = bi.getWidth();
        int srcHeight = bi.getHeight();
        double ratio = Math.max((double)maxWidth / (double)srcWidth, (double)maxHeight / (double)srcHeight);
        int destWidth = (int)((double)srcWidth * ratio);
        int destHeight = (int)((double)srcHeight * ratio);
        int x = Math.abs((destWidth - maxWidth) / 2);
        int y = Math.abs((destHeight - maxHeight) / 2);
        bi = ImageUtil.crop(bi, destWidth, destHeight, maxWidth, maxHeight, x, y);
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, format, os);
            out = os.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    public static BufferedImage crop(BufferedImage bi, int scaleWidth, int scaleHeight, int cutWidth, int cutHeight, int x, int y) {
        BufferedImage out = null;
        bi = ImageUtil.scale(bi, scaleWidth, scaleHeight);
        out = ImageUtil.crop(bi, cutWidth, cutHeight, x, y);
        return out;
    }

    public static BufferedImage crop(BufferedImage bi, int cutWidth, int cutHeight, int x, int y) {
        BufferedImage out = null;
        CropImageFilter cropFilter = new CropImageFilter(x, y, cutWidth, cutHeight);
        Image image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(bi.getSource(), cropFilter));
        out = ImageUtil.getBufferedImageFromImage(image);
        return out;
    }

    public static BufferedImage scale(BufferedImage bi, int scaleWidth, int scaleHeight) {
        Image image = bi.getScaledInstance(scaleWidth, scaleHeight, 4);
        return ImageUtil.getBufferedImageFromImage(image);
    }

    public static byte[] scale(byte[] imgData, int scaleWidth, int scaleHeight, String format) {
        byte[] out = null;
        BufferedImage bi = ImageUtil.scale(ImageUtil.getBufferedImageFromByte(imgData), scaleWidth, scaleHeight);
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, format, os);
            out = os.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    public static byte[] scaleByWidth(byte[] imgData, int scaleWidth, String format) {
        byte[] out = null;
        BufferedImage bi = ImageUtil.getBufferedImageFromByte(imgData);
        int srcWidth = bi.getWidth();
        int srcHeight = bi.getHeight();
        double ratio = Math.min((double)scaleWidth / (double)srcWidth, 1.0);
        int destWidth = (int)((double)srcWidth * ratio);
        int destHeight = (int)((double)srcHeight * ratio);
        out = ImageUtil.scale(imgData, destWidth, destHeight, format);
        return out;
    }

    public static byte[] scaleByHeight(byte[] imgData, int scaleHeight, String format) {
        byte[] out = null;
        BufferedImage bi = ImageUtil.getBufferedImageFromByte(imgData);
        int srcWidth = bi.getWidth();
        int srcHeight = bi.getHeight();
        double ratio = Math.min((double)scaleHeight / (double)srcHeight, 1.0);
        int destWidth = (int)((double)srcWidth * ratio);
        int destHeight = (int)((double)srcHeight * ratio);
        out = ImageUtil.scale(imgData, destWidth, destHeight, format);
        return out;
    }

    public static BufferedImage getBufferedImageFromByte(byte[] imgData) {
        ByteArrayInputStream is = new ByteArrayInputStream(imgData);
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bi;
    }

    public static BufferedImage getBufferedImageFromImage(Image image) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics g = bi.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveImage(byte[] data, String path) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            fos.write(data);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readImage(String path) {
        byte[] in = null;
        FileInputStream fis = null;
        try {
            File file = new File(path);
            if (file != null && (fis = new FileInputStream(file)) != null) {
                int len = fis.available();
                in = new byte[len];
                fis.read(in);
                fis.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return in;
    }

    public static byte[] convert(byte[] imgData, String format) {
        byte[] out = null;
        BufferedImage bi = ImageUtil.getBufferedImageFromByte(imgData);
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, format, os);
            out = os.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    public static byte[] getJPEGImageByte(String path, String className) {
        return ImageUtil.getImageByte(path, "jpg", className);
    }

    public static byte[] getImageByte(String path, String className) {
        return ImageUtil.getImageByte(path, "", className);
    }

    public static byte[] getImageByte(String path, String format, String className) {
        byte[] data = null;
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object object = constructor.newInstance(new Object[0]);
            if (object instanceof IImageByteConverter) {
                data = ImageUtil.getImageByte(path, format, (IImageByteConverter)object);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public static byte[] getImageByte(String path, String format, IImageByteConverter converter) {
        converter.setPath(path);
        if (format == null || format.equals("")) {
            format = converter.getFormat();
        }
        return converter.getByte(format);
    }

    public static String getImageBase64String(String path, String format, IImageByteConverter converter) {
        byte[] data = null;
        String str = null;
        data = ImageUtil.getImageByte(path, format, converter);
        if (data != null) {
            str = StringUtil.getBase64FromByte(data);
        }
        return str;
    }

    public static String getImageBase64String(String path, String format, String className) {
        byte[] data = null;
        String str = null;
        data = ImageUtil.getImageByte(path, format, className);
        if (data != null) {
            str = StringUtil.getBase64FromByte(data);
        }
        return str;
    }

    public static String getImageBase64String(String path, String className) {
        return ImageUtil.getImageBase64String(path, "", className);
    }

    public static String getJPEGImageBase64String(String path, String className) {
        return ImageUtil.getImageBase64String(path, "jpg", className);
    }
}

