/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util.sendmsg.util.image;

import com.kingdee.eas.base.message.util.sendmsg.util.image.IImageByteConverter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class URLImageByteConverter
implements IImageByteConverter {
    private String format = "";
    private BufferedInputStream bis = null;
    private Map<String, String> imageMimeMapping = new HashMap<String, String>();

    public URLImageByteConverter() {
        this.imageMimeMapping.put("image/png", "png");
        this.imageMimeMapping.put("image/gif", "gif");
        this.imageMimeMapping.put("image/jpeg", "jpg");
        this.imageMimeMapping.put("image/bmp", "bmp");
    }

    @Override
    public void setPath(String path) {
        try {
            int HttpResult = 0;
            URL url = new URL(path);
            URLConnection urlconn = url.openConnection();
            urlconn.connect();
            this.format = URLConnection.guessContentTypeFromName(path);
            HttpURLConnection httpconn = (HttpURLConnection)urlconn;
            HttpResult = httpconn.getResponseCode();
            if (HttpResult == 200) {
                this.bis = new BufferedInputStream(urlconn.getInputStream());
                if (this.format.equals("")) {
                    this.format = URLConnection.guessContentTypeFromStream(this.bis);
                }
                this.format = this.format.replace("image/", "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte[] getByte(String format) {
        byte[] data = null;
        if (this.bis != null) {
            try {
                BufferedImage bm = ImageIO.read(this.bis);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bm, format, bos);
                bos.flush();
                data = bos.toByteArray();
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getName() {
        return null;
    }
}

