/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.webservice;

import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.base.message.webservice.MessageWebServiceDao;
import com.kingdee.eas.base.message.webservice.MessageWebServiceDaoProxy;
import com.kingdee.eas.base.message.webservice.WSConfigInfo;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class MessageServiceConfig {
    private static Logger logger = Logger.getLogger(MessageServiceConfig.class);
    private static final MessageServiceConfig MSConfig = new MessageServiceConfig();
    private static final String PORTALCONFIG = "portal.config";
    private static final String MSConfigFile = "WSConfig.xml";
    private FileInputStream configFile;
    static List configList = null;
    private static Set<String> cleanerSet = new HashSet<String>();

    private MessageServiceConfig() {
    }

    public List LoadConfig() {
        if (configList.size() <= 0) {
            return null;
        }
        return configList;
    }

    private void readConfig() {
        String insHome = System.getProperty("EAS_INSTANCE_HOME");
        if (insHome == null) {
            throw new RuntimeException("EAS_INSTANCE_HOME is null");
        }
        String wsPath = insHome + File.separator + "config" + File.separator + "portalConfig" + File.separator + MSConfigFile;
        try {
            this.configFile = new FileInputStream(wsPath);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"\u521b\u5efa\u914d\u7f6e\u6587\u4ef6\u8f93\u5165\u6d41\u7684\u65f6\u5019\u51fa\u9519", (Throwable)e);
        }
        configList = this.fillConfigInfo(this.configFile);
    }

    private List fillConfigInfo(FileInputStream configFile) {
        LinkedList<WSConfigInfo> infoList = new LinkedList<WSConfigInfo>();
        Document doc = null;
        Element root = null;
        List classConfig = null;
        Element classElement2 = null;
        try {
            doc = XMLParser.parseXML((InputStream)configFile);
        }
        catch (Exception e) {
            logger.error((Object)"\u89e3\u6790XML\u6587\u4ef6\u6709\u8bef", (Throwable)e);
            return infoList;
        }
        if (doc == null) {
            return infoList;
        }
        root = doc.getRootElement();
        classConfig = root.getChildren("class");
        for (Element classElement2 : classConfig) {
            WSConfigInfo configInfo = new WSConfigInfo();
            String server = classElement2.getChildTextTrim("server");
            String path = classElement2.getChildTextTrim("path");
            String dataCenter = classElement2.getChildTextTrim("dataCenter");
            Element taskElement = classElement2.getChild("task");
            String taskValue = taskElement.getAttributeValue("value");
            String task_workflow = taskElement.getChildTextTrim("workflow");
            Element noticeElement = classElement2.getChild("notice");
            String noticeValue = noticeElement.getAttributeValue("value");
            String notice_workflow = noticeElement.getChildTextTrim("workflow");
            String notice_forwarn = noticeElement.getChildTextTrim("forwarn");
            String notice_urgent = noticeElement.getChildTextTrim("urgent");
            String notice_online = "";
            if (noticeElement.getChild("online") != null) {
                notice_online = noticeElement.getChildTextTrim("online");
            }
            String notice_office = "";
            if (noticeElement.getChild("office") != null) {
                notice_office = noticeElement.getChildTextTrim("office");
            }
            String notice_async = "";
            if (noticeElement.getChild("async") != null) {
                notice_async = noticeElement.getChildTextTrim("async");
            }
            String notice_xitongoffice = "";
            if (noticeElement.getChild("xitongoffice") != null) {
                notice_xitongoffice = noticeElement.getChildTextTrim("xitongoffice");
            }
            String notice_hr = "";
            if (noticeElement.getChild("hr") != null) {
                notice_hr = noticeElement.getChildTextTrim("hr");
            }
            Element onlineElement = classElement2.getChild("online");
            String onlineValue = onlineElement.getAttributeValue("value");
            configInfo.setClassName(path);
            configInfo.setServerPath(server);
            configInfo.setDataCenter(dataCenter);
            configInfo.setTask(Boolean.valueOf(taskValue));
            configInfo.setTask_workFlow(Boolean.valueOf(task_workflow));
            configInfo.setNotice(Boolean.valueOf(noticeValue));
            configInfo.setNotice_Forwarn(Boolean.valueOf(notice_forwarn));
            configInfo.setNotice_Urgent(Boolean.valueOf(notice_urgent));
            configInfo.setNotice_workFlow(Boolean.valueOf(notice_workflow));
            if (!StringUtils.isEmpty((String)notice_online)) {
                configInfo.setNotice_online(Boolean.valueOf(notice_online));
            }
            if (!StringUtils.isEmpty((String)notice_office)) {
                configInfo.setNotice_office(Boolean.valueOf(notice_office));
            }
            if (!StringUtils.isEmpty((String)notice_async)) {
                configInfo.setNotice_async(Boolean.valueOf(notice_async));
            }
            if (!StringUtils.isEmpty((String)notice_xitongoffice)) {
                configInfo.setNotice_xitongoffice(Boolean.valueOf(notice_xitongoffice));
            }
            if (!StringUtils.isEmpty((String)notice_hr)) {
                configInfo.setNotice_hr(Boolean.valueOf(notice_hr));
            }
            configInfo.setOnline(Boolean.valueOf(onlineValue));
            try {
                MessageWebServiceDao dao = (MessageWebServiceDao)Class.forName(configInfo.getClassName()).newInstance();
                String dc = configInfo.getDataCenter();
                MessageWebServiceDaoProxy daoProxy = new MessageWebServiceDaoProxy(dao, dc);
                if (!cleanerSet.contains(dc)) {
                    daoProxy.init();
                    cleanerSet.add(dc);
                }
                MessageWebServiceDao proxyDao = (MessageWebServiceDao)Proxy.newProxyInstance(dao.getClass().getClassLoader(), dao.getClass().getInterfaces(), (InvocationHandler)daoProxy);
                configInfo.setMessServiceDao(proxyDao);
            }
            catch (Throwable e) {
                logger.error((Object)("\u521d\u59cb\u5316MessageWebServiceDao\u51fa\u9519\uff0cclassName=" + configInfo.getClassName()), e);
            }
            infoList.add(configInfo);
        }
        return infoList;
    }

    public static MessageServiceConfig getMSConfig() {
        if (configList == null) {
            MSConfig.readConfig();
        }
        return MSConfig;
    }
}

