/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.sns.task.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.api.HttpClientUtil;
import com.kingdee.lightapp.pa.api.YZJInvokeUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.lightapp.xt.YZJUrlContants;
import com.kingdee.sns.task.util.YZJNoticeCenterSyncJob;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class YZJFlowCenterDeal {
    private static Logger logger = Logger.getLogger(YZJFlowCenterDeal.class);

    public static void changeNotic2Done(Context ctx, String eid, String noticeMsgId) {
        try {
            Class.forName("com.kingdee.lightapp.workflow.util.YZJFlowCenterDeal");
            return;
        }
        catch (Exception e) {
            logger.error((Object)"class YZJFlowCenterDeal do not exist");
            try {
                String qry;
                IRowSet rowSet;
                if (!StringUtils.isEmpty((CharSequence)eid) && !StringUtils.isEmpty((CharSequence)noticeMsgId) && (rowSet = DbUtil.executeQuery((Context)ctx, (String)(qry = "SELECT 1 FROM T_ASSIGN_XTMSG WHERE FSTATE IS NULL AND MSGID = ?"), (Object[])new Object[]{noticeMsgId})).next()) {
                    ArrayList<String> paramList = new ArrayList<String>();
                    paramList.add(eid);
                    paramList.add(noticeMsgId);
                    YZJNoticeCenterSyncJob.init(ctx, paramList);
                }
            }
            catch (Exception e2) {
                logger.error((Object)("YZJFlowCenterDeal changeNotic2Done error result:" + e2.getMessage()));
            }
            return;
        }
    }

    public static String change2Done(Context ctx, String assignId) {
        String url = YZJUrlContants.FLOWCENTER_DONE_URL;
        return YZJFlowCenterDeal.dealTodo(ctx, assignId, url, "done");
    }

    public static String deleteTodo(Context ctx, String assignId) {
        String url = YZJUrlContants.FLOWCENTER_DELETETODO_URL;
        return YZJFlowCenterDeal.dealTodo(ctx, assignId, url, "delete");
    }

    private static String dealTodo(Context ctx, String assignId, String url, String dealInfo) {
        String postResult = "";
        try {
            String realeid = (String)XTServiceConfig.getInstance().getXTInfoProperties().get("realEid");
            String ais = ctx.getAIS();
            String eid = XTServiceConfig.getInstance().getEidByDbCode(ais);
            String appId = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "appId", "");
            realeid = StringUtils.isEmpty((CharSequence)realeid) ? eid : realeid;
            String teamAccessToken = YZJInvokeUtil.getInstance().getTeamAccessToken(realeid, appId, "");
            url = url + "?accessToken=" + teamAccessToken;
            HashMap<String, Object> dealMap = new HashMap<String, Object>();
            ArrayList<String> bizIdList = new ArrayList<String>();
            bizIdList.add(assignId);
            dealMap.put("appId", appId);
            dealMap.put("bizId", bizIdList);
            postResult = HttpClientUtil.doPost((String)url, (String)JSON.toJSONString(dealMap), (String)"UTF-8");
            if (!StringUtils.isEmpty((CharSequence)postResult)) {
                JSONObject result = JSON.parseObject((String)postResult);
                if (result.getBoolean("success").booleanValue()) {
                    YZJFlowCenterDeal.assignHandledAndUpdate(ctx, assignId, dealInfo);
                } else {
                    logger.error((Object)("YZJFlowCenterDeal dealTodo error result:" + postResult));
                    YZJFlowCenterDeal.insertError(assignId, assignId, result.getString("error"), result.getString("errorCode"), ctx, dealInfo);
                }
            }
        }
        catch (Exception e) {
            YZJFlowCenterDeal.insertError(assignId, assignId, e.getMessage(), "0", ctx, dealInfo);
        }
        return postResult;
    }

    private static void assignHandledAndUpdate(Context ctx, String assignId, String dealInfo) {
        try {
            String updatesql = "UPDATE T_ASSIGN_XTMSG  SET FSTATE= '1', DEALTYPE = ? WHERE  FASSIGNID = ? ";
            DbUtil.execute((Context)ctx, (String)updatesql, (Object[])new Object[]{dealInfo, assignId});
        }
        catch (BOSException e) {
            YZJFlowCenterDeal.insertError(assignId, assignId, e.getMessage(), "1", ctx, dealInfo);
            logger.error((Object)"-----------YZJFlowCenterDeal assignHandledAndUpdate error ", (Throwable)e);
        }
    }

    public static void insertError(String msgid, String assignId, String errormsg, String errorcode, Context ctx, String dealInfo) {
        try {
            String insertsql = " INSERT INTO T_ASSIGN_CHANGGEERROR(MSGID,FASSIGNID,ERRORMSG,ERRORCODE,DEALTYPE,SENDTIME) VALUES(?,?,?,?,?,getdate())";
            DbUtil.execute((Context)ctx, (String)insertsql, (Object[])new Object[]{msgid, assignId, errormsg, dealInfo, errorcode});
        }
        catch (Exception e) {
            logger.error((Object)("-----------YZJFlowCenterDeal insertError occur " + assignId));
        }
    }

    public static String changeProcess2Finish(Context ctx, String procInstId) {
        String url = YZJFlowCenterDeal.ifPush2FlowCenter(ctx, procInstId) ? YZJUrlContants.FLOWCENTER_PROCESSFINISH_URL : YZJUrlContants.FLOWCENTER_PROCESSDELETE_URL;
        return YZJFlowCenterDeal.finishProcessAndHandle(ctx, procInstId, url, "end");
    }

    private static boolean ifPush2FlowCenter(Context ctx, String procInstId) {
        try {
            String sql = "SELECT TOP 1 MSGID FROM T_ASSIGN_XTMSG WHERE  PUSHTYPE = '1' AND PROCINSTID = ? ";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{procInstId});
            return rowSet.next();
        }
        catch (Exception e) {
            logger.error((Object)("YZJFlowCenterDeal  error procInstId" + procInstId));
            logger.error((Object)"YZJFlowCenterDeal checkInitiatorHasOpenid error ", (Throwable)e);
            return false;
        }
    }

    public static String deleteProcess(Context ctx, String procInstId) {
        String url = YZJUrlContants.FLOWCENTER_PROCESSDELETE_URL;
        return YZJFlowCenterDeal.finishProcessAndHandle(ctx, procInstId, url, "del");
    }

    public static String finishProcessAndHandle(Context ctx, String procInstId, String url, String dealType) {
        String postResult = "";
        try {
            String realeid = (String)XTServiceConfig.getInstance().getXTInfoProperties().get("realEid");
            String ais = ctx.getAIS();
            String eid = XTServiceConfig.getInstance().getEidByDbCode(ais);
            String appId = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "appId", "");
            realeid = StringUtils.isEmpty((CharSequence)realeid) ? eid : realeid;
            String teamAccessToken = YZJInvokeUtil.getInstance().getTeamAccessToken(realeid, appId, "");
            url = url + "?accessToken=" + teamAccessToken;
            HashMap<String, Object> dealMap = new HashMap<String, Object>();
            ArrayList<String> flowIdList = new ArrayList<String>();
            flowIdList.add(procInstId);
            dealMap.put("appId", appId);
            dealMap.put("flowId", flowIdList);
            postResult = HttpClientUtil.doPost((String)url, (String)JSON.toJSONString(dealMap), (String)"UTF-8");
            if (!StringUtils.isEmpty((CharSequence)postResult)) {
                JSONObject result = JSON.parseObject((String)postResult);
                if (result.getBoolean("success").booleanValue()) {
                    YZJFlowCenterDeal.saveProcessHandledSuccess(ctx, procInstId, dealType, postResult);
                } else {
                    logger.error((Object)("YZJFlowCenterDeal dealTodo error result:" + postResult));
                    YZJFlowCenterDeal.saveProcessHandledfailed(ctx, procInstId, dealType, postResult, result.getString("errorCode"), result.getString("error"));
                }
            }
        }
        catch (Exception e) {
            YZJFlowCenterDeal.saveProcessHandledfailed(ctx, procInstId, dealType, postResult, "2", e.getMessage());
        }
        return postResult;
    }

    private static void saveProcessHandledSuccess(Context ctx, String procInstId, String dealType, String resultStr) {
        try {
            String insertsql = " INSERT INTO T_ASSIGN_PROCINSTDEAL(FPROCINSTID,FDEALTYPE,FDEALRESULT,FSTATE,FDEALTIME) VALUES(?,?,?,'1',GETDATE())";
            DbUtil.execute((Context)ctx, (String)insertsql, (Object[])new Object[]{procInstId, dealType, resultStr});
        }
        catch (BOSException e) {
            logger.error((Object)"YZJFlowCenterDeal saveProcessHandledSuccess error occur ", (Throwable)e);
        }
    }

    private static void saveProcessHandledfailed(Context ctx, String procInstId, String dealType, String resultStr, String errorCode, String errorInfo) {
        try {
            String insertsql = " INSERT INTO T_ASSIGN_PROCINSTDEAL(FPROCINSTID,FDEALTYPE,FDEALRESULT, FERRORCODE,FINFO,FSTATE,FDEALTIME)VALUES(?,?,?,?,?,'0',GETDATE())";
            DbUtil.execute((Context)ctx, (String)insertsql, (Object[])new Object[]{procInstId, dealType, resultStr, errorCode, errorInfo});
        }
        catch (BOSException e) {
            logger.error((Object)"YZJFlowCenterDeal saveProcessHandledfailed error occur ", (Throwable)e);
        }
    }
}

