/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.formatter.DateParser;
import com.kingdee.bos.ctrl.kdf.formatter.FormatException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.model.ComboColorSelectionModel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.EmunCustomize;
import com.kingdee.eas.base.param.IParamManagerControl;
import com.kingdee.eas.base.param.ParamDataType;
import com.kingdee.eas.base.param.ParamException;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.ParamManagerControlCollection;
import com.kingdee.eas.base.param.ParamManagerControlFactory;
import com.kingdee.eas.base.param.ParamManagerControlInfo;
import com.kingdee.eas.base.param.ParamValueRangeInfo;
import com.kingdee.eas.base.param.client.AbstractControlRangeUI;
import com.kingdee.eas.base.param.util.ParamClientUtil;
import com.kingdee.eas.base.param.util.ParamControlUtil;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ControlRangeUI
extends AbstractControlRangeUI {
    private static final Logger logger = CoreUIObject.getLogger(ControlRangeUI.class);
    private String resName = "com.kingdee.eas.base.param.ParamResource";
    private String metaFilter = "com_kingdee_eas_base_paramBaseDataType";
    private FullOrgUnitCollection orgUnitCol;
    private int DEFAULT_LEVEL = 2;
    private static final int INDEX = 0;
    private static final int CONTROL = 1;
    private static final int INCLUDE_SUB = 2;
    private static final int ORG_NUMBER = 3;
    private static final int ORG_NAME = 4;
    private static final int PARAM_VALUE = 5;
    private static final int CAN_MODIFY = 6;
    private static final int ORG_LONG_NUMBER = 7;
    private static final int ORG_INFO = 8;
    private static final int PARAMITEMINFO = 9;
    private static final int SUPERIOR_CONTROL_ID = 10;
    private static final int IS_SUPER_CONTROLED = 11;
    private static final int PC_FID = 12;
    List paramValueList = new ArrayList();
    private List paramItemList;
    private MetaDataBriefInfo md;
    private List baseDataList;
    private ParamInfo paramInfo;
    private ParamItemInfo curSelectParamItemInfo = null;
    private String status = "success";
    List newControlledOrgUnitIDList = new ArrayList();
    OrgUnitInfo orgInfo;
    private ParamDataType dataType;
    private Integer curLevel = new Integer(2);
    List ctrlRangeInfoList = new ArrayList();
    Map changedMap = new HashMap();
    Map showOldParamValueMap = new HashMap();
    Map oldUpdateParamValueMap = new HashMap();
    private Map longNumberAndIncludeSubParamControlMap = new HashMap();

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.status.equals("error")) {
            return;
        }
        int j = this.kdTable.getRowCount();
        for (int i = 0; i < j; ++i) {
            IRow row = this.kdTable.getRow(i);
            if (!row.getCell(1).getValue().equals(Boolean.TRUE) || !StringUtils.isEmpty((String)StringUtils.cnulls((Object)row.getCell(5).getValue()))) continue;
            String resource = EASResource.getString((String)this.resName, (String)"LAB_DI_CanNotNull");
            MessageFormat mf = new MessageFormat(resource);
            String result = mf.format(new Object[]{this.kdTable.getCell(i, 0).getValue()});
            MsgBox.showError((Component)((Object)this), (String)result);
            return;
        }
        this.changedMap.put("oldUpdateParamValueMap", this.oldUpdateParamValueMap);
        ParamManagerControlFactory.getRemoteInstance().saveParamManagerControls(this.changedMap);
        this.getUIWindow().close();
    }

    private void limitLevel(Integer level) {
        this.kDSpinner1.setValue((Object)level);
        this.kDSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (Integer.valueOf(ControlRangeUI.this.kDSpinner1.getValue().toString()).compareTo(new Integer(ControlRangeUI.this.DEFAULT_LEVEL)) == -1) {
                    ControlRangeUI.this.kDSpinner1.setValue((Object)new Integer(ControlRangeUI.this.DEFAULT_LEVEL));
                }
            }
        });
    }

    private Map getLongNumberAndIncludeSubParamControlMap() throws Exception {
        HashMap<String, ParamManagerControlInfo> ret = new HashMap<String, ParamManagerControlInfo>();
        ParamManagerControlCollection paramControlCol = ParamManagerControlFactory.getRemoteInstance().getParamManagerControlsOfIncludeSub(this.paramInfo.getId().toString());
        int size = paramControlCol.size();
        for (int i = 0; i < size; ++i) {
            ParamManagerControlInfo pcInfo = paramControlCol.get(i);
            String orgLongNumber = pcInfo.getParamItem().getOrgUnitID().getLongNumber();
            ret.put(orgLongNumber, pcInfo);
        }
        return ret;
    }

    public void onLoad() throws Exception {
        this.kdTable.getLayoutManager().setToolTipVisible(false);
        super.onLoad();
        this.curSelectParamItemInfo = (ParamItemInfo)this.getUIContext().get("paramItem");
        this.orgInfo = this.curSelectParamItemInfo.getOrgUnitID();
        this.dataType = this.curSelectParamItemInfo.getKeyID().getDataType();
        this.paramInfo = this.curSelectParamItemInfo.getKeyID();
        this.longNumberAndIncludeSubParamControlMap = ParamManagerControlFactory.getRemoteInstance().getLongNumberAndIncludeSubParamControlMap(this.paramInfo.getId().toString(), this.paramInfo.getOrgType());
        Map orgAndParamControlMap = this.getOrgAndParamControlMap();
        this.initTableColumns();
        this.limitLevel(new Integer(this.DEFAULT_LEVEL));
        this.init(orgAndParamControlMap);
        if (this.getUIContext().get("state") != null && "view".equals(this.getUIContext().get("state").toString())) {
            this.btnOK.setEnabled(false);
        }
        this.kdTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    if (e.getColIndex() == 5) {
                        ControlRangeUI.this.checkValue(e);
                    }
                    ControlRangeUI.this.addToChangedMap(e);
                }
                catch (ParamException pe1) {
                    logger.error((Object)"ParamException", (Throwable)((Object)pe1));
                }
            }

            public void editValueChanged(KDTEditEvent e1) {
                if (e1.getColIndex() == 1) {
                    ControlRangeUI.this.afterSelectChanged(e1);
                } else if (e1.getColIndex() == 2) {
                    ControlRangeUI.this.afterIncludeSubChanged(e1);
                } else if (e1.getColIndex() == 6) {
                    ControlRangeUI.this.afterCanModifyChanged(e1);
                }
            }
        });
    }

    private void addToChangedMap(KDTEditEvent e) {
        String newValue;
        String oldValue;
        ParamItemInfo paramItemInfo;
        int rowIndex = e.getRowIndex();
        IRow row = this.kdTable.getRow(rowIndex);
        ParamManagerControlInfo info = new ParamManagerControlInfo();
        info.setIsControlled((Boolean)row.getCell(1).getValue());
        info.setIsIncludeSub((Boolean)row.getCell(2).getValue());
        info.setCanModify((Boolean)row.getCell(6).getValue());
        info.setId((BOSUuid)row.getCell(12).getValue());
        boolean isSuperControled = (Boolean)row.getCell(11).getValue();
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)row.getCell(8).getValue();
        String orgUnitId = orgUnitInfo.getId().toString();
        if (!isSuperControled) {
            info.setSuperiorControlID(orgUnitId);
        }
        if ((paramItemInfo = (ParamItemInfo)row.getCell(9).getValue()) == null) {
            paramItemInfo = new ParamItemInfo();
            paramItemInfo.setIsModify(false);
        }
        paramItemInfo.setOrgUnitID(orgUnitInfo);
        paramItemInfo.setKeyID(this.curSelectParamItemInfo.getKeyID());
        paramItemInfo.setOrgTreeID(this.curSelectParamItemInfo.getOrgTreeID());
        Object paramValue = row.getCell(5).getValue();
        ParamControlUtil.setParamValueByDataType(null, paramValue, paramItemInfo, this.curSelectParamItemInfo.getKeyID().getDataType());
        info.setParamItem(paramItemInfo);
        Object obj = this.showOldParamValueMap.get(orgUnitId);
        if (obj != null && !ToolUtils.equalObject((Object)(oldValue = obj.toString()), (Object)(newValue = paramItemInfo.getValue()))) {
            this.oldUpdateParamValueMap.put(orgUnitId, oldValue);
        }
        this.changedMap.put(orgUnitId, info);
    }

    private void checkValue(KDTEditEvent e) throws ParamException {
        IRow row;
        String result;
        MessageFormat mf;
        String s;
        Number paramValue;
        Color c;
        this.status = "success";
        ParamValueRangeInfo pvrf = null;
        if (ParamDataType.Date.equals((Object)this.dataType) || ParamDataType.Int.equals((Object)this.dataType) || ParamDataType.Double.equals((Object)this.dataType)) {
            pvrf = this.curSelectParamItemInfo.getKeyID().getTheValueRange();
        }
        ICell cell = this.kdTable.getCell(e.getRowIndex(), 5);
        Object cellValue = cell.getValue();
        if (e.getColIndex() == 5 && this.dataType.equals((Object)ParamDataType.Color) && (c = (Color)cell.getValue()) != null) {
            cell.getStyleAttributes().setBackground(c);
        }
        if (e.getColIndex() == 5 && this.dataType.equals((Object)ParamDataType.Date)) {
            DateFormat format = BOSLocaleUtil.getDateFormat();
            Date itemDateTime = null;
            Date maxDateTime = null;
            Date minDateTime = null;
            try {
                String result2;
                MessageFormat mf2;
                String s2;
                if (cellValue != null && !cellValue.toString().equals("")) {
                    itemDateTime = DateParser.pasterDate((String)cell.getValue().toString());
                }
                if (!StringUtils.isEmpty((String)pvrf.getMaxValue())) {
                    maxDateTime = format.parse(pvrf.getMaxValue().toString());
                }
                if (pvrf.getMinValue() != null && !pvrf.getMinValue().equals("")) {
                    minDateTime = format.parse(pvrf.getMinValue().toString());
                }
                if (maxDateTime != null && itemDateTime != null && itemDateTime.after(maxDateTime)) {
                    this.status = "error";
                    s2 = EASResource.getString((String)this.resName, (String)"CanNotBiggerThanMax");
                    mf2 = new MessageFormat(s2);
                    result2 = mf2.format(new String[]{maxDateTime.toLocaleString()});
                    MsgBox.showError((String)result2);
                    cell.setValue((Object)maxDateTime);
                }
                if (minDateTime != null && itemDateTime != null && itemDateTime.before(minDateTime)) {
                    this.status = "error";
                    s2 = EASResource.getString((String)this.resName, (String)"CanNotLessThanMin");
                    mf2 = new MessageFormat(s2);
                    result2 = mf2.format(new String[]{minDateTime.toLocaleString()});
                    MsgBox.showError((String)result2);
                    cell.setValue((Object)minDateTime);
                }
            }
            catch (ParseException e1) {
                logger.error((Object)"error:ParseException", (Throwable)e1);
            }
            catch (FormatException e2) {
                logger.error((Object)"error:FormatException", (Throwable)e2);
            }
        }
        if (e.getColIndex() == 5 && this.dataType.equals((Object)ParamDataType.Int)) {
            paramValue = null;
            Integer minValue = null;
            Integer maxValue = null;
            if (cellValue != null && !cellValue.toString().equals("")) {
                paramValue = Integer.decode(cellValue.toString());
            }
            if (!StringUtils.isEmpty((String)pvrf.getMaxValue())) {
                maxValue = Integer.decode(pvrf.getMaxValue());
            }
            if (!StringUtils.isEmpty((String)pvrf.getMinValue())) {
                minValue = Integer.decode(pvrf.getMinValue());
            }
            if (paramValue != null && maxValue != null && ((Integer)paramValue).compareTo(maxValue) == 1) {
                this.status = "error";
                s = EASResource.getString((String)this.resName, (String)"CanNotBiggerThanMax");
                mf = new MessageFormat(s);
                result = mf.format(new String[]{maxValue.toString()});
                MsgBox.showError((String)result);
                cell.setValue((Object)maxValue);
            }
            if (paramValue != null && minValue != null && ((Integer)paramValue).compareTo(minValue) == -1) {
                this.status = "error";
                s = EASResource.getString((String)this.resName, (String)"CanNotLessThanMin");
                mf = new MessageFormat(s);
                result = mf.format(new String[]{minValue.toString()});
                MsgBox.showError((String)result);
                cell.setValue((Object)minValue);
            }
        }
        if (e.getColIndex() == 5 && this.dataType.equals((Object)ParamDataType.Double)) {
            paramValue = null;
            Double maxValue = null;
            Double minValue = null;
            if (cellValue != null && !cellValue.toString().equals("")) {
                paramValue = Double.valueOf(cellValue.toString());
            }
            if (!StringUtils.isEmpty((String)pvrf.getMaxValue())) {
                maxValue = Double.valueOf(pvrf.getMaxValue().toString());
            }
            if (!StringUtils.isEmpty((String)pvrf.getMinValue())) {
                minValue = Double.valueOf(pvrf.getMinValue().toString());
            }
            if (paramValue != null && maxValue != null && ((Double)paramValue).compareTo(maxValue) == 1) {
                this.status = "error";
                s = EASResource.getString((String)this.resName, (String)"CanNotBiggerThanMax");
                mf = new MessageFormat(s);
                result = mf.format(new String[]{maxValue.toString()});
                MsgBox.showError((String)result);
                cell.setValue((Object)maxValue);
            }
            if (paramValue != null && minValue != null && ((Double)paramValue).compareTo(minValue) == -1) {
                this.status = "error";
                s = EASResource.getString((String)this.resName, (String)"CanNotLessThanMin");
                mf = new MessageFormat(s);
                result = mf.format(new String[]{minValue.toString()});
                MsgBox.showError((String)result);
                cell.setValue((Object)minValue);
            }
        }
        if (Boolean.TRUE.equals((row = this.kdTable.getRow(e.getRowIndex())).getCell(2).getValue())) {
            Object value = this.kdTable.getCell(e.getRowIndex(), 5).getValue();
            if (value == null) {
                return;
            }
            String clickRow_longNumber = (String)this.kdTable.getCell(e.getRowIndex(), 7).getValue();
            int j = this.kdTable.getRowCount();
            for (int i = e.getRowIndex(); i < j; ++i) {
                IRow iRow = this.kdTable.getRow(i);
                String longNumber = (String)iRow.getCell(7).getValue();
                ParamItemInfo subParamItemInfo = (ParamItemInfo)iRow.getCell(9).getValue();
                if (!this.paramInfo.isCanBeModified() && subParamItemInfo != null && subParamItemInfo.isIsModify() || !longNumber.startsWith(clickRow_longNumber + "!")) continue;
                if (this.dataType.equals((Object)ParamDataType.Color)) {
                    iRow.getCell(5).getStyleAttributes().setBackground((Color)value);
                }
                iRow.getCell(5).setValue(value);
            }
        }
    }

    private void afterSelectChanged(KDTEditEvent e) {
        if (Boolean.TRUE.equals(e.getValue())) {
            this.kdTable.getCell(e.getRowIndex(), 5).getStyleAttributes().setLocked(false);
            this.kdTable.getCell(e.getRowIndex(), 2).getStyleAttributes().setLocked(false);
            this.kdTable.getCell(e.getRowIndex(), 6).getStyleAttributes().setLocked(false);
        } else {
            this.kdTable.getCell(e.getRowIndex(), 2).setValue((Object)Boolean.FALSE);
            this.kdTable.getCell(e.getRowIndex(), 6).getStyleAttributes().setLocked(true);
            this.kdTable.getCell(e.getRowIndex(), 6).setValue((Object)Boolean.TRUE);
            this.kdTable.getCell(e.getRowIndex(), 5).getStyleAttributes().setLocked(true);
        }
    }

    private void afterIncludeSubChanged(KDTEditEvent e) {
        String currLongNumber = (String)this.kdTable.getCell(e.getRowIndex(), 7).getValue();
        Boolean canModify = (Boolean)this.kdTable.getCell(e.getRowIndex(), 6).getValue();
        if (Boolean.TRUE.equals(e.getValue())) {
            this.kdTable.getCell(e.getRowIndex(), 1).setValue((Object)Boolean.TRUE);
            this.kdTable.getCell(e.getRowIndex(), 5).getStyleAttributes().setLocked(false);
            this.autoSelectSub(Boolean.TRUE, currLongNumber, canModify, e);
        } else {
            this.kdTable.getCell(e.getRowIndex(), 5).getStyleAttributes().setLocked(false);
            this.autoSelectSub(Boolean.FALSE, currLongNumber, null, e);
        }
        this.btnRefresh.requestFocus();
    }

    private void afterCanModifyChanged(KDTEditEvent e) {
        IRow row = this.kdTable.getRow(e.getRowIndex());
        if (row.getCell(2).getValue().equals(Boolean.TRUE)) {
            Object value = this.kdTable.getCell(e.getRowIndex(), 6).getValue();
            String clickRow_longNumber = (String)this.kdTable.getCell(e.getRowIndex(), 7).getValue();
            int j = this.kdTable.getRowCount();
            for (int i = e.getRowIndex(); i < j; ++i) {
                IRow iRow = this.kdTable.getRow(i);
                String longNumber = (String)iRow.getCell(7).getValue();
                if (!longNumber.startsWith(clickRow_longNumber + "!")) continue;
                if (value.equals(Boolean.TRUE)) {
                    iRow.getCell(6).setValue((Object)Boolean.FALSE);
                    continue;
                }
                iRow.getCell(6).setValue((Object)Boolean.TRUE);
            }
        }
        this.btnRefresh.requestFocus();
    }

    private void autoSelectSub(boolean flag, String currLongNumber, Boolean canModify, KDTEditEvent e) {
        int sizeOfTable = this.kdTable.getRowCount();
        for (int i = 0; i < sizeOfTable; ++i) {
            boolean isCanNotModify;
            String longNumber = (String)this.kdTable.getCell(i, 7).getValue();
            if (!longNumber.startsWith(currLongNumber + "!") || this.kdTable.getCell(i, 0).getStyleAttributes().getBackground().equals(Color.LIGHT_GRAY)) continue;
            this.kdTable.getCell(i, 1).setValue((Object)flag);
            this.kdTable.getCell(i, 2).setValue((Object)false);
            ICell iCell = this.kdTable.getCell(i, 5);
            ICell iCell2 = this.kdTable.getCell(e.getRowIndex(), 5);
            IRow row = this.kdTable.getRow(i);
            ParamItemInfo tempParamItemInfo = (ParamItemInfo)row.getCell(9).getValue();
            boolean bl = isCanNotModify = !this.paramInfo.isCanBeModified() && tempParamItemInfo != null && tempParamItemInfo.isIsModify();
            if (flag) {
                row.getStyleAttributes().setBackground(Color.GRAY);
                row.getCell(1).getStyleAttributes().setLocked(true);
                row.getCell(2).getStyleAttributes().setLocked(true);
                row.getCell(6).getStyleAttributes().setLocked(true);
                if (isCanNotModify) continue;
                iCell.getStyleAttributes().setLocked(true);
                iCell.setValue(iCell2.getValue());
            } else if (isCanNotModify) {
                row.getStyleAttributes().setBackground(Color.GRAY);
                row.getStyleAttributes().setLocked(true);
            } else {
                row.getStyleAttributes().setBackground(Color.WHITE);
                row.getStyleAttributes().setLocked(true);
                row.getCell(1).getStyleAttributes().setLocked(false);
                row.getCell(2).getStyleAttributes().setLocked(false);
                row.getCell(6).getStyleAttributes().setLocked(false);
                row.getCell(6).setValue((Object)Boolean.TRUE);
            }
            if (this.dataType.equals((Object)ParamDataType.Color)) {
                Color color = (Color)iCell2.getValue();
                iCell.getStyleAttributes().setBackground(color);
            }
            if (canModify == null) continue;
            this.kdTable.getCell(i, 6).setValue((Object)canModify);
        }
    }

    private Map getOrgAndParamControlMap() throws EASBizException, BOSException {
        IParamManagerControl iParamManagerControl = ParamManagerControlFactory.getRemoteInstance();
        Map orgAndParamControlMap = iParamManagerControl.getOrgAndParamControlMap(this.curSelectParamItemInfo, this.curLevel);
        this.handleEmptyParamControl(orgAndParamControlMap);
        return orgAndParamControlMap;
    }

    private void handleEmptyParamControl(Map orgAndParamControlMap) {
        Set orgCol = orgAndParamControlMap.keySet();
        for (FullOrgUnitInfo org : orgCol) {
            ParamManagerControlInfo value = (ParamManagerControlInfo)orgAndParamControlMap.get(org);
            if (value != null && value.getId() != null) continue;
            ParamManagerControlInfo superParamControlInfo = this.getSuperIncludeParamControlInfo(org);
            ParamManagerControlInfo paramControlInfo = new ParamManagerControlInfo();
            if (superParamControlInfo != null) {
                paramControlInfo.setIsControlled(true);
                paramControlInfo.setCanModify(superParamControlInfo.isCanModify());
                paramControlInfo.setIsIncludeSub(false);
                paramControlInfo.setSuperiorControlID(superParamControlInfo.getParamItem().getOrgUnitID().getId().toString());
                if (value != null && superParamControlInfo.isCanModify()) {
                    paramControlInfo.setParamItem(value.getParamItem());
                } else {
                    ParamItemInfo info = (ParamItemInfo)superParamControlInfo.getParamItem().clone();
                    info.setId(null);
                    paramControlInfo.setParamItem(info);
                }
                orgAndParamControlMap.put(org, paramControlInfo);
                continue;
            }
            paramControlInfo.setIsControlled(false);
            paramControlInfo.setCanModify(true);
            paramControlInfo.setIsIncludeSub(false);
            if (value != null) {
                paramControlInfo.setParamItem(value.getParamItem());
            } else {
                ParamItemInfo temp = new ParamItemInfo();
                temp.setOrgUnitID(org);
                temp.setValue(this.curSelectParamItemInfo.getKeyID().getDefaultValue());
                temp.setKeyID(this.curSelectParamItemInfo.getKeyID());
                paramControlInfo.setParamItem(temp);
            }
            orgAndParamControlMap.put(org, paramControlInfo);
        }
    }

    private ParamManagerControlInfo getSuperIncludeParamControlInfo(FullOrgUnitInfo org) {
        Iterator itr = this.longNumberAndIncludeSubParamControlMap.keySet().iterator();
        String curLongNumber = org.getLongNumber();
        while (itr.hasNext()) {
            String includeLongNumber = (String)itr.next();
            if (!curLongNumber.startsWith(includeLongNumber + "!")) continue;
            return (ParamManagerControlInfo)this.longNumberAndIncludeSubParamControlMap.get(includeLongNumber);
        }
        return null;
    }

    private List getSortedIncludeSubOrgLongNumber() {
        ArrayList orgLongNumberList = new ArrayList();
        Iterator itr = this.longNumberAndIncludeSubParamControlMap.keySet().iterator();
        while (itr.hasNext()) {
            orgLongNumberList.add(itr.next());
        }
        Collections.sort(orgLongNumberList);
        return orgLongNumberList;
    }

    private List getSortedOrgUnitList(Map orgAndParamControlInfoMap) {
        ArrayList orgList = new ArrayList();
        Iterator keyItr = orgAndParamControlInfoMap.keySet().iterator();
        while (keyItr.hasNext()) {
            orgList.add(keyItr.next());
        }
        Collections.sort(orgList, new Comparator(){

            public int compare(Object o1, Object o2) {
                FullOrgUnitInfo org1 = (FullOrgUnitInfo)o1;
                FullOrgUnitInfo org2 = (FullOrgUnitInfo)o2;
                return org1.getLongNumber().compareTo(org2.getLongNumber());
            }
        });
        return orgList;
    }

    private void init(Map orgAndParamControlInfoMap) throws BOSException, EASBizException {
        Set orgCol = orgAndParamControlInfoMap.keySet();
        Iterator keyItr = orgCol.iterator();
        FullOrgUnitInfo orgUnitInfo = null;
        int i = 0;
        while (keyItr.hasNext()) {
            boolean paramCanBeModified;
            IRow row = this.kdTable.addRow();
            row.getStyleAttributes().setLocked(true);
            orgUnitInfo = (FullOrgUnitInfo)keyItr.next();
            ParamManagerControlInfo paramControlInfo = (ParamManagerControlInfo)orgAndParamControlInfoMap.get(orgUnitInfo);
            ParamManagerControlInfo superParamControlInfo = this.getSuperIncludeParamControlInfo(orgUnitInfo);
            row.getCell(8).setValue((Object)orgUnitInfo);
            row.getCell(12).setValue((Object)paramControlInfo.getId());
            row.getCell(0).setValue((Object)new Integer(i + 1));
            boolean isControled = paramControlInfo.isIsControlled();
            ICell isControlCell = row.getCell(1);
            isControlCell.getStyleAttributes().setLocked(false);
            isControlCell.setValue((Object)isControled);
            ICell includeSubCell = row.getCell(2);
            includeSubCell.setValue((Object)paramControlInfo.isIsIncludeSub());
            row.getCell(3).setValue((Object)orgUnitInfo.getNumber());
            row.getCell(4).setValue((Object)orgUnitInfo.getName());
            ICell canModifyCell = row.getCell(6);
            canModifyCell.setValue((Object)paramControlInfo.isCanModify());
            row.getCell(7).setValue((Object)orgUnitInfo.getLongNumber());
            ParamItemInfo paramItem = paramControlInfo.getParamItem();
            this.showOldParamValueMap.put(orgUnitInfo.getId().toString(), paramItem.getValue());
            row.getCell(9).setValue((Object)paramItem);
            row.getCell(11).setValue((Object)paramControlInfo.isSuperControled());
            ICell valueCell = row.getCell(5);
            ICell superiorControlIdCell = row.getCell(10);
            String superiorControlID = paramControlInfo.getSuperiorControlID();
            superiorControlIdCell.setValue((Object)superiorControlID);
            boolean isCanModify = paramControlInfo.isCanModify();
            if (isControled) {
                boolean isSuperControled = paramControlInfo.isSuperControled();
                if (isSuperControled) {
                    isControlCell.getStyleAttributes().setLocked(true);
                    if (isCanModify) {
                        valueCell.getStyleAttributes().setLocked(false);
                    }
                } else {
                    isControlCell.getStyleAttributes().setLocked(false);
                    includeSubCell.getStyleAttributes().setLocked(false);
                    valueCell.getStyleAttributes().setLocked(false);
                    canModifyCell.getStyleAttributes().setLocked(false);
                }
            }
            if (superParamControlInfo != null) {
                row.getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(Color.GRAY);
                if (isCanModify && !SysContext.getSysContext().getCurrentOrgUnit().getId().toString().equals(superParamControlInfo.getSuperiorControlID())) {
                    valueCell.getStyleAttributes().setLocked(false);
                    valueCell.getStyleAttributes().setBackground(Color.white);
                }
            }
            if (!(paramCanBeModified = this.paramInfo.isCanBeModified()) && paramItem.isIsModify()) {
                valueCell.getStyleAttributes().setLocked(true);
                valueCell.getStyleAttributes().setBackground(Color.GRAY);
                isControlCell.getStyleAttributes().setLocked(true);
            }
            this.initParamValue(valueCell, this.dataType, paramItem);
            ++i;
        }
    }

    private void initTableColumns() {
        this.kdTable.setFormatXml("");
        this.kdTable.removeRows();
        this.kdTable.removeHeadRows();
        this.kdTable.removeColumns();
        this.kdTable.addHeadRow();
        this.kdTable.addColumns(13);
        this.kdTable.getColumn(0).setWidth(30);
        this.kdTable.getColumn(1).setWidth(30);
        this.kdTable.getColumn(2).setWidth(60);
        this.kdTable.getColumn(3).setWidth(70);
        this.kdTable.getColumn(4).setWidth(200);
        this.kdTable.getColumn(5).setWidth(80);
        this.kdTable.getColumn(6).setWidth(50);
        this.kdTable.getHeadRow(0).getCell(1).setValue((Object)EASResource.getString((String)this.resName, (String)"CONTROL"));
        this.kdTable.getHeadRow(0).getCell(2).setValue((Object)EASResource.getString((String)this.resName, (String)"INCLUDESUB"));
        this.kdTable.getHeadRow(0).getCell(3).setValue((Object)EASResource.getString((String)this.resName, (String)"NUMBER"));
        this.kdTable.getHeadRow(0).getCell(4).setValue((Object)EASResource.getString((String)this.resName, (String)"NAME"));
        this.kdTable.getHeadRow(0).getCell(5).setValue((Object)EASResource.getString((String)this.resName, (String)"PARAMVALUE"));
        this.kdTable.getHeadRow(0).getCell(6).setValue((Object)EASResource.getString((String)this.resName, (String)"CANMODIFY"));
        this.kdTable.getColumn(7).getStyleAttributes().setHided(true);
        this.kdTable.getColumn(8).getStyleAttributes().setHided(true);
        this.kdTable.getColumn(9).getStyleAttributes().setHided(true);
        this.kdTable.getColumn(10).getStyleAttributes().setHided(true);
        this.kdTable.getColumn(11).getStyleAttributes().setHided(true);
        this.kdTable.getColumn(3).getStyleAttributes().setLocked(true);
        this.kdTable.getColumn(4).getStyleAttributes().setLocked(true);
        this.kdTable.getColumn(5).getStyleAttributes().setLocked(true);
        this.kdTable.getIndexColumn().getStyleAttributes().setHided(true);
        this.kdTable.getColumn(0).getStyleAttributes().setLocked(true);
        this.kdTable.getColumn(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.kdTable.getColumn(12).getStyleAttributes().setHided(true);
    }

    private void setTableValue(ICell iCell, Boolean value) {
        Object[] obj = new Object[]{EASResource.getString((String)this.resName, (String)"YES"), EASResource.getString((String)this.resName, (String)"NO")};
        KDComboBox cb = new KDComboBox(obj);
        cb.putClientProperty((Object)"jump", (Object)"false");
        iCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cb));
        if (Boolean.TRUE.equals(value)) {
            cb.setSelectedIndex(0);
            iCell.setValue(cb.getSelectedItem());
        } else if (Boolean.FALSE.equals(value)) {
            cb.setSelectedIndex(1);
            iCell.setValue(cb.getSelectedItem());
        }
    }

    private void setTableValue(ICell iCell, Date value) {
        KDDatePicker picker = new KDDatePicker();
        picker.setMilliSecondEnable(false);
        picker.setDateEnabled(true);
        String format = CtrlFormatUtilities.getDateFormatString();
        String dateFormat = "%{" + format + "}t";
        picker.setDatePattern(format);
        picker.putClientProperty((Object)"jump", (Object)"false");
        this.kdTable.getColumn(5).setEditor((ICellEditor)new KDTDefaultCellEditor(picker));
        this.kdTable.getColumn(5).getStyleAttributes().setNumberFormat(dateFormat);
        if (value != null) {
            picker.setValue((Object)value);
        }
        iCell.setValue(picker.getValue());
    }

    private void setTableValue(ICell iCell, Color color) {
        KDComboColor cc = new KDComboColor();
        iCell.setRenderer(new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                Rectangle r = clip.getBounds();
                int width = r.width;
                int height = r.height;
                int x = r.x;
                int y = r.y;
                graphics.setColor((Color)object);
                graphics.drawRect(x, y, width, height);
                graphics.fillRect(x, y, width, height);
            }
        });
        cc.putClientProperty((Object)"jump", (Object)"false");
        iCell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)cc));
        if (color != null) {
            cc.setSelectionModel((ColorSelectionModel)new ComboColorSelectionModel(color));
            iCell.getStyleAttributes().setBackground(color);
            iCell.setValue((Object)color);
        }
    }

    private void setTableValue(ICell iCell, Integer paramItem) {
        KDComboBox cb = new KDComboBox();
        Object[] list = (EmunCustomize[])ParamClientUtil.iniEnumValues(this.paramInfo.getTheValueRange().getValueEnum(), this.paramInfo.getTheValueRange().getExclusValue());
        cb.removeAllItems();
        cb.addItems(list);
        Object ec = null;
        if (list != null) {
            for (int m = 0; m < list.length; ++m) {
                ec = list[m];
                if (((EmunCustomize)ec).intValue == paramItem) break;
            }
        }
        cb.setSelectedItem(ec);
        cb.putClientProperty((Object)"jump", (Object)"false");
        iCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cb));
        iCell.setValue(ec);
    }

    private void initParamValue(ICell paramValueCell, ParamDataType dataType, ParamItemInfo paramItem) throws BOSException {
        String paramValue = paramItem.getValue();
        if (dataType.equals((Object)ParamDataType.BaseInformation)) {
            KDBizPromptBox bpb = new KDBizPromptBox();
            bpb.setEditFormat("$number$");
            bpb.setDisplayFormat("$name$");
            bpb.setCommitFormat("$number$");
            bpb.setEditable(true);
            bpb.setEnabledMultiSelection(false);
            if (paramItem.getKeyID() == null) {
                return;
            }
            String baseType = this.curSelectParamItemInfo.getKeyID().getBaseType();
            MetaDataBriefInfo md = SubSystemUtils.getMetaDataBriefInfoByFullName((String)baseType, (String)this.metaFilter);
            String properties = SubSystemUtils.getExtendPropertyValue((MetaDataBriefInfo)md, (String)"defaultF7Query");
            bpb.setQueryInfo(properties);
            bpb.putClientProperty((Object)"jump", (Object)"false");
            paramValueCell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bpb));
            IObjectValue ov = paramItem.getBaseData();
            if (ov != null) {
                bpb.setData((Object)ov);
                paramValueCell.setValue((Object)ov);
            } else {
                BOSObjectType bostype = SubSystemUtils.getEntityObjectInfo((MetaDataBriefInfo)md).getType();
                IDynamicObject dyn = DynamicObjectFactory.getRemoteInstance();
                ObjectStringPK pk = new ObjectStringPK(paramValue);
                IObjectValue baseData = dyn.getValue(bostype, (IObjectPK)pk);
                bpb.setData((Object)baseData);
                paramValueCell.setValue((Object)baseData);
            }
        }
        if (dataType.equals((Object)ParamDataType.Boolean)) {
            this.setTableValue(paramValueCell, Boolean.valueOf(paramValue));
        }
        if (dataType.equals((Object)ParamDataType.Date)) {
            try {
                this.setTableValue(paramValueCell, DateParser.pasterDate((String)paramValue));
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
        }
        if (dataType.equals((Object)ParamDataType.Color)) {
            int rgb = Integer.decode(paramValue);
            Color color = new Color(rgb);
            this.setTableValue(paramValueCell, color);
        }
        if (dataType.equals((Object)ParamDataType.Int)) {
            KDFormattedTextField ftf = new KDFormattedTextField();
            ftf.setDataType(0);
            ftf.setDataVerifierType(12);
            ftf.putClientProperty((Object)"jump", (Object)"false");
            paramValueCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)ftf));
            paramValueCell.setValue((Object)paramValue);
        }
        if (dataType.equals((Object)ParamDataType.String)) {
            paramValueCell.setValue((Object)paramValue);
        }
        if (dataType.equals((Object)ParamDataType.Enum)) {
            this.setTableValue(paramValueCell, new Integer(paramItem.getValue()));
        }
        if (dataType.equals((Object)ParamDataType.Double)) {
            KDFormattedTextField ftf = new KDFormattedTextField();
            ftf.setDataType(5);
            ftf.setDataVerifierType(12);
            String decimalFormat = "%{" + CtrlFormatUtilities.getDecimalFormatString() + "}f";
            paramValueCell.getStyleAttributes().setNumberFormat(decimalFormat);
            ftf.putClientProperty((Object)"jump", (Object)"false");
            paramValueCell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)ftf));
            paramValueCell.setValue((Object)paramValue);
        }
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.curLevel = (Integer)this.kDSpinner1.getValue();
        this.longNumberAndIncludeSubParamControlMap = ParamManagerControlFactory.getRemoteInstance().getLongNumberAndIncludeSubParamControlMap(this.paramInfo.getId().toString(), this.paramInfo.getOrgType());
        Map orgAndParamControlMap = this.getOrgAndParamControlMap();
        this.kdTable.removeRows();
        this.init(orgAndParamControlMap);
    }
}

