/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.CurrencyFormatForNationalEnum;
import com.kingdee.eas.base.param.DateFormatForNationalEnum;
import com.kingdee.eas.base.param.INationalPlan;
import com.kingdee.eas.base.param.INationalPlanForLanguage;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.param.NationalPlanCollection;
import com.kingdee.eas.base.param.NationalPlanFactory;
import com.kingdee.eas.base.param.NationalPlanForLanguageFactory;
import com.kingdee.eas.base.param.NationalPlanForLanguageInfo;
import com.kingdee.eas.base.param.NationalPlanInfo;
import com.kingdee.eas.base.param.NumberFormatForNationalEnum;
import com.kingdee.eas.base.param.ParamException;
import com.kingdee.eas.base.param.TimeFormatForNationalEnum;
import com.kingdee.eas.base.param.client.AbstractNationalizationConfigUI;
import com.kingdee.eas.base.param.client.PlanNameDlg;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.assistant.ITimeZone;
import com.kingdee.eas.basedata.assistant.TimeZoneCollection;
import com.kingdee.eas.basedata.assistant.TimeZoneFactory;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Semaphore;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class NationalizationConfigUI
extends AbstractNationalizationConfigUI {
    private static final Logger logger = CoreUIObject.getLogger(NationalizationConfigUI.class);
    private boolean isAdmin = false;
    private HashMap sysplanhash = new HashMap();
    private KDLabelContainer anothernamecontainer;
    private KDTextField anothername;
    private String resName = "com.kingdee.eas.base.param.ParamResource";
    private String nationResName = "com.kingdee.eas.base.param.NationalPlanResource";
    private static TimeZoneInfo defaultTimeZone = NationalizationConfigUI.getDefaultTimeZoneInfo();
    private static final Semaphore semp = new Semaphore(1);
    private static volatile boolean isCacheCleaned;

    public NationalizationConfigUI() throws Exception {
        this.kDTabbedPane1.setForcedHide(true);
        this.kDTabbedPane2.setForcedHide(true);
        this.jbinit();
        this.initPreData();
        this.initData();
        this.initButton();
        this.initLanguage();
        this.addPlanchangeListener();
    }

    private void completeTimeZoneF7() {
        KDBizPromptBox prmtTimeZone = new KDBizPromptBox();
        prmtTimeZone.setQueryInfo("com.kingdee.eas.basedata.assistant.app.TimeZoneQuery");
        prmtTimeZone.setDisplayFormat("$name$");
        prmtTimeZone.setEditFormat("$number$");
        prmtTimeZone.setCommitFormat("$number$;$name$");
        ExtendParser parser = new ExtendParser(prmtTimeZone);
        prmtTimeZone.setCommitParser((IParser)parser);
        KDTDefaultCellEditor kdtBEBankCellEditor = new KDTDefaultCellEditor((IKDEditor)prmtTimeZone);
    }

    private void addPlanchangeListener() {
        this.kDComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (arg0.getStateChange() == 1) {
                    String planname = arg0.getItem().toString();
                    NationalizationConfigUI.this.changShowInfoWithPlan(planname);
                }
            }
        });
        this.kDComboBox22.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (arg0.getStateChange() == 1) {
                    LanguageInfo langobject = (LanguageInfo)arg0.getItem();
                    String languagename = langobject.locale;
                    NationalizationConfigUI.this.changShowInfoWithLanguage(languagename);
                }
            }
        });
    }

    private void changShowInfoWithLanguage(String languagename) {
        INationalPlanForLanguage inflang = null;
        NationalPlanForLanguageInfo info = null;
        String langcode = languagename;
        try {
            inflang = NationalPlanForLanguageFactory.getRemoteInstance();
            INationalPlan inplan = NationalPlanFactory.getRemoteInstance();
            NationalPlanInfo nplan = null;
            if (inflang.isExistLanguagePlan(langcode)) {
                info = inflang.getLanguagePlanBylanguageName(langcode);
                String planid = info.getPlanid();
                nplan = inplan.getNationalPlanInfo((IObjectPK)new ObjectUuidPK(planid));
                this.kDComboBox23.setEditable(true);
                this.kDComboBox23.setSelectedItem((Object)nplan.getName());
                this.kDComboBox23.setEditable(false);
            } else {
                this.kDComboBox23.setSelectedItem(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changShowInfoWithPlan(String planname) {
        boolean issysanddefault = false;
        NationalPlanInfo nplan = null;
        try {
            INationalPlan inplan = NationalPlanFactory.getRemoteInstance();
            NationalPlanInfo sysnplan = inplan.getSysDefaultPlan();
            if (sysnplan != null && sysnplan.getName().equals(planname)) {
                issysanddefault = true;
            }
            nplan = inplan.getPlanByPlanname(planname);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (nplan != null) {
            this.showSelectedInfoByPlan(nplan, issysanddefault);
        }
    }

    private void initLanguage() {
        Map sortedLangMap = UIConfig.getLanguages();
        Object[] langs = new LanguageInfo[sortedLangMap.size()];
        Iterator iterator = sortedLangMap.entrySet().iterator();
        int index = 0;
        Locale local = ContextUtils.getLocaleFromEnv();
        Object selectedlanguage = null;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            String[] locales = key.split("#");
            langs[index] = new LanguageInfo(locales[0], (String)entry.getValue());
            if (((LanguageInfo)langs[index]).locale.equalsIgnoreCase(local.toString())) {
                selectedlanguage = langs[index];
            }
            ++index;
        }
        this.kDComboBox22.addItems(langs);
        this.kDComboBox22.setEditable(true);
        this.kDComboBox22.setSelectedItem(selectedlanguage);
        this.kDComboBox22.setEditable(false);
        if (selectedlanguage != null) {
            this.changShowInfoWithLanguage(((LanguageInfo)selectedlanguage).locale);
        }
    }

    public static String getTimeZoneByNumExpress(TimeZone timeZone) {
        int rawOffset = timeZone.getRawOffset();
        int timeZoneByNumExpress = rawOffset / 3600000;
        String timeZoneByNumExpressStr = "";
        if (timeZoneByNumExpress > 0 && timeZoneByNumExpress < 10) {
            timeZoneByNumExpressStr = "+0" + timeZoneByNumExpress + ":00";
        } else if (timeZoneByNumExpress >= 10) {
            timeZoneByNumExpressStr = "+" + timeZoneByNumExpress + ":00";
        } else if (timeZoneByNumExpress > -10 && timeZoneByNumExpress < 0) {
            timeZoneByNumExpress = Math.abs(timeZoneByNumExpress);
            timeZoneByNumExpressStr = "-0" + timeZoneByNumExpress + ":00";
        } else if (timeZoneByNumExpress <= -10) {
            timeZoneByNumExpress = Math.abs(timeZoneByNumExpress);
            timeZoneByNumExpressStr = "-" + timeZoneByNumExpress + ":00";
        } else {
            timeZoneByNumExpressStr = "Z";
        }
        return "UTC " + timeZoneByNumExpressStr;
    }

    private void jbinit() {
        String[] zoneids = TimeZone.getAvailableIDs();
        Object tzColl = null;
        this.kDComboBox3.addItem((Object)TimeFormatForNationalEnum.TIMEFORMAT_HHMMSS);
        this.kDComboBox3.addItem((Object)TimeFormatForNationalEnum.TIMEFORMAT_HMMSS);
        this.kDComboBox3.addItem((Object)TimeFormatForNationalEnum.TIMEFORMAT_TTHHMMSS);
        this.kDComboBox3.addItem((Object)TimeFormatForNationalEnum.TIMEFORMAT_TTHMMSS);
        this.kDComboBox3.addItem((Object)TimeFormatForNationalEnum.TIMEFORMAT_HMMSSA);
        this.kDComboBox3.addItem((Object)TimeFormatForNationalEnum.TIMEFORMAT_HHMMSSA);
        this.kDComboBox4.addItem((Object)TimeFormatForNationalEnum.TIMEFORMAT_SEPARATER);
        this.kDComboBox6.setVisible(false);
        this.kDComboBox5.setVisible(false);
        this.kDLabelContainer9.setVisible(false);
        this.kDLabelContainer10.setVisible(false);
        this.kDComboBox7.addItem((Object)DateFormatForNationalEnum.SHORTDATE_MMDDYYYY);
        this.kDComboBox7.addItem((Object)DateFormatForNationalEnum.SHORTDATE_YYMD);
        this.kDComboBox7.addItem((Object)DateFormatForNationalEnum.SHORTDATE_YYYYMD);
        this.kDComboBox7.addItem((Object)DateFormatForNationalEnum.SHORTDATE_YYYYMMDD);
        this.kDComboBox7.addItem((Object)DateFormatForNationalEnum.SHORTDATE_DDMMYY);
        this.kDComboBox8.addItem((Object)DateFormatForNationalEnum.DATESEPARATOR_PERIOD);
        this.kDComboBox8.addItem((Object)DateFormatForNationalEnum.DATESEPARATOR_VIRGULE);
        this.kDComboBox8.addItem((Object)DateFormatForNationalEnum.DATESPERATOR_DASH);
        this.kDComboBox9.addItem((Object)DateFormatForNationalEnum.LONGDATE_1);
        this.kDComboBox9.addItem((Object)DateFormatForNationalEnum.LONGDATE_2);
        this.kDComboBox9.addItem((Object)DateFormatForNationalEnum.LONGDATE_3);
        this.kDComboBox9.addItem((Object)DateFormatForNationalEnum.LONGDATE_4);
        this.kDComboBox10.addItems(CurrencyFormatForNationalEnum.getEnumList().toArray());
        this.kDComboBox11.addItem((Object)"\uffe51.1");
        this.kDComboBox11.addItem((Object)"1.1\uffe5");
        this.kDComboBox12.addItem((Object)"-\uffe51.1");
        this.kDComboBox12.addItem((Object)"\uffe5-1.1");
        this.kDComboBox13.addItem((Object)".");
        this.kDComboBox13.addItem((Object)",");
        this.kDComboBox14.addItem((Object)"2");
        this.kDComboBox15.addItem((Object)((Object)((Object)NumberFormatForNationalEnum.NUMBER_SEPARATOR_COMMA) + "          " + EASResource.getString((String)this.nationResName, (String)"comma4thousand")));
        this.kDComboBox15.addItem((Object)((Object)((Object)NumberFormatForNationalEnum.NUMBER_SEPARATOR_PERIOD) + "          " + EASResource.getString((String)this.nationResName, (String)"dot4thousand")));
        this.kDComboBox15.addItem((Object)("           " + EASResource.getString((String)this.nationResName, (String)"blank4thousand")));
        this.kDComboBox15.addItem((Object)("           " + EASResource.getString((String)this.nationResName, (String)"space4thousand")));
        this.kDComboBox16.addItem((Object)NumberFormatForNationalEnum.NUMBER_SEPARATOR_PERIOD);
        this.kDComboBox16.addItem((Object)NumberFormatForNationalEnum.NUMBER_SEPARATOR_COMMA);
        this.kDComboBox17.addItem((Object)"2");
        this.kDComboBox18.addItem((Object)((Object)((Object)NumberFormatForNationalEnum.NUMBER_SEPARATOR_COMMA) + "          " + EASResource.getString((String)this.nationResName, (String)"comma4thousand")));
        this.kDComboBox18.addItem((Object)((Object)((Object)NumberFormatForNationalEnum.NUMBER_SEPARATOR_PERIOD) + "          " + EASResource.getString((String)this.nationResName, (String)"dot4thousand")));
        this.kDComboBox18.addItem((Object)("           " + EASResource.getString((String)this.nationResName, (String)"blank4thousand")));
        this.kDComboBox18.addItem((Object)("           " + EASResource.getString((String)this.nationResName, (String)"space4thousand")));
        this.kDComboBox19.addItem((Object)"-");
        this.kDComboBox20.addItem((Object)"-1.1");
        this.kDComboBox20.addItem((Object)"1.1-");
        this.kDComboBox21.addItem((Object)".7");
        this.kDComboBox21.addItem((Object)"0.7");
    }

    private void initPreData() {
        this.kDTextField4.setText("\uffe5123,456,789.00");
        this.kDTextField5.setText("123,456,789.00");
    }

    private String myDateFormat(String formatType) {
        char dateseprator = this.kDComboBox8.getSelectedItem().toString().trim().charAt(0);
        formatType = formatType.replace('-', dateseprator);
        formatType = formatType.replace('/', dateseprator);
        formatType = formatType.replace('.', dateseprator);
        SimpleDateFormat format = new SimpleDateFormat(formatType);
        String tzone = this.kDComboBox2.getSelectedItem().toString();
        String zoneid = tzone.substring(0, tzone.indexOf("--"));
        format.setTimeZone(TimeZone.getTimeZone(zoneid));
        return format.format(new Date());
    }

    private String myTimeFormat(String formatType) {
        SimpleDateFormat format = new SimpleDateFormat();
        DateFormatSymbols dfs = new DateFormatSymbols();
        format.setDateFormatSymbols(dfs);
        String tzone = this.kDComboBox2.getSelectedItem().toString();
        String zoneid = tzone.substring(0, tzone.indexOf("--"));
        format.setTimeZone(TimeZone.getTimeZone(zoneid));
        format.applyPattern(formatType);
        return format.format(new Date());
    }

    public void initData() {
        this.isAdmin = UserType.SYSTEM.equals((Object)SysContext.getSysContext().getCurrentUserInfo().getType());
        this.disEnableField();
        if (!this.isAdmin) {
            this.disableAllCoponent();
        } else {
            this.sysplanhash = this.getSystemPlans();
            this.kDComboBox1.removeAllItems();
            this.kDComboBox1.addItems(this.sysplanhash.keySet().toArray());
            this.kDComboBox23.removeAllItems();
            this.kDComboBox23.addItems(this.sysplanhash.keySet().toArray());
        }
        this.showPlanAtFirst();
        this.preview();
    }

    private void showPlanAtFirst() {
        NationalPlanInfo nplan = null;
        boolean issysanddefault = false;
        try {
            INationalPlan inplan = NationalPlanFactory.getRemoteInstance();
            nplan = inplan.getSysDefaultPlan();
            issysanddefault = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (nplan != null) {
            this.showSelectedInfoByPlan(nplan, issysanddefault);
        }
    }

    private String getTimezoneStr(String timezonestr) {
        String[] timezonearr = timezonestr.split("--");
        String timezonetemp = "";
        String timezonedisplaynamebylocal = TimeZone.getTimeZone(timezonearr[0]).getDisplayName(true, 1, BOSLocaleUtil.getDefaultLocale());
        if (null != timezonedisplaynamebylocal && null != timezonearr[0] && !"".equals(timezonedisplaynamebylocal)) {
            timezonetemp = timezonearr[0] + "--" + timezonedisplaynamebylocal;
        }
        return timezonetemp;
    }

    private static TimeZoneInfo getDefaultTimeZoneInfo() {
        if (defaultTimeZone != null) {
            return defaultTimeZone;
        }
        TimeZoneInfo tzInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("sortNumber", (Object)999, CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        try {
            ITimeZone iTimeZone = TimeZoneFactory.getRemoteInstance();
            TimeZoneCollection tzColl = iTimeZone.getTimeZoneCollection(viewInfo);
            int size = tzColl != null && tzColl.size() > 0 ? tzColl.size() : 0;
            int sortNum = 10;
            for (int i = 0; i < size; ++i) {
                if (tzColl.get(i).getSortNumber() >= sortNum) continue;
                tzInfo = tzColl.get(i);
                sortNum = tzInfo.getSortNumber();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        defaultTimeZone = tzInfo;
        return tzInfo;
    }

    private void showSelectedInfoByPlan(NationalPlanInfo nplan, boolean issysanddefault) {
        this.changeComboxToEditble(true);
        this.kDComboBox1.setSelectedItem((Object)nplan.getName());
        this.kDComboBox2.setSelectedItem((Object)this.getTimezoneStr(nplan.getTimezone()));
        this.kDComboBox3.setSelectedItem((Object)nplan.getTimeformat());
        this.kDComboBox4.setSelectedItem((Object)nplan.getTimeseparator());
        this.kDComboBox7.setSelectedItem((Object)nplan.getShortdateformat());
        this.kDComboBox8.setSelectedItem((Object)nplan.getDatesperator());
        this.kDComboBox9.setSelectedItem((Object)nplan.getLongdateformat());
        this.kDComboBox10.setSelectedItem((Object)nplan.getCurrencysymbol());
        this.kDComboBox11.setSelectedItem((Object)nplan.getCurrencyplusformat());
        this.kDComboBox12.setSelectedItem((Object)nplan.getCurrencynegaformat());
        this.kDComboBox13.setSelectedItem((Object)nplan.getCurrencypoint());
        this.kDComboBox14.setSelectedItem((Object)Integer.toString(nplan.getPointdigit()));
        this.kDComboBox15.setSelectedItem((Object)this.converThousand(nplan.getThousandseparator(), false));
        this.kDComboBox16.setSelectedItem((Object)nplan.getNumberpoint());
        this.kDComboBox17.setSelectedItem((Object)Integer.toString(nplan.getNumpointdigit()));
        this.kDComboBox18.setSelectedItem((Object)this.converThousand(nplan.getNumthousandseparator(), false));
        this.kDComboBox19.setSelectedItem((Object)nplan.getMinussymbol());
        this.kDComboBox20.setSelectedItem((Object)nplan.getNegativeformat());
        this.kDComboBox21.setSelectedItem((Object)nplan.getZeroshow());
        TimeZoneInfo tz = null;
        try {
            ITimeZone iTimezone = TimeZoneFactory.getRemoteInstance();
            tz = nplan.getTimeZoneID() != null && nplan.getTimeZoneID().getId() != null ? (TimeZoneInfo)iTimezone.getValue((IObjectPK)new ObjectUuidPK(nplan.getTimeZoneID().getId())) : defaultTimeZone;
            this.timeZoneValue.setUseCacheObject(false);
            this.timeZoneValue.setData((Object)tz);
            this.timeZoneValue.setUserData((Object)tz);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        this.changeComboxToEditble(false);
        if (nplan.isIssysdefault()) {
            this.kDCheckBox1.setSelected(true);
        } else {
            this.kDCheckBox1.setSelected(false);
        }
        this.preview();
    }

    private void changeComboxToEditble(boolean flag) {
        this.kDComboBox1.setEditable(flag);
        this.kDComboBox2.setEditable(flag);
        this.kDComboBox3.setEditable(flag);
        this.kDComboBox4.setEditable(flag);
        this.kDComboBox5.setEditable(flag);
        this.kDComboBox6.setEditable(flag);
        this.kDComboBox7.setEditable(flag);
        this.kDComboBox8.setEditable(flag);
        this.kDComboBox9.setEditable(flag);
        this.kDComboBox10.setEditable(flag);
        this.kDComboBox11.setEditable(flag);
        this.kDComboBox12.setEditable(flag);
        this.kDComboBox13.setEditable(flag);
        this.kDComboBox14.setEditable(flag);
        this.kDComboBox15.setEditable(flag);
        this.kDComboBox16.setEditable(flag);
        this.kDComboBox17.setEditable(flag);
        this.kDComboBox18.setEditable(flag);
        this.kDComboBox19.setEditable(flag);
        this.kDComboBox20.setEditable(flag);
        this.kDComboBox21.setEditable(flag);
    }

    private NationalPlanInfo getSysPlanForFirstShow() {
        NationalPlanInfo np = null;
        try {
            INationalPlan inplan = NationalPlanFactory.getRemoteInstance();
            np = inplan.getSysDefaultPlan();
            return np;
        }
        catch (Exception e) {
            e.printStackTrace();
            return np;
        }
    }

    public void disableAllCoponent() {
        this.kDComboBox23.setEnabled(false);
        this.kDComboBox22.setEnabled(false);
        this.kDComboBox21.setEnabled(false);
        this.kDComboBox20.setEnabled(false);
        this.kDComboBox19.setEnabled(false);
        this.kDComboBox18.setEnabled(false);
        this.kDComboBox17.setEnabled(false);
        this.kDComboBox16.setEnabled(false);
        this.kDComboBox15.setEnabled(false);
        this.kDComboBox14.setEnabled(false);
        this.kDComboBox13.setEnabled(false);
        this.kDComboBox12.setEnabled(false);
        this.kDComboBox11.setEnabled(false);
        this.kDComboBox10.setEnabled(false);
        this.kDComboBox9.setEnabled(false);
        this.kDComboBox8.setEnabled(false);
        this.kDComboBox7.setEnabled(false);
        this.kDComboBox6.setEnabled(false);
        this.kDComboBox5.setEnabled(false);
        this.kDComboBox4.setEnabled(false);
        this.kDComboBox3.setEnabled(false);
        this.kDComboBox2.setEnabled(false);
        this.kDComboBox1.setEnabled(false);
        this.kDButton1.setEnabled(false);
        this.kDButton2.setEnabled(false);
        this.kDButton3.setEnabled(false);
        this.kDButton4.setEnabled(false);
        this.kDButton5.setEnabled(false);
        this.kDButton6.setEnabled(false);
        this.kDCheckBox1.setEnabled(false);
        this.timeZoneValue.setEnabled(false);
    }

    private void disEnableField() {
        this.kDTextField2.setEnabled(false);
        this.kDTextField3.setEnabled(false);
        this.kDTextField4.setEnabled(false);
        this.kDTextField5.setEnabled(false);
    }

    private HashMap getSystemPlans() {
        HashMap<String, NationalPlanInfo> hp = new HashMap<String, NationalPlanInfo>();
        try {
            INationalPlan inplan = NationalPlanFactory.getRemoteInstance();
            NationalPlanInfo nplan = null;
            NationalPlanCollection coll = inplan.getNationalPlanCollection();
            for (int i = 0; i < coll.size(); ++i) {
                nplan = coll.get(i);
                hp.put(nplan.getName(), nplan);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hp;
    }

    private void preview() {
        this.kDTextField2.setText(this.myTimeFormat(this.kDComboBox3.getSelectedItem().toString()));
        this.kDTextField3.setText(this.myDateFormat(this.kDComboBox7.getSelectedItem().toString()));
        this.kDTextField4.setText(this.myCurrencyFormat());
        this.kDTextField5.setText(this.myNumberFormat());
    }

    private String myCurrencyFormat() {
        DecimalFormatSymbols dfsbl = new DecimalFormatSymbols();
        dfsbl.setCurrencySymbol(this.kDComboBox10.getSelectedItem().toString());
        String groupSeparator = this.converThousand(this.kDComboBox15.getSelectedItem().toString().trim(), true);
        dfsbl.setMonetaryDecimalSeparator(this.kDComboBox13.getSelectedItem().toString().trim().charAt(0));
        if (!"".equals(groupSeparator)) {
            dfsbl.setGroupingSeparator(groupSeparator.charAt(0));
            DecimalFormat df = new DecimalFormat();
            df.setDecimalFormatSymbols(dfsbl);
            df.applyPattern("\u00a4###,###,###.00");
            String currencystr = df.format(1.23456789E8);
            return currencystr;
        }
        DecimalFormat df = new DecimalFormat();
        df.setDecimalFormatSymbols(dfsbl);
        df.applyPattern("\u00a4#########.00");
        String currencystr = df.format(1.23456789E8);
        return currencystr;
    }

    private String myNumberFormat() {
        DecimalFormatSymbols dfsbl = new DecimalFormatSymbols();
        String groupSeparator = this.converThousand(this.kDComboBox18.getSelectedItem().toString().trim(), true);
        dfsbl.setDecimalSeparator(this.kDComboBox16.getSelectedItem().toString().trim().charAt(0));
        if (!"".equals(groupSeparator)) {
            dfsbl.setGroupingSeparator(groupSeparator.charAt(0));
            DecimalFormat df = new DecimalFormat();
            df.setDecimalFormatSymbols(dfsbl);
            df.applyPattern("###,###,###.00");
            String currencystr = df.format(1.23456789E8);
            return currencystr;
        }
        DecimalFormat df = new DecimalFormat();
        df.setDecimalFormatSymbols(dfsbl);
        df.applyPattern("#########.00");
        String currencystr = df.format(1.23456789E8);
        return currencystr;
    }

    private void savePlanData() {
        INationalPlan inplan = null;
        NationalPlanInfo nplan = null;
        Object pname = this.kDComboBox1.getSelectedItem();
        if (pname == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"chooseplan"));
            return;
        }
        try {
            inplan = NationalPlanFactory.getRemoteInstance();
            nplan = inplan.getPlanByPlanname(this.kDComboBox1.getSelectedItem().toString());
            nplan.setTimezone(this.kDComboBox2.getSelectedItem().toString());
            nplan.setTimeformat(this.kDComboBox3.getSelectedItem().toString());
            nplan.setTimeseparator(this.kDComboBox4.getSelectedItem().toString());
            nplan.setShortdateformat(this.kDComboBox7.getSelectedItem().toString());
            nplan.setDatesperator(this.kDComboBox8.getSelectedItem().toString());
            nplan.setLongdateformat(null);
            nplan.setCurrencysymbol(this.kDComboBox10.getSelectedItem().toString());
            nplan.setCurrencyplusformat(this.kDComboBox11.getSelectedItem().toString());
            nplan.setCurrencynegaformat(this.kDComboBox12.getSelectedItem().toString());
            nplan.setCurrencypoint(this.kDComboBox13.getSelectedItem().toString());
            nplan.setPointdigit(Integer.parseInt(this.kDComboBox14.getSelectedItem().toString()));
            nplan.setThousandseparator(this.converThousand(this.kDComboBox15.getSelectedItem().toString(), true));
            nplan.setNumberpoint(this.kDComboBox16.getSelectedItem().toString());
            nplan.setNumpointdigit(Integer.parseInt(this.kDComboBox17.getSelectedItem().toString()));
            nplan.setNumthousandseparator(this.converThousand(this.kDComboBox18.getSelectedItem().toString(), true));
            nplan.setMinussymbol(this.kDComboBox19.getSelectedItem().toString());
            nplan.setNegativeformat(this.kDComboBox20.getSelectedItem().toString());
            nplan.setZeroshow(this.kDComboBox21.getSelectedItem().toString());
            nplan.setTimeZoneID((TimeZoneInfo)this.timeZoneValue.getValue());
            if (this.kDCheckBox1.isSelected()) {
                NationalPlanInfo oldsysplan = inplan.getSysDefaultPlan();
                if (oldsysplan != null) {
                    oldsysplan.setIssysdefault(false);
                    inplan.update((IObjectPK)new ObjectUuidPK(oldsysplan.getId().toString()), (CoreBaseInfo)oldsysplan);
                }
                nplan.setIssysdefault(true);
            } else {
                NationalPlanInfo tempplan = inplan.getSysDefaultPlan();
                if (null == tempplan || null != tempplan && tempplan.getId().toString().equals(nplan.getId().toString())) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"mustconfigplan"));
                    return;
                }
                nplan.setIssysdefault(false);
            }
            inplan.update((IObjectPK)new ObjectUuidPK(nplan.getId().toString()), (CoreBaseInfo)nplan);
        }
        catch (ParamException e) {
            logger.error((Object)e.getCause(), (Throwable)((Object)e));
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            return;
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        try {
            NantionalServiceFacadeFactory.getRemoteInstance().clearNationPlanCache();
        }
        catch (EASBizException e) {
            logger.error((Object)"\u6e05\u5b9e\u4f8b\u7f13\u5b58\u51fa\u9519\u4e86", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"\u6e05\u5b9e\u4f8b\u7f13\u5b58\u51fa\u9519\u4e86", (Throwable)e);
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"saveSuccessed"));
    }

    public static void setIsCacheCleaned(boolean isCacheCleaned) {
    }

    private boolean isCacheCleaned() {
        return isCacheCleaned;
    }

    private String converThousand(String original, boolean isSaveOrPrew) {
        if (isSaveOrPrew) {
            if (StringUtils.isEmpty((String)original) && !" ".equals(original)) {
                return "";
            }
            if (original.indexOf(EASResource.getString((String)this.nationResName, (String)"comma4thousand")) > -1) {
                return ",";
            }
            if (original.indexOf(EASResource.getString((String)this.nationResName, (String)"dot4thousand")) > -1) {
                return ".";
            }
            if (original.indexOf(EASResource.getString((String)this.nationResName, (String)"blank4thousand")) > -1) {
                return "";
            }
            if (original.indexOf(EASResource.getString((String)this.nationResName, (String)"space4thousand")) > -1) {
                return " ";
            }
        } else {
            if (",".equals(original)) {
                return (Object)((Object)NumberFormatForNationalEnum.NUMBER_SEPARATOR_COMMA) + "          " + EASResource.getString((String)this.nationResName, (String)"comma4thousand");
            }
            if (".".equals(original)) {
                return (Object)((Object)NumberFormatForNationalEnum.NUMBER_SEPARATOR_PERIOD) + "          " + EASResource.getString((String)this.nationResName, (String)"dot4thousand");
            }
            if (StringUtils.isEmpty((String)original) && !" ".equals(original)) {
                return "           " + EASResource.getString((String)this.nationResName, (String)"blank4thousand");
            }
            if (StringUtils.isEmpty((String)original)) {
                return "           " + EASResource.getString((String)this.nationResName, (String)"space4thousand");
            }
        }
        return original;
    }

    private void exitConfig() {
    }

    private PlanNameDlg showPlanNameDlg(Component cp) {
        Frame parent = (Frame)SwingUtilities.getRoot(cp);
        PlanNameDlg dlg = new PlanNameDlg(parent, true);
        dlg.show();
        return dlg;
    }

    private void savaLanguageplan() {
        INationalPlanForLanguage inflang = null;
        NationalPlanForLanguageInfo langinfo = null;
        INationalPlan inplan = null;
        NationalPlanInfo nplan = null;
        String languagecode = ((LanguageInfo)this.kDComboBox22.getSelectedItem()).locale;
        try {
            inflang = NationalPlanForLanguageFactory.getRemoteInstance();
            inplan = NationalPlanFactory.getRemoteInstance();
            if (inflang.isExistLanguagePlan(languagecode)) {
                langinfo = inflang.getLanguagePlanBylanguageName(languagecode);
                String planname = this.kDComboBox23.getSelectedItem().toString();
                nplan = inplan.getPlanByPlanname(planname);
                langinfo.setPlanid(nplan.getId().toString());
                inflang.update((IObjectPK)new ObjectUuidPK(langinfo.getId().toString()), (CoreBaseInfo)langinfo);
            } else {
                langinfo = new NationalPlanForLanguageInfo();
                langinfo.setLanguagcode(languagecode);
                String planname = this.kDComboBox23.getSelectedItem().toString();
                nplan = inplan.getPlanByPlanname(planname);
                langinfo.setPlanid(nplan.getId().toString());
                inflang.addnew((CoreBaseInfo)langinfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveAnotherPlan(String planname, ActionEvent arg0) {
        try {
            INationalPlan inplan = NationalPlanFactory.getRemoteInstance();
            if (inplan.checkPlanname(planname)) {
                MsgBox.showInfo((Component)((Component)arg0.getSource()), (String)EASResource.getString((String)this.resName, (String)"nameexists"));
                return;
            }
            NationalPlanInfo nplan = new NationalPlanInfo();
            nplan.setName(planname, new Locale("l1"));
            nplan.setName(planname, new Locale("l2"));
            nplan.setName(planname, new Locale("l3"));
            nplan.setName(planname);
            nplan.setTimezone(this.kDComboBox2.getSelectedItem().toString());
            nplan.setTimeformat(this.kDComboBox3.getSelectedItem().toString());
            nplan.setTimeseparator(this.kDComboBox4.getSelectedItem().toString());
            nplan.setShortdateformat(this.kDComboBox7.getSelectedItem().toString());
            nplan.setDatesperator(this.kDComboBox8.getSelectedItem().toString());
            nplan.setLongdateformat(null);
            nplan.setCurrencysymbol(this.kDComboBox10.getSelectedItem().toString());
            nplan.setCurrencyplusformat(this.kDComboBox11.getSelectedItem().toString());
            nplan.setCurrencynegaformat(this.kDComboBox12.getSelectedItem().toString());
            nplan.setCurrencypoint(this.kDComboBox13.getSelectedItem().toString());
            nplan.setPointdigit(Integer.parseInt(this.kDComboBox14.getSelectedItem().toString()));
            nplan.setThousandseparator(this.converThousand(this.kDComboBox15.getSelectedItem().toString(), true));
            nplan.setNumberpoint(this.kDComboBox16.getSelectedItem().toString());
            nplan.setNumpointdigit(Integer.parseInt(this.kDComboBox17.getSelectedItem().toString()));
            nplan.setNumthousandseparator(this.converThousand(this.kDComboBox18.getSelectedItem().toString(), true));
            nplan.setMinussymbol(this.kDComboBox19.getSelectedItem().toString());
            nplan.setNegativeformat(this.kDComboBox20.getSelectedItem().toString());
            nplan.setZeroshow(this.kDComboBox21.getSelectedItem().toString());
            IObjectPK iObjectPK = inplan.addnew((CoreBaseInfo)nplan);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initButton() {
        this.kDButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NationalizationConfigUI.this.savaLanguageplan();
                MsgBox.showInfo((Component)((Component)arg0.getSource()), (String)EASResource.getString((String)NationalizationConfigUI.this.resName, (String)"saveSuccessed"));
            }
        });
        this.kDButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NationalizationConfigUI.this.getUIWindow().close();
            }
        });
        this.kDButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NationalizationConfigUI.this.preview();
            }
        });
        this.kDButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NationalizationConfigUI.this.savePlanData();
            }
        });
        this.kDButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PlanNameDlg dlg = NationalizationConfigUI.this.showPlanNameDlg((Component)arg0.getSource());
                String planname = dlg.getFavName();
                if (dlg.getIsCancel()) {
                    return;
                }
                if (!(planname != null && planname.length() != 0 || dlg.getIsCancel())) {
                    MsgBox.showInfo((Component)((Component)arg0.getSource()), (String)EASResource.getString((String)NationalizationConfigUI.this.resName, (String)"namecannotnull"));
                    return;
                }
                NationalizationConfigUI.this.saveAnotherPlan(planname, arg0);
                MsgBox.showInfo((Component)((Component)arg0.getSource()), (String)EASResource.getString((String)NationalizationConfigUI.this.resName, (String)"anothersavesuccess"));
                NationalizationConfigUI.this.initData();
            }
        });
        this.kDButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NationalizationConfigUI.this.getUIWindow().close();
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    class LanguageInfo {
        private String locale;
        private String name;

        public LanguageInfo(String locale, String name) {
            this.locale = locale;
            this.name = name;
        }

        public String getLocale() {
            return this.locale;
        }

        public String toString() {
            return this.name;
        }
    }
}

