/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.param.ParamCollection;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.client.AbstractParamDeleteUI;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IPermissionRangeFacade;
import com.kingdee.eas.base.permission.PermissionRangeFacadeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.service.OrgRangeService;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.OuF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.OUUnionF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.BigMsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ParamDeleteUI
extends AbstractParamDeleteUI {
    private static final Logger logger = CoreUIObject.getLogger(ParamDeleteUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initOrgF7();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initOrgF7() throws EASBizException, BOSException {
        OUUnionF7 orgF7 = new OUUnionF7((IUIObject)this);
        this.setF7ByUser((OuF7PromptDialog)orgF7, this.getTargetUserPK());
        orgF7.setShowSub(true);
        orgF7.disableTheOUWhichIsOnlyAdmin();
        orgF7.setMultiSelect(false);
        orgF7.setShowAssistantOrg(true);
        this.kDBizPromptBoxOrgUnit.setSelector((KDPromptSelector)orgF7);
    }

    private void setF7ByUser(OuF7PromptDialog orgf7, IObjectPK targetUserPK) throws EASBizException, BOSException {
        if (!Administrator.isCUAdmin(null, (IObjectPK)ToolUtils.getCurrentUserPK())) {
            HashMap<String, Boolean> accreditOrgs = new HashMap<String, Boolean>();
            IPermissionRangeFacade iPermissionRangeFacade = PermissionRangeFacadeFactory.getRemoteInstance();
            Collection col = iPermissionRangeFacade.getOrgRange(ToolUtils.getCurrentUserPK(), ToolUtils.getCurrentUserPK());
            if (col != null) {
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    accreditOrgs.put(it.next().toString(), Boolean.FALSE);
                }
            }
            orgf7.useFilter(accreditOrgs);
        }
        List cuIdList = OrgRangeService.getCUOrgRange(null, (IObjectPK)ToolUtils.getCurrentUserPK());
        try {
            orgf7.setCuIdList(cuIdList);
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
        orgf7.setMultiCUs(true);
    }

    private IObjectPK getTargetUserPK() {
        Object object = this.getUIContext().get("targetID");
        if (object == null) {
            return new ObjectUuidPK(this.getCurrentUser().getId());
        }
        return new ObjectUuidPK((String)this.getUIContext().get("targetID"));
    }

    private UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        FullOrgUnitInfo orgUnit = null;
        orgUnit = (FullOrgUnitInfo)this.kDBizPromptBoxOrgUnit.getData();
        if (orgUnit == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.param.ParamResource", (String)"orgUnitIsNull"));
            return;
        }
        ParamCollection deleteFailParam = null;
        deleteFailParam = (ParamCollection)ParamManager.deleteOrgUnitParam(null, orgUnit.getId().toString());
        if (deleteFailParam != null && deleteFailParam.size() > 0) {
            Iterator iterator = deleteFailParam.iterator();
            ParamInfo tempParam = null;
            StringBuffer copyFailParamNumberListStr = new StringBuffer();
            while (iterator.hasNext()) {
                tempParam = (ParamInfo)iterator.next();
                copyFailParamNumberListStr.append(tempParam.getNumber()).append(", ");
            }
            copyFailParamNumberListStr.deleteCharAt(copyFailParamNumberListStr.lastIndexOf(","));
            copyFailParamNumberListStr.append(EASResource.getString((String)"com.kingdee.eas.base.param.ParamResource", (String)"deleteParamFail"));
            BigMsgBox.showError((StringBuffer)copyFailParamNumberListStr);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.param.ParamResource", (String)"deleteParamSuccess"));
        }
    }
}

