/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.param.IParam;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.client.AbstractParamListUI;
import com.kingdee.eas.base.param.client.DeleteDumplicateParamUI;
import com.kingdee.eas.base.param.client.ParamDeleteUI;
import com.kingdee.eas.base.param.client.ParamEditUI;
import com.kingdee.eas.base.param.client.ParamSetEgo;
import com.kingdee.eas.base.param.client.SubSysTree;
import com.kingdee.eas.base.param.client.helper.ParamHelper;
import com.kingdee.eas.base.param.util.ParamClientUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class ParamListUI
extends AbstractParamListUI {
    Logger logger = Logger.getLogger(ParamListUI.class);
    ITreeBuilder treeBuilder;
    private IParam iParam;
    String SubSysId = "";
    private KDPopupMenu popMenu = null;
    private static final String VALUE_ALIAS = "param.valueAlias";
    private static final String PARAM_ID = "Param.id";
    private static final String PARAM_DATA_TYPE = "Param.dataType";

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName(this.getUIHandlerClassName());
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnAddParamItem_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.iParam = ParamFactory.getRemoteInstance();
        IUIFactory uiFactory = null;
        int i = ParamClientUtil.getSelectedRow(this.tblMain);
        if (this.tblMain.getRow(i) != null) {
            try {
                IRow iRow = this.tblMain.getRow(i);
                ObjectUuidPK ipk = new ObjectUuidPK(iRow.getCell(PARAM_ID).getValue().toString());
                ParamInfo paramInfo = this.iParam.getParamInfo((IObjectPK)ipk);
                String parentUpdDate = iRow.getCell("Param.lastUpdateTime").getValue().toString();
                String parentUpdUser = iRow.getCell("Param.lastUpdateUser").getValue().toString();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("Owner", (Object)this);
                map.put("ParamInfo", paramInfo);
                map.put("lastUpdateTime", parentUpdDate);
                map.put("lastUpdateUser", parentUpdUser);
                uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.param.client.ParamItemListUI", map);
                uiWindow.show();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.param.ParamResource", (String)"CanNotOpenParamItemListUI"), (Throwable)ex);
            }
        }
    }

    private void renderColorCell(KDTable table) throws EASBizException, BOSException {
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            ICell cell;
            String value;
            int dataType;
            Object type;
            IRow row = table.getRow(i);
            ICell typeCell = row.getCell(PARAM_DATA_TYPE);
            if (typeCell == null || (type = typeCell.getValue()) == null || !(type instanceof BizEnumValueDTO) || (dataType = ((BizEnumValueDTO)type).getInt()) != 7 || StringUtil.isEmptyString((String)(value = (cell = row.getCell(VALUE_ALIAS)).getValue().toString()))) continue;
            int rgb = Integer.decode(value);
            cell.getStyleAttributes().setBackground(new Color(rgb));
            cell.setValue((Object)"");
        }
    }

    private void iniKDTree() {
        try {
            ParamHelper paramHelper = new ParamHelper();
            this.treeSubSys = paramHelper.initTree(this.treeSubSys, false);
            this.treeSubSys.addMouseListener(this.initPopMenu());
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected String getEditUIName() {
        return ParamEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ParamFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return PARAM_ID;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setTableSelfAttr();
        this.setBtnStatusIsEnable(false);
        this.iniKDTree();
        this.addKDTableDataFillListener();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnLocate.setVisible(false);
        this.btnQuery.setVisible(false);
        this.menuItemQuery.setVisible(false);
        this.menuItemLocate.setVisible(false);
    }

    private void addKDTableDataFillListener() {
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                KDTable table = (KDTable)e.getSource();
                try {
                    ParamListUI.this.renderColorCell(table);
                }
                catch (Exception ex) {
                    ParamListUI.this.handleException(ex);
                }
                for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                    Object objValue = ((KDTable)e.getSource()).getCell(i, ParamListUI.VALUE_ALIAS).getValue();
                    if (objValue == null) continue;
                    if ("true".equalsIgnoreCase(objValue.toString())) {
                        ((KDTable)e.getSource()).getCell(i, ParamListUI.VALUE_ALIAS).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.param.ParamResource", (String)"Msg_True"));
                        continue;
                    }
                    if (!"false".equalsIgnoreCase(objValue.toString())) continue;
                    ((KDTable)e.getSource()).getCell(i, ParamListUI.VALUE_ALIAS).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.param.ParamResource", (String)"Msg_False"));
                }
            }
        });
    }

    private void setTableSelfAttr() {
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    private void setBtnStatusIsEnable(boolean status) {
        this.btnAddNew.setEnabled(status);
        this.btnEdit.setEnabled(status);
        this.btnRemove.setEnabled(status);
    }

    protected void setParamsBySubSys(String subSysID) {
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("subSysID", (Object)subSysID, CompareType.EQUALS));
        i.getFilterItems().add(new FilterItemInfo("userEdit", (Object)new Integer(0), CompareType.EQUALS));
        i.setMaskString("#0 and #1");
        this.mainQuery.setFilter(i);
        if (this.mainQuery.getSorter().isEmpty()) {
            this.mainQuery.getSorter().add(new SorterItemInfo("number"));
        }
        this.execQuery();
    }

    @Override
    protected void treeSubSys_valueChanged(TreeSelectionEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
        if (!treeNode.isRoot()) {
            if (treeNode.getUserObject() != null) {
                if (treeNode.getUserObject() instanceof SubSysTree) {
                    SubSysTree si = (SubSysTree)treeNode.getUserObject();
                    this.SubSysId = si.subSysIDString;
                } else {
                    MetaDataBriefInfo si = (MetaDataBriefInfo)treeNode.getUserObject();
                    this.SubSysId = si.getFullName();
                }
                this.setParamsBySubSys(this.SubSysId);
                this.setBtnStatusIsEnable(true);
            }
        } else {
            this.setBtnStatusIsEnable(false);
            this.SubSysId = "";
            this.setParamsBySubSys(this.SubSysId);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() != 2) {
            super.tblMain_tableClicked(e);
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        String lastDateTime = null;
        String lastUpdUser = null;
        if (((AbstractButton)e.getSource()).getAction().equals(this.actionAddNew)) {
            lastUpdUser = SysContext.getSysContext().getUserName();
            Date date = new Date(System.currentTimeMillis());
            lastDateTime = date.toString();
        } else {
            int i = ParamClientUtil.getSelectedRow(this.tblMain);
            IRow iRow = this.tblMain.getRow(i);
            if (iRow != null) {
                if (iRow.getCell("Param.lastUpdateTime").getValue() != null) {
                    lastDateTime = iRow.getCell("Param.lastUpdateTime").getValue().toString();
                }
                if (iRow.getCell("Param.lastUpdateUser").getValue() != null) {
                    lastUpdUser = iRow.getCell("Param.lastUpdateUser").getValue().toString();
                }
            }
        }
        uiContext.put((Object)"SubSysID", (Object)this.SubSysId);
        uiContext.put((Object)"lastUpdateTime", (Object)lastDateTime);
        uiContext.put((Object)"lastUpdateUser", (Object)lastUpdUser);
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.param.ParamResource", (String)"ParamDelete")));
    }

    private MouseListener initPopMenu() {
        this.popMenu = new KDPopupMenu();
        KDMenuItem menuItem = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.base.param.ParamResource", (String)"OtherParamSetting"), 1);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamListUI.this.menuItem_actionPerformed(e);
            }
        });
        this.popMenu.add((JMenuItem)menuItem);
        PopupListener popupListener = new PopupListener(this.popMenu);
        return popupListener;
    }

    private void menuItem_actionPerformed(ActionEvent e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Owner", (Object)this);
        map.put("SubSysId", this.SubSysId);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(ParamSetEgo.class.getName(), map, null, null);
            uiWindow.show();
        }
        catch (UIException e1) {
            this.logger.info((Object)"", (Throwable)e1);
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.iniKDTree();
    }

    @Override
    public void actionParamDelete_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(ParamDeleteUI.class.getName(), this.getUIContext(), null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    protected void btnDeleteDumpParam_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteDumpParam_actionPerformed(e);
        IUIFactory uiFactory = null;
        try {
            UIContext ctx = new UIContext((Object)this);
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow deleteDialog = uiFactory.create(DeleteDumplicateParamUI.class.getName(), (Map)ctx);
            deleteDialog.show();
        }
        catch (UIException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    class PopupListener
    extends MouseAdapter {
        KDPopupMenu popup;

        PopupListener(KDPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)ParamListUI.this.treeSubSys.getSelectionPath().getLastPathComponent();
            if (!treeNode.isRoot() && !(treeNode.getUserObject() instanceof SubSysTree) && e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

