/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.arcm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentFtpFacade;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentFtpInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentUploadClient;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.attachment.util.VariousAttachmentInfoMaker;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.arcm.DocReceiveInfo;
import com.kingdee.eas.cp.arcm.SendDocumentInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DocAttachmentUtil {
    private static Logger logger = Logger.getLogger(DocAttachmentUtil.class);

    public static String replaceIllegalCharactor(String originalStr) {
        if (StringUtils.isEmpty((String)originalStr)) {
            return "";
        }
        String[] invalidChars = new String[]{"/", "\\", "*", "\"", "'", "?", ":", "<", ">", "|", "!", "@", "#", "$", "%", "^", "&", ",", "`"};
        String illegalChar = "";
        String targetStr = originalStr;
        for (int i = 0; i < invalidChars.length; ++i) {
            illegalChar = invalidChars[i];
            if (originalStr.indexOf(illegalChar) <= -1) continue;
            originalStr = targetStr = Pattern.compile(illegalChar, 16).matcher(originalStr).replaceAll(DocAttachmentUtil.ToSBC(illegalChar));
        }
        return targetStr;
    }

    public static String ToSBC(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return "";
        }
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String ToDBC(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return "";
        }
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static void processUpload(Context ctx, BillBaseInfo newInfo, BillBaseInfo oldInfo, InputStream in) throws EASBizException, BOSException, Exception {
        String fileName = "";
        if (oldInfo instanceof DocReceiveInfo) {
            fileName = ((DocReceiveInfo)oldInfo).getName() + "-" + ((DocReceiveInfo)oldInfo).getReceiveNumber();
        }
        if (oldInfo instanceof SendDocumentInfo) {
            fileName = ((SendDocumentInfo)oldInfo).getName() + "-" + ((SendDocumentInfo)oldInfo).getCode();
        }
        fileName = DocAttachmentUtil.replaceIllegalCharactor(fileName);
        File file = new File(fileName);
        SimpleAttachmentInfo sai = DocAttachmentUtil.getSimpleFile(file, in);
        DocAttachmentUtil.addNewAttachment(ctx, newInfo.getId().toString(), sai);
    }

    public static void addNewAttachment(Context ctx, String boID, SimpleAttachmentInfo sai) throws BOSException, EASBizException {
        String oql;
        IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
        AttachmentCollection coll = iAttachment.getAttachmentCollection(oql = "select id where name = '" + sai.getMainName() + "'");
        if (coll.size() == 0) {
            AttachmentInfo attachmentInfo = VariousAttachmentInfoMaker.makeAttachmentInfo((IAttachment)iAttachment, (String)boID, (SimpleAttachmentInfo)sai);
            DocAttachmentUtil.submitAttachment(attachmentInfo, iAttachment, ctx);
        } else {
            BoAttchAssoInfo baai = new BoAttchAssoInfo();
            baai.setBoID(boID);
            baai.setAssoType(Resrcs.getString((String)"NewAttachment"));
            baai.setAssoBusObjType(BOSUuid.read((String)boID).getType().toString());
            baai.setAttachment(coll.get(0));
            BoAttchAssoFactory.getLocalInstance((Context)ctx).addnew(baai);
        }
    }

    public static String submitAttachment(AttachmentInfo attachmentInfo, IAttachment iAttachment, Context ctx) throws BOSException, EASBizException {
        IAttachmentFtpFacade iAttachmentFtpFacade = AttachmentFtpFacadeFactory.getLocalInstance((Context)ctx);
        String attchID = "";
        byte[] fileInfo = attachmentInfo.getFile();
        if (fileInfo != null && fileInfo.length > AttachmentFtpInfo.MAX_OF_UPLOAD_LENGTH) {
            logger.info((Object)" begin mutl part file upload");
            attachmentInfo.setFile(null);
            attchID = iAttachment.addnew(attachmentInfo).toString();
            try {
                AttachmentUploadClient fileUpload = new AttachmentUploadClient(iAttachmentFtpFacade);
                fileUpload.uploadFile(attchID, fileInfo);
            }
            catch (BOSException e) {
                iAttachment.delete((IObjectPK)new ObjectStringPK(attchID));
                logger.info((Object)"upload file fail:", (Throwable)e);
                throw e;
            }
            catch (EASBizException e) {
                iAttachment.delete((IObjectPK)new ObjectStringPK(attchID));
                logger.info((Object)"upload file fail:", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                iAttachment.delete((IObjectPK)new ObjectStringPK(attchID));
                logger.info((Object)"upload file fail:", (Throwable)e);
                throw new BOSException(e.getMessage());
            }
        } else {
            logger.info((Object)" begin one part file upload");
            attchID = iAttachment.addnew(attachmentInfo).toString();
        }
        return attchID;
    }

    public static SimpleAttachmentInfo getSimpleFile(File file, InputStream in) throws BOSException, EASBizException, Exception {
        try {
            String fullname = file.getName();
            String mainname = StringUtil4File.getMainFileName((String)fullname);
            String extname = StringUtil4File.getExtendedFileName((String)fullname);
            byte[] content = DocAttachmentUtil.getBytes(in);
            SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
            sai.setMainName(mainname);
            sai.setExtName("doc");
            sai.setContent(content);
            sai.setIsShared(false);
            return sai;
        }
        catch (FileNotFoundException fe) {
            throw new AttachmentException(AttachmentException.READFILEERROR);
        }
    }

    private static byte[] getBytes(InputStream in) throws Exception {
        int n;
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4000);
        byte[] b = new byte[4000];
        while ((n = in.read(b)) != -1) {
            out.write(b, 0, n);
        }
        in.close();
        out.close();
        return out.toByteArray();
    }

    public static void main(String[] args) {
        String name = "**////?";
        System.out.println(DocAttachmentUtil.replaceIllegalCharactor(name));
    }
}

