/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.StringUtil;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.cm.CMContentFactory;
import com.kingdee.eas.cp.eip.cm.CMContentInfo;
import com.kingdee.eas.cp.eip.cm.CMReaderCollection;
import com.kingdee.eas.cp.eip.cm.CMReaderFactory;
import com.kingdee.eas.cp.eip.cm.CMReaderInfo;
import com.kingdee.eas.cp.eip.cm.ICMContent;
import com.kingdee.eas.cp.eip.cm.ICMReader;
import com.kingdee.eas.cp.eip.cm.web.ContentResourceHandle;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.UuidException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CmFileStreamServlet
extends HttpServlet {
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        request.setCharacterEncoding("UTF-8");
        String fileNameStr = request.getParameter("fileName");
        if (fileNameStr != null) {
            fileNameStr = fileNameStr.replaceAll(" ", "+");
        }
        String fileId = "";
        try {
            ICMContent iCMContent = CMContentFactory.getLocalInstance(ctx);
            if (BOSUuid.isValid((String)fileNameStr, (boolean)true) && iCMContent.exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)fileNameStr)))) {
                CMContentInfo info = (CMContentInfo)iCMContent.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)fileNameStr)));
                fileId = null != info && null != info.getFile() ? info.getFile().toString() : "";
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        Object out = response.getOutputStream();
        AttachmentInfo attInfo = null;
        try {
            attInfo = !"".equals(fileId) ? ContentResourceHandle.getAttacheByBizID(ctx, fileId) : ContentResourceHandle.getAttacheByBizID(ctx, fileNameStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (attInfo == null) {
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        } else {
            String fileName = StringUtil.encoder((String)fileNameStr);
            if (fileName.indexOf("%") > -1) {
                fileName = fileName.replaceAll("%", "9");
            }
            String suffix = attInfo.getSimpleName();
            File fileDir = new File(this.getServletContext().getRealPath("") + "//resource//");
            if (!fileDir.exists()) {
                fileDir.mkdir();
            }
            File file = new File(this.getServletContext().getRealPath("") + "/resource/" + fileName + "." + suffix);
            BufferedInputStream in = null;
            fileName = attInfo.getName() != null && !"".equals(attInfo.getName()) ? attInfo.getName() : fileName;
            response.setHeader("Content-disposition", "attachment; filename=" + StringUtil.encoder((String)fileName) + "." + suffix);
            if (file.exists()) {
                int len;
                byte[] array;
                long saveOrUpdateToDBTime;
                long uploadTime = file.lastModified();
                if (uploadTime != (saveOrUpdateToDBTime = attInfo.getLastUpdateTime().getTime())) {
                    file.delete();
                    try {
                        in = new BufferedInputStream(new ByteArrayInputStream(attInfo.getFile()));
                        out = new BufferedOutputStream(new FileOutputStream(file));
                        file.setLastModified(attInfo.getLastUpdateTime().getTime());
                        array = new byte[4096];
                        len = 0;
                        while ((len = in.read(array)) != -1) {
                            ((OutputStream)out).write(array, 0, len);
                        }
                        ((OutputStream)out).flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            if (out != null) {
                                ((OutputStream)out).close();
                            }
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        in = new BufferedInputStream(new FileInputStream(file));
                        out = response.getOutputStream();
                        array = new byte[4096];
                        len = 0;
                        while ((len = in.read(array)) != -1) {
                            ((OutputStream)out).write(array, 0, len);
                        }
                        ((OutputStream)out).flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            if (out != null) {
                                ((OutputStream)out).close();
                            }
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    try {
                        in = new BufferedInputStream(new FileInputStream(file));
                        array = new byte[4096];
                        len = 0;
                        while ((len = in.read(array)) != -1) {
                            ((OutputStream)out).write(array, 0, len);
                        }
                        ((OutputStream)out).flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            if (out != null) {
                                ((OutputStream)out).close();
                            }
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                int len;
                byte[] array;
                try {
                    in = new BufferedInputStream(new ByteArrayInputStream(attInfo.getFile()));
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    file.setLastModified(attInfo.getLastUpdateTime().getTime());
                    array = new byte[4096];
                    len = 0;
                    while ((len = in.read(array)) != -1) {
                        ((OutputStream)out).write(array, 0, len);
                    }
                    ((OutputStream)out).flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    in = new BufferedInputStream(new FileInputStream(file));
                    out = response.getOutputStream();
                    array = new byte[4096];
                    len = 0;
                    while ((len = in.read(array)) != -1) {
                        ((OutputStream)out).write(array, 0, len);
                    }
                    ((OutputStream)out).flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            String username = ContextUtil.getCurrentUserInfo((Context)ctx).getName();
            String Dep = ContextUtil.getCurrentAdminUnit((Context)ctx).getName();
            if (fileNameStr != null) {
                fileNameStr = fileNameStr.replaceAll(" ", "+");
            }
            System.out.println("setRead.jsp >>>>>>>>>>>>>>>>>>>>> username=" + username + " Dep=" + Dep + " contentId=" + fileNameStr);
            if (fileNameStr != null && !fileNameStr.trim().equals("") && username != null && Dep != null) {
                EntityViewInfo tempEVI = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("contentID", (Object)fileNameStr, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("reader", (Object)username, CompareType.EQUALS));
                tempEVI.setFilter(filterInfo);
                try {
                    CMReaderCollection con = CMReaderFactory.getLocalInstance(ctx).getCollection(tempEVI);
                    if (con == null || con.size() == 0) {
                        ICMReader iCMReader = CMReaderFactory.getLocalInstance(ctx);
                        CMReaderInfo info = new CMReaderInfo();
                        info.setContentID(BOSUuid.read((String)fileNameStr));
                        info.setReader(username);
                        info.setReaderDep(Dep);
                        Date date = new Date();
                        info.setReadTime(new Timestamp(System.currentTimeMillis()));
                        iCMReader.addnew(info);
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

