/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.NLSSortType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.cm.CMReaderInfo;
import com.kingdee.eas.cp.eip.cm.web.ContentReadQueryAction;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class ContentHistoryAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger((String)ContentReadQueryAction.class.getName());
    String id = "";

    public ActionForward show(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.id = request.getParameter("id").replaceAll(" ", "+");
        return mapping.findForward("success");
    }

    public ActionForward Query(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        int total = 0;
        int totalPage = 0;
        int pageNo = 0;
        int pageSize = 0;
        int currentPage = 0;
        Date date = new Date();
        String page = request.getParameter("pageNumber");
        String pageSizeStr = request.getParameter("pageSize");
        String status = request.getParameter("status");
        String orderByField = request.getParameter("sortFieldName");
        String orderType = request.getParameter("sortType");
        String nlsOrderType = "";
        if (!orderByField.equals("readTime")) {
            nlsOrderType = NLSSortType.SCHINESE_PINYIN.getName();
        }
        if (orderType == null || orderType.trim().length() == 0) {
            orderType = SortType.DESCEND.getName();
        }
        orderType = orderType.toUpperCase();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        filterItemInfo = new FilterItemInfo("contentID", (Object)this.id);
        filterInfo.getFilterItems().add(filterItemInfo);
        if (page == null || page.equals("")) {
            page = "1";
        }
        if (pageSizeStr == null || pageSizeStr.equals("")) {
            pageSizeStr = "20";
        }
        pageNo = Integer.parseInt(page);
        pageSize = Integer.parseInt(pageSizeStr);
        orderType = orderType.toUpperCase();
        entityViewInfo.setFilter(filterInfo);
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentHisQuery");
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        try {
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            logger.debug((Object)("executor search content count sql is:" + exec.getSQL()));
            countRowSet = exec.executeQuery();
            if (countRowSet.next()) {
                total = countRowSet.size();
                logger.debug((Object)("record total is" + total));
            }
            totalPage = (total - 1) / pageSize + 1;
            logger.debug((Object)("total page is:" + totalPage));
            if (pageNo > totalPage) {
                pageNo = totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            currentPage = pageNo;
            SorterItemInfo sorterItemInfo = new SorterItemInfo(orderByField);
            sorterItemInfo.setSortType(SortType.getEnum((String)orderType));
            if (nlsOrderType != null && !"".equals(nlsOrderType)) {
                sorterItemInfo.setNLSSortType(NLSSortType.getEnum((String)nlsOrderType));
            }
            entityViewInfo.getSorter().add(sorterItemInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            logger.debug((Object)("executor search content sql is:" + exec.getSQL()));
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            request.setAttribute("totalCount", (Object)Integer.toString(total));
            request.setAttribute("ctListData", (Object)rowSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("querySuccess");
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public ActionForward print(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        HSSFWorkbook workbook = null;
        request.setCharacterEncoding("UTF-8");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        filterItemInfo = new FilterItemInfo("contentID", (Object)this.id);
        filterInfo.getFilterItems().add(filterItemInfo);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("readTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        entityViewInfo.getSorter().add(sorterItemInfo);
        entityViewInfo.setFilter(filterInfo);
        List linkCarList = this.getProcessedData(ctx, entityViewInfo);
        workbook = this.exportCommonExcel(request, linkCarList);
        this.printExcel(workbook, "\u9605\u8bfb\u8bb0\u5f55\u6e05\u5355.xls", request, response);
        return null;
    }

    public HSSFWorkbook exportCommonExcel(HttpServletRequest request, List list) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        HSSFWorkbook workbook = null;
        workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("\u9605\u8bfb\u8bb0\u5f55\u6e05\u5355");
        this.setSheetColumnWidth(sheet);
        HSSFCellStyle style = this.createTitleStyle(workbook);
        HSSFCellStyle styleBole = this.createTitleStyleBold(workbook);
        HSSFRow row = sheet.createRow(0);
        this.createCell(row, 0, styleBole, CellType.STRING, "\u9605\u8bfb\u4eba");
        this.createCell(row, 1, styleBole, CellType.STRING, "\u9605\u8bfb\u65f6\u95f4");
        this.createCell(row, 2, styleBole, CellType.STRING, "\u90e8\u95e8");
        for (int i = 0; i < list.size(); ++i) {
            CMReaderInfo linkCar = (CMReaderInfo)list.get(i);
            row = sheet.createRow((int)((short)(i + 1)));
            this.createCell(row, 0, style, CellType.STRING, linkCar.getReader());
            this.createCell(row, 1, style, CellType.STRING, linkCar.getReadTime());
            this.createCell(row, 2, style, CellType.STRING, linkCar.getReaderDep());
        }
        if (list == null || list.isEmpty()) {
            this.createCell(sheet.createRow(1), 0, style, CellType.STRING, "\u6ca1\u6709\u8bb0\u5f55\uff01");
        }
        return workbook;
    }

    private List getProcessedData(Context ctx, EntityViewInfo entityViewInfo) {
        ArrayList<CMReaderInfo> linkReadInfoList = null;
        try {
            MetaDataPK pk = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app.ContentHisQuery");
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)pk);
            exec.setObjectView(entityViewInfo);
            IRowSet rows = exec.executeQuery();
            String reader = "";
            String readerDep = "";
            Timestamp readTime = null;
            CMReaderInfo readerinfo = null;
            linkReadInfoList = new ArrayList<CMReaderInfo>();
            while (rows.next()) {
                reader = rows.getString("reader");
                readerDep = rows.getString("readerDep");
                readTime = rows.getTimestamp("readTime");
                readerinfo = new CMReaderInfo();
                readerinfo.setReader(reader);
                readerinfo.setReaderDep(readerDep);
                readerinfo.setReadTime(readTime);
                linkReadInfoList.add(readerinfo);
            }
        }
        catch (BOSException be) {
            be.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return linkReadInfoList;
    }

    private void printExcel(HSSFWorkbook workbook, String fileName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        String infor = new String(fileName);
        fileName = new String(infor.getBytes("GB2312"), "ISO-8859-1");
        response.setHeader("Content-disposition", "attachment; filename=" + fileName);
        response.setContentType("application/msexcel;charset=GB2312");
        workbook.write((OutputStream)out);
        out.flush();
        out.close();
    }

    private void createCell(HSSFRow row, int column, HSSFCellStyle style, CellType cellType, Object value) {
        HSSFCell cell = row.createCell((int)((short)column));
        if (style != null) {
            cell.setCellStyle(style);
        }
        switch (cellType) {
            case BLANK: {
                break;
            }
            case STRING: {
                if (value != null) {
                    cell.setCellValue((RichTextString)new HSSFRichTextString(value.toString()));
                    break;
                }
                cell.setCellValue((RichTextString)new HSSFRichTextString(""));
                break;
            }
            case NUMERIC: {
                cell.setCellType(CellType.NUMERIC);
                if (value != null) {
                    try {
                        cell.setCellValue(Double.parseDouble(value.toString()));
                    }
                    catch (Exception e) {
                        cell.setCellValue((RichTextString)new HSSFRichTextString(""));
                    }
                    break;
                }
                cell.setCellValue((RichTextString)new HSSFRichTextString(""));
                break;
            }
        }
    }

    private void setSheetColumnWidth(HSSFSheet sheet) {
        sheet.setColumnWidth(0, 6000);
        sheet.setColumnWidth(1, 6000);
        sheet.setColumnWidth(2, 6000);
    }

    private HSSFCellStyle createTitleStyle(HSSFWorkbook wb) {
        HSSFFont boldFont = wb.createFont();
        boldFont.setFontHeight((short)200);
        HSSFCellStyle style = wb.createCellStyle();
        style.setFont(boldFont);
        return style;
    }

    private HSSFCellStyle createTitleStyleBold(HSSFWorkbook wb) {
        HSSFFont boldFont = wb.createFont();
        boldFont.setFontHeight((short)200);
        HSSFCellStyle style = wb.createCellStyle();
        style.setFont(boldFont);
        return style;
    }
}

