/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.eip.cm.CMClassFactory;
import com.kingdee.eas.cp.eip.cm.CMClassInfo;
import com.kingdee.eas.cp.eip.cm.CMContentFactory;
import com.kingdee.eas.cp.eip.cm.CMContentInfo;
import com.kingdee.eas.cp.eip.cm.ContentStatus;
import com.kingdee.eas.cp.eip.cm.ICMClass;
import com.kingdee.eas.cp.eip.cm.ICMContent;
import com.kingdee.eas.cp.eip.cm.web.Content;
import com.kingdee.eas.cp.eip.cm.web.ContentQueryActionForm;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ContentQueryAction
extends Action {
    private static Logger logger = Logger.getLogger((String)ContentQueryAction.class.getName());
    private Context context = null;
    private int total = 0;
    private int totalPage = 0;
    private int currentPage = 0;
    private static int pageSize = 16;
    private String personId = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        this.context = (Context)session.getAttribute("UserContext");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.context);
        if (null != userInfo.getPerson()) {
            this.personId = userInfo.getPerson().getId().toString();
        }
        logger.info((Object)("the person id is " + this.personId + " of user name" + this.context.getUserName()));
        IRowSet ctRowset = null;
        ContentQueryActionForm queryForm = (ContentQueryActionForm)form;
        String[] idArray = request.getParameterValues("ckID");
        String ifDelete = request.getParameter("ifDelete");
        String ifBlankOut = request.getParameter("ifBlankOut");
        String pageNo = request.getParameter("currentPage");
        int pageNoInt = 0;
        if (null == pageNo) {
            pageNo = "1";
        }
        pageNoInt = Integer.parseInt(pageNo);
        ObjectUuidPK[] pkArray = null;
        if (null != idArray) {
            logger.debug((Object)"\u6784\u9020 ObjectPK \u6570\u7ec4");
            pkArray = new ObjectUuidPK[idArray.length];
            for (int i = 0; i < idArray.length; ++i) {
                pkArray[i] = new ObjectUuidPK(idArray[i]);
            }
        }
        if ("true".equals(ifDelete)) {
            logger.debug((Object)"\u8fdb\u884c\u5185\u5bb9\u6279\u91cf\u5220\u9664");
            this.deletes(pkArray);
            queryForm.setPageNo("1");
        }
        if ("true".equals(ifBlankOut)) {
            logger.debug((Object)"\u8fdb\u884c\u5185\u5bb9\u6279\u91cf\u4f5c\u5e9f");
            this.blankOuts(pkArray);
            queryForm.setPageNo("1");
        }
        if (null == queryForm) {
            queryForm = new ContentQueryActionForm();
        }
        if ("ftSearch".equals(queryForm.getSearchType())) {
            logger.debug((Object)"\u5f00\u59cb\u8fdb\u884c\u5bf9\u5185\u5bb9\u7ba1\u7406\u8fdb\u884c\u5168\u6587\u68c0\u7d22");
        } else if ("highSearch".equals(queryForm.getSearchType())) {
            logger.debug((Object)"\u5f00\u59cb\u5bf9\u5185\u5bb9\u7ba1\u7406\u8fdb\u884c\u9ad8\u7ea7\u67e5\u8be2");
        } else {
            logger.debug((Object)"\u5f00\u59cb\u5bf9\u5185\u5bb9\u7ba1\u7406\u8fdb\u884c\u666e\u901a\u67e5\u8be2");
            String columnID = request.getParameter("columnID");
            String classID = request.getParameter("classID");
            String satus = request.getParameter("status");
            if (null != columnID) {
                queryForm.setColumnID(columnID);
            }
            if (null != classID) {
                queryForm.setClassID(classID);
            }
            if (null != satus) {
                queryForm.setStatus(satus);
            }
            if (null == queryForm.getStatus()) {
                queryForm.setStatus("2");
            }
            logger.debug((Object)("columnID=" + columnID + ",classID=" + classID + ",satus=" + satus));
            ctRowset = this.queryContent(this.context, pageNoInt, pageSize, queryForm.getClassID(), queryForm.getColumnID(), queryForm.getStatus());
        }
        this.setCanSelect(request, ctRowset, queryForm.getStatus());
        request.setAttribute("total", (Object)String.valueOf(this.total));
        request.setAttribute("totalPage", (Object)String.valueOf(this.totalPage));
        request.setAttribute("currentPage", (Object)String.valueOf(this.currentPage));
        queryForm.setTotal(this.total);
        queryForm.setPageCount(this.totalPage);
        queryForm.setCurrentPage(this.currentPage);
        return mapping.findForward("success");
    }

    public ActionForward query(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String classID = request.getParameter("ID");
        HttpSession session = request.getSession();
        Context context = (Context)session.getAttribute("UserContext");
        return mapping.findForward("success");
    }

    public ActionForward queryList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String classID = request.getParameter("classID");
        HttpSession session = request.getSession();
        Context context = (Context)session.getAttribute("UserContext");
        IRowSet ctRowset = this.queryContent(context, 1, 16, "1", "1", "2");
        request.setAttribute("ctRowset", (Object)ctRowset);
        return mapping.findForward("success");
    }

    public IRowSet queryContent(Context context, int pageNo, int pageSize, String classID, String columnID, String status) {
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentQuery");
        MetaDataPK queryCountPK = new MetaDataPK("com.kingdee.eas.cp.eip.cm.app", "ContentCountQuery");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        logger.debug((Object)"\u5185\u5bb9\u67e5\u8be2\u8fc7\u6ee4\u5668\u8bbe\u7f6e\u5f00\u59cb");
        if (null != classID && !"".equals(classID)) {
            filterItemInfo = new FilterItemInfo("classID", (Object)classID);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        if (null != columnID) {
            filterItemInfo = new FilterItemInfo("columnID", (Object)columnID);
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        if (null == status) {
            status = "2";
        }
        filterItemInfo = new FilterItemInfo("status", (Object)status);
        filterInfo.getFilterItems().add(filterItemInfo);
        if ("0".equals(status) || "1".equals(status)) {
            filterItemInfo = new FilterItemInfo("creator.ID", (Object)context.getCaller().toString());
            filterInfo.getFilterItems().add(filterItemInfo);
        } else if ("3".equals(status)) {
            filterItemInfo = new FilterItemInfo("lastUpdateUser.ID", (Object)context.getCaller().toString());
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        entityViewInfo.setFilter(filterInfo);
        logger.debug((Object)"\u5185\u5bb9\u67e5\u8be2\u8fc7\u6ee4\u5668\u8bbe\u7f6e\u5b8c\u6bd5");
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        try {
            IQueryExecutor exec = null;
            logger.debug((Object)"begin get count");
            exec = this.getQueryExecutor((IMetaDataPK)queryCountPK, entityViewInfo, context);
            logger.debug((Object)("executor search content count sql is:" + exec.getSQL()));
            countRowSet = exec.executeQuery();
            if (countRowSet.next()) {
                this.total = countRowSet.getInt(1);
                logger.debug((Object)("record total is\uff1a" + this.total));
            }
            this.totalPage = (this.total - 1) / pageSize + 1;
            logger.debug((Object)("total page is:" + this.totalPage));
            if (pageNo > this.totalPage) {
                pageNo = this.totalPage;
            }
            if (pageNo <= 0) {
                pageNo = 1;
            }
            this.currentPage = pageNo;
            logger.debug((Object)("beging search the content of page " + pageNo));
            SorterItemInfo sorterItemInfo = new SorterItemInfo("lastUpdateTime");
            sorterItemInfo.setSortType(SortType.DESCEND);
            entityViewInfo.getSorter().add(sorterItemInfo);
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, context);
            logger.debug((Object)("executor search content sql is:" + exec.getSQL()));
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            logger.debug((Object)"end search");
        }
        catch (Exception e) {
            logger.error((Object)("\u5206\u9875\u67e5\u627e\u5185\u5bb9\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()));
        }
        return rowSet;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public void deletes(ObjectUuidPK[] arrayPK) throws Exception {
        logger.debug((Object)"\u5f00\u59cb\u5220\u9664\u5185\u5bb9");
        try {
            ICMContent iCMContent = CMContentFactory.getLocalInstance(this.context);
            iCMContent.delete((IObjectPK[])arrayPK);
        }
        catch (Exception e) {
            logger.debug((Object)("\u5220\u9664\u5185\u5bb9\u5931\u8d25\uff01" + e.getMessage()));
        }
        logger.debug((Object)"\u5220\u9664\u5185\u5bb9\u6210\u529f");
    }

    private void blankOuts(ObjectUuidPK[] arrayPK) throws Exception {
        logger.debug((Object)"\u5f00\u59cb\u4f5c\u5e9f\u5185\u5bb9");
        try {
            ICMContent iCMContent = CMContentFactory.getLocalInstance(this.context);
            for (int i = 0; i < arrayPK.length; ++i) {
                CMContentInfo info = (CMContentInfo)iCMContent.getValue((IObjectPK)arrayPK[i]);
                info.setStatus(ContentStatus.DISUSE);
                iCMContent.update((IObjectPK)arrayPK[i], (CoreBaseInfo)info);
            }
        }
        catch (Exception e) {
            logger.debug((Object)("\u4f5c\u5e9f\u5185\u5bb9\u5931\u8d25\uff01" + e.getMessage()));
        }
        logger.debug((Object)"\u4f5c\u5e9f\u5185\u5bb9\u6210\u529f");
    }

    private void setCanSelect(HttpServletRequest request, IRowSet rowSet, String state) throws Exception {
        HashMap<String, CMClassInfo> map = new HashMap<String, CMClassInfo>();
        ArrayList<Content> ctList = new ArrayList<Content>();
        ICMClass iCMClass = CMClassFactory.getLocalInstance(this.context);
        while (rowSet.next()) {
            CMClassInfo classInfo;
            Content ctItem = new Content();
            ctItem.setID(rowSet.getString("ID"));
            ctItem.setTitle(rowSet.getString("TITLE"));
            ctItem.setAuthor(rowSet.getString("USER.NAME"));
            ctItem.setPublishDate(rowSet.getString("LASTUPDATETIME").substring(0, 16));
            ctItem.setSate(rowSet.getString("STATUS"));
            ctItem.setColumnClass(rowSet.getString("CMCOLUMN.NAME") + "/" + rowSet.getString("CMCLASS.NAME"));
            if (!map.containsKey(rowSet.getString("CLASSID"))) {
                classInfo = (CMClassInfo)iCMClass.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rowSet.getString("CLASSID"))));
                map.put(rowSet.getString("CLASSID"), classInfo);
            }
            ctItem.setCanSelect(false);
            if ("0".equals(state)) {
                ctItem.setCanSelect(true);
            } else {
                classInfo = (CMClassInfo)map.get(rowSet.getString("CLASSID"));
                if (classInfo.getClassAdmin().toString().equals(this.personId)) {
                    ctItem.setCanSelect(true);
                }
            }
            ctList.add(ctItem);
        }
        request.setAttribute("ctListData", ctList);
    }
}

