/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.StringUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class ContentResourceHandle {
    private static Logger logger = Logger.getLogger((String)ContentResourceHandle.class.getName());

    private AttachmentInfo getAttachmentByID(String id, Context ctx) {
        if (id != null) {
            id = id.replaceAll(" ", "+");
        }
        AttachmentInfo info = null;
        try {
            info = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return info;
    }

    public static String getColumnResourceFile(String bizID, Context ctx, ServletContext app) throws Exception {
        AttachmentInfo attInfo = ContentResourceHandle.getAttacheByBizID(ctx, bizID);
        if (attInfo == null) {
            return "";
        }
        String path = "";
        String attachID = attInfo.getAttachID();
        String fileName = StringUtil.encoder((String)bizID);
        if (fileName.indexOf("%") > -1) {
            fileName = fileName.replaceAll("%", "9");
        }
        String suffix = attInfo.getSimpleName();
        File image = null;
        image = ContentResourceHandle.createFileOnServer(fileName + "_" + attachID + "." + suffix, app, attInfo);
        return "../resource/" + image.getName();
    }

    public static String getContentResourceFile(String bizID, Context ctx, ServletContext app) {
        AttachmentInfo attInfo = null;
        try {
            attInfo = ContentResourceHandle.getAttacheByBizID(ctx, bizID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (attInfo == null) {
            return "";
        }
        String path = "";
        String attachID = attInfo.getAttachID();
        String fileName = StringUtil.encoder((String)bizID);
        if (fileName.indexOf("%") > -1) {
            fileName = fileName.replaceAll("%", "9");
        }
        String suffix = attInfo.getSimpleName();
        File image = null;
        image = ContentResourceHandle.createFileOnServer(fileName + "_" + attachID + "." + suffix, app, attInfo);
        return "./resource/" + image.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttachmentInfo getAttacheByBizID(Context ctx, String seleID) throws Exception {
        if (seleID != null) {
            seleID = seleID.replaceAll(" ", "+");
        }
        IBoAttchAsso boAtt = null;
        BoAttchAssoInfo info = null;
        BoAttchAssoCollection cols = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boID", (Object)seleID, CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        boAtt = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        cols = boAtt.getBoAttchAssoCollection(ev);
        if (cols != null && cols.size() > 0) {
            info = cols.get(0);
        }
        if (info == null) {
            return null;
        }
        BOSUuid attachID = info.getAttachment().getId();
        AttachmentInfo attachInfo = null;
        try {
            AttachmentServerManager acm = AttachmentManagerFactory.getServerManager((Context)ctx);
            byte[] bytes = null;
            Class<AttachmentServerManager> clazz = AttachmentServerManager.class;
            synchronized (AttachmentServerManager.class) {
                bytes = acm.download(attachID.toString());
                // ** MonitorExit[var11_12] (shouldn't be in output)
                CoreBaseCollection cc = AttachmentFactory.getLocalInstance((Context)ctx).getCollection("select file,simpleName,name,lastUpdateTime,attachid where id = '" + attachID + "'");
                if (cc != null && cc.size() > 0) {
                    attachInfo = (AttachmentInfo)cc.get(0);
                }
                if (attachInfo == null || bytes == null) {
                    return null;
                }
                attachInfo.setFile(bytes);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return attachInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createFileOnServer(String fileName, ServletContext app, AttachmentInfo info) {
        File file;
        File fileDir = new File(app.getRealPath("") + "//resource//");
        if (!fileDir.exists()) {
            fileDir.mkdir();
        }
        if ((file = new File(app.getRealPath("") + "/resource/" + fileName)).exists()) {
            long saveOrUpdateToDBTime;
            long uploadTime = file.lastModified();
            if (uploadTime < (saveOrUpdateToDBTime = info.getLastUpdateTime().getTime())) {
                file.delete();
            } else {
                return file;
            }
        }
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new ByteArrayInputStream(info.getFile()));
            out = new BufferedOutputStream(new FileOutputStream(file));
            byte[] array = new byte[4096];
            int len = 0;
            while ((len = in.read(array)) != -1) {
                ((BufferedOutputStream)out).write(array, 0, len);
            }
            ((BufferedOutputStream)out).flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }
}

