/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.web.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.eip.cm.ColumnTypeEnum;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.Description;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.facade.portal.PortalServiceFacade;
import com.kingdee.portal.biz.facade.portal.common.context.SimplePortalContext;
import com.kingdee.portal.biz.facade.portal.facade.PortletDefinitionServiceFacade;
import com.kingdee.portal.biz.module.portlet.dto.PortletParam;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import java.util.List;
import org.apache.log4j.Logger;

public class NewPortalUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.eip.cm.web.util.NewPortalUtil");
    private static String CP_CATEGORYID = "fb576e97-7bc1-4120-a8f3-1c7aed25a37d";

    public static PortletDefinition createPortletDefinition(Context ctx, String columnName, String columnID, String descr, ColumnTypeEnum colType, StatusEnum status) throws PortalBizException {
        PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
        SimplePortalContext simCtx = NewPortalUtil.builtSimplePortalContext(ctx);
        PortletParam para = NewPortalUtil.builtPortletParam(columnName, columnID, descr, status);
        String portletName = NewPortalUtil.getPortletNameByColumnType(colType);
        PortletDefinition poreletDef = portletDefinitionServiceFacade.createPortletDefinition(simCtx, "plt_cp", portletName, para);
        return poreletDef;
    }

    public static void updatePortletDefinition(Context ctx, String portletDefinitionId, String columnName, String columnID, String descr, StatusEnum status) throws PortalBizException {
        PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
        SimplePortalContext simCtx = NewPortalUtil.builtSimplePortalContext(ctx);
        PortletParam para = NewPortalUtil.builtPortletParam(columnName, columnID, descr, status);
        portletDefinitionServiceFacade.updatePortletDefinition(simCtx, portletDefinitionId, para);
    }

    public static void updateNewPortletDefinition(Context ctx, String portletDefinitionId, String columnName, String columnID, String descr, StatusEnum status, ColumnTypeEnum colType) throws PortalBizException {
        PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
        SimplePortalContext simCtx = NewPortalUtil.builtSimplePortalContext(ctx);
        String portletName = NewPortalUtil.getPortletNameByColumnType(colType);
        PortletParam para = NewPortalUtil.builtPortletParam(columnName, columnID, descr, status);
        if (para != null) {
            para.setPortletName(portletName);
        }
        portletDefinitionServiceFacade.updatePortletDefinition(simCtx, portletDefinitionId, para);
    }

    public static List findPortletDefinitionList(Context ctx, String columnName, ColumnTypeEnum colType) throws PortalBizException {
        SimplePortalContext simCtx = NewPortalUtil.builtSimplePortalContext(ctx);
        DisplayName displayName = new DisplayName(columnName);
        String portletName = NewPortalUtil.getPortletNameByColumnType(colType);
        PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
        List list = portletDefinitionServiceFacade.findPortletDefinitionList(simCtx, "plt_cp", portletName, displayName);
        return list;
    }

    public static PortletDefinition findPortletDefinitionById(Context ctx, String portletDefinitionId) throws PortalBizException {
        SimplePortalContext simCtx = NewPortalUtil.builtSimplePortalContext(ctx);
        PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
        PortletDefinition poreletDef = portletDefinitionServiceFacade.findPortletDefinitionById(simCtx, portletDefinitionId);
        return poreletDef;
    }

    public static void deletePortletDefinitionById(Context ctx, String portletDefinitionId) throws PortalBizException {
        PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
        SimplePortalContext simCtx = NewPortalUtil.builtSimplePortalContext(ctx);
        portletDefinitionServiceFacade.deletePortletDefinitionById(simCtx, portletDefinitionId);
    }

    private static String getPortletNameByColumnType(ColumnTypeEnum colType) {
        String portletName = "";
        switch (colType.getValue()) {
            case 20: {
                portletName = "LinkPortlet";
                break;
            }
            case 30: {
                portletName = "NewsPortlet";
                break;
            }
            case 40: {
                portletName = "NoticPortlet";
                break;
            }
            case 50: {
                portletName = "AttachmentPortlet";
                break;
            }
            case 60: {
                portletName = "PicturePortlet";
                break;
            }
            case 70: {
                portletName = "PicNewsPortlet";
                break;
            }
            case 80: {
                portletName = "PicGroupPortlet";
                break;
            }
            default: {
                portletName = "CommonPortlet";
            }
        }
        return portletName;
    }

    private static PortletParam builtPortletParam(String columnName, String columnID, String descr, StatusEnum status) {
        PortletParam para = new PortletParam();
        DisplayName displayName = new DisplayName(columnName);
        para.setDisplayName(displayName);
        Preferences preferences = new Preferences();
        Preference idPre = new Preference("columnId", columnID);
        preferences.addPreference(idPre);
        para.setPreferences(preferences);
        Description description = new Description(descr);
        para.setDescription(description);
        para.setCategoryId(CP_CATEGORYID);
        para.setStatus(status);
        return para;
    }

    private static SimplePortalContext builtSimplePortalContext(Context ctx) {
        SimplePortalContext simCtx = new SimplePortalContext();
        simCtx.setUserId(ctx.getCaller().toString());
        simCtx.setUserCode(ctx.getUserName());
        simCtx.setDataCenter(ctx.getAIS());
        return simCtx;
    }
}

