/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.xt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.xt.AttchmentUtil;
import com.kingdee.eas.cp.base.xt.XTUtil;
import com.kingdee.eas.cp.eip.cm.CMClassFactory;
import com.kingdee.eas.cp.eip.cm.CMClassInfo;
import com.kingdee.eas.cp.eip.cm.CMColumnFactory;
import com.kingdee.eas.cp.eip.cm.CMColumnInfo;
import com.kingdee.eas.cp.eip.cm.CMContentFactory;
import com.kingdee.eas.cp.eip.cm.CMContentInfo;
import com.kingdee.eas.cp.eip.cm.ColumnTypeEnum;
import com.kingdee.eas.cp.eip.cm.ContentTypeEnum;
import com.kingdee.eas.cp.eip.cm.ICMClass;
import com.kingdee.eas.cp.eip.cm.ICMColumn;
import com.kingdee.eas.cp.eip.cm.ICMContent;
import com.kingdee.eas.cp.eip.cm.web.ContentResourceHandle;
import com.kingdee.eas.cp.eip.cm.xt.CMNewsContentUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.ThumbnailSizeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.util.FileUtil;
import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.util.image.ImageUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CMNewsAdapter
implements IMessageAdapter {
    private static final String SHORT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String LONG_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String PACKAGE_FILE_NAME = "package.zip";
    private static final String INDEX_FILE_NAME = "index.html";
    private static final String MHT_FILE_NAME = "cmContent.html";
    private static final String RESOURCE_CONTENTMANAGE = "com.kingdee.eas.cp.eip.cm.ContentManage";
    private static final String NEW_FILE_NAME = "title_pic_new.jpg";
    private static final String NOTICE_FILE_NAME = "title_pic_notice.jpg";
    private static Logger logger = Logger.getLogger((String)CMNewsAdapter.class.getName());
    private String contentID = null;
    private Context ctx = null;
    private CMContentInfo contentInfo = null;
    private CMColumnInfo columnInfo = null;
    private CMClassInfo classInfo = null;
    private AttachmentInfo pictureInfo = null;
    private String firstImgUrl = null;
    private String firstImgName = null;
    private String firstDescription = null;

    public CMNewsAdapter(String contentID, Context ctx) throws IllegalArgumentException, NullPointerException {
        this.contentID = contentID;
        this.ctx = ctx;
        if (!this.hasInitialized()) {
            throw new IllegalArgumentException();
        }
        this.readContentInfo();
        if (this.contentInfo == null) {
            throw new NullPointerException("content:" + contentID + "not found");
        }
        this.readColumnInfo();
        this.readClassInfo();
        this.readPictureInfo();
    }

    public MessageTypeEnum getType() {
        MessageTypeEnum newsType = MessageTypeEnum.GRAPHIC;
        if (this.hasInitialized() && this.columnInfo != null) {
            if (this.columnInfo.getColumnType().equals((Object)ColumnTypeEnum.PICTURE)) {
                newsType = MessageTypeEnum.IMAGE;
            } else if (this.columnInfo.getColumnType().equals((Object)ColumnTypeEnum.LINK)) {
                newsType = MessageTypeEnum.LINK;
            }
        }
        return newsType;
    }

    public MessageModelEnum getModel() {
        if (this.getType() == MessageTypeEnum.GRAPHIC) {
            return MessageModelEnum.SINGLEGRAPHIC;
        }
        return null;
    }

    public Map<String, Object> getContent() {
        HashMap<String, Object> message = null;
        try {
            String title = "";
            if (ColumnTypeEnum.NOTICE.equals((Object)this.columnInfo.getColumnType())) {
                title = EASResource.getString((String)RESOURCE_CONTENTMANAGE, (String)"notice");
            }
            message = new HashMap<String, Object>();
            if (this.getType() == MessageTypeEnum.TEXT) {
                message.put("text", title + this.getTitle());
            } else if (this.getType() == MessageTypeEnum.IMAGE) {
                message.put("name", this.getPictureName(true));
                message.put("pic", StringUtil.getBase64FromByte((byte[])this.getPictureData()));
            } else if (this.getType() == MessageTypeEnum.LINK) {
                this.createFile(false);
                String url = this.getHttpUrlPort();
                String postId = this.contentID;
                if (postId != null) {
                    postId = postId.replaceAll("=", "93D");
                    postId = postId.replaceAll("/", "92F");
                    postId = postId.replaceAll("\\+", "92B");
                }
                url = url + "/plt_cp/xt/news/" + postId + "/content/index.html";
                message.put("text", title + this.getTitle());
                message.put("url", url);
            } else if (this.getType() == MessageTypeEnum.GRAPHIC) {
                this.firstImgUrl = null;
                this.firstImgName = null;
                this.firstDescription = null;
                message.put("date", new SimpleDateFormat(SHORT_DATE_FORMAT).format(this.getUpdateTime()));
                message.put("title", title + this.getTitle());
                message.put("text", this.getSummary());
                message.put("zip", StringUtil.getBase64FromByte((byte[])this.getFullPackage()));
                message.put("url", this.getMsgCallbackURL());
                if (this.getPictureName(false).equals("")) {
                    if (ColumnTypeEnum.NOTICE.equals((Object)this.columnInfo.getColumnType())) {
                        message.put("name", NOTICE_FILE_NAME);
                        message.put("pic", StringUtil.getBase64FromByte((byte[])this.getPictureData(NOTICE_FILE_NAME)));
                    } else if (ColumnTypeEnum.PIC_GROUP.equals((Object)this.columnInfo.getColumnType())) {
                        if (!StringUtils.isEmpty((String)this.firstImgUrl) && !StringUtils.isEmpty((String)this.firstImgName)) {
                            byte[] newsPicture = null;
                            newsPicture = ImageUtil.readImage((String)this.firstImgUrl);
                            if (newsPicture != null) {
                                newsPicture = ImageUtil.scaleByWidth((byte[])newsPicture, (int)ThumbnailSizeEnum.BIG_WIDTH.value(), (String)"jpg");
                            }
                            message.put("text", this.firstDescription);
                            message.put("name", this.firstImgName);
                            message.put("pic", StringUtil.getBase64FromByte((byte[])newsPicture));
                        }
                    } else {
                        message.put("name", NEW_FILE_NAME);
                        message.put("pic", StringUtil.getBase64FromByte((byte[])this.getPictureData(NEW_FILE_NAME)));
                    }
                } else if (this.getModel() == MessageModelEnum.SINGLEGRAPHIC) {
                    message.put("name", this.getPictureName(true));
                    message.put("pic", StringUtil.getBase64FromByte((byte[])this.getPictureData()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("content build error:" + e.getMessage()));
        }
        return message;
    }

    public boolean createFile(boolean isNotAuto) {
        File contentFolder = this.getContentFolder();
        return this.createHtmlFile(contentFolder, isNotAuto);
    }

    public List<String> getUsers() {
        ArrayList<String> userIDs = null;
        if (this.hasInitialized() && this.columnInfo != null) {
            Object[] params = new Object[]{this.columnInfo.getCU().getId().toString()};
            StringBuffer userSql = new StringBuffer();
            userSql.append("select distinct t2.FPersonID from T_PM_UserRoleOrg t1 join t_pm_user t2 on t1.FUserID=t2.FID ");
            userSql.append("join t_cm_columnreadright t3 on t1.FRoleID=t3.FRoleID ");
            userSql.append("where t1.FOrgID = ? and t3.FColumnID='" + this.columnInfo.getId().toString() + "' and t2.FPersonID is not null ");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)userSql.toString(), (Object[])params);
                userIDs = new ArrayList<String>();
                while (rowSet.next()) {
                    userIDs.add(rowSet.getString(1));
                }
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
            catch (UuidException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return userIDs;
    }

    public Date getUpdateTime() {
        Timestamp date = null;
        if (this.hasInitialized() && this.contentInfo != null) {
            date = this.contentInfo.getLastUpdateTime() != null ? this.contentInfo.getLastUpdateTime() : this.contentInfo.getCreateTime();
        }
        return date;
    }

    public boolean isNeedSendXT() {
        if (this.columnInfo != null && this.columnInfo.isPublishToXTtop()) {
            return true;
        }
        if (this.columnInfo != null && this.columnInfo.isPublishToDesktop()) {
            File contentFolder = this.getContentFolder();
            this.createHtmlFile(contentFolder, false);
        }
        return false;
    }

    public void clearTemporary() {
        File uidFolder = this.getUIDFolder();
        FileUtil.deleteFile((File)uidFolder);
    }

    public String getID() {
        return this.contentID;
    }

    public String getTitle() {
        String newsTitle = "";
        if (this.hasInitialized() && this.contentInfo != null) {
            if (this.columnInfo != null) {
                this.columnInfo.getColumnType();
            }
            newsTitle = this.contentInfo.getTitle();
        }
        return newsTitle;
    }

    public String getSummary() {
        String newsSummary = "";
        if (this.hasInitialized() && this.contentInfo != null) {
            newsSummary = this.contentInfo.getSummary();
        }
        return newsSummary;
    }

    public String getCreator() {
        String newsCreateor = "";
        if (this.hasInitialized() && this.contentInfo != null && this.contentInfo.getCreator() != null) {
            newsCreateor = this.contentInfo.getCreator().getName();
        }
        return newsCreateor;
    }

    public String getPictureName(boolean includeExtension) {
        String pictureName = "";
        if (this.hasInitialized() && this.pictureInfo != null && this.contentInfo != null) {
            pictureName = StringUtil.encoder((String)this.contentInfo.getFile().toString());
            if (pictureName.indexOf("%") > -1) {
                pictureName = pictureName.replaceAll("%", "9");
            }
            if (includeExtension) {
                pictureName = pictureName + "." + this.pictureInfo.getSimpleName();
            }
        }
        return pictureName;
    }

    public byte[] getPictureData() {
        byte[] newsPicture = null;
        if (this.hasInitialized() && this.pictureInfo != null) {
            newsPicture = this.pictureInfo.getFile();
        }
        if (newsPicture != null) {
            newsPicture = ImageUtil.scaleByWidth((byte[])newsPicture, (int)ThumbnailSizeEnum.BIG_WIDTH.value(), (String)"jpg");
        }
        return newsPicture;
    }

    public byte[] getFullPackage() {
        byte[] packageFile = null;
        try {
            File uidFolder = this.getUIDFolder();
            File contentFolder = this.getContentFolder();
            this.createHtmlFile(contentFolder, false);
            packageFile = FileUtil.readFile((File)FileUtil.compress((String)contentFolder.getPath(), (String)(uidFolder.getPath() + File.separator + PACKAGE_FILE_NAME)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return packageFile;
    }

    private boolean createHtmlFile(File contentFolder, boolean isNotAuto) {
        try {
            boolean isPicGroup = false;
            if (ColumnTypeEnum.PIC_GROUP.equals((Object)this.getCMColumnInfo().getColumnType())) {
                isPicGroup = true;
            }
            String html = CMNewsContentUtil.getCMContentHTML(this, contentFolder, isNotAuto);
            FileUtil.createFile((String)(contentFolder.getPath() + File.separator + INDEX_FILE_NAME));
            FileUtil.writeFile((String)(contentFolder.getPath() + File.separator + INDEX_FILE_NAME), (byte[])html.getBytes("UTF-8"));
            try {
                FileUtil.safeCopyFile((String)(XTUtil.getJsFileSrcPath() + File.separator + "jquery-1.5.min.js"), (String)(contentFolder.getPath() + File.separator + "jquery-1.5.min.js"));
            }
            catch (IOException e1) {
                logger.info((Object)("getJsFileSrcPath error: " + e1.getMessage()));
            }
            if (isPicGroup) {
                FileUtil.safeCopyFile((String)(XTUtil.getCssFileSrcPath() + File.separator + "xt_news_picgroup_detail.css"), (String)(contentFolder.getPath() + File.separator + "xt_news_picgroup_detail.css"));
                FileUtil.safeCopyFile((String)(XTUtil.getSwipeJsFileSrcPath() + File.separator + "swipe.js"), (String)(contentFolder.getPath() + File.separator + "swipe.js"));
            } else {
                FileUtil.safeCopyFile((String)(XTUtil.getStyleFileSrcPath() + File.separator + "xt_news_tinyScreen.css"), (String)(contentFolder.getPath() + File.separator + "xt_news_tinyScreen.css"));
                try {
                    FileUtil.safeCopyFile((String)(XTUtil.getAttListJsFileSrcPath() + File.separator + "attlist.js"), (String)(contentFolder.getPath() + File.separator + "attlist.js"));
                }
                catch (IOException e1) {
                    logger.info((Object)("getAttListJsFileSrcPath error: " + e1.getMessage()));
                }
                try {
                    String sourceURL = XTUtil.getImgFileSrcPath();
                    String toUrl = contentFolder.getPath() + File.separator + "images";
                    FileUtil.createFolder((String)toUrl);
                    FileUtil.safeCopyFile((String)(sourceURL + File.separator + "file_type.png"), (String)(toUrl + File.separator + "file_type.png"));
                    FileUtil.safeCopyFile((String)(sourceURL + File.separator + "icon.png"), (String)(toUrl + File.separator + "icon.png"));
                }
                catch (IOException e1) {
                    logger.info((Object)("getImgFileSrcPath error: " + e1.getMessage()));
                }
            }
            FileUtil.deleteFile((String)(contentFolder + File.separator + MHT_FILE_NAME));
            return true;
        }
        catch (IOException e) {
            logger.info((Object)("createHtmlFile error: " + e.getMessage()));
            return false;
        }
    }

    public String getCMContent() {
        String newsContent = "";
        if (this.hasInitialized() && this.contentInfo != null) {
            if (this.contentInfo.getContentType() == ContentTypeEnum.HTML) {
                newsContent = CMNewsContentUtil.getHTMLContent(this);
            } else if (this.contentInfo.getContentType() == ContentTypeEnum.WORD) {
                newsContent = CMNewsContentUtil.getMHTContent(this);
            }
        }
        return newsContent;
    }

    public File getContentFolder() {
        File contentFolder = FileUtil.createFolder((String)(this.getUIDFolder().getPath() + File.separator + "content"));
        return contentFolder;
    }

    public Context getContext() {
        return this.ctx;
    }

    public static Context createContext(String user, String ais, String solution) {
        Context ctx = new Context();
        ctx.setUserName(StringUtil.decoder((String)user));
        ctx.setAIS(StringUtil.decoder((String)ais));
        ctx.setSolution(StringUtil.decoder((String)solution));
        return ctx;
    }

    private File getUIDFolder() {
        File uidFolder = XTUtil.getUIDFolder((Context)this.ctx, (String)"XTNews", (String)this.getID(), (String)"news");
        return uidFolder;
    }

    public void saveXtImgNameContentInfo(String xtImgName, boolean flag) {
        if (this.hasInitialized()) {
            try {
                if (flag) {
                    String sql = "UPDATE T_CM_Content SET FxtImgName='" + xtImgName + "' WHERE FID='" + this.contentID + "'";
                    DbUtil.execute((Context)this.ctx, (String)sql);
                } else {
                    ICMContent iCMContent = CMContentFactory.getLocalInstance(this.ctx);
                    CMContentInfo cInfo = (CMContentInfo)iCMContent.getValue((IObjectPK)new ObjectUuidPK(this.contentID));
                    cInfo.setXtImgName(xtImgName);
                    iCMContent.save((CoreBaseInfo)cInfo);
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveIsConverContentInfo(boolean isconver) {
        if (this.hasInitialized()) {
            try {
                ICMContent iCMContent = CMContentFactory.getLocalInstance(this.ctx);
                CMContentInfo cInfo = (CMContentInfo)iCMContent.getValue((IObjectPK)new ObjectUuidPK(this.contentID));
                cInfo.setIsConvert(isconver);
                iCMContent.save((CoreBaseInfo)cInfo);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private void readContentInfo() {
        if (this.hasInitialized()) {
            try {
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sic = viewInfo.getSelector();
                sic.add("file");
                sic.add("title");
                sic.add("summary");
                sic.add("lastUpdateTime");
                sic.add("columnID");
                sic.add("classID");
                sic.add("creator.name");
                sic.add("createTime");
                sic.add("contentType");
                sic.add("picDisplay");
                ICMContent iCMContent = CMContentFactory.getLocalInstance(this.ctx);
                this.contentInfo = (CMContentInfo)iCMContent.getValue((IObjectPK)new ObjectUuidPK(this.contentID), sic);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private void readColumnInfo() {
        if (this.hasInitialized() && this.contentInfo != null) {
            try {
                ICMColumn iCMColumn = CMColumnFactory.getLocalInstance(this.ctx);
                this.columnInfo = (CMColumnInfo)iCMColumn.getValue((IObjectPK)new ObjectUuidPK(this.contentInfo.getColumnID()));
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    private void readClassInfo() {
        if (this.hasInitialized() && this.contentInfo != null) {
            try {
                ICMClass iCMClass = CMClassFactory.getLocalInstance(this.ctx);
                this.classInfo = (CMClassInfo)iCMClass.getValue((IObjectPK)new ObjectUuidPK(this.contentInfo.getClassID()));
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    private void readPictureInfo() {
        if (this.hasInitialized()) {
            try {
                this.pictureInfo = ContentResourceHandle.getAttacheByBizID(this.ctx, this.contentInfo.getFile().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean hasInitialized() {
        return this.contentID != null && this.ctx != null;
    }

    private byte[] getPictureData(String fileName) {
        byte[] newsPicture = null;
        StringBuffer cm_title_pic_path = new StringBuffer(System.getProperty("EAS_HOME"));
        cm_title_pic_path.append(File.separator);
        cm_title_pic_path.append("server");
        cm_title_pic_path.append(File.separator);
        cm_title_pic_path.append("deploy");
        cm_title_pic_path.append(File.separator);
        cm_title_pic_path.append("portal.ear");
        cm_title_pic_path.append(File.separator);
        cm_title_pic_path.append("plt_cp.war");
        cm_title_pic_path.append(File.separator);
        cm_title_pic_path.append("res");
        cm_title_pic_path.append(File.separator);
        cm_title_pic_path.append("img");
        cm_title_pic_path.append(File.separator);
        cm_title_pic_path.append(fileName);
        String path = cm_title_pic_path.toString().replace("/", File.separator);
        newsPicture = ImageUtil.readImage((String)path);
        if (newsPicture != null) {
            newsPicture = ImageUtil.scaleByWidth((byte[])newsPicture, (int)ThumbnailSizeEnum.BIG_WIDTH.value(), (String)"jpg");
        }
        return newsPicture;
    }

    public boolean isWord() {
        return this.contentInfo.getContentType() == ContentTypeEnum.WORD;
    }

    private String getMsgCallbackURL() {
        String url = "";
        return url;
    }

    public boolean isHasAttchment() {
        String sql = "select att.fid from t_Bas_Attachment att, t_bas_boattchasso bo  where att.fid = bo.fAttachmentid and bo.fboid = '" + this.contentID + "' and att.Fname_l2 not like 'docBody_%' ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            return rowSet.next();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public List getAttchmentList() {
        List list = AttchmentUtil.getAttchmentList((Context)this.ctx, (String)this.contentID);
        return list;
    }

    public String getHttpUrlPort() {
        XTServiceConfig xTServiceConfig = XTServiceConfig.getInstance();
        String httpUrlPort = "";
        try {
            httpUrlPort = xTServiceConfig.getPubAcctProperty(xTServiceConfig.getEidByDbCode(this.ctx.getAIS()), "XTNews", "http.url.port", "");
        }
        catch (Exception e) {
            System.out.println("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6IP\u7684\u5740\u51fa\u9519:" + e.getMessage());
        }
        System.out.println("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6IP\u7684\u5740\u662f:" + httpUrlPort);
        return httpUrlPort;
    }

    public String getAppId() {
        XTServiceConfig xTServiceConfig = XTServiceConfig.getInstance();
        String appId = xTServiceConfig.getPubAcctProperty(xTServiceConfig.getEidByDbCode(this.ctx.getAIS()), "XTNews", "appId", "");
        return appId;
    }

    public String getXtEid() {
        String eid = XTServiceConfig.getInstance().getEidByDbCode(this.ctx.getAIS());
        return eid;
    }

    public boolean isPicDisplay() {
        return this.contentInfo == null ? false : this.contentInfo.isPicDisplay();
    }

    public CMContentInfo getCMContentInfo() {
        return this.contentInfo;
    }

    public CMColumnInfo getCMColumnInfo() {
        return this.columnInfo;
    }

    public void setFirstImg(String imgPach, String imgName, String description) {
        this.firstImgUrl = imgPach;
        this.firstImgName = imgName;
        this.firstDescription = description;
    }
}

