/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.mc.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.DevolveDenialException;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.message.client.MessageServiceProvider;
import com.kingdee.eas.base.message.client.MessageUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.eip.mc.client.AbstractEntrustProcListUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class EntrustProcListUI
extends AbstractEntrustProcListUI {
    private static final Logger logger = CoreUIObject.getLogger(EntrustProcListUI.class);
    private static final MetaDataPK allTaskQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.mc.app", "EntrustAllProcQuery");
    private static final MetaDataPK undisposeTaskQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.mc.app", "EntrustPendingProcQuery");
    private static final MetaDataPK disposedTaskQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.mc.app", "EntrustAlreadyProcQuery");
    private static final MetaDataPK disposedTaskHstQueryPK = new MetaDataPK("com.kingdee.eas.cp.eip.mc.app", "EntrustAlreadyHstProcQuery");
    private static final String INDEX_COLUMN_STATE = "state";
    private static final String ASSIGNID_NAME = "id";
    private static final String ENTRUSTED_USERID = "personUserID";
    private static final String ENTRUSTED_USERNAME = "personUserName";
    private static final String SOURCEASSIGNID = "sourceAssignId";
    private static final String RESOURCE = "com.kingdee.eas.cp.eip.mc.MessageCenter";
    private CommonQueryDialog dlgEntrustPendingProc = null;
    private CommonQueryDialog dlgEntrustAllProc = null;
    private CommonQueryDialog dlgEntrustAlreadyProc = null;
    private CommonQueryDialog dlgEntrustAlreadyHstProc = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnView.setVisible(false);
        this.btnShowBill.setEnabled(true);
        this.btnShowWFImage.setEnabled(true);
        this.btnViewAuditResult.setEnabled(true);
        this.kdcb_assignType.setSelectedIndex(0);
        this.btnShowBill.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.btnShowBill.setText(this.resHelper.getString("btnShowBill.text"));
        this.btnShowWFImage.setIcon(EASResource.getIcon((String)"imgTbtn_estatechart"));
        this.btnShowWFImage.setText(this.resHelper.getString("btnShowWFImage.text"));
        this.btnViewAuditResult.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnBackEntrust.setIcon(EASResource.getIcon((String)"imgTbtn_undo"));
        this.btnBackAllEntrust.setIcon(EASResource.getIcon((String)"imgTbtn_undo"));
    }

    public void onLoad() throws Exception {
        this.tblMain.addKDTDataFillListener((KDTDataFillListener)new EntrustAssignFillListener());
        super.onLoad();
    }

    @Override
    public void actionSelectAssignType_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdcb_assignType.getSelectedIndex() == 0) {
            this.kdchb_history.setVisible(false);
            this.btnBackEntrust.setVisible(true);
            this.btnBackEntrust.setEnabled(true);
            this.btnBackAllEntrust.setVisible(true);
            this.btnBackAllEntrust.setEnabled(true);
            this.mainQueryPK = undisposeTaskQueryPK;
        } else if (this.kdcb_assignType.getSelectedIndex() == 1) {
            this.kdchb_history.setVisible(false);
            this.btnBackEntrust.setVisible(false);
            this.btnBackAllEntrust.setVisible(false);
            this.mainQueryPK = allTaskQueryPK;
        } else {
            this.kdchb_history.setVisible(true);
            this.kdchb_history.setEnabled(true);
            this.kdchb_history.setSelected(false);
            this.btnBackEntrust.setVisible(false);
            this.btnBackAllEntrust.setVisible(false);
            this.mainQueryPK = disposedTaskQueryPK;
        }
        this.setDefaultSolutionToMainQuery();
        this.tblMain.refresh();
    }

    protected void initTableParams() {
        super.initTableParams();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        EntityViewInfo execCondition = viewInfo == null ? new EntityViewInfo() : (EntityViewInfo)viewInfo.clone();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        PersonInfo personInfo = userInfo.getPerson();
        FilterInfo filter = new FilterInfo();
        String personId = "";
        if (personInfo == null) {
            personId = "\u5f53\u524d\u767b\u5f55\u7528\u6237\u6ca1\u6709\u5bf9\u5e94\u7684\u804c\u5458";
            logger.info((Object)("\u5f53\u524d\u767b\u5f55\u7528\u6237\u6ca1\u6709\u5bf9\u5e94\u7684\u804c\u5458,\u663e\u793a\u4e3a\u7a7a\u5217\u8868.\u7528\u6237\u7f16\u7801\u4e3a" + userInfo.getNumber()));
        } else {
            personId = personInfo.getId().toString();
            logger.info((Object)("\u5f53\u524d\u767b\u5f55\u7528\u6237\u5bf9\u5e94\u7684\u804c\u5458ID\u662f\uff1a" + personId));
        }
        filter.getFilterItems().add(new FilterItemInfo("responsibleEmpId", (Object)personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("personEmpID", (Object)personId, CompareType.NOTEQUALS));
        if (execCondition.getFilter() != null && !StringUtils.isEmpty((String)execCondition.getFilter().toString())) {
            try {
                execCondition.getFilter().mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            execCondition.setFilter(filter);
        }
        SorterItemInfo sorterItemInfo = null;
        sorterItemInfo = new SorterItemInfo(SOURCEASSIGNID);
        sorterItemInfo.setSortType(SortType.DESCEND);
        execCondition.getSorter().add(sorterItemInfo);
        IQueryExecutor exec = super.getQueryExecutor(queryPK, execCondition);
        return exec;
    }

    @Override
    public void actionHstCheck_actionPerformed(ActionEvent e) throws Exception {
        this.mainQueryPK = this.kdchb_history.getSelected() == 32 ? disposedTaskHstQueryPK : disposedTaskQueryPK;
        this.setDefaultSolutionToMainQuery();
        this.tblMain.refresh();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        MetaDataPK currentPK = null;
        currentPK = this.kdcb_assignType.getSelectedIndex() == 0 ? undisposeTaskQueryPK : (this.kdcb_assignType.getSelectedIndex() == 1 ? allTaskQueryPK : (this.kdchb_history.getSelected() == 32 ? disposedTaskHstQueryPK : disposedTaskQueryPK));
        String queryName = EntrustProcListUI.getQueryInfo((IMetaDataPK)currentPK).getFullName();
        if (!this.isPerformDefaultQuery(iQuery, queryName) && !this.isFirstDefaultQuery()) {
            this.openCommonQueryDialog((IMetaDataPK)currentPK);
        }
    }

    private CommonQueryDialog openCommonQueryDialog(IMetaDataPK currentPK) throws Exception {
        CommonQueryDialog dlg = this.kdcb_assignType.getSelectedIndex() == 0 ? this.dlgEntrustPendingProc : (this.kdcb_assignType.getSelectedIndex() == 1 ? this.dlgEntrustAllProc : (this.kdchb_history.getSelected() == 32 ? this.dlgEntrustAlreadyHstProc : this.dlgEntrustAlreadyProc));
        if (dlg == null) {
            dlg = new CommonQueryDialog();
            if (this.getUIWindow() == null) {
                dlg.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                dlg.setOwner((Component)((Object)this));
            }
            dlg.setShowSorter(false);
            dlg.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            dlg.setQueryObjectPK(currentPK);
            dlg.setDisVisiableDefaultView(false);
            dlg.setUiObject(null);
            if (this.kdcb_assignType.getSelectedIndex() == 0) {
                this.dlgEntrustPendingProc = dlg;
            } else if (this.kdcb_assignType.getSelectedIndex() == 1) {
                this.dlgEntrustAllProc = dlg;
            } else if (this.kdchb_history.getSelected() == 32) {
                this.dlgEntrustAlreadyHstProc = dlg;
            } else {
                this.dlgEntrustAlreadyProc = dlg;
            }
        }
        if (dlg.show()) {
            EntityViewInfo result = dlg.getEntityViewInfoResult();
            if (result == null) {
                this.mainQuery.setFilter((FilterInfo)null);
            } else {
                this.mainQuery.setFilter(result.getFilter());
            }
            this.doQuery(dlg);
            this.tblMain.refresh();
        }
        return dlg;
    }

    public void setDefaultSolutionToMainQuery() {
        String cureQueryName = "";
        IQuerySolutionFacade iQuery = null;
        cureQueryName = this.mainQueryPK.getFullName();
        EntityViewInfo entityViewInfo = null;
        QuerySolutionInfo querySolutionInfo = null;
        try {
            String query;
            iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            querySolutionInfo = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), cureQueryName);
            if (querySolutionInfo != null && !StringUtils.isEmpty((String)(query = querySolutionInfo.getEntityViewInfo()))) {
                entityViewInfo = Util.getInnerFilterInfo((QuerySolutionInfo)querySolutionInfo);
            }
        }
        catch (BOSException e1) {
            logger.error((Object)("EntrustProcListUI\u52a0\u8f7d\u901a\u7528\u8fc7\u6ee4\u9ed8\u8ba4\u65b9\u6848setDefaultSolutionToMainQuery\u5f02\u5e38" + e1.getMessage()), (Throwable)e1);
        }
        catch (EASBizException e2) {
            logger.error((Object)("EntrustProcListUI\u52a0\u8f7d\u901a\u7528\u8fc7\u6ee4\u9ed8\u8ba4\u65b9\u6848setDefaultSolutionToMainQuery\u5f02\u5e38" + e2.getMessage()), (Throwable)e2);
        }
        if (this.mainQuery != null) {
            if (entityViewInfo != null) {
                this.mainQuery.setFilter(entityViewInfo.getFilter());
            } else {
                this.mainQuery.setFilter((FilterInfo)null);
            }
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.refresh();
    }

    @Override
    public void actionShowBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        Object sourceId = this.tblMain.getRow(rowIndex).getCell(ASSIGNID_NAME).getValue();
        MessageServiceProvider.showWFBill((Component)((Object)this), (String)sourceId.toString());
    }

    @Override
    public void actionShowWFImage_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        Object sourceId = this.tblMain.getRow(rowIndex).getCell(ASSIGNID_NAME).getValue();
        MessageUtil.showWorkFlowImage((EASWfServiceClient)this.getWorkflowClient(), (String)sourceId.toString(), (Object)((Object)this));
    }

    private EASWfServiceClient getWorkflowClient() {
        return new EASWfServiceClient();
    }

    @Override
    public void actionViewAuditResult_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        try {
            int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            String sourceId = this.tblMain.getRow(rowIndex).getCell(ASSIGNID_NAME).getValue().toString();
            MessageServiceProvider.showAuditResult((Component)((Object)this), (String)sourceId);
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"showImageFail"), (Throwable)e1);
        }
    }

    @Override
    public void actionBackEntrust_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int result = MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE, (String)"confirmBackEntrust"));
        if (result == 2) {
            return;
        }
        int size = this.tblMain.getSelectManager().size();
        if (size > 1) {
            this.mutiBackEntrust(size, this.tblMain.getSelectManager());
        } else {
            int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            Object assignId_tblCell = this.tblMain.getRow(rowIndex).getCell(ASSIGNID_NAME).getValue();
            if (assignId_tblCell != null) {
                String assignId = assignId_tblCell.toString();
                IEnactmentService wfService = EnactmentServiceFactory.createRemoteEnactService();
                UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
                String userId = userInfo.getId().toString();
                HashMap<String, String> extendMsg = new HashMap<String, String>();
                extendMsg.put("forwardType", "backdele");
                try {
                    wfService.devolve(assignId, userId, extendMsg);
                }
                catch (Exception e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                    MsgBox.showError((Component)((Object)this), (String)"\u56de\u6536\u59d4\u6258\u6d41\u7a0b\u5931\u8d25", (String)e1.getMessage());
                    return;
                }
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"takeBackEntrustSuccess"));
                this.tblMain.refresh();
            }
        }
    }

    @Override
    public void actionBackAllEntrust_actionPerformed(ActionEvent e) throws Exception {
        int result = MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE, (String)"confirmBackAllEntrust"));
        if (result == 2) {
            return;
        }
        int size = this.tblMain.getBody().size();
        KDTSelectManager kdtSelectManager = new KDTSelectManager(this.tblMain);
        kdtSelectManager.select(0, 0, size - 1, size - 1, 10);
        this.mutiBackEntrust(kdtSelectManager.size(), kdtSelectManager);
    }

    public void mutiBackEntrust(int size, KDTSelectManager kdtSelectManager) throws Exception {
        StringBuilder sbf = new StringBuilder();
        int successCount = 0;
        int failedCount = 0;
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = kdtSelectManager.get(i);
            for (int j = sb.getTop(); j <= sb.getBottom(); ++j) {
                String assignId;
                Object assignId_tblCell;
                ICell cell;
                IRow row;
                if (j < 0 || (row = this.tblMain.getRow(j)) == null || (cell = row.getCell(ASSIGNID_NAME)) == null || (assignId_tblCell = cell.getValue()) == null || (assignId = assignId_tblCell.toString()).length() == 0) continue;
                if (sbf.length() == 0) {
                    sbf.append(assignId);
                    continue;
                }
                sbf.append(";");
                sbf.append(assignId);
            }
        }
        if (StringUtils.isEmpty((String)sbf.toString())) {
            return;
        }
        String[] idArray = sbf.toString().split(";");
        HashMap<String, String> extendMsg = new HashMap<String, String>();
        for (int i = 0; i < idArray.length; ++i) {
            extendMsg.put("forwardType", "backdele");
            IEnactmentService wfService = EnactmentServiceFactory.createRemoteEnactService();
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            String userId = userInfo.getId().toString();
            try {
                wfService.devolve(idArray[i], userId, extendMsg);
                ++successCount;
                continue;
            }
            catch (Exception e1) {
                if (e1 instanceof DevolveDenialException) {
                    logger.error((Object)(idArray[i] + EASResource.getString((String)RESOURCE, (String)"forbidTransmit") + e1.getMessage()), (Throwable)e1);
                    continue;
                }
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        String successCountStr = successCount + "";
        failedCount = this.tblMain.getRowCount() - successCount;
        String failedCountStr = failedCount + "";
        StringBuffer msgStrBuf = new StringBuffer(EASResource.getString((String)RESOURCE, (String)"takeBackEntrustCount"));
        msgStrBuf.append("\uff1a").append(EASResource.getString((String)RESOURCE, (String)"failed")).append(failedCountStr).append(", ").append(EASResource.getString((String)RESOURCE, (String)"success")).append(": ").append(successCountStr);
        MsgBox.showInfo((String)msgStrBuf.toString());
        this.tblMain.refresh();
    }

    public static String allowForward(IEnactmentService service, String assignmentId) throws Exception {
        if (service == null) {
            throw new IllegalArgumentException();
        }
        if (assignmentId == null || assignmentId.length() <= 0) {
            throw new IllegalArgumentException();
        }
        AssignmentInfo assignmentInfo = service.getAssignmentById(assignmentId);
        String procInstId = assignmentInfo.getProcInstId();
        String actDefId = assignmentInfo.getActDefId();
        ProcessInstInfo processInstInfo = service.getProcessInstInfo(procInstId);
        ProcessDef processDef = null;
        processDef = service.getRuntimeProcessDef(processInstInfo.getProcDefHashValue());
        if (processDef == null) {
            logger.error((Object)"The process define is not existing ");
            return EASResource.getString((String)RESOURCE, (String)"procDefIsNull");
        }
        ActivityDef activityDef = processDef.getActivityDef(actDefId);
        if (!(activityDef instanceof ManpowerActivityDef)) {
            return EASResource.getString((String)RESOURCE, (String)"isNotManpowerActivityDef");
        }
        return "true";
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        } else if (e.getType() == 1) {
            if (this.tblMain.getSelectManager().get() == null) {
                return;
            }
            if (e.getButton() != 1 || e.getClickCount() == 2) {
                // empty if block
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getKeyFieldName() {
        return ASSIGNID_NAME;
    }

    class EntrustAssignFillListener
    implements KDTDataFillListener {
        EntrustAssignFillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            int firstRow = e.getFirstRow();
            int lastRow = e.getLastRow();
            if (lastRow != -1) {
                HashSet<String> sourceIds = new HashSet<String>();
                for (int i = firstRow; i <= lastRow; ++i) {
                    IRow row = EntrustProcListUI.this.tblMain.getRow(i);
                    String sourceAssignId = (String)row.getCell(EntrustProcListUI.SOURCEASSIGNID).getValue();
                    if (!sourceIds.contains(sourceAssignId)) {
                        sourceIds.add(sourceAssignId);
                        String entrustedUserName = (String)row.getCell(EntrustProcListUI.ENTRUSTED_USERNAME).getValue();
                        if (entrustedUserName != null) {
                            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
                            String userName = userInfo.getName();
                            StringBuffer sf = new StringBuffer("");
                            sf.append(userName).append(" ").append(EASResource.getString((String)EntrustProcListUI.RESOURCE, (String)"entrust")).append(" ").append(entrustedUserName);
                            row.getCell(EntrustProcListUI.ENTRUSTED_USERNAME).setValue((Object)sf.toString());
                        }
                        Object state = row.getCell(EntrustProcListUI.INDEX_COLUMN_STATE).getValue();
                        if (EntrustProcListUI.this.mainQueryPK != allTaskQueryPK || state == null) continue;
                        int _state = Integer.parseInt(state.toString());
                        row.getCell(EntrustProcListUI.INDEX_COLUMN_STATE).setValue((Object)WfAssignmentState.getEnum((int)_state));
                        continue;
                    }
                    EntrustProcListUI.this.tblMain.removeRow(i);
                    --i;
                    --lastRow;
                }
            }
        }
    }
}

