/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc.client;

import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.eas.cp.mc.AttributeBean;
import com.kingdee.eas.cp.mc.client.IShapeChange;
import com.kingdee.eas.cp.mc.shape.Circle;
import com.kingdee.eas.cp.mc.shape.IShape;
import com.kingdee.eas.cp.mc.shape.Polygon;
import com.kingdee.eas.cp.mc.shape.Rectangle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

public class DrawContainer
extends KDPanel {
    private static final long serialVersionUID = -2627664090559232598L;
    private int currentShape = 1;
    Component parent;
    private KDPopupMenu popupMenu;
    private List shapes;
    private List lines;
    private boolean isDrawing = false;
    private boolean isMouseUp = true;
    private Point startPoint;
    private Point endPoint;
    private boolean isDrawingPolygon = false;
    private IShape activeShape;
    private Rectangle currentRectangle;
    private Circle currentCircle;
    private IShapeChange shapeChange;

    public DrawContainer(Component parent, IShapeChange shapeChange) {
        this.parent = parent;
        this.lines = new ArrayList();
        this.shapes = new ArrayList();
        this.shapeChange = shapeChange;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (DrawContainer.this.currentShape == 1 || DrawContainer.this.currentShape == 2) {
                    if (DrawContainer.this.isMouseUp) {
                        DrawContainer.this.isMouseUp = false;
                        DrawContainer.this.startPoint = e.getPoint();
                        DrawContainer.this.endPoint = e.getPoint();
                    }
                } else if (DrawContainer.this.currentShape == 3) {
                    if (!DrawContainer.this.isDrawingPolygon) {
                        DrawContainer.this.isDrawingPolygon = true;
                        DrawContainer.this.lines.clear();
                        DrawContainer.this.startPoint = e.getPoint();
                        DrawContainer.this.endPoint = e.getPoint();
                        DrawContainer.this.lines.add(DrawContainer.this.startPoint);
                    }
                } else if (DrawContainer.this.currentShape == 4) {
                    // empty if block
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DrawContainer.this.currentShape != 3 && !DrawContainer.this.isDrawing) {
                    DrawContainer.this.isMouseUp = true;
                    DrawContainer.this.setActiveShape(e.getPoint());
                    return;
                }
                DrawContainer.this.isDrawing = false;
                if (DrawContainer.this.currentShape == 1 || DrawContainer.this.currentShape == 2) {
                    if (!DrawContainer.this.isMouseUp) {
                        DrawContainer.this.endPoint = new Point(e.getX(), e.getY());
                        if (DrawContainer.this.currentShape == 1 && DrawContainer.this.currentRectangle != null) {
                            if (DrawContainer.this.currentRectangle.getHeight() > 5 && DrawContainer.this.currentRectangle.getWidth() > 5) {
                                DrawContainer.this.addShape(DrawContainer.this.currentRectangle);
                            }
                        } else if (DrawContainer.this.currentShape == 2 && DrawContainer.this.currentCircle.getRadius() > 5) {
                            DrawContainer.this.addShape(DrawContainer.this.currentCircle);
                        }
                        DrawContainer.this.isMouseUp = true;
                        DrawContainer.this.repaint();
                    }
                } else if (DrawContainer.this.currentShape == 3 && DrawContainer.this.isDrawingPolygon) {
                    DrawContainer.this.startPoint = e.getPoint();
                    DrawContainer.this.endPoint = e.getPoint();
                    if (DrawContainer.this.lines.size() >= 3) {
                        Point start = (Point)DrawContainer.this.lines.get(0);
                        int distance = (int)start.distance(DrawContainer.this.endPoint);
                        if (distance <= 5) {
                            DrawContainer.this.endPoint = (Point)start.clone();
                            DrawContainer.this.isDrawingPolygon = false;
                            DrawContainer.this.lines.add(DrawContainer.this.endPoint);
                            DrawContainer.this.addPolygon();
                        } else {
                            DrawContainer.this.lines.add(DrawContainer.this.endPoint);
                        }
                    } else if (DrawContainer.this.lines.size() == 2) {
                        Point start = (Point)DrawContainer.this.lines.get(0);
                        int distance = (int)start.distance(DrawContainer.this.endPoint);
                        if (distance <= 5) {
                            DrawContainer.this.lines.clear();
                            DrawContainer.this.isDrawingPolygon = false;
                        } else {
                            DrawContainer.this.lines.add(DrawContainer.this.endPoint);
                        }
                    } else {
                        DrawContainer.this.lines.add(DrawContainer.this.endPoint);
                    }
                    DrawContainer.this.repaint();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!(DrawContainer.this.currentShape != 1 && DrawContainer.this.currentShape != 2 || DrawContainer.this.isMouseUp)) {
                    DrawContainer.this.endPoint = new Point(e.getX(), e.getY());
                }
                DrawContainer.this.isDrawing = true;
                DrawContainer.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (DrawContainer.this.currentShape == 3 && DrawContainer.this.isDrawingPolygon) {
                    DrawContainer.this.endPoint = new Point(e.getX(), e.getY());
                }
                DrawContainer.this.repaint();
            }
        });
        this.popupMenu = new KDPopupMenu();
        KDMenuItem menuItem = new KDMenuItem("Edit");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeBean attBean = DrawContainer.this.activeShape.getAttribute();
            }
        });
        this.popupMenu.add((JMenuItem)menuItem);
        menuItem = new KDMenuItem("Delete");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawContainer.this.removeShape(DrawContainer.this.activeShape);
            }
        });
        this.popupMenu.add((JMenuItem)menuItem);
        this.setOpaque(false);
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.BLACK);
        if (this.currentShape == 1 || this.currentShape == 2) {
            if (!this.isMouseUp) {
                if (this.currentShape == 1) {
                    this.currentRectangle = this.generateRectangle(this.startPoint, this.endPoint);
                    g2d.drawRect(this.currentRectangle.getX(), this.currentRectangle.getY(), this.currentRectangle.getWidth(), this.currentRectangle.getHeight());
                } else if (this.currentShape == 2) {
                    this.currentCircle = this.generateCircle(this.startPoint, this.endPoint);
                    g2d.drawOval(this.currentCircle.getX(), this.currentCircle.getY(), this.currentCircle.getDiameter(), this.currentCircle.getDiameter());
                }
            }
        } else if (this.currentShape == 3) {
            int size = this.lines.size();
            for (int i = 0; i < size - 1; ++i) {
                Point start = (Point)this.lines.get(i);
                Point end = (Point)this.lines.get(i + 1);
                g2d.drawLine(start.x, start.y, end.x, end.y);
            }
            if (this.isDrawingPolygon) {
                g2d.drawLine(this.startPoint.x, this.startPoint.y, this.endPoint.x, this.endPoint.y);
            }
        }
        for (int i = this.shapes.size() - 1; i >= 0; --i) {
            IShape s;
            s.setActive(this.activeShape == (s = (IShape)this.shapes.get(i)));
            s.draw(g2d);
        }
    }

    private Circle generateCircle(Point startPoint, Point endPoint) {
        int width;
        int height = Math.abs(startPoint.y - endPoint.y);
        int length = height > (width = Math.abs(startPoint.x - endPoint.x)) ? height : width;
        Circle circle = new Circle();
        circle.setX(startPoint.x - length);
        circle.setY(startPoint.y - length);
        circle.setDiameter(length * 2);
        return circle;
    }

    private Rectangle generateRectangle(Point startPoint, Point endPoint) {
        Point pointOne = startPoint;
        Point pointTwo = endPoint;
        if (endPoint.x > startPoint.x && endPoint.y > startPoint.y) {
            pointOne = new Point(startPoint);
            pointTwo = new Point(endPoint);
        } else if (endPoint.x > startPoint.x && endPoint.y < startPoint.y) {
            pointOne = new Point(startPoint.x, endPoint.y);
            pointTwo = new Point(endPoint.x, startPoint.y);
        } else if (endPoint.x < startPoint.x && endPoint.y < startPoint.y) {
            pointOne = endPoint;
            pointTwo = startPoint;
        } else if (endPoint.x < startPoint.x && endPoint.y > startPoint.y) {
            pointOne = new Point(endPoint.x, startPoint.y);
            pointTwo = new Point(startPoint.x, endPoint.y);
        }
        return new Rectangle(pointOne.x, pointOne.y, pointTwo.x - pointOne.x, pointTwo.y - pointOne.y);
    }

    private void addPolygon() {
        int[] x = new int[this.lines.size()];
        int[] y = new int[this.lines.size()];
        for (int i = 0; i < this.lines.size(); ++i) {
            Point point = (Point)this.lines.get(i);
            x[i] = point.x;
            y[i] = point.y;
        }
        Polygon poly = new Polygon(x, y);
        this.addShape(poly);
    }

    public void removeShape(IShape shape) {
        if (shape == null) {
            return;
        }
        this.shapes.remove(shape);
        this.activeShape = null;
        this.shapeChange.change(shape, 1);
        this.repaint();
    }

    public void addShape(IShape shape) {
        this.shapes.add(0, shape);
        this.shapeChange.change(shape, 0);
    }

    public List getShapes() {
        return this.shapes;
    }

    public void setCurrentShape(int currentShape) {
        this.currentShape = currentShape;
        if (currentShape == 4) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void removeShapes() {
        this.lines.clear();
        this.shapes.clear();
        this.shapeChange.change(null, 3);
        this.activeShape = null;
        this.repaint();
    }

    public void setActiveShape(Point point) {
        if (this.currentShape == 4 && !this.popupMenu.isShowing()) {
            IShape shape2 = null;
            for (IShape shape2 : this.shapes) {
                if (!shape2.contains(point)) continue;
                this.setActiveShape(shape2);
                break;
            }
        }
    }

    public void setActiveShape(IShape shape) {
        this.activeShape = shape;
        this.shapeChange.change(shape, 2);
        this.repaint();
    }

    public IShape getActiveShape() {
        return this.activeShape;
    }
}

