/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc.client;

import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.common.client.ClientVersionUtil;
import com.kingdee.eas.cp.mc.AttributeBean;
import com.kingdee.eas.cp.mc.MapTypeEnum;
import com.kingdee.eas.cp.mc.PortletImportExportException;
import com.kingdee.eas.cp.mc.StateEnum;
import com.kingdee.eas.cp.mc.client.DrawContainer;
import com.kingdee.eas.cp.mc.shape.AdapterShape;
import com.kingdee.eas.cp.mc.shape.Circle;
import com.kingdee.eas.cp.mc.shape.IShape;
import com.kingdee.eas.cp.mc.shape.Polygon;
import com.kingdee.eas.cp.mc.shape.Rectangle;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ImportExportOprt {
    private static String RES = "com.kingdee.eas.cp.mc.MapDesignResource";

    public static void deleteFolder(File dir) {
        File[] filelist = dir.listFiles();
        int listlen = filelist.length;
        for (int i = 0; i < listlen; ++i) {
            if (filelist[i].isDirectory()) {
                ImportExportOprt.deleteFolder(filelist[i]);
                continue;
            }
            filelist[i].delete();
        }
        dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] exportFile(File savePath, String saveName, File imagefile, DrawContainer drawContainer) {
        File dir = new File(savePath + File.separator + saveName);
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdir();
        }
        File imgfile = new File(dir, "hotImage.jpg");
        FileOutputStream streamOut = null;
        FileInputStream streamIn = null;
        File xmlFile = null;
        try {
            streamOut = new FileOutputStream(imgfile);
            streamIn = new FileInputStream(imagefile);
            int bytesRead = 0;
            while ((bytesRead = streamIn.read()) != -1) {
                streamOut.write(bytesRead);
            }
            xmlFile = new File(dir + File.separator + saveName + ".xml");
            xmlFile.createNewFile();
            String xmlPath = dir + File.separator + saveName + ".xml";
            ImportExportOprt.xmlEncoder(drawContainer.getShapes(), xmlPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (streamOut != null) {
                try {
                    streamOut.close();
                }
                catch (IOException e) {}
            }
            if (streamIn != null) {
                try {
                    streamIn.close();
                }
                catch (IOException e) {}
            }
        }
        File[] files = new File[]{imgfile, xmlFile};
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String importZipFile(File jarfile, String path) {
        FileInputStream in = null;
        ZipInputStream jarIn = null;
        FileOutputStream out = null;
        ZipEntry jar = null;
        File jarDirc = null;
        try {
            String[] dirc = jarfile.getName().split(".zip");
            jarDirc = new File(path + File.separator + dirc[0]);
            if (!jarDirc.exists() && !jarDirc.mkdir()) {
                throw new PortletImportExportException(PortletImportExportException.MKDIR_FAIL);
            }
            in = new FileInputStream(jarfile);
            jarIn = new ZipInputStream(in);
            while ((jar = jarIn.getNextEntry()) != null) {
                String fname;
                File dt;
                String name = jar.getName();
                if (jar.isDirectory()) {
                    name = name.substring(0, name.length() - 1);
                    File file1 = new File(jarDirc + File.separator + name);
                    file1.mkdir();
                    continue;
                }
                if (name.lastIndexOf("/") != -1 && !(dt = new File(fname = path + jar.getName().substring(0, jar.getName().lastIndexOf("/")))).exists()) {
                    dt.mkdirs();
                }
                File newfile = new File(jarDirc + File.separator + jar.getName());
                newfile.createNewFile();
                out = new FileOutputStream(newfile);
                int bytesRead = 0;
                while ((bytesRead = jarIn.read()) != -1) {
                    out.write(bytesRead);
                }
                out.flush();
            }
        }
        catch (PortletImportExportException e) {
            ExceptionHandler.handle((Throwable)((Object)e));
        }
        catch (IOException ex) {
            ExceptionHandler.handle((Throwable)ex);
            ex.printStackTrace();
        }
        finally {
            if (jarIn != null) {
                try {
                    jarIn.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return jarDirc.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportZipFile(File[] allfiles, String saveName) {
        ZipEntry entry = null;
        int bytesRead = 0;
        int length = allfiles.length;
        FileOutputStream stream = null;
        FileInputStream in = null;
        ZipOutputStream out = null;
        try {
            stream = new FileOutputStream(saveName + ".zip");
            out = new ZipOutputStream(stream);
            for (int i = 0; i < length; ++i) {
                entry = new ZipEntry(allfiles[i].getName());
                out.putNextEntry(entry);
                in = new FileInputStream(allfiles[i]);
                while ((bytesRead = in.read()) != -1) {
                    out.write(bytesRead);
                }
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document xmIncoder(File file) {
        FileInputStream in = null;
        Object reader = null;
        Document document = null;
        try {
            in = new FileInputStream(file);
            document = XMLParser.parseXML((InputStream)in);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void xmlEncoder(List array, String path) {
        List arr = array;
        BufferedWriter buff = null;
        FileOutputStream stream = null;
        try {
            String version = ClientVersionUtil.getCommonLibVersion();
            String head = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
            String root = "<graphicportlet version=\"" + version + "\" >";
            String end = "</graphicportlet>";
            stream = new FileOutputStream(new File(path));
            buff = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, "UTF-8"));
            buff.write(head);
            buff.newLine();
            buff.write(root);
            buff.newLine();
            for (IShape sha : arr) {
                String xml = sha.toXml();
                buff.write(xml);
                buff.newLine();
            }
            buff.write(end);
            buff.flush();
            buff.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (buff != null) {
                try {
                    buff.close();
                }
                catch (IOException e) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static boolean checkVersion(Document doc) {
        boolean flag = false;
        Element root = doc.getRootElement();
        String version = root.getAttributeValue("version");
        if (version != null) {
            try {
                if (ClientVersionUtil.getCommonLibVersion().equals(version)) {
                    flag = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    private static boolean checkXml(Document doc) {
        boolean flag = false;
        Element root = doc.getRootElement();
        if (root.getAttribute("version") != null && root.getName().equals("graphicportlet")) {
            flag = true;
        }
        return flag;
    }

    public static boolean loadFromXML(Document doc, DrawContainer drawContainer) throws PortletImportExportException {
        boolean flag = false;
        if (!ImportExportOprt.checkXml(doc)) {
            MsgBox.showError((String)EASResource.getString((String)RES, (String)"invalidXml"));
            return flag;
        }
        if (!ImportExportOprt.checkVersion(doc)) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"versionError"));
            SysUtil.abort();
        }
        AttributeBean bean = null;
        Element root = doc.getRootElement();
        Element hot2 = null;
        AdapterShape shape = null;
        Object attribute = null;
        List arry = root.getChildren("hot");
        for (Element hot2 : arry) {
            String[] result;
            String hotType = hot2.getAttributeValue("type");
            String param = hot2.getAttributeValue("param");
            if (hotType.equals("Rectangle")) {
                bean = new AttributeBean();
                ImportExportOprt.loadAttributeBean(bean, hot2);
                result = param.split(",");
                shape = new Rectangle(new Integer(result[0]), new Integer(result[1]), new Integer(result[2]), new Integer(result[3]));
                drawContainer.setCurrentShape(1);
                shape.setAttribute(bean);
                drawContainer.addShape(shape);
            } else if (hotType.equals("Circle")) {
                bean = new AttributeBean();
                ImportExportOprt.loadAttributeBean(bean, hot2);
                result = param.split(",");
                Circle cir = new Circle();
                cir.setX(new Integer(result[0]));
                cir.setY(new Integer(result[1]));
                cir.setDiameter(new Integer(result[2]));
                shape = cir;
                shape.setAttribute(bean);
                drawContainer.addShape(shape);
                drawContainer.setCurrentShape(2);
            } else if (hotType.equals("Polygon")) {
                bean = new AttributeBean();
                ImportExportOprt.loadAttributeBean(bean, hot2);
                result = param.split(";");
                int[] xResult = null;
                int[] yResult = null;
                if (result != null) {
                    int i;
                    String[] n = result[0].split(",");
                    int size = n.length;
                    xResult = new int[size];
                    for (i = 0; i < size; ++i) {
                        xResult[i] = new Integer(n[i]);
                    }
                    n = result[1].split(",");
                    size = n.length;
                    yResult = new int[size];
                    for (i = 0; i < size; ++i) {
                        yResult[i] = new Integer(n[i]);
                    }
                }
                shape = new Polygon(xResult, yResult);
                shape.setAttribute(bean);
                drawContainer.addShape(shape);
                drawContainer.setCurrentShape(3);
            }
            flag = true;
        }
        return flag;
    }

    private static void loadAttributeBean(AttributeBean bean, Element hot) {
        String href = null;
        Element attribute = hot.getChild("attribute");
        if (attribute.getAttributeValue("type").equals("menu")) {
            bean.setType(MapTypeEnum.MENU);
            href = attribute.getAttributeValue("href");
            MainMenuItemInfo itemInfo = new MainMenuItemInfo();
            if (!href.equals("") && href != null) {
                String[] menuInfo = href.split(",");
                itemInfo.setUiClassName(menuInfo[0]);
                itemInfo.setUiClassParam(menuInfo[1]);
                itemInfo.setUiOprt(menuInfo[2]);
                itemInfo.setName(menuInfo[3]);
                bean.setHref(itemInfo);
            }
        } else if (attribute.getAttributeValue("type").equals("link")) {
            bean.setType(MapTypeEnum.LINK);
            href = attribute.getAttributeValue("href");
            if (!href.equals("") && href != null) {
                bean.setHref(href);
            }
        }
        bean.setTitle(attribute.getAttributeValue("title"));
        bean.setAlt(attribute.getAttributeValue("alt"));
        bean.setOnClick(attribute.getAttributeValue("onClick"));
        if (attribute.getAttributeValue("enable").equals("true")) {
            bean.setState(StateEnum.ENABLE);
        } else {
            bean.setState(StateEnum.DISABLE);
        }
    }
}

