/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.myeas.client.ProjectSettingFileFilter;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.mc.IMyLinkPortlet;
import com.kingdee.eas.cp.mc.MyLinkPortletException;
import com.kingdee.eas.cp.mc.MyLinkPortletFactory;
import com.kingdee.eas.cp.mc.MyLinkPortletInfo;
import com.kingdee.eas.cp.mc.client.AbstractMyLinkPortalEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class MyLinkPortalEditUI
extends AbstractMyLinkPortalEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MyLinkPortalEditUI.class);
    private static final String[] CHOOSEABLE_FILE_EXTEND = new String[]{"JPG", "GIF", "PNG"};
    private static final String CHOOSEABLE_FILE_TYPE = "Image File";
    private File oldMyLinkLogo = null;
    private File newMyLinkLogo = null;
    private AttachmentClientManager attachmentManager = new AttachmentClientManager();

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("url"));
        sic.add(new SelectorItemInfo("isSystemShare"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("orderNo"));
        sic.add(new SelectorItemInfo("userId"));
        sic.add(new SelectorItemInfo("logo"));
        sic.add(new SelectorItemInfo("isAppendSso"));
        return sic;
    }

    public MyLinkPortalEditUI() throws Exception {
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_preview2"));
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    MyLinkPortalEditUI.this.newMyLinkLogo = MyLinkPortalEditUI.this.chooseFile(CHOOSEABLE_FILE_EXTEND, MyLinkPortalEditUI.CHOOSEABLE_FILE_TYPE);
                    if (MyLinkPortalEditUI.this.newMyLinkLogo != null) {
                        MyLinkPortalEditUI.this.labelLogo.setIcon((Icon)new ImageIcon(MyLinkPortalEditUI.this.newMyLinkLogo.toURL()));
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
        this.btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MyLinkPortalEditUI.this.newMyLinkLogo = null;
                MyLinkPortalEditUI.this.labelLogo.setIcon(null);
            }
        });
    }

    private File chooseFile(String[] ext, String descript) {
        File selectFile = null;
        KDFileChooser fileChooser = new KDFileChooser(System.getProperty("user.home"));
        fileChooser.setFileFilter((FileFilter)new ProjectSettingFileFilter(ext, descript));
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        int option = fileChooser.showOpenDialog((Component)((Object)this));
        if (option == 1) {
            fileChooser.cancelSelection();
            return selectFile;
        }
        selectFile = fileChooser.getSelectedFile();
        return selectFile;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String imageLogoAttachmentID = null;
        if (this.newMyLinkLogo != null) {
            String imageID = BOSUuid.create((BOSObjectType)this.getBizInterface().getType()).toString();
            int begin = this.newMyLinkLogo.getName().indexOf(".");
            String suffix = this.newMyLinkLogo.getName().substring(begin, this.newMyLinkLogo.getName().length());
            File tempFile = null;
            try {
                String name = System.currentTimeMillis() + "";
                tempFile = File.createTempFile(name, suffix);
            }
            catch (Exception ex) {
                tempFile = new File(this.newMyLinkLogo.getParent() + File.pathSeparator + this.newMyLinkLogo.getName());
            }
            this.copyFile(this.newMyLinkLogo, tempFile);
            imageLogoAttachmentID = this.attachmentManager.addNewAttachment(imageID, tempFile);
            tempFile.delete();
            this.editData.setLogo(imageLogoAttachmentID);
        }
        this.editData.setUserId(SysContext.getSysContext().getCurrentUserInfo());
        super.actionSubmit_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File sourceFile, File copyFile) throws IOException {
        sourceFile.createNewFile();
        copyFile.createNewFile();
        FileInputStream fileInput = null;
        FileOutputStream fileOut = null;
        byte[] buf = new byte[1024];
        try {
            fileInput = new FileInputStream(sourceFile);
            fileOut = new FileOutputStream(copyFile);
            int count = fileInput.read(buf);
            while (count != -1) {
                fileOut.write(buf);
                count = fileInput.read(buf);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fileInput != null) {
                try {
                    fileInput.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initButton();
        this.initChkIsSystemShare();
        if (this.editData.getLogo() != null && this.editData.getLogo().trim().length() > 1) {
            this.initLogo();
        }
    }

    private void initChkIsSystemShare() throws Exception {
        String userid = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String orgid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        boolean isManager = ((IMyLinkPortlet)this.getBizInterface()).isManager(userid, orgid);
        if (isManager) {
            this.chkIsSystemShare.setEnabled(true);
        }
    }

    private void initButton() throws Exception {
        if (this.oprtState.equals(OprtState.ADDNEW) || this.oprtState.equals(OprtState.COPYADDNEW) || this.oprtState.equals(OprtState.EDIT)) {
            this.btnView.setEnabled(true);
            this.btnDel.setEnabled(true);
        } else {
            this.btnView.setEnabled(false);
            this.btnDel.setEnabled(false);
        }
        this.btnSave.setEnabled(false);
        this.btnSave.setVisible(false);
        this.btnCopy.setVisible(false);
    }

    private void initLogo() throws Exception {
        String imagePath = this.attachmentManager.downloadAttachment(this.editData.getLogo());
        this.labelLogo.setIcon((Icon)new ImageIcon(new URL("file:/" + imagePath)));
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.btnView.setEnabled(true);
        this.btnDel.setEnabled(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.btnView.setEnabled(true);
        this.btnDel.setEnabled(true);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        MyLinkPortletInfo info = new MyLinkPortletInfo();
        info.setUrl("http://");
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MyLinkPortletFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo languageInfo = null;
        while (iter.hasNext()) {
            languageInfo = (LanguageInfo)iter.next();
            MultiLangItem name = this.kDBizMultiLangTitle.getItemBy(languageInfo);
            String nameData = (String)name.getData();
            if (nameData != null && nameData.trim().length() >= 1) continue;
            this.kDBizMultiLangTitle.requestFocus();
            this.kDBizMultiLangTitle.setSelectedLanguage(languageInfo);
            throw new MyLinkPortletException(MyLinkPortletException.TITLE_NOTNULL);
        }
        if (this.txtUrl.getText() == null || this.txtUrl.getText().trim().length() < 1) {
            this.txtUrl.requestFocus();
            throw new MyLinkPortletException(MyLinkPortletException.URL_NOT_NULL);
        }
    }
}

