/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc.shape;

import com.kingdee.eas.cp.mc.shape.AdapterShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;

public class Polygon
extends AdapterShape {
    private static final long serialVersionUID = 1742857873090443155L;
    private java.awt.Polygon _polygon;

    public Polygon(int[] x, int[] y) {
        this._polygon = new java.awt.Polygon(x, y, x.length);
    }

    @Override
    public void draw(Graphics2D g2d) {
        g2d.setColor(Color.BLACK);
        g2d.drawPolygon(this._polygon.xpoints, this._polygon.ypoints, this._polygon.npoints);
        if (this.active) {
            this.drawHighlighted(g2d);
        }
    }

    @Override
    public void drawHighlighted(Graphics2D g2d) {
        g2d.setColor(new Color(1.0f, 1.0f, 1.0f, 0.5f));
        g2d.fillPolygon(this._polygon.xpoints, this._polygon.ypoints, this._polygon.npoints);
    }

    @Override
    public boolean contains(Point p) {
        return this._polygon.contains(p);
    }

    public int[] getXPoints() {
        return this._polygon.xpoints;
    }

    public int[] getYPoints() {
        return this._polygon.ypoints;
    }

    public int getNPoints() {
        return this._polygon.npoints;
    }

    public String toString() {
        if (this.getAttribute().getTitle() != null && !"".equals(this.getAttribute().getTitle().trim())) {
            return this.getAttribute().getTitle();
        }
        return "Polygon(" + this.getXPoints()[0] + "," + this.getYPoints()[0] + ")";
    }

    public String toParamString() {
        String param = "";
        String paramX = "";
        String paramY = "";
        int[] n = this.getXPoints();
        if (n != null) {
            int i = n.length;
            for (int j = 0; j < i; ++j) {
                if (j == 0) {
                    paramX = paramX + this.getXPoints()[j];
                    paramY = paramY + this.getYPoints()[j];
                    continue;
                }
                paramX = paramX + "," + this.getXPoints()[j];
                paramY = paramY + "," + this.getYPoints()[j];
            }
            if (i != 0) {
                param = paramX + ";" + paramY;
            }
        }
        return param;
    }

    @Override
    public String toXml() {
        StringBuffer buf = new StringBuffer();
        buf.append("  <hot");
        buf.append(" type=\"Polygon\" param=\"");
        buf.append(this.toParamString());
        buf.append("\"");
        buf.append(" info=\"");
        buf.append(this.toString());
        buf.append("\">\n");
        buf.append("    <attribute ");
        buf.append(this.attribute.toString());
        buf.append("/>\n");
        buf.append("");
        buf.append("  </hot>");
        return buf.toString();
    }
}

