/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.StringUtil;
import com.kingdee.eas.cp.mc.GraphicsCollection;
import com.kingdee.eas.cp.mc.GraphicsFactory;
import com.kingdee.eas.cp.mc.GraphicsInfo;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Calendar;
import javax.servlet.ServletContext;

public class MutiGraphicsInstanceUtil {
    private String[] ids;

    public static MutiGraphicsInstanceUtil getInstance() {
        return new MutiGraphicsInstanceUtil();
    }

    private MutiGraphicsInstanceUtil() {
    }

    public String[] initIDs(String portletID, Context ctx) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("attachment.id"));
        selector.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Portlet", (Object)portletID, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(filter);
        GraphicsCollection col = null;
        try {
            col = GraphicsFactory.getRemoteInstance().getGraphicsCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        GraphicsInfo info = col.get(0);
        String graphicsID = info.getId().toString();
        if (info.getAttachment() == null) {
            this.ids = new String[]{portletID, graphicsID, null};
            return this.ids;
        }
        String attachID = info.getAttachment().getId().toString();
        this.ids = new String[]{portletID, graphicsID, attachID};
        return this.ids;
    }

    public void initIDs(String[] ids) {
        this.ids = ids;
    }

    public File loadImageSpotFromDB(Context ctx, ServletContext app) throws Exception {
        GraphicsInfo info = this.getGraphicsInfoByPK(ctx);
        byte[] imageSpotsContent = info.getFile();
        File imageSpots = this.getImageSpotsFromDB(imageSpotsContent, app, this.ids[2] + info.getLastUpdateTime().getTime());
        return imageSpots;
    }

    public File loadImageFromDB(Context ctx, ServletContext app) throws Exception {
        File image = this.getImageFromDB(this.ids[2], ctx, app);
        return image;
    }

    public GraphicsInfo getGraphicsInfoByPK(Context ctx) {
        GraphicsInfo info = null;
        try {
            info = GraphicsFactory.getRemoteInstance().getGraphicsInfo((IObjectPK)new ObjectUuidPK(this.ids[1]));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFile(String fileName, byte[] fileContent, ServletContext app) {
        File file = null;
        if (app == null) {
            String localDir = System.getProperty("EAS_HOME");
            SecureRandom rand = new SecureRandom();
            file = new File(localDir + "/client/temp/resource/" + this.getCodeRuleNumber(rand.nextInt()) + "/");
            if (!file.exists()) {
                file.mkdirs();
            }
            file = new File(file, fileName);
        } else {
            File fileDir = new File(app.getRealPath("") + "//resource//");
            if (!fileDir.exists()) {
                fileDir.mkdir();
            }
            if ((file = new File(app.getRealPath("") + "/resource/" + fileName)).exists()) {
                return file;
            }
        }
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            in = new BufferedInputStream(new ByteArrayInputStream(fileContent));
            out = new BufferedOutputStream(new FileOutputStream(file));
            byte[] array = new byte[4096];
            int len = 0;
            while ((len = in.read(array)) != -1) {
                ((BufferedOutputStream)out).write(array, 0, len);
            }
            ((BufferedOutputStream)out).flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    private String getCodeRuleNumber(int nCodeNumber) {
        StringBuffer sysNumber = new StringBuffer();
        String strCodeNumber = "";
        Calendar c = Calendar.getInstance();
        if (++nCodeNumber > 1000) {
            nCodeNumber = 0;
        }
        strCodeNumber = "" + nCodeNumber;
        int n = strCodeNumber.length();
        strCodeNumber = "";
        for (int i = 1; i < 4 - n; ++i) {
            strCodeNumber = strCodeNumber + 0;
        }
        strCodeNumber = strCodeNumber + nCodeNumber;
        sysNumber.append(c.get(1));
        if (c.get(2) + 1 < 10) {
            sysNumber.append(0).append(c.get(2) + 1);
        } else {
            sysNumber.append(c.get(2) + 1);
        }
        if (c.get(5) < 10) {
            sysNumber.append(0).append(c.get(5));
        } else {
            sysNumber.append(c.get(5));
        }
        if (c.get(11) < 10) {
            sysNumber.append(0).append(c.get(11));
        } else {
            sysNumber.append(c.get(11));
        }
        if (c.get(12) < 10) {
            sysNumber.append(0).append(c.get(12));
        } else {
            sysNumber.append(c.get(12));
        }
        if (c.get(13) < 10) {
            sysNumber.append(0).append(c.get(13));
        } else {
            sysNumber.append(c.get(13));
        }
        sysNumber.append(strCodeNumber);
        return sysNumber.toString();
    }

    public File getImageFromDB(String attachID, Context ctx, ServletContext app) {
        if (attachID == null) {
            return null;
        }
        AttachmentInfo info = this.getImageByID(attachID, ctx);
        if (info == null) {
            return null;
        }
        byte[] fileBytes = this.getFileBytes(attachID, ctx);
        String suffix = info.getSimpleName();
        File image = null;
        String fileName = null;
        if (app == null) {
            fileName = StringUtil.encoder((String)attachID);
            if (fileName.indexOf("%") > -1) {
                fileName = fileName.replaceAll("%", "9");
            }
            image = this.createFile(fileName + "." + suffix, fileBytes, null);
        } else {
            fileName = StringUtil.encoder((String)(attachID + info.getLastUpdateTime().getTime()));
            if (fileName.indexOf("%") > -1) {
                fileName = fileName.replaceAll("%", "9");
            }
            image = this.createFileOnServer(fileName + "." + suffix, app, info, fileBytes);
        }
        return image;
    }

    private byte[] getFileBytes(String attachID, Context ctx) {
        byte[] file = null;
        if (ctx == null) {
            AttachmentClientManager attachmentClientManager = AttachmentManagerFactory.getClientManager();
            try {
                file = attachmentClientManager.download(attachID);
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        AttachmentServerManager attachmentServerManager = AttachmentManagerFactory.getServerManager((Context)ctx);
        try {
            file = attachmentServerManager.download(attachID);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileOnServer(String fileName, ServletContext app, AttachmentInfo info, byte[] fileBytes) {
        File file;
        File fileDir = new File(app.getRealPath("") + "//resource//");
        if (!fileDir.exists()) {
            fileDir.mkdir();
        }
        if ((file = new File(app.getRealPath("") + "/resource/" + fileName)).exists()) {
            long saveOrUpdateToDBTime;
            long uploadTime = file.lastModified();
            if (uploadTime != (saveOrUpdateToDBTime = info.getLastUpdateTime().getTime())) {
                file.delete();
            } else if (uploadTime == saveOrUpdateToDBTime) {
                return file;
            }
        }
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new ByteArrayInputStream(fileBytes));
            out = new BufferedOutputStream(new FileOutputStream(file));
            file.setLastModified(info.getLastUpdateTime().getTime());
            byte[] array = new byte[4096];
            int len = 0;
            while ((len = in.read(array)) != -1) {
                ((BufferedOutputStream)out).write(array, 0, len);
            }
            ((BufferedOutputStream)out).flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    private AttachmentInfo getImageByID(String id, Context ctx) {
        AttachmentInfo info = null;
        try {
            info = AttachmentFactory.getRemoteInstance().getAttachmentInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return info;
    }

    public File getImageSpotsFromDB(byte[] imageSpotsContent, ServletContext app) {
        return this.getImageSpotsFromDB(imageSpotsContent, app, this.ids[2]);
    }

    public File getImageSpotsFromDB(byte[] imageSpotsContent, ServletContext app, String fileName) {
        if (imageSpotsContent == null) {
            return null;
        }
        if ((fileName = StringUtil.encoder((String)fileName)).indexOf("%") > -1) {
            fileName = fileName.replaceAll("%", "9");
        }
        File imageSpots = null;
        imageSpots = this.createFile(fileName + ".data", imageSpotsContent, app);
        return imageSpots;
    }
}

