/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.odm.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.netctrl.ObjectUpdateLock;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;

public class BillMessagePlugin
extends AbstractBillPlugin {
    boolean isAddNew = false;

    public void onLoad() {
        super.onLoad();
        try {
            PersonInfo personInfo = (PersonInfo)this.application.getValue("basedataAuthor", 0);
            if (this.isAddNew && personInfo != null) {
                String personId = personInfo.getId().toString();
                AdminOrgUnitInfo heightOrg = this.getHeightOrgByUserID(this.application.getContext(), personId);
                AdminOrgUnitInfo company = this.getCompany(this.application.getContext(), heightOrg);
                this.application.setValue("basedataCompany", (Object)company, 0);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        block3: {
            this.isAddNew = OperationStatus.ADDNEW.equals(param.billOperation);
            try {
                HashMap aMap;
                ObjectUpdateLock lockIns;
                Context ctx = this.application.getContext();
                String billID = param.billPk;
                if (!OperationStatus.EDIT.equals(param.billOperation)) break block3;
                UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                String userName = user.getName();
                if (MutexServiceControlFactory.getLocalInstance((Context)ctx).requestObjIDForUpdate(billID, userName) || (lockIns = (ObjectUpdateLock)(aMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).getObjIDForUpdateList()).get(billID + ctx.getAIS())) == null) break block3;
                if (userName.equals(lockIns.getUserName()) || this.isOverTimeLock(lockIns.getCreatedTime(), new Date())) {
                    MutexServiceControlFactory.getLocalInstance((Context)ctx).releaseObjIDForUpdate(billID);
                    MutexServiceControlFactory.getLocalInstance((Context)ctx).requestObjIDForUpdate(billID, userName);
                    break block3;
                }
                String message = "\u5bf9\u4e0d\u8d77\uff0c{0}\u6b63\u5728\u7f16\u8f91\u6b64\u5355\u636e\uff0c\u8bf7\u7a0d\u7b49\uff01";
                message = MessageFormat.format(message, lockIns.getUserName());
                throw new EASBizException(new NumericExceptionSubItem("", message));
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return super.onInitialize(param);
    }

    public void beforeCloseForm() throws BOSException {
        try {
            String billID = (String)this.application.getCustomParameter("billId");
            MutexServiceControlFactory.getLocalInstance((Context)this.application.getContext()).releaseObjIDForUpdate(billID);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        super.beforeCloseForm();
    }

    private boolean isOverTimeLock(Date lockDate, Date currentDate) {
        boolean flag = false;
        long mins = 60000L;
        if ((currentDate.getTime() - lockDate.getTime()) / mins >= 60L) {
            flag = true;
        }
        return flag;
    }

    public void dataChanged(DataChangeCommandArg dataChangeCommandArg) {
        String key = dataChangeCommandArg.getKey();
        if ("basedataAuthor".equalsIgnoreCase(key)) {
            try {
                if (dataChangeCommandArg.getNewValue() == null || ((PersonInfo)dataChangeCommandArg.getNewValue()).getId() == null) {
                    return;
                }
                String personId = ((PersonInfo)dataChangeCommandArg.getNewValue()).getId().toString();
                AdminOrgUnitInfo heightOrg = this.getHeightOrgByUserID(this.application.getContext(), personId);
                AdminOrgUnitInfo company = this.getCompany(this.application.getContext(), heightOrg);
                this.application.setValue("basedataCompany", (Object)company, 0);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private AdminOrgUnitInfo getCompany(Context ctx, AdminOrgUnitInfo adminOrgUnitInfo) {
        AdminOrgUnitInfo adminInfo = null;
        try {
            if (this.isCompanyOrUnit(adminOrgUnitInfo)) {
                return adminOrgUnitInfo;
            }
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            adminInfo = iAdmin.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnitInfo.getParent().getId().toString()));
            return this.getCompany(ctx, adminInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return adminInfo;
        }
    }

    private boolean isCompanyOrUnit(AdminOrgUnitInfo orgUnit) {
        String UNIT = "00000000-0000-0000-0000-00000000000162824988";
        String COMPANY = "00000000-0000-0000-0000-00000000000262824988";
        if (null != orgUnit && null != orgUnit.getUnitLayerType()) {
            return "00000000-0000-0000-0000-00000000000162824988".equals(orgUnit.getUnitLayerType().getId().toString()) || "00000000-0000-0000-0000-00000000000262824988".equals(orgUnit.getUnitLayerType().getId().toString());
        }
        return true;
    }

    public AdminOrgUnitInfo getHeightOrgByUserID(Context ctx, String personId) {
        AdminOrgUnitInfo info = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select position.* ,position.adminOrgUnit.*,isPrimary,id,number,name,parent");
            sb.append(" where person.id = '");
            sb.append(personId);
            sb.append("'");
            IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
            PositionMemberCollection pmColl = ipm.getPositionMemberCollection(sb.toString());
            int size = pmColl.size();
            for (int i = 0; i < size; ++i) {
                if (pmColl.get(i).getPosition() == null || !pmColl.get(i).isIsPrimary()) continue;
                info = pmColl.get(i).getPosition().getAdminOrgUnit();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return info;
    }

    private AdminOrgUnitInfo getCompany() {
        String UNIT = "00000000-0000-0000-0000-00000000000162824988";
        String COMPANY = "00000000-0000-0000-0000-00000000000262824988";
        Context ctx = this.application.getContext();
        AdminOrgUnitInfo orgUnitInfo = null;
        if (null != ContextUtil.getCurrentAdminUnit((Context)ctx) && null != ContextUtil.getCurrentAdminUnit((Context)ctx).getUnitLayerType()) {
            orgUnitInfo = "00000000-0000-0000-0000-00000000000162824988".equals(ContextUtil.getCurrentAdminUnit((Context)ctx).getUnitLayerType().getId().toString()) || "00000000-0000-0000-0000-00000000000262824988".equals(ContextUtil.getCurrentAdminUnit((Context)ctx).getUnitLayerType().getId().toString()) ? ContextUtil.getCurrentAdminUnit((Context)ctx) : (AdminOrgUnitInfo)ctx.get((Object)OrgType.Admin);
        }
        return orgUnitInfo;
    }
}

