/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.odm.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.command.BeforeCommandArg;
import com.kingdee.eas.base.form.model.list.ListPlugin;
import com.kingdee.eas.cp.odm.CommonOpinionFactory;
import com.kingdee.eas.cp.odm.CommonOpinionInfo;
import com.kingdee.eas.cp.odm.IsEnabledEnum;
import com.kingdee.eas.framework.CoreBaseInfo;

public class CommonOpinionListPlugin
extends ListPlugin {
    public void onLoad() {
    }

    public void beforeBarItemClick(BeforeCommandArg arg) throws BOSException {
        if ("tbButtonEnable".equalsIgnoreCase(arg.getKey())) {
            this.setEnableOrDisable(IsEnabledEnum.ENABLED);
        } else if ("tbButtonDisable".equalsIgnoreCase(arg.getKey())) {
            this.setEnableOrDisable(IsEnabledEnum.DISABLED);
        } else if ("tbButtonShare".equalsIgnoreCase(arg.getKey())) {
            // empty if block
        }
    }

    private void setEnableOrDisable(IsEnabledEnum isEnabledEnum) throws BOSException {
        String[] pks = this.application.getListView().getSelectedBillIds();
        try {
            if (pks == null || pks.length == 0) {
                this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff01");
                return;
            }
            if (pks.length > 1) {
                this.application.showMessage("\u4e0d\u80fd\u9009\u62e9\u591a\u884c\u6570\u636e\uff01");
                return;
            }
            IObjectValue objectValue = DAOHelper.getDAO().load(this.application.getContext(), pks[0], null);
            CommonOpinionInfo commonOpinion = (CommonOpinionInfo)objectValue;
            if (commonOpinion.getIsEnabled().getValue() == isEnabledEnum.getValue()) {
                this.application.showMessage("\u4e0d\u80fd\u5bf9" + isEnabledEnum.getAlias() + "\u72b6\u6001\u7684\u5355\u636e\u6267\u884c" + isEnabledEnum.getAlias() + "\u64cd\u4f5c\uff01");
                return;
            }
            commonOpinion.setIsEnabled(isEnabledEnum);
            CommonOpinionFactory.getLocalInstance(this.application.getContext()).save((CoreBaseInfo)commonOpinion);
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    public void afterOperation(FormOperation formOperation) {
        try {
            this.application.getListView().refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

