/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.odm.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.extend.attachment.AttachmentInfo;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.odm.util.OdmUtil;
import com.kingdee.eas.cp.wfm.utils.CommonUtil;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.util.StringUtils;

public class OdmDocBaseBillPlugin
extends AbstractBillPlugin {
    private static final String NODECONTROLBOSTYPE = "30551B26";
    private static final String OFFICEKEY = "Foffice";
    private String layoutId;
    private String nodeId;
    private String flowId;
    private String flowTemplateId = null;
    private String billPk;

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        this.billPk = param.billPk;
        if (this.billPk == null) {
            this.billPk = param.wfState.getBillID();
        }
        this.layoutId = this.application.getBillView().getLayoutInfo().getId();
        if (param.wfState != null) {
            this.nodeId = param.wfState.getNodeID();
            this.flowId = param.wfState.getProcDefId();
        }
        this.flowTemplateId = (String)this.application.getCustomParameter("flowTempId");
        if (this.flowId == null) {
            this.nodeId = "-1";
            this.flowId = "DRAFT";
        }
        if (this.nodeId == null) {
            this.nodeId = "-1";
        }
        return super.onInitialize(param);
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        Context ctx;
        AttachmentInfo attachemntInfo;
        String billId;
        Boolean mustClearDoc;
        boolean flag = super.beforeOperation(operation);
        if (operation.getOperation().equals("Submit") && (mustClearDoc = this.getSpecifiedBooleanProp(this.getControlPolicy(), "mustClearDoc", Boolean.FALSE)).booleanValue() && null != this.application.getBillModel().getPKValue() && !StringUtils.isEmpty((String)(billId = CommonUtil.loadObjectValue((Context)this.application.getContext(), (String)this.application.getBillModel().getPKValue()).getString("docContentId"))) && (attachemntInfo = OdmUtil.getAttachmentById(ctx = this.application.getContext(), billId)) != null && !"1".equals(attachemntInfo.getHasAcceptRevision())) {
            throw new ActionCommonException(null, "\u8bf7\u5bf9\u6b63\u6587\u5185\u5bb9\u6e05\u7a3f\u540e\u518d\u63d0\u4ea4\uff01");
        }
        return flag;
    }

    private IObjectValue getControlPolicy() throws EASBizException, BOSException {
        String pk = this.getPk();
        IObjectValue objectValue = null;
        if (pk != null) {
            objectValue = DAOHelper.getDAO().load(this.application.getContext(), pk, null);
        }
        return objectValue;
    }

    private String getPk() {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("layoutId", (Object)this.layoutId);
        if ("-1".equals(this.nodeId)) {
            this.flowId = "DRAFT";
        }
        if (this.flowId != null) {
            filter.appendFilterItem("flowId", (Object)this.flowId);
        }
        filter.appendFilterItem("flowNodeId", (Object)this.nodeId);
        filter.appendFilterItem("templateId", (Object)this.flowTemplateId);
        try {
            IObjectPK[] pks = DAOHelper.getDAO().getPKList(this.application.getContext(), BOSObjectType.create((String)NODECONTROLBOSTYPE), filter, null);
            if (pks.length > 0) {
                return pks[0].toString();
            }
            return null;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Boolean getSpecifiedBooleanProp(IObjectValue nodeSetting, String propName, Boolean bDefault) {
        Boolean prop = bDefault;
        if (nodeSetting != null) {
            prop = (Boolean)nodeSetting.get(propName);
        }
        return prop;
    }
}

