/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.odm.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.app.BusinessSeviceUtil;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoCollection;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoFactory;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoInfo;
import com.kingdee.eas.base.form.extend.flow.IDocumentInfo;
import com.kingdee.eas.base.form.extend.flow.ITemplate;
import com.kingdee.eas.base.form.extend.flow.TemplateFactory;
import com.kingdee.eas.base.form.extend.flow.TemplateInfo;
import com.kingdee.eas.base.form.extend.flow.WorkflowStatus;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.bill.BillBusinessUtil;
import com.kingdee.eas.base.form.model.bill.BillEventsProxy;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.BeforeCommandArg;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.form.util.FormActionUtil;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.odm.FileCenterRecordFactory;
import com.kingdee.eas.cp.odm.IFileCenterRecord;
import com.kingdee.eas.cp.odm.IOdmBotpFacade;
import com.kingdee.eas.cp.odm.IOdmFacade;
import com.kingdee.eas.cp.odm.OdmBotpFacadeFactory;
import com.kingdee.eas.cp.odm.OdmFacadeFactory;
import com.kingdee.eas.cp.odm.util.OdmUtil;
import com.kingdee.eas.dynbusiness.config.PropertyCheckConfigItems;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class OdmFileCenterBillPlugin
extends AbstractBillPlugin {
    private static final String FLOWINFO_BOSTYPE = "D8D254B4";
    boolean isNoFlowId = false;

    public boolean onInitialize(OpenBillParameter param) throws BOSException, EASBizException {
        return super.onInitialize(param);
    }

    public void onLoad() {
        super.onLoad();
        String formId = this.application.getForm().getId();
        if (formId != null && OdmUtil.isFileCenterAndNoWfByFormId(this.application.getContext(), formId)) {
            this.application.getContext().put((Object)"NOTTHROW_NOFLOWIDEXP", (Object)"false");
            this.isNoFlowId = true;
        } else {
            this.application.getContext().put((Object)"NOTTHROW_NOFLOWIDEXP", null);
            this.isNoFlowId = false;
        }
    }

    public void dataChanged(DataChangeCommandArg arg) {
        if ("FmulbasedataThematic".equalsIgnoreCase(arg.getKey())) {
            Object obj = arg.getNewValue();
            String thematicStr = "";
            if (obj != null) {
                String str = obj.toString();
                str = str.substring(str.lastIndexOf("[\"") + 2, str.lastIndexOf("\"]"));
                thematicStr = str.replaceAll("\",\"", " ");
            }
            try {
                this.application.setValue("FtxtThematic", (Object)thematicStr, 0);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public void doCustomOperation(String operation) throws BOSException, EASBizException {
        if ("closeBillWindow".equalsIgnoreCase(operation)) {
            this.application.getContext().put((Object)"NOTTHROW_NOFLOWIDEXP", (Object)"false");
            this.application.close();
            return;
        }
    }

    public void beforeBarItemClick(BeforeCommandArg beforeCommandArg) throws BOSException {
        System.out.println("into .....beforeBarItemClick");
    }

    public void beforeOperation(String operation) throws EASBizException, BOSException {
        System.out.println("into .....beforeOperation");
    }

    public boolean beforeOperation(FormOperation operation) throws BOSException, EASBizException {
        if ("Submit".equalsIgnoreCase(operation.getOperation())) {
            String billId = this.application.getBillModel().getPKValue();
            if (!OdmUtil.isExistAttachment(billId)) {
                this.application.showMessage(ResourceBase.getString((String)"com.kingdee.eas.cp.odm.OdmResource", (String)"upLoadFile", (Locale)this.application.getContext().getLocale()));
                return false;
            }
            HashSet<String> set = new HashSet<String>();
            Object zhusong = this.application.getBillModel().getBillValue().get("tocu");
            String[] str = null;
            try {
                str = OdmUtil.getConfidentialPersonNumByMulBaseDate(zhusong);
                if (str != null) {
                    for (int i = 0; i < str.length; ++i) {
                        set.add(str[i]);
                    }
                }
                if (set == null || set.size() < 1) {
                    this.application.showMessage(ResourceBase.getString((String)"com.kingdee.eas.cp.odm.OdmResource", (String)"noConfidentialPerson", (Locale)this.application.getContext().getLocale()));
                    return false;
                }
                IRowSet iRowSet = OdmUtil.getPersonIdsByConfidentialPerson(this.application.getContext(), set);
                if (iRowSet == null || iRowSet.size() < 1) {
                    this.application.showMessage(ResourceBase.getString((String)"com.kingdee.eas.cp.odm.OdmResource", (String)"noConfidentialPerson", (Locale)this.application.getContext().getLocale()));
                    return false;
                }
                if (iRowSet != null) {
                    boolean isNoPerson = false;
                    while (iRowSet.next()) {
                        String personId = iRowSet.getString("Person.id");
                        if (StringUtils.isEmpty((String)personId) || "null".equals(personId)) continue;
                        isNoPerson = true;
                        break;
                    }
                    if (!isNoPerson) {
                        this.application.showMessage(ResourceBase.getString((String)"com.kingdee.eas.cp.odm.OdmResource", (String)"noConfidentialPerson", (Locale)this.application.getContext().getLocale()));
                        return false;
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (this.isNoFlowId) {
                this.runSubmit(this.application.getContext());
                this.saveFileCenterRecord();
                this.application.showMessage("Submit", ResourceBase.getString((String)"com.kingdee.eas.cp.odm.OdmResource", (String)"sumbitSucceed", (Locale)this.application.getContext().getLocale()), 0, null);
                this.application.close();
                return false;
            }
        }
        return super.beforeOperation(operation);
    }

    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        super.afterOperation(operation);
    }

    private void saveFileCenterRecord() throws EASBizException, BOSException {
        IFileCenterRecord iFileCenterRecord = FileCenterRecordFactory.getLocalInstance(this.application.getContext());
        String billId = this.application.getBillModel().getPKValue();
        if (iFileCenterRecord.exists(" where billId='" + billId + "'")) {
            return;
        }
        IObjectValue iObjectValue = this.application.getBillModel().getBillValue();
        Object zhusong = iObjectValue.get("tocu");
        Object chaosong = iObjectValue.get("carboncopycu");
        this.application.getBillValue();
        boolean isSMS = new Boolean("true").equals(this.application.getValue("FisSMS", 0));
        boolean isMsg = new Boolean("true").equals(this.application.getValue("FisMsg", 0));
        boolean isEmail = new Boolean("true").equals(this.application.getValue("FisEmail", 0));
        Set set = OdmUtil.getConfidentNumSet(zhusong, chaosong);
        if (set == null || set.size() < 1) {
            return;
        }
        AdminOrgUnitInfo orgUnit = (AdminOrgUnitInfo)this.application.getValue("Fdept", 0);
        String txtAttachmentId = String.valueOf(this.application.getValue("Fid4attachment", 0));
        String bodyContent = String.valueOf(this.application.getValue("Ftitle", 0));
        IOdmFacade iOdmFacade = OdmFacadeFactory.getLocalInstance(this.application.getContext());
        iOdmFacade.saveFileCenterRecord(set, orgUnit, txtAttachmentId, billId, bodyContent, bodyContent, isSMS, isMsg, isEmail);
    }

    public void afterBotp(IObjectCollection destBills) throws EASBizException, BOSException {
        IObjectCollection coll = destBills;
        if (coll != null && coll.size() > 0 && "CreateTo".equals(this.application.getCustomParameter("botpFunc"))) {
            UserInfo user = (UserInfo)this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
            PersonInfo personInfo = UserFactory.getLocalInstance((Context)this.application.getContext()).getUserInfo((IObjectPK)new ObjectUuidPK(user.getId().toString())).getPerson();
            IObjectValue value = coll.getObject(0);
            value.setString("txtattachment", String.valueOf(BOSUuid.create((BOSObjectType)value.getBOSType())));
            try {
                IOdmBotpFacade iOdmBotpFacade = OdmBotpFacadeFactory.getLocalInstance(this.application.getContext());
                iOdmBotpFacade.odmBotp(value, personInfo, "fileCenter", false);
            }
            catch (BOSException e) {
                System.out.println("OdmFileCenterBillPlugin afterBotp is error:" + e.getMessage());
            }
            value.put("doccontentid", (Object)"");
        }
    }

    private void runSubmit(Context ctx) throws EASBizException, BOSException, DataAccessException {
        boolean isNew = this.isNew();
        if (isNew) {
            this.handleSaveAtNew();
        }
        if (this.beforeSubmit()) {
            this.submitToFlowInfo(ctx);
        }
    }

    private boolean isNew() throws BOSException, EASBizException {
        boolean isNew = false;
        IObjectValue objectValue = this.application.getBillValue();
        Object destBillIdPk = objectValue.get(objectValue.getPKField());
        String destBillId = null;
        if (destBillIdPk == null) {
            return true;
        }
        destBillId = destBillIdPk.toString();
        IBOSObject obj = BOSObjectFactory.createBOSObject((Context)this.application.getContext(), (BOSObjectType)BOSObjectType.create((String)this.application.getForm().getBosType()));
        ICoreBase iBillBase = (ICoreBase)obj;
        isNew = destBillId == null || !iBillBase.exists((IObjectPK)new ObjectUuidPK(destBillId));
        return isNew;
    }

    private void handleSaveAtNew() throws EASBizException, BOSException {
        IObjectValue objectValue = this.application.getBillValue();
        objectValue.put("CU", (Object)ContextUtil.getCurrentCtrlUnit((Context)this.application.getContext()));
        if (objectValue.get("creator") == null) {
            objectValue.put("creator", this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)"));
        }
        if (objectValue.get("createTime") == null) {
            objectValue.put("createTime", (Object)Calendar.getInstance().getTime());
        }
    }

    private boolean beforeSubmit() throws EASBizException, BOSException {
        BusinessInfo businessInfo = this.application.getBillModel().getBusinessInfo();
        BillEventsProxy BillEventsProxy2 = new BillEventsProxy();
        BillEventsProxy.ModelEventsProxy eventsProxy = BillEventsProxy2.getModelEventsProxy();
        boolean bSuccess = eventsProxy.fireBeforeSaveOrSubmitData();
        if (!bSuccess) {
            return false;
        }
        this.validateBeforeSubmit();
        this.application.getBillValue().put("lastUpdateUser", this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)"));
        this.application.getBillValue().put("lastUpdateTime", (Object)Calendar.getInstance().getTime());
        List saveActions = businessInfo.getForm().getSaveActions();
        FormActionUtil.invokeActions((IFormApplication)this.application, null, (List)saveActions, null, (int)0);
        return true;
    }

    private void validateBeforeSubmit() throws BOSException, EASBizException {
        IObjectValue objectValue = this.application.getBillValue();
        BusinessInfo businessInfo = this.application.getBillModel().getBusinessInfo();
        BillEventsProxy BillEventsProxy2 = new BillEventsProxy();
        BillEventsProxy.ModelEventsProxy eventsProxy = BillEventsProxy2.getModelEventsProxy();
        if (BusinessSeviceUtil.isExistsSameNumber((Context)this.application.getContext(), (IObjectValue)objectValue)) {
            throw new ActionCommonException(null, ResourceBase.getString((String)"com.kingdee.eas.cp.odm.OdmResource", (String)"isExistNo", (Locale)this.application.getContext().getLocale()) + objectValue.getString("number") + ResourceBase.getString((String)"com.kingdee.eas.cp.odm.OdmResource", (String)"abillName", (Locale)this.application.getContext().getLocale()));
        }
        PropertyCheckConfigItems checkItems = null;
        try {
            if (businessInfo.getCheckItems() != null) {
                checkItems = (PropertyCheckConfigItems)businessInfo.getCheckItems().clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new BOSException((Throwable)e);
        }
        eventsProxy.fireOnValidate(checkItems);
        BillBusinessUtil.validateAtSave((PropertyCheckConfigItems)checkItems, (String)businessInfo.getForm().getBosType(), (DynamicFormApplication)this.application, (IObjectValue)objectValue);
    }

    private void submitToFlowInfo(Context ctx) throws BOSException, EASBizException {
        Object commingDocNo;
        Object documentOrg;
        Object documentDate;
        DocumentInfoInfo documentInfo;
        String templateID = this.getTemplateIDFromFlowInfo(ctx, this.application.getBillModel().getPKValue());
        TemplateInfo templateInfo = this.getTemplateInfo(ctx, templateID);
        if (templateInfo == null) {
            return;
        }
        String pk = this.getFlowObjectPK(this.application.getBillModel().getPKValue());
        IDocumentInfo iDocument = DocumentInfoFactory.getLocalInstance((Context)ctx);
        if (pk == null || pk.length() == 0) {
            documentInfo = new DocumentInfoInfo();
            documentInfo.setCreator((UserInfo)this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)"));
            documentInfo.setCreateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
            documentInfo.setWorkflowStatus(WorkflowStatus.draft);
            documentInfo.setTemplateType(templateInfo.getTemplateType());
        } else {
            try {
                documentInfo = iDocument.getDocumentInfoInfo((IObjectPK)new ObjectUuidPK(pk));
            }
            catch (DataAccessException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
        String docNumber = (String)this.application.getBillModel().getValue(templateInfo.getBillNumberKey(), 0);
        Date requestTime = (Date)this.application.getBillModel().getValue(templateInfo.getProposerDateKey(), 0);
        PersonInfo properser = (PersonInfo)this.application.getBillModel().getValue(templateInfo.getProposerKey(), 0);
        documentInfo.setDocNumber(docNumber);
        documentInfo.setRequestTime(requestTime);
        documentInfo.setFormID(templateInfo.getFormID());
        documentInfo.setLayoutID(templateInfo.getLayoutID());
        documentInfo.setTitle((String)this.application.getBillModel().getValue(templateInfo.getTitleKey(), 0));
        if (!StringUtils.isEmpty((String)templateInfo.getUrgencyLevelKey())) {
            documentInfo.setUrgencyLevel(String.valueOf(this.application.getBillModel().getValue(templateInfo.getUrgencyLevelKey(), 0)));
        }
        if (!StringUtils.isEmpty((String)templateInfo.getSecretLevelKey())) {
            documentInfo.setSecretLevel(String.valueOf(this.application.getBillModel().getValue(templateInfo.getSecretLevelKey(), 0)));
        }
        if (!StringUtils.isEmpty((String)templateInfo.getDocumentDateKey()) && (documentDate = this.application.getBillModel().getValue(templateInfo.getDocumentDateKey(), 0)) != null) {
            documentInfo.setDocumentDate((Date)documentDate);
        }
        if (!StringUtils.isEmpty((String)templateInfo.getDocumentOrgKey()) && (documentOrg = this.application.getBillModel().getValue(templateInfo.getDocumentOrgKey(), 0)) != null) {
            if (documentOrg instanceof AdminOrgUnitInfo) {
                documentInfo.setDocumentOrg((AdminOrgUnitInfo)documentOrg);
                documentInfo.setDocumentOrgName(((AdminOrgUnitInfo)documentOrg).getName());
            } else {
                documentInfo.setDocumentOrgName((String)documentOrg);
            }
        }
        if (!StringUtils.isEmpty((String)templateInfo.getCommingDocNoKey()) && (commingDocNo = this.application.getBillModel().getValue(templateInfo.getCommingDocNoKey(), 0)) != null) {
            documentInfo.setCommingDocNo((String)commingDocNo);
        }
        documentInfo.setSourcePK(this.application.getBillModel().getPKValue());
        documentInfo.setTemplateId(templateInfo.getId().toString());
        documentInfo.setProposer(properser);
        documentInfo.setFlowID("");
        documentInfo.setWorkflowStatus(WorkflowStatus.pass);
        documentInfo.setApprovedTime(new Timestamp(new Date().getTime()));
        if (pk == null || pk.length() == 0) {
            iDocument.addnew((CoreBaseInfo)documentInfo);
        } else {
            iDocument.update((IObjectPK)new ObjectUuidPK(pk), (CoreBaseInfo)documentInfo);
        }
    }

    private String getFlowObjectPK(String sourcePK) throws DataAccessException {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("sourcePK", (Object)sourcePK);
        IObjectPK[] pks = DAOHelper.getDAO().getPKList(this.application.getContext(), BOSObjectType.create((String)FLOWINFO_BOSTYPE), filter, null);
        if (pks.length > 0) {
            return pks[0].getKeyValue("id").toString();
        }
        return "";
    }

    private TemplateInfo getTemplateInfo(Context ctx, String templateId) {
        ITemplate templateService = null;
        TemplateInfo templateInfo = null;
        try {
            templateService = TemplateFactory.getLocalInstance((Context)ctx);
            templateInfo = templateService.getTemplateInfo((IObjectPK)new ObjectUuidPK(templateId));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return templateInfo;
    }

    private String getTemplateIDFromFlowInfo(Context ctx, String sourcePK) {
        String tempateId = "";
        if (sourcePK == null) {
            return tempateId;
        }
        String oql = "select templateId where sourcePK='" + sourcePK + "'";
        try {
            DocumentInfoCollection col = DocumentInfoFactory.getLocalInstance((Context)ctx).getDocumentInfoCollection(oql);
            if (col != null && col.size() > 0) {
                DocumentInfoInfo doc = col.get(0);
                tempateId = doc.getTemplateId();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return tempateId;
    }
}

