/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.odm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.BillPassRecordEntryInfo;
import com.kingdee.eas.cp.base.BillPassRecordFactory;
import com.kingdee.eas.cp.base.BillPassRecordInfo;
import com.kingdee.eas.cp.base.BillPassRecordStatus;
import com.kingdee.eas.cp.base.IBillPassRecord;
import com.kingdee.eas.cp.base.util.MessageTools;
import com.kingdee.eas.cp.odm.ISelectBillPassPerson;
import com.kingdee.eas.cp.odm.SelectBillPassPersonCollection;
import com.kingdee.eas.cp.odm.SelectBillPassPersonFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class SelectBillPassPersonUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.odm.util.SelectBillPassPersonUtil");

    public boolean passAssignment(Context ctx, String destBillId, String sendNote, Boolean sendMessage, Boolean sendMail) throws BOSException {
        SelectBillPassPersonCollection billPassCollection = this.getSelectBillPassPersonCollection(ctx, destBillId);
        if (null != billPassCollection && billPassCollection.size() > 0) {
            String senderName = this.getCurrentPersonName(ctx);
            HashSet<String> selectBillPassRecordIdSet = new HashSet<String>();
            for (int i = 0; i < billPassCollection.size(); ++i) {
                UserCollection uc;
                if (null == billPassCollection.get(i) || null == billPassCollection.get(i).getId()) continue;
                String fparentId = billPassCollection.get(i).getId().toString();
                selectBillPassRecordIdSet.add(fparentId);
                Set personSet = this.getPersonSet(ctx, fparentId);
                if (null == personSet || personSet.size() <= 0 || null == (uc = this.getUserCollection(ctx, personSet)) || uc.size() <= 0) continue;
                String[] userIds = new String[uc.size()];
                for (int j = 0; j < userIds.length; ++j) {
                    userIds[j] = uc.get(j).getId().toString();
                }
                BillPassRecordInfo billPassRecordInfo = new BillPassRecordInfo();
                billPassRecordInfo.setBillID(destBillId);
                billPassRecordInfo.setBillPassTime(billPassCollection.get(i).getSubmitTime());
                billPassRecordInfo.setSender(billPassCollection.get(i).getUser());
                billPassRecordInfo.setModulePackge("com.kingdee.eas.cp.odm.app");
                billPassRecordInfo.setSourceBillId(destBillId);
                billPassRecordInfo.setFormID(billPassCollection.get(i).getFormId());
                billPassRecordInfo.setEditUrl("");
                billPassRecordInfo.setBillPassRecordOption(sendNote);
                BillPassRecordEntryInfo billPassRecordEntry = null;
                for (int k = 0; k < uc.size(); ++k) {
                    billPassRecordEntry = new BillPassRecordEntryInfo();
                    billPassRecordEntry.setUser(uc.get(k));
                    billPassRecordEntry.setReceiveTime(new Timestamp(System.currentTimeMillis()));
                    billPassRecordEntry.setStatus(BillPassRecordStatus.UNREADED);
                    billPassRecordInfo.getEntrys().add(billPassRecordEntry);
                }
                IBillPassRecord billPassRecordService = BillPassRecordFactory.getLocalInstance((Context)ctx);
                try {
                    billPassRecordService.save((CoreBaseInfo)billPassRecordInfo);
                }
                catch (EASBizException e) {
                    logger.error((Object)("billPassRecordService.save(billPassRecordInfo) is failed,exception is " + e.getMessage()));
                    e.printStackTrace();
                    return false;
                }
                String title = this.getBillPassTitle(ctx, destBillId);
                if (null != title || "".equals(title)) {
                    title = sendNote;
                }
                logger.info((Object)("WFBillBaseControllerBean::_passAssignment()----MessageTools.sendMessage  messageTitle = \u534f\u540c\u4f20\u9605:[" + title + "]"));
                try {
                    MessageTools.sendMessage((Context)ctx, (String[])userIds, (String)("\u534f\u540c\u4f20\u9605:[" + title + "]"), (String)senderName, (String)sendNote, (BillPassRecordInfo)billPassRecordInfo, (String)"block");
                }
                catch (EASBizException e) {
                    logger.error((Object)("MessageTools.sendMessage is failed,exception is " + e.getMessage()));
                    e.printStackTrace();
                }
                String callerName = null;
                try {
                    callerName = UserFactory.getRemoteInstance().getUserInfo("where id='" + ctx.getCaller().toString() + "'").getName(ctx.getLocale());
                }
                catch (Exception ex) {
                    logger.warn((Object)("get username by id[" + ctx.getCaller().toString() + "] error:" + ex.getMessage()));
                    callerName = "";
                }
                String sendSMSOrMailResult = "";
                if (sendMessage.booleanValue()) {
                    boolean sendSMSResult = MessageTools.sendSMSCpBase((Context)ctx, (Set)personSet, (String)("\u6536\u5230\u6765\u81ea" + callerName + "\u7684\u534f\u540c\u4f20\u9605\u4fe1\u606f \uff0c\u4f20\u9605\u610f\u89c1\uff1a" + sendNote));
                    if (!sendSMSResult) {
                        sendSMSOrMailResult = "\u4f46\u77ed\u4fe1\u901a\u77e5\u4e0d\u6210\u529f.";
                    }
                    logger.info((Object)("WFBillBaseControllerBean::_passAssignment()----MessageTools.sendSMSCpBase  sendSMSResult = " + sendSMSResult + ",sendSMSOrMailResult = " + sendSMSOrMailResult));
                }
                if (!sendMail.booleanValue()) continue;
                boolean sendMailResult = MessageTools.sendMailCpBase((Context)ctx, (Set)personSet, (String)("\u6536\u5230\u6765\u81ea" + callerName + "\u7684\u534f\u540c\u4f20\u9605\u4fe1\u606f"), (String)("\u4f20\u9605\u610f\u89c1\uff1a" + sendNote));
                if (!sendMailResult) {
                    sendSMSOrMailResult = "".equals(sendSMSOrMailResult) ? "\u4f46\u90ae\u4ef6\u901a\u77e5\u4e0d\u6210\u529f." : "\u4f46\u77ed\u4fe1\u901a\u77e5\u548c\u90ae\u4ef6\u901a\u77e5\u90fd\u4e0d\u6210\u529f.";
                }
                logger.info((Object)("WFBillBaseControllerBean::_passAssignment()---MessageTools.sendMailCpBase  sendMailResult = " + sendMailResult + ",sendSMSOrMailResult = " + sendSMSOrMailResult));
            }
            boolean result = this.setSelectBillPassPersonIsSent(ctx, selectBillPassRecordIdSet);
            logger.info((Object)("WFBillBaseControllerBean::_passAssignment()----setSelectBillPassPersonIsSent's result = " + result));
        }
        return true;
    }

    private String getBillPassTitle(Context ctx, String destBillId) {
        if (null == destBillId || "".equals(destBillId)) {
            logger.info((Object)"WFBillBaseControllerBean::getReceiverPersonIdSet()--------the destBillId is null ! ");
            return "";
        }
        String title = "";
        String getTitleSql = "select ftitle  from t_bas_documentinfo where fsourcepk='" + destBillId + "'";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)getTitleSql);
            logger.info((Object)("WFBillBaseControllerBean::getBillPassTitle() -----DbUtil.executeQuery ,getTitleSql = " + getTitleSql));
            logger.info((Object)("WFBillBaseControllerBean::getBillPassTitle() -----DbUtil.executeQuery ,IRowSet size= " + rs.size()));
            if (rs != null && rs.size() > 0 && rs.next()) {
                title = rs.getString("ftitle");
                logger.info((Object)("WFBillBaseControllerBean::getBillPassTitle() -----DbUtil.executeQuery ,from rs get title =  " + title));
            }
        }
        catch (BOSException e1) {
            logger.error((Object)("WFBillBaseControllerBean::getBillPassTitle() -----DbUtil.executeQuery has error,message = " + e1.getMessage()));
        }
        catch (SQLException e2) {
            logger.error((Object)("WFBillBaseControllerBean::getBillPassTitle() -----get Title from db IRowSet has error,message = " + e2.getMessage()));
        }
        return title;
    }

    public String getStrFromSet(Set set) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int i = 0;
        int len = set.size();
        for (Object key : set) {
            sb.append("'").append((String)key).append("'");
            if (i < len - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private boolean setSelectBillPassPersonIsSent(Context ctx, Set selectBillPassRecordIdSet) {
        boolean result = false;
        if (null == selectBillPassRecordIdSet || selectBillPassRecordIdSet.size() == 0) {
            logger.info((Object)"setSelectBillPassPersonIsSent--------the fid is null ! ");
            return false;
        }
        String updateSql = "Update T_Odm_Selectbillpassperson Set Fissent=1 where fid in " + this.getStrFromSet(selectBillPassRecordIdSet);
        try {
            logger.info((Object)("setSelectBillPassPersonIsSent--------the sql = " + updateSql));
            DbUtil.execute((Context)ctx, (String)updateSql);
            result = true;
        }
        catch (BOSException e) {
            logger.error((Object)("setSelectBillPassPersonIsSent is failed! exception = " + e.getMessage()));
            e.printStackTrace();
        }
        return result;
    }

    private UserCollection getUserCollection(Context ctx, Set personSet) throws BOSException {
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        FilterInfo filterUser = new FilterInfo();
        filterUser.getFilterItems().add(new FilterItemInfo("person.id", (Object)personSet, CompareType.INCLUDE));
        EntityViewInfo eviUser = new EntityViewInfo();
        eviUser.setFilter(filterUser);
        eviUser.getSelector().add(new SelectorItemInfo("id"));
        eviUser.getSelector().add(new SelectorItemInfo("name"));
        UserCollection uc = iuser.getUserCollection(eviUser);
        return uc;
    }

    private Set getPersonSet(Context ctx, String fparentId) {
        HashSet<String> personSet = new HashSet<String>();
        String sql = "select fpersonid from T_ODM_SelectBPPersonEntry where fparentid='" + fparentId + "'";
        logger.info((Object)("Get the fpersonid by billID from T_ODM_SelectBPPersonEntry,the  sql is  " + sql));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            logger.info((Object)("Get the fpersonid by fparentid from T_ODM_SelectBPPersonEntry the size  is  " + rs.size()));
            String personId = "";
            while (rs.next()) {
                personId = rs.getString("fpersonid");
                personSet.add(personId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"WFBillBaseControllerBean::_passAssignment()----getReceivers is failed!");
        }
        return personSet;
    }

    private SelectBillPassPersonCollection getSelectBillPassPersonCollection(Context ctx, String destBillId) throws BOSException {
        ISelectBillPassPerson iSelectBillPassPerson = SelectBillPassPersonFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)destBillId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSent", (Object)Boolean.FALSE, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("billId"));
        evi.getSelector().add(new SelectorItemInfo("submitTime"));
        evi.getSelector().add(new SelectorItemInfo("person"));
        evi.getSelector().add(new SelectorItemInfo("user"));
        evi.getSelector().add(new SelectorItemInfo("formId"));
        SelectBillPassPersonCollection billPassCollection = iSelectBillPassPerson.getSelectBillPassPersonCollection(evi);
        return billPassCollection;
    }

    private String getCurrentPersonName(Context ctx) {
        String senderName = ContextUtil.getCurrentUserInfo((Context)ctx).getName();
        if (null != ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId()) {
            String sql = "select fname_l2 from T_bd_person where fid='" + ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString() + "'";
            logger.info((Object)("Get the fname_l2 by fid from T_bd_person,the  sql is  " + sql));
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                logger.info((Object)("Get the fname_l2 by fid from T_bd_person the size  is  " + rs.size()));
                if (rs.next()) {
                    senderName = rs.getString("fname_l2");
                }
            }
            catch (Exception e) {
                logger.error((Object)"WFBillBaseControllerBean::getCurrentPersonName()----getCurrentPersonName is failed!");
            }
        }
        return senderName;
    }
}

