/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.odm.xt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoCollection;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoFactory;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoInfo;
import com.kingdee.eas.base.form.extend.flow.IDocumentInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.xt.AttchmentUtil;
import com.kingdee.eas.cp.base.xt.XTUtil;
import com.kingdee.eas.cp.odm.IReleasePortlet;
import com.kingdee.eas.cp.odm.ReleasePortletCollection;
import com.kingdee.eas.cp.odm.ReleasePortletFactory;
import com.kingdee.eas.cp.odm.ReleasePortletInfo;
import com.kingdee.eas.cp.odm.xt.OdmXtContentUtil;
import com.kingdee.eas.cp.odm.xt.OdmXtUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.ThumbnailSizeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.util.FileUtil;
import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.util.image.ImageUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.UuidException;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OdmXtAdapter
implements IMessageAdapter {
    private static final String SHORT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String LONG_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String PACKAGE_FILE_NAME = "package.zip";
    private static final String INDEX_FILE_NAME = "index.html";
    private static final String MHT_FILE_NAME = "cmContent.html";
    private static final String ODM_FILE_NAME = "title_pic_dispatch.jpg";
    private static final String RESOURCE_CONTENTMANAGE = "com.kingdee.eas.cp.eip.cm.ContentManage";
    private static Logger logger = Logger.getLogger((String)OdmXtAdapter.class.getName());
    public Context ctx = null;
    private String billId = null;
    private ReleasePortletInfo releasePortletInfo = null;
    private DocumentInfoInfo documentInfoInfo;
    private byte[] zip_byte = null;

    public OdmXtAdapter(Context ctx, String billId) throws IllegalArgumentException, NullPointerException {
        this.initAdapter(ctx, billId);
    }

    private void initAdapter(Context ctx, String billId) throws IllegalArgumentException, NullPointerException {
        this.billId = billId;
        this.ctx = ctx;
        this.readReleasePortletInfo();
        this.readDocumentInfo();
    }

    private void readReleasePortletInfo() {
        if (this.hasInitialized() && this.billId != null) {
            try {
                IReleasePortlet iReleasePortlet = ReleasePortletFactory.getLocalInstance(this.ctx);
                String oql = "select id,creator.name,createTime,publishToXTtop,publishToDesktop,isPushAllPerson where billId='" + this.billId + "'";
                ReleasePortletCollection coll = iReleasePortlet.getReleasePortletCollection(oql);
                this.releasePortletInfo = coll != null && coll.size() > 0 ? coll.get(0) : new ReleasePortletInfo();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private void readDocumentInfo() {
        if (this.hasInitialized() && this.billId != null) {
            try {
                IDocumentInfo iDocumentInfo = DocumentInfoFactory.getLocalInstance((Context)this.ctx);
                DocumentInfoCollection coll = iDocumentInfo.getDocumentInfoCollection(" where SourcePK='" + this.billId + "'");
                if (coll != null && coll.size() > 0) {
                    this.documentInfoInfo = coll.get(0);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private File getUIDFolder() {
        File uidFolder = XTUtil.getUIDFolder((Context)this.ctx, (String)"XTOdm", (String)this.billId, (String)"odm");
        return uidFolder;
    }

    public File getContentFolder() {
        File contentFolder = FileUtil.createFolder((String)(this.getUIDFolder().getPath() + File.separator + "content"));
        return contentFolder;
    }

    public byte[] getFullPackage() {
        byte[] packageFile = null;
        try {
            File uidFolder = this.getUIDFolder();
            File contentFolder = this.getContentFolder();
            this.createHtmlFile(contentFolder, false);
            packageFile = FileUtil.readFile((File)FileUtil.compress((String)contentFolder.getPath(), (String)(uidFolder.getPath() + File.separator + PACKAGE_FILE_NAME)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return packageFile;
    }

    private boolean createHtmlFile(File contentFolder, boolean isNotAuto) {
        try {
            String html = OdmXtContentUtil.getCMContentHTML(this, contentFolder, isNotAuto);
            FileUtil.createFile((String)(contentFolder.getPath() + File.separator + INDEX_FILE_NAME));
            FileUtil.writeFile((String)(contentFolder.getPath() + File.separator + INDEX_FILE_NAME), (byte[])html.getBytes("UTF-8"));
            FileUtil.safeCopyFile((String)(XTUtil.getStyleFileSrcPath() + File.separator + "xt_news_tinyScreen.css"), (String)(contentFolder.getPath() + File.separator + "xt_news_tinyScreen.css"));
            try {
                FileUtil.safeCopyFile((String)(XTUtil.getJsFileSrcPath() + File.separator + "jquery-1.5.min.js"), (String)(contentFolder.getPath() + File.separator + "jquery-1.5.min.js"));
            }
            catch (IOException e1) {
                logger.info((Object)("getJsFileSrcPath error: " + e1.getMessage()));
            }
            try {
                FileUtil.safeCopyFile((String)(XTUtil.getAttListJsFileSrcPath() + File.separator + "attlist.js"), (String)(contentFolder.getPath() + File.separator + "attlist.js"));
            }
            catch (IOException e1) {
                logger.info((Object)("getAttListJsFileSrcPath error: " + e1.getMessage()));
            }
            try {
                String sourceURL = XTUtil.getImgFileSrcPath();
                String toUrl = contentFolder.getPath() + File.separator + "images";
                FileUtil.createFolder((String)toUrl);
                FileUtil.safeCopyFile((String)(sourceURL + File.separator + "file_type.png"), (String)(toUrl + File.separator + "file_type.png"));
                FileUtil.safeCopyFile((String)(sourceURL + File.separator + "icon.png"), (String)(toUrl + File.separator + "icon.png"));
            }
            catch (IOException e1) {
                logger.info((Object)("getImgFileSrcPath error: " + e1.getMessage()));
            }
            FileUtil.deleteFile((String)(contentFolder + File.separator + MHT_FILE_NAME));
            return true;
        }
        catch (IOException e) {
            logger.info((Object)("createHtmlFile error: " + e.getMessage()));
            return false;
        }
    }

    public String getOdmContent() {
        String newsContent = "";
        if (this.hasInitialized()) {
            newsContent = OdmXtContentUtil.getMHTContent(this);
        }
        return newsContent;
    }

    public String getTitle() {
        String newsTitle = this.documentInfoInfo.getTitle();
        return newsTitle;
    }

    public Date getUpdateTime() {
        Date date = new Date();
        try {
            date = this.releasePortletInfo.getCreateTime();
        }
        catch (Exception e) {
            logger.debug((Object)("getUpdateTime error:" + e.getMessage()));
        }
        return date;
    }

    public String getCreator() {
        String newsCreateor = "";
        if (this.hasInitialized() && this.releasePortletInfo != null && this.releasePortletInfo.getCreator() != null) {
            newsCreateor = this.releasePortletInfo.getCreator().getName();
        }
        return newsCreateor;
    }

    public String getBillId() {
        return this.billId;
    }

    public Context getContext() {
        return this.ctx;
    }

    public static Context createContext(String user, String ais, String solution) {
        Context ctx = new Context();
        ctx.setUserName(StringUtil.decoder((String)user));
        ctx.setAIS(StringUtil.decoder((String)ais));
        ctx.setSolution(StringUtil.decoder((String)solution));
        return ctx;
    }

    private boolean hasInitialized() {
        System.out.println("hasInitialized(): billId=" + this.billId);
        if (this.billId == null || this.ctx == null) {
            System.out.println("hasInitialized() return false");
            return false;
        }
        System.out.println("hasInitialized() return true");
        return true;
    }

    public String getSummary() {
        String newsSummary = "";
        return newsSummary;
    }

    private String getMsgCallbackURL() {
        String url = "";
        logger.debug((Object)("call back URL:" + url));
        return url;
    }

    public void clearTemporary() {
        File uidFolder = this.getUIDFolder();
        FileUtil.deleteFile((File)uidFolder);
    }

    public Map<String, Object> getContent() {
        HashMap<String, Object> message = null;
        try {
            message = new HashMap<String, Object>();
            String url = this.getHttpUrlPort();
            if ("true".equals(this.isMoreServer())) {
                String appId = this.getAppId();
                url = url + "/plt_cp/cp/base/openIndex.jsp?type=odm&billId=" + this.billId + "&appId=" + appId;
            } else {
                String postId = this.billId;
                if (postId != null) {
                    postId = postId.replaceAll("=", "93D");
                    postId = postId.replaceAll("/", "92F");
                    postId = postId.replaceAll("\\+", "92B");
                }
                url = url + "/plt_cp/xt/odm/" + postId + "/content/index.html";
            }
            if (this.getType() == MessageTypeEnum.LINK) {
                this.createFile(false);
                message.put("text", ResourceBase.getString((String)RESOURCE_CONTENTMANAGE, (String)"dispatch", (Locale)new Locale("l2")) + this.getTitle());
                message.put("url", url);
            } else {
                message.put("date", new SimpleDateFormat(SHORT_DATE_FORMAT).format(this.getUpdateTime()));
                message.put("title", ResourceBase.getString((String)RESOURCE_CONTENTMANAGE, (String)"dispatch", (Locale)new Locale("l2")) + this.getTitle());
                message.put("text", this.getSummary());
                File contentFolder = this.getContentFolder();
                this.createHtmlFile(contentFolder, false);
                message.put("zip", "");
                message.put("url", url);
                if (this.getModel() == MessageModelEnum.SINGLEGRAPHIC) {
                    message.put("name", ODM_FILE_NAME);
                    message.put("pic", StringUtil.getBase64FromByte((byte[])this.getPictureData()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("content build error:" + e.getMessage()));
        }
        return message;
    }

    public boolean createFile(boolean isNotAuto) {
        File contentFolder = this.getContentFolder();
        return this.createHtmlFile(contentFolder, isNotAuto);
    }

    public MessageModelEnum getModel() {
        return MessageModelEnum.SINGLETEXT;
    }

    public MessageTypeEnum getType() {
        return MessageTypeEnum.LINK;
    }

    public byte[] getPictureData() {
        byte[] newsPicture = null;
        StringBuffer odm_title_pic_path = new StringBuffer(System.getProperty("EAS_HOME"));
        odm_title_pic_path.append(File.separator);
        odm_title_pic_path.append("server");
        odm_title_pic_path.append(File.separator);
        odm_title_pic_path.append("deploy");
        odm_title_pic_path.append(File.separator);
        odm_title_pic_path.append("portal.ear");
        odm_title_pic_path.append(File.separator);
        odm_title_pic_path.append("plt_cp.war");
        odm_title_pic_path.append(File.separator);
        odm_title_pic_path.append("res");
        odm_title_pic_path.append(File.separator);
        odm_title_pic_path.append("img");
        odm_title_pic_path.append(File.separator);
        odm_title_pic_path.append(ODM_FILE_NAME);
        String path = odm_title_pic_path.toString().replace("/", File.separator);
        newsPicture = ImageUtil.readImage((String)path);
        if (newsPicture != null) {
            newsPicture = ImageUtil.scaleByWidth((byte[])newsPicture, (int)ThumbnailSizeEnum.BIG_WIDTH.value(), (String)"jpg");
        }
        return newsPicture;
    }

    public List<String> getUsers() {
        ArrayList<String> userIDs = null;
        if (this.hasInitialized()) {
            Set<String> personIds = OdmXtUtil.getPersons(this.ctx, this.billId, this.releasePortletInfo.isIsPushAllPerson());
            userIDs = new ArrayList<String>();
            for (String personId : personIds) {
                userIDs.add(personId);
            }
        }
        return userIDs;
    }

    public boolean isNeedSendXT() {
        if (this.releasePortletInfo != null && this.releasePortletInfo.isPublishToXTtop()) {
            return true;
        }
        if (this.releasePortletInfo != null && this.releasePortletInfo.isPublishToDesktop()) {
            File contentFolder = this.getContentFolder();
            this.createHtmlFile(contentFolder, false);
        }
        return false;
    }

    public void saveIsConverContentInfo(boolean isconver) {
        if (this.hasInitialized() && this.releasePortletInfo.getId() != null) {
            try {
                IReleasePortlet iReleasePortlet = ReleasePortletFactory.getLocalInstance(this.ctx);
                ReleasePortletInfo tempInfo = iReleasePortlet.getReleasePortletInfo(" where id='" + this.releasePortletInfo.getId().toString() + "'");
                tempInfo.setIsConvert(isconver);
                iReleasePortlet.save((CoreBaseInfo)tempInfo);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public List getAttchmentList() {
        List list = AttchmentUtil.getAttchmentList((Context)this.ctx, (String)this.billId);
        return list;
    }

    public String getHttpUrlPort() {
        XTServiceConfig xTServiceConfig = XTServiceConfig.getInstance();
        String httpUrlPort = "";
        try {
            httpUrlPort = xTServiceConfig.getPubAcctProperty(xTServiceConfig.getEidByDbCode(this.ctx.getAIS()), "XTOdm", "http.url.port", "");
        }
        catch (Exception e) {
            logger.error((Object)("getHttpUrlPort error:" + e.getMessage()));
        }
        return httpUrlPort;
    }

    public String getAppId() {
        XTServiceConfig xTServiceConfig = XTServiceConfig.getInstance();
        String appId = xTServiceConfig.getPubAcctProperty(xTServiceConfig.getEidByDbCode(this.ctx.getAIS()), "XTOdm", "appId", "");
        return appId;
    }

    public String getXtEid() {
        String eid = XTServiceConfig.getInstance().getEidByDbCode(this.ctx.getAIS());
        return eid;
    }

    private String isMoreServer() {
        String isMore = "false";
        try {
            XTServiceConfig xTServiceConfig = XTServiceConfig.getInstance();
            isMore = xTServiceConfig.getPubAcctProperty(xTServiceConfig.getEidByDbCode(this.ctx.getAIS()), "XTOdm", "moreServer", "");
        }
        catch (Exception e) {
            e.getMessage();
        }
        return isMore;
    }

    public String isViewContent() {
        String isView = "false";
        try {
            XTServiceConfig xTServiceConfig = XTServiceConfig.getInstance();
            isView = xTServiceConfig.getPubAcctProperty(xTServiceConfig.getEidByDbCode(this.ctx.getAIS()), "XTOdm", "viewContent", "");
        }
        catch (Exception e) {
            e.getMessage();
        }
        return isView;
    }

    public String getContentSize() {
        String strSize = "";
        String docId = this.billId;
        if (!StringUtils.isEmpty((String)docId) && !"null".equalsIgnoreCase(docId)) {
            docId = docId.replaceAll("%2B", "+");
            String sql = "SELECT FSize FROM T_BAS_BillAttachment WHERE FControlKey='FOFFICE' AND FBillId='" + docId + "'";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                if (rowSet.next()) {
                    strSize = rowSet.getString("FSize");
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (UuidException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return strSize;
    }
}

