/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.odm.xt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.cp.base.xt.AttchmentDTO;
import com.kingdee.eas.cp.base.xt.HTMLUtil;
import com.kingdee.eas.cp.base.xt.MHTUtil;
import com.kingdee.eas.cp.base.xt.XtImageUtil;
import com.kingdee.eas.cp.odm.xt.OdmXtAdapter;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.util.FileUtil;
import com.kingdee.util.UuidException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class OdmXtContentUtil {
    private static final String MIDDLE_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String MHT_FILE_NAME = "cmContent.html";
    private static final String IMAGE_FOLDER_NAME = "images";

    private OdmXtContentUtil() {
    }

    public static String getCMContentHTML(OdmXtAdapter adapter, File contentFolder, boolean isNotAuto) {
        StringBuffer html = new StringBuffer();
        html.append("<html>");
        html.append(OdmXtContentUtil.buildHTMLHead());
        html.append(OdmXtContentUtil.buildHTMLBody(adapter, contentFolder, isNotAuto));
        html.append("</html>");
        return html.toString();
    }

    public static String getMHTContent(OdmXtAdapter adapter) {
        String newsContent = "";
        String billId = adapter.getBillId();
        if (!StringUtils.isEmpty((String)billId) && !"null".equalsIgnoreCase(billId)) {
            billId = billId.replaceAll("%2B", "+");
            Object[] params = new Object[]{billId};
            String sql = "select FContent from T_CP_WordMht WHERE FID = ?";
            System.out.println("getMHTContent sql=" + sql + " billId=" + billId);
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)adapter.getContext(), (String)sql, (Object[])params);
                Blob blob = null;
                byte[] data = null;
                if (rowSet.next()) {
                    blob = rowSet.getBlob(1);
                    data = blob.getBytes(1L, Integer.valueOf(String.valueOf(blob.length())));
                    System.out.println("begin getContentFolder......");
                    File contentFolder = adapter.getContentFolder();
                    System.out.println("end getContentFolder......");
                    MHTUtil.getHtmlFileFromMhtData((byte[])data, (String)(contentFolder + File.separator + MHT_FILE_NAME), (MHTUtil.ResourceSaveModeEnum)MHTUtil.ResourceSaveModeEnum.SaveImageToFile);
                    newsContent = new String(FileUtil.readFile((String)(contentFolder + File.separator + MHT_FILE_NAME)), "gb2312");
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (UuidException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return newsContent;
    }

    public static String getOdmContentHTML(OdmXtAdapter adapter, File contentFolder, boolean isNotAuto) {
        StringBuffer html = new StringBuffer();
        html.append("<html>");
        html.append(OdmXtContentUtil.buildHTMLHead());
        html.append(OdmXtContentUtil.buildHTMLBody(adapter, contentFolder, isNotAuto));
        html.append("</html>");
        return html.toString();
    }

    private static String buildHTMLHead() {
        StringBuffer head = new StringBuffer();
        head.append("<head>\n");
        head.append("<title>\u53d1\u6587\u6b63\u6587</title>\n");
        head.append("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\">\n");
        head.append("<meta name=\"viewport\" content=\"width=device-width, minimum-scale=1.0, maximum-scale=1.0\">\n");
        head.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"./xt_news_tinyScreen.css\">\n");
        head.append("</head>\n");
        return head.toString();
    }

    private static String buildHTMLBody(OdmXtAdapter adapter, File contentFolder, boolean isNotAuto) {
        String html = "";
        boolean isHasAtt = false;
        String url = "";
        String appid = adapter.getAppId();
        List list = adapter.getAttchmentList();
        if (list != null && list.size() > 0) {
            isHasAtt = true;
        }
        StringBuffer body = new StringBuffer();
        boolean isViewContent = "true".equals(adapter.isViewContent());
        if (isHasAtt || isViewContent) {
            url = adapter.getHttpUrlPort();
        }
        if (isViewContent && !isHasAtt) {
            body.append("<body onload=\"_getDocContent('" + adapter.getBillId() + "');\">\n");
        } else {
            body.append("<body>\n");
        }
        body.append("<div class=\"content\">\n");
        System.out.println("begin getOdmContent.......");
        if (isViewContent) {
            if (isHasAtt) {
                body.append("<div class=\"open-name\">\n");
                body.append("<a class=\"open-file\" href=\"#\" onclick=\"_getDocContent('" + adapter.getBillId() + "');\">\u67e5\u770b\u6b63\u6587</a> \n");
                body.append("</div>\n");
            }
        } else {
            String content = adapter.getOdmContent();
            System.out.println("end getOdmContent.......");
            body.append(content);
        }
        body.append("</div>\n");
        if (isHasAtt) {
            if (!isViewContent) {
                body.append("<div class=\"tool-box\">\n");
                body.append("<a href=\"#\" class=\"btns-l hide\" ><span class=\"fx-icon\"></span>\u5206\u4eab</a>\n");
                body.append("<a href=\"#\" class=\"btns-r  hide\"><span class=\"on-icon\"></span>\u6536\u85cf</a>\n");
                body.append("<a href=\"#\" class=\"btns clear\" style=\"color:#333;text-decoration:none;\" ><span class=\"fj-icon\"></span>\u9644\u4ef6</a>\n");
                body.append("</div>\n");
            }
            if (isViewContent) {
                body.append("<div class=\"know-list\" style=\"display:block;left:0; top:25em;width:100%;\">\n");
            } else {
                body.append("<div class=\"know-list\" style=\"width:100%;\">\n");
            }
            body.append(" <ul>\n");
            if (isViewContent) {
                body.append(" \t<li style=\"font-size:2em;\">\u9644\u4ef6</li>\n");
            }
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                AttchmentDTO dto = (AttchmentDTO)list.get(i);
                body.append("\t<li onclick=\"_myDownload('" + dto.getId() + "');\">\n");
                body.append("\t\t<div class=\"" + dto.getExtCss() + "\"><span class=\"fileImg\"></span></div>\n");
                body.append("\t\t<div class=\"text-cont\">\n");
                body.append("\t\t\t<div class=\"cont-l\">\n");
                body.append("\t\t\t\t<p class=\"title\">" + dto.getName() + "." + dto.getSimplename() + "</p>\n");
                body.append("\t\t\t\t<p class=\"page\">" + dto.getSize() + "</p>\n");
                body.append("\t\t\t</div>\n");
                body.append("\t\t</div>\n");
                body.append("\t</li>\n");
            }
            if (!isViewContent) {
                body.append(" \t<li><a href=\"javascript:;\" class=\"close-btn\" style=\"color:#0062d2;text-decoration:none;\" >\u8fd4\u56de</a></li>\n");
            }
            body.append(" </ul>\n");
            body.append("</div>\n");
        }
        body.append("<script type=\"text/javascript\" src=\"./jquery-1.5.min.js\"></script>\n");
        body.append("<script src=\"https://do.yunzhijia.com/pub/js/qingjs.js\"></script>\n");
        body.append("<script type=\"text/javascript\">\n");
        body.append("var _openId='';var _eid='';\n");
        body.append("XuntongJSBridge.call('hideOptionMenu');\n");
        body.append("XuntongJSBridge.call('getPersonInfo',{},\n");
        body.append("\t\t\tfunction(result){\n");
        body.append("\t\t\t\tif(result.data != null){\n");
        body.append("\t\t\t\t\t_openId = result.data.openId;\n");
        body.append("\t\t\t\t\t_eid = result.data.eid;\n");
        body.append("\t\t\t\t\tif(_eid != null && _eid !='' && _openId != null && _openId !=''){\n");
        body.append("\t\t\t\t\t\tvar _url ='http://web20.kingdee.com/webstat/push?eid='+_eid+'&uid='+_openId+'&app=cpnews&action=\u67e5\u770b\u516c\u6587';\n");
        body.append("\t\t\t\t\t\t$.ajax({url:_url,type:'POST'});\n");
        body.append("\t\t\t\t\t}\n");
        body.append("\t\t\t \t}\n");
        body.append("\t\t\t }\n");
        body.append(");\n");
        if (isHasAtt) {
            body.append("function _myDownload(id){\n");
            body.append("\tmyDownload(id,_eid,_openId,'" + appid + "','" + url + "');\n");
            body.append("}\n");
        }
        if (isViewContent) {
            body.append("function _getDocContent(id){\n");
            body.append("\tgetDocContent(id,_eid,_openId,'" + appid + "','odm','" + url + "');\n");
            body.append("}\n");
        }
        body.append("</script>\n");
        body.append("<script type=\"text/javascript\" src=\"./attlist.js\"></script>\n");
        body.append("</body>");
        html = XtImageUtil.reduceImageURL((String)body.toString(), (File)contentFolder, (Context)adapter.getContext());
        if (!isNotAuto) {
            adapter.saveIsConverContentInfo(true);
        }
        return html;
    }

    private static String stripContentHTML(String content, File contentFolder) {
        content = HTMLUtil.convertHtmlTagToLowerCase((String)content);
        content = HTMLUtil.stripHtmlComment((String)content);
        content = HTMLUtil.stripHtmlDocumentContent((String)content);
        content = HTMLUtil.stripHtmlFrameContent((String)content);
        content = HTMLUtil.stripHtmlFormContent((String)content);
        content = HTMLUtil.stripHtmlMediaContent((String)content);
        content = HTMLUtil.stripHtmlTableContent((String)content);
        content = HTMLUtil.stripHtmlDocumentTags((String)content);
        content = HTMLUtil.stripHtmlArticleTags((String)content);
        content = HTMLUtil.stripHtmlListTags((String)content);
        content = HTMLUtil.stripHtmlTextTags((String)content);
        switch (1) {
            case 0: {
                content = HTMLUtil.stripHtmlHrefTag((String)content);
                break;
            }
            case 1: {
                content = HTMLUtil.stripHtmlHrefContent((String)content);
            }
        }
        content = HTMLUtil.stripHtmlWordFormat((String)content);
        content = HTMLUtil.stripHtmlImageAttribute((String)content);
        content = HTMLUtil.stripHtmlBlankLine((String)content);
        content = HTMLUtil.stripHtmlSpace((String)content);
        return content;
    }
}

