/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.sm.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.simple.JSONObject;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.sm.InviteBillStateEnum;
import com.kingdee.eas.cp.sm.Schedule4PersonVisableConfigInfo;
import com.kingdee.eas.cp.sm.util.CommonDataUtil;
import com.kingdee.eas.cp.sm.util.DateUtil;
import com.kingdee.eas.cp.sm.web.ScheduleDataDao;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class MySMCalendarAction
extends DispatchAction {
    Logger logger = Logger.getLogger((String)MySMCalendarAction.class.getName());
    private static final String resource = "com.kingdee.eas.cp.sm.BizCollResource";
    private static Locale locale = ContextUtils.getLocaleFromEnv();

    public ActionForward getcalendarXml(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info((Object)"--------------new mysmca-------------------------");
        String yMonth = request.getParameter("yMonth");
        JSONObject temp = null;
        if (yMonth != null && yMonth.trim().length() > 0) {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            String beginStr = yMonth + "-01 00:00";
            String endStr = yMonth + "-31 23:59";
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateUtil.getDateFormat(beginStr, "yyyy-MM-dd H:mm"));
            paramMap.put("userCal", cal);
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            paramMap.put("userId", userInfo.getPerson().getId().toString());
            List myCreateList = new ScheduleDataDao().getUserCreateScheduleData(ctx, paramMap);
            List invitedMyList = new ScheduleDataDao().getInvitedUserScheduleData(ctx, paramMap);
            Schedule4PersonVisableConfigInfo configInfo = CommonDataUtil.getPersonVisableConfig(ctx, userInfo.getPerson().getId().toString());
            List MyScheduleList = this.clearMyScheduleDirtyData(configInfo, myCreateList, invitedMyList);
            HashMap<String, ArrayList<Msg>> dateMap = new HashMap<String, ArrayList<Msg>>();
            String dateStr = null;
            ArrayList<Msg> list = null;
            if (MyScheduleList.size() > 0) {
                for (int i = 0; i < MyScheduleList.size(); ++i) {
                    BizEnumValueDTO inviteBillState;
                    HashMap info = (HashMap)MyScheduleList.get(i);
                    Date eventDate = null;
                    Date eventEndDate = null;
                    String id = null;
                    String title = null;
                    if (info.get("eventdate") == null || info.get("eventenddate") == null || (inviteBillState = (BizEnumValueDTO)info.get("invitedperson.invitebillstate")) != null && inviteBillState.getValue().equals(String.valueOf(InviteBillStateEnum.REFUSE.getValue()))) continue;
                    id = (String)info.get("id");
                    eventDate = (Date)info.get("eventdate");
                    eventEndDate = (Date)info.get("eventenddate");
                    title = (String)info.get("title");
                    Calendar calStart = Calendar.getInstance();
                    calStart.setTime(eventDate);
                    Calendar calEnd = Calendar.getInstance();
                    calEnd.setTime(eventEndDate);
                    dateStr = DateUtil.toString(calStart.getTime(), "yyyy-MM-dd");
                    dateStr = dateStr.replaceAll("-", "");
                    list = (ArrayList<Msg>)dateMap.get(dateStr);
                    if (list == null) {
                        list = new ArrayList<Msg>();
                        dateMap.put(dateStr, list);
                    }
                    Msg msg = new Msg();
                    msg.id = id;
                    msg.title = title;
                    msg.time = DateUtil.toString(eventDate, "yyyy-MM-dd H:mm");
                    msg.body = (String)info.get("content");
                    msg.resourceId = id;
                    msg.type = 20;
                    list.add(msg);
                    if (calEnd.get(5) == calStart.get(5)) continue;
                    dateStr = DateUtil.toString(calEnd.getTime(), "yyyy-MM-dd");
                    list = (ArrayList<Msg>)dateMap.get(dateStr = dateStr.replaceAll("-", ""));
                    if (list == null) {
                        list = new ArrayList<Msg>();
                        dateMap.put(dateStr, list);
                    }
                    list.add(msg);
                }
            }
            temp = this.makeJson(yMonth, dateMap, this.getLocale(ctx));
            this.writeResult(response, temp.toString(), "getcalendarXml");
        }
        return null;
    }

    private Locale getLocale(Context ctx) {
        if (ctx == null) {
            return locale;
        }
        if (ctx.getLocale() == null) {
            return locale;
        }
        return ctx.getLocale();
    }

    private JSONObject makeJson(String yMonth, HashMap map, Locale mLocale) {
        JSONObject reply = new JSONObject();
        reply.put((Object)"yam", (Object)yMonth);
        String date = yMonth.replaceAll("-", "");
        String tDate = "";
        ArrayList list = null;
        Msg msg = null;
        JSONObject monthInfo = new JSONObject();
        int index = 0;
        for (int i = 0; i < 31; ++i) {
            tDate = date + this.convertInt(i + 1);
            list = (ArrayList)map.get(tDate);
            if (list == null || list.size() <= 0) continue;
            JSONArray dayInfo = new JSONArray();
            for (int j = 0; j < list.size() && j < 3; ++j) {
                msg = (Msg)list.get(j);
                if (msg == null) continue;
                JSONObject msgInfo = new JSONObject();
                msgInfo.put((Object)"subject", (Object)(EASCommonResource.getString((String)resource, (String)"title", (Locale)mLocale) + "\uff1a" + this.convertLenth(msg.title, 40)));
                msgInfo.put((Object)"time", (Object)msg.time);
                msgInfo.put((Object)"address", (Object)(EASCommonResource.getString((String)resource, (String)"content", (Locale)mLocale) + "\uff1a" + this.convertLenth(msg.body, 40)));
                msgInfo.put((Object)"msgtype", (Object)new Integer(msg.type));
                msgInfo.put((Object)"url", (Object)("1," + msg.id + "," + msg.resourceId + "," + msg.type + "," + msg.webSupport + "," + msg.sourceIDs + "," + msg.bizType));
                dayInfo.put(j, (Object)msgInfo);
            }
            monthInfo.put((Object)("day" + (i + 1)), (Object)dayInfo);
            ++index;
        }
        reply.put((Object)"monthInfo", (Object)monthInfo);
        System.out.println("the reply------------------------------");
        System.out.println(reply);
        return reply;
    }

    private String convertInt(int i) {
        String temp = String.valueOf(i);
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        return temp;
    }

    private String convertLenth(String str, int length) {
        if (str == null) {
            return "";
        }
        if (str.length() < length) {
            return str;
        }
        return str.substring(0, length);
    }

    protected void writeResult(HttpServletResponse response, String result, String functionName) throws BOSException, EASBizException {
        this.logger.info((Object)(functionName + "'s reply----------------------"));
        this.logger.info((Object)result);
        response.setContentType("text/json;charset=utf-8");
        try {
            response.getWriter().write(result);
            response.getWriter().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List clearMyScheduleDirtyData(Schedule4PersonVisableConfigInfo configInfo, List myCreateList, List invitedMyList) {
        HashMap data;
        int i;
        ArrayList<HashMap> retList = new ArrayList<HashMap>();
        HashSet<String> idSet = new HashSet<String>();
        boolean cancelIsInList = true;
        boolean refuseIsInList = true;
        if (configInfo != null) {
            cancelIsInList = configInfo.isIsCancelVisable();
            refuseIsInList = configInfo.isIsDeletedVisable();
        }
        if (myCreateList != null && myCreateList.size() > 0) {
            for (i = 0; i < myCreateList.size(); ++i) {
                boolean isCancel;
                data = (HashMap)myCreateList.get(i);
                boolean bl = isCancel = (BizEnumValueDTO)data.get("sstate") == null ? false : "CANCEL".equals(((BizEnumValueDTO)data.get("sstate")).getValue());
                if (!cancelIsInList && isCancel) continue;
                idSet.add((String)data.get("id"));
                retList.add(data);
            }
        }
        if (invitedMyList != null && invitedMyList.size() > 0) {
            for (i = 0; i < invitedMyList.size(); ++i) {
                boolean isDeleted;
                boolean isRefuse;
                data = (HashMap)invitedMyList.get(i);
                String scheduleId = (String)data.get("id");
                boolean bl = data.get("invitedperson.invitebillstate") == null ? false : (isRefuse = 2 == ((BizEnumValueDTO)data.get("invitedperson.invitebillstate")).getInt());
                boolean bl2 = data.get("invitedperson.isdeleted") == null ? false : (isDeleted = (Boolean)data.get("invitedperson.isdeleted") == new Boolean(true));
                if (idSet.contains(scheduleId) || isDeleted || !refuseIsInList && isRefuse) continue;
                retList.add(data);
                idSet.add(scheduleId);
            }
        }
        return retList;
    }

    public class Msg {
        public int type;
        public int bizType;
        public String id;
        public String resourceId;
        public String title;
        public String body;
        public String time;
        public boolean webSupport = false;
        public String sourceIDs = "";
    }
}

