/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.sm.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.sm.ISchedulePorletSetting;
import com.kingdee.eas.cp.sm.SchedulePorletSettingCollection;
import com.kingdee.eas.cp.sm.SchedulePorletSettingFactory;
import com.kingdee.eas.cp.sm.SchedulePorletSettingInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONObject;

public class SMPortletSettingAction
extends Action {
    private String resultMsg = "";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.sm.web.SMPortletSettingAction");

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.resultMsg = "";
        String method = request.getParameter("method");
        if ("save".equalsIgnoreCase(method)) {
            this.save(mapping, form, request, response);
        } else if ("show".equalsIgnoreCase(method)) {
            this.show(mapping, form, request, response);
        }
        try {
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(this.resultMsg);
            response.getWriter().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SchedulePorletSettingInfo model = this.initScheduleParams(request);
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        ISchedulePorletSetting spSetting = SchedulePorletSettingFactory.getRemoteInstance();
        if (null != model.getId() && !"".equals(model.getId())) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("tab"));
            selector.add(new SelectorItemInfo("dayDisplay"));
            selector.add(new SelectorItemInfo("weekDisplay"));
            spSetting.updatePartial((CoreBaseInfo)model, selector);
        } else {
            spSetting.addnew((CoreBaseInfo)model);
        }
        JSONObject info = new JSONObject();
        info.put("id", (Object)model.getId().toString());
        info.put("tab", (Object)model.getTab());
        info.put("dayDisplay", model.getDayDisplay());
        info.put("weekDisplay", model.getWeekDisplay());
        info.put("success", (Object)Boolean.TRUE);
        this.resultMsg = info.toString();
    }

    protected void show(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String cpSysNum = request.getParameter("cpSysNum");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cpSysNum", (Object)cpSysNum));
        filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)userInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("isManager", (Object)Boolean.FALSE));
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo("isManager");
        if (SMPortletSettingAction.isCMAdmin(ctx)) {
            filter.getFilterItems().add(new FilterItemInfo("isManager", (Object)Boolean.TRUE));
            filter.setMaskString(" #0 and ((#1 and #2) or #3 ) ");
            sort.setSortType(SortType.DESCEND);
        } else {
            sort.setSortType(SortType.ASCEND);
        }
        sortColl.add(sort);
        view.setSorter(sortColl);
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("tab"));
        sic.add(new SelectorItemInfo("dayDisplay"));
        sic.add(new SelectorItemInfo("weekDisplay"));
        view.setSelector(sic);
        ISchedulePorletSetting spSetting = SchedulePorletSettingFactory.getRemoteInstance();
        SchedulePorletSettingCollection coll = spSetting.getSchedulePorletSettingCollection(view);
        if (coll != null && coll.size() > 0) {
            SchedulePorletSettingInfo spInfo = coll.get(0);
            JSONObject info = new JSONObject();
            info.put("id", (Object)spInfo.getId().toString());
            info.put("tab", (Object)spInfo.getTab());
            info.put("dayDisplay", spInfo.getDayDisplay());
            info.put("weekDisplay", spInfo.getWeekDisplay());
            this.resultMsg = info.toString();
        }
    }

    private SchedulePorletSettingInfo initScheduleParams(HttpServletRequest request) throws BOSException {
        SchedulePorletSettingInfo info = new SchedulePorletSettingInfo();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String id = null;
        if (null != request.getParameter("id") && !"".equals(request.getParameter("id"))) {
            id = request.getParameter("id");
            info.setId(BOSUuid.read((String)id));
        }
        info.setCpSysNum(request.getParameter("cpSysNum"));
        if (request.getParameter("tab") != null && !"".equals(request.getParameter("tab"))) {
            info.setTab(request.getParameter("tab"));
        }
        if (request.getParameter("dayCount") != null && !"".equals(request.getParameter("dayCount"))) {
            info.setDayDisplay(Integer.parseInt(request.getParameter("dayCount")));
        }
        if (request.getParameter("weekCount") != null && !"".equals(request.getParameter("weekCount"))) {
            info.setWeekDisplay(Integer.parseInt(request.getParameter("weekCount")));
        }
        if (SMPortletSettingAction.isCMAdmin(ctx)) {
            info.setIsManager(true);
        } else {
            info.setIsManager(false);
        }
        return info;
    }

    public static boolean isCMAdmin(Context ctx) {
        boolean isCMAdmin = false;
        try {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            try {
                isCMAdmin = iPermission.hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()), "portal_manage");
            }
            catch (Exception e) {
                logger.info((Object)(ctx.getUserName() + "\u4e0d\u662f\u95e8\u6237\u7ba1\u7406\u5458"));
            }
        }
        catch (BOSException e) {
            logger.info((Object)"MenuBaseAction:\u83b7\u53d6\u6743\u9650\u5931\u8d25");
        }
        return isCMAdmin;
    }
}

