/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.taskmng.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.app.BusinessSeviceUtil;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.bill.BillApplicationHelper;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.BaseDataFilterArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.form.util.FormActionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.taskmng.AbstractTaskInfo;
import com.kingdee.eas.cp.taskmng.ITask;
import com.kingdee.eas.cp.taskmng.ITaskTeam;
import com.kingdee.eas.cp.taskmng.TaskCollection;
import com.kingdee.eas.cp.taskmng.TaskFactory;
import com.kingdee.eas.cp.taskmng.TaskInfo;
import com.kingdee.eas.cp.taskmng.TaskState;
import com.kingdee.eas.cp.taskmng.TaskTeamFactory;
import com.kingdee.eas.cp.taskmng.TaskTeamInfo;
import com.kingdee.eas.cp.taskmng.util.StringUtil;
import com.kingdee.eas.cp.taskmng.util.TmHelpUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class TasksPlugin
extends AbstractBillPlugin {
    private int edit;
    private boolean isSave = false;
    private String taskName;
    private boolean isSubmit = false;
    private OperationStatus operationStatus;
    private String operateAction;
    private int currRow = 0;
    private boolean cp019 = false;
    private Context ctx;
    private String taskSourcePk;

    public boolean onInitialize(OpenBillParameter param) throws BOSException, EASBizException {
        this.operationStatus = param.billOperation;
        this.ctx = this.application.getContext();
        return super.onInitialize(param);
    }

    public void onGetFieldFilter(BaseDataFilterArg arg) throws EASBizException, BOSException {
        if ("".equals(arg.getKey())) {
            FilterInfo filter = new FilterInfo();
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("state", (Object)TaskState.giveIn));
            arg.setOql(filter.toString());
        }
        super.onGetFieldFilter(arg);
    }

    public void onLoad() {
        String name = (String)this.application.getValue("Ftxt1", 0);
        this.application.lockElement("Fbtn1", true);
        try {
            if (!StringUtil.isEmpty((String)name)) {
                this.application.setValue("Ftxt1", (Object)StringUtil.throwOffBlank(name), 0);
            }
            String filter = this.f7Filter().toString();
            this.application.setFieldFilter("FTaskSourse", filter);
        }
        catch (BOSException e2) {
            e2.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        String reportView = (String)this.ctx.get((Object)"reportView");
        this.ctx.put((Object)"reportView", null);
        if ("reportView".equals(reportView)) {
            try {
                ITask task = TaskFactory.getLocalInstance(this.ctx);
                String taskPk = (String)this.ctx.get((Object)"TaskPK");
                TaskInfo taskInfo = task.getTaskInfo((IObjectPK)new ObjectUuidPK(taskPk));
                this.application.getBillModel().setBillValue((IObjectValue)taskInfo);
                this.application.setEnabled("Fbtn", false);
                this.application.setEnabled("Fbtn1", false);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        } else {
            String operationStatus = this.application.getBillView().getOperationStatus().getStatus();
            if ("ADDNEW".equals(operationStatus)) {
                if (this.ctx.get((Object)"isAnalyze") == null) {
                    this.edit = 3;
                    this.taskSourcePk = (String)this.ctx.get((Object)"taskSourcePk");
                    this.ctx.put((Object)"taskSourcePk", null);
                    String taskTeamPK = (String)this.ctx.get((Object)"taskTeamPK");
                    this.ctx.put((Object)"taskTeamPK", null);
                    if (this.taskSourcePk != null) {
                        try {
                            ITask task = TaskFactory.getLocalInstance(this.ctx);
                            TaskInfo taskInfo = task.getTaskInfo((IObjectPK)new ObjectUuidPK(this.taskSourcePk));
                            this.application.setValue("Ftxt", (Object)StringUtil.throwOffBlank(taskInfo.getName()), 0);
                            String oql = "select customNumber where TaskTeam.id='" + taskTeamPK + "' and customNumber like '" + taskInfo.getCustomNumber() + ".%'";
                            String taskNumber = this.getTaskNumber(oql, taskInfo.getCustomNumber());
                            this.application.setValue("Fnumber", (Object)taskNumber, 0);
                        }
                        catch (BOSException e1) {
                            e1.printStackTrace();
                        }
                        catch (EASBizException e) {
                            e.printStackTrace();
                        }
                    } else {
                        String oql = "select customNumber where TaskTeam.id='" + taskTeamPK + "'";
                        try {
                            ITask taskService = TaskFactory.getLocalInstance(this.ctx);
                            TaskCollection coll = taskService.getTaskCollection(oql);
                            int index = 1;
                            for (int j = 0; j < coll.size(); ++j) {
                                TaskInfo info = coll.get(j);
                                if (info.getCustomNumber().length() != 1) continue;
                                ++index;
                            }
                            this.application.setValue("Fnumber", (Object)new Integer(index), 0);
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                        catch (EASBizException e) {
                            e.printStackTrace();
                        }
                    }
                    if (taskTeamPK != null && !"".equals(taskTeamPK)) {
                        try {
                            ITaskTeam taskTeamService = TaskTeamFactory.getLocalInstance(this.ctx);
                            TaskTeamInfo taskTeamInfo = taskTeamService.getTaskTeamInfo((IObjectPK)new ObjectUuidPK(taskTeamPK));
                            this.application.setValue("Fbasedata", (Object)taskTeamInfo, 0);
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                        catch (EASBizException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    Map map = (Map)this.ctx.get((Object)"taskMap");
                    this.ctx.put((Object)"isAnalyze", null);
                    this.ctx.put((Object)"taskMap", null);
                    try {
                        this.application.setValue("Fbasedata", map.get("taskTeam"), 0);
                        this.application.setValue("Ftxt", map.get("taskName"), 0);
                        this.application.setValue("Flist", map.get("importantDegree"), 0);
                        this.application.setValue("Flist1", map.get("exigentDegree"), 0);
                        this.application.setValue("Fremark", map.get("explain"), 0);
                        this.application.setValue("Fremark1", map.get("checkCriterion"), 0);
                        this.application.setValue("Fnumber", map.get("number"), 0);
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                }
            } else if ("EDIT".equals(operationStatus)) {
                this.taskSourcePk = (String)this.ctx.get((Object)"taskSourcePk");
                this.edit = 2;
            }
        }
        if ("statistics".equals(this.ctx.get((Object)"statistics"))) {
            this.application.setEnabled("Fbtn2", true);
            this.ctx.put((Object)"statistics", null);
        }
        super.onLoad();
    }

    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        if ("\u4fdd\u5b58".equals(operation.getName())) {
            // empty if block
        }
        return super.beforeOperation(operation);
    }

    public void doCustomOperation(String operation) throws EASBizException, BOSException {
        if ("taskAnalyze".equals(operation)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String number = (String)this.application.getValue("Fnumber", 0);
            TaskTeamInfo taskTeamInfo = (TaskTeamInfo)this.application.getValue("Fbasedata", 0);
            String oql = "select customNumber where TaskTeam.id='" + taskTeamInfo.getId().toString() + "'" + " and TaskSource='" + this.application.getValue("Ftxt1", 0) + "' and customNumber like '" + number + "%'";
            String taskNumber = this.getTaskNumber(oql, number);
            map.put("taskTeam", taskTeamInfo);
            map.put("number", taskNumber);
            map.put("taskName", this.application.getValue("Ftxt1", 0));
            map.put("importantDegree", this.application.getValue("Flist", 0));
            map.put("exigentDegree", this.application.getValue("Flist1", 0));
            map.put("explain", this.application.getValue("Fremark", 0));
            map.put("checkCriterion", this.application.getValue("Fremark1", 0));
            this.application.createNewData();
            this.application.setValue("Fbasedata", map.get("taskTeam"), 0);
            this.application.setValue("Ftxt", map.get("taskName"), 0);
            this.application.setValue("Flist", map.get("importantDegree"), 0);
            this.application.setValue("Flist1", map.get("exigentDegree"), 0);
            this.application.setValue("Fremark", map.get("explain"), 0);
            this.application.setValue("Fremark1", map.get("checkCriterion"), 0);
            this.application.setValue("Fnumber", map.get("number"), 0);
        } else if ("taskSubmit".equals(operation)) {
            String pk = (String)this.ctx.get((Object)"taskSourcePk");
            if (StringUtil.isEmpty((String)pk)) {
                pk = this.getCurrentTaskPKByTaskTeamPk();
            }
            this.submitFlow(pk);
        }
        super.doCustomOperation(operation);
    }

    public boolean beforeSaveOrSubmitData() {
        if (this.isSubmit || this.isSave) {
            try {
                this.application.getView().getParentFormView().refresh();
                this.application.close();
                return false;
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        String name = (String)this.application.getValue("Ftxt1", 0);
        Object frontTask = this.application.getValue("Ftxt", 0);
        if (null != frontTask) {
            name = this.getRealName(this.taskSourcePk);
        }
        try {
            this.taskName = name;
            this.application.setValue("Ftxt1", (Object)name, 0);
            this.application.setValue("Ftxt2", (Object)StringUtil.throwOffBlank(name), 0);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return super.beforeSaveOrSubmitData();
    }

    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        if ("\u4fdd\u5b58".equals(operation.getName())) {
            this.application.setValue("Ftxt1", (Object)StringUtil.throwOffBlank(this.taskName), 0);
            TaskInfo info = TmHelpUtil.getTaskInfo(this.ctx, "select * where id='" + this.taskSourcePk + "'");
            if (info != null && info.getState().toString().equals("0")) {
                this.application.lockElement("Fbtn1", false);
            }
            this.updateTaskName(this.taskSourcePk, this.taskName);
            this.isSave = true;
        }
        super.afterOperation(operation);
    }

    private void submitFlow(String formId, String pk) throws BOSException, EASBizException, Exception {
        OpenBillParameter param = new OpenBillParameter();
        param.setFormId(formId);
        param.billPk = pk;
        BillApplicationHelper helper = BillApplicationHelper.getInstance((Context)this.application.getContext(), (OpenBillParameter)param, null);
        BillApplication billApp = helper.newBillApplication();
        helper.loadData(null);
        FormActionUtil.invokeBillFunction((IFormApplication)billApp, (String)"Submit", null);
    }

    private String getTaskNumber(String oql, String number) throws BOSException {
        ITask taskService = TaskFactory.getLocalInstance(this.ctx);
        TaskCollection coll = taskService.getTaskCollection(oql);
        String taskNumber = "";
        if (coll.size() <= 0) {
            taskNumber = number + ".1";
        } else {
            int i = 1;
            for (int j = 0; j < coll.size(); ++j) {
                if (coll.get(j).getCustomNumber().length() != number.length() + 2) continue;
                ++i;
            }
            taskNumber = number + "." + i;
        }
        return taskNumber;
    }

    private String getRealName(String pk) {
        String name = (String)this.application.getValue("Ftxt1", 0);
        String oql = "select * where id='" + pk + "'";
        TaskInfo info = TmHelpUtil.getTaskInfo(this.ctx, oql);
        String realName = null;
        String operationStatus = this.application.getBillView().getOperationStatus().getStatus();
        realName = this.edit == 2 ? StringUtil.getAllBlank(info.getAlias()) + name : StringUtil.getAllBlank(info.getAlias()) + StringUtil.add2BlankFrontStr(name);
        return realName;
    }

    private FilterInfo f7Filter() {
        String pk = (String)this.ctx.get((Object)"f7TaskId");
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("TaskTeam.id", (Object)pk));
        filter.setMaskString("#0");
        return filter;
    }

    private TaskTeamInfo getTaskTeamById(String pk) {
        AbstractTaskInfo info = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)pk));
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add("TaskTeam.*");
            view.setFilter(filterInfo);
            view.setSelector(coll);
            ITask taskService = TaskFactory.getLocalInstance(this.ctx);
            CoreBaseCollection collection = taskService.getCollection(view);
            if (collection != null && collection.size() > 0) {
                info = (TaskInfo)collection.get(0);
            }
            return info.getTaskTeam();
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void submitFlow(String pk) throws BOSException, EASBizException {
        String processDefID;
        TaskInfo frontTaskInfo;
        IObjectValue objectValue = DAOHelper.getDAO().load(this.application.getContext(), pk, null);
        String formId = this.application.getForm().getId();
        String billName = StringUtil.throwOffBlank(objectValue.getString("name"));
        String billNumber = objectValue.getString("number");
        String sourcePK = objectValue.get("id").toString();
        TaskTeamInfo taskTeamInfo = this.getTaskTeamById(pk);
        TaskInfo info = TmHelpUtil.getTaskInfo(this.ctx, "select * where id='" + pk + "'");
        if ("true".equals(info.getIsDepend().trim()) && (frontTaskInfo = info.getFrontageTask()) != null) {
            frontTaskInfo = TmHelpUtil.getTaskInfo(this.ctx, "select * where id='" + frontTaskInfo.getId().toString() + "'");
            this.application.setValue("FTaskSourse1", (Object)StringUtil.throwOffBlank(frontTaskInfo.getName()), 0);
            if (!frontTaskInfo.getSchedule().toString().equals("100.0000000000")) {
                this.application.showMessage("\u540d\u79f0\u4e3a" + StringUtil.throwOffBlank(frontTaskInfo.getName()) + "\u7684\u4efb\u52a1\u6682\u65f6\u672a\u5b8c\u6210\uff01");
                this.application.lockElement("Fbtn1", true);
                return;
            }
        }
        if (StringUtil.isEmpty((String)(processDefID = (String)taskTeamInfo.get("relatingWf")))) {
            this.application.showMessage("\u5f53\u524d\u5c0f\u7ec4\u6ca1\u6709\u5173\u8054\u6d41\u7a0b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            return;
        }
        if (processDefID != null) {
            String userId = this.application.getContext().getCaller().toString();
            IEnactmentService wfService = EnactmentServiceProxy.getEnacementService((Context)this.application.getContext());
            HashMap<String, String> invokeContext = new HashMap<String, String>();
            invokeContext.put("billidString", pk);
            invokeContext.put("formId", formId);
            invokeContext.put("billName", billName);
            invokeContext.put("billNo", billNumber);
            wfService.createAndCompleteFiristActivity(processDefID, invokeContext, userId);
            this.isSubmit = true;
            this.application.lockElement("Fbtn1", true);
            this.application.lockElement("Fbtn", true);
            this.application.lockElement("Fbtn2", true);
            this.application.showMessage("\u63d0\u4ea4\u6210\u529f\uff01");
            return;
        }
        BusinessSeviceUtil.triggerWfEvent((Context)this.application.getContext(), (BOSObjectType)objectValue.getBOSType(), (String)"Submit", (String)pk, (String)formId, (String)billName, (String)billNumber);
    }

    private String getCurrentTaskPKByTaskTeamPk() {
        String pk = null;
        String oql = "select * where TaskTeam.id='" + TmHelpUtil.getTaskTeamPk() + "' order by createTime desc";
        try {
            ITask taskService = TaskFactory.getLocalInstance(this.ctx);
            TaskCollection coll = taskService.getTaskCollection(oql);
            if (coll.size() > 0) {
                return coll.get(0).getId().toString();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return pk;
    }

    private void updateTaskName(String pk, String name) {
        try {
            ITask taskService = TaskFactory.getLocalInstance(this.ctx);
            TaskInfo info = taskService.getTaskInfo("select * where id='" + this.getCurrentTaskPKByTaskTeamPk() + "'");
            info.setAlias(name);
            taskService.update((IObjectPK)new ObjectUuidPK(this.getCurrentTaskPKByTaskTeamPk()), (CoreBaseInfo)info);
            PreparedStatement ps = null;
            String sql = "update t_tas_task set falias='" + name + "' where fid='" + this.getCurrentTaskPKByTaskTeamPk() + "'";
            ps = EJBFactory.getConnection((Context)this.ctx).prepareStatement(sql);
            ps.execute();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

