/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.uc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemException;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.uc.IMInfoCollection;
import com.kingdee.eas.cp.uc.IMInfoFactory;
import com.kingdee.eas.cp.uc.IMInfoInfo;
import com.kingdee.eas.cp.uc.dianji.util.GK_MS_API;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import qflag.ucstar.manager.WebserviceManager;
import qflag.ucstar.webservice.UcstarWebservice;

public class DataTools {
    public static final String CP_UC_IMInfo_Update = "cp_uc_ImInfo_Update";
    public static final String DOCDISPATCH_UPDATE_PERMISSION = "cp_arcm_DocDispatch_Update";
    public static final String DOCRECEIVE_UPDATE_PERMISSION = "cp_arcm_DocReceive_Update";
    public static final String MRMAPPLY_PERMISSION = "cp_mrm_MRApply_AddNew";
    public static final String MRSUMMARY_PERMISSION = "cp_mrm_MRSummary_AddNew";
    public static final String MRREGULAR_PERMISSION = "cp_mrm_MRRegular_AddNew";
    public static final String EXPENSE_UPDATE_PERMISSION = "cp_bc_Expense_Update";
    public static final String DAILYLOAN_UPDATE_PERMISSION = "cp_bc_DailyLoan_Update";
    public static final String EVECTIONREQ_UPDATE_PERMISSION = "cp_bc_EvectionReq_Update";
    public static final String EVECTIONLOAD_UPDATE_PERMISSION = "cp_bc_EvectionLoan_Update";
    public static final String EXPENSEACCOUNT_UPDATE_PERMISSION = "cp_bc_ExpenseAccount_Update";
    public static final String TRAVELACCOUNT_UPDATE_PERMISSION = "cp_bc_TravelAccount_Update";
    public static final String BIZACCOUNTOUTBILL_UPDATE_PERMISSION = "cp_bc_BizAccountOutBill_Update";

    public static boolean checkDianJiIm(String ip, String port) {
        boolean result = false;
        GK_MS_API gkmsapi = new GK_MS_API();
        gkmsapi.init(ip, Integer.parseInt(port));
        String str = gkmsapi.serverControl("status", "123");
        try {
            if (str.indexOf("10601") >= 0) {
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("dianji has error");
        }
        return result;
    }

    public static boolean checkQingQiIm(String ip, String port) {
        boolean result = false;
        try {
            WebserviceManager.getInstance().bindWebService(ip, port);
            UcstarWebservice us = WebserviceManager.getInstance().getWebservice();
            us.getAllOnlineCount();
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("qingqi has error" + ip + ":" + port);
        }
        return result;
    }

    public static IMInfoInfo getIMInfo(Context ctx) throws BOSException {
        IMInfoCollection con = IMInfoFactory.getLocalInstance(ctx).getIMInfoCollection("select * where IsMain='0'");
        if (con.size() != 0) {
            return con.get(0);
        }
        return null;
    }

    public static List getEASMenu(Context ctx, String userIDs) {
        LinkedList<Map> menuList = new LinkedList<Map>();
        if (userIDs == null || "".equals(userIDs)) {
            return menuList;
        }
        Map sendmsg = DataTools.getMenuMap("0", "\u53d1\u6d88\u606f", "true", "", "", "modal");
        Map sendSMS = DataTools.getMenuMap("0", "\u53d1\u77ed\u4fe1", "true", "", "", "modal");
        String receiveremils = DataTools.getUserEmailsByUserids(ctx, userIDs);
        String emaildis = "false";
        String url = "";
        if (receiveremils != null && !receiveremils.equals("")) {
            emaildis = "false";
            url = "/easweb/cp/uc/ucstar_email.jsp?emailaddress=mailto:" + receiveremils;
        } else {
            emaildis = "true";
        }
        Map sendMail = DataTools.getMenuMap("0", "\u53d1\u90ae\u4ef6", emaildis, "", url, "modal");
        HashMap<String, String> breakLine = new HashMap<String, String>();
        breakLine.put("menu_type", "1");
        String disabled = "false";
        String infourl = "";
        if (userIDs.indexOf(";") > 0) {
            disabled = "true";
        } else {
            try {
                infourl = "/easweb/cp/uc/ImPersonInfo.jsp?userid=" + URLEncoder.encode(userIDs, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        Map info = DataTools.getMenuMap("0", "\u4eba\u5458\u4fe1\u606f", disabled, "", infourl, "modal");
        menuList.add(sendmsg);
        menuList.add(sendSMS);
        menuList.add(sendMail);
        menuList.add(breakLine);
        menuList.add(info);
        return menuList;
    }

    private static Map getMenuMap(String type, String label, String disabled, String action, String url, String opentype) {
        HashMap<String, String> menu = new HashMap<String, String>();
        menu.put("menu_type", type);
        menu.put("menu_label", label);
        menu.put("menu_disabled", disabled);
        menu.put("menu_action", action);
        menu.put("menu_url", url);
        menu.put("menu_opentype", opentype);
        return menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUsernamesByUserids(Context ctx, String userids) throws BOSException {
        IRowSet rs = null;
        String[] useridarr = userids.trim().split(";");
        String sqlids = "";
        String username = "";
        try {
            IMInfoInfo info = DataTools.getIMInfo(ctx);
            WebserviceManager.getInstance().bindWebService(info.getIp(), info.getPort());
            UcstarWebservice us = WebserviceManager.getInstance().getWebservice();
            int size = useridarr.length;
            for (int i = 0; i < size; ++i) {
                sqlids = sqlids + "'" + useridarr[i] + "',";
            }
            sqlids = sqlids.substring(0, sqlids.length() - 1);
            StringBuffer selectSql = new StringBuffer();
            selectSql.append("select fname_l2 from T_UC_IMSynPerson where FPersonid in(" + sqlids + ") ");
            rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            while (rs.next()) {
                if (us.getUser(rs.getString(1)) == null) continue;
                username = username + rs.getString(1) + ",";
            }
            if (rs.size() != 0 && username.length() > 0) {
                username = username.substring(0, username.length() - 1);
            }
            String string = username;
            return string;
        }
        catch (BOSException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return username.toLowerCase();
    }

    public static String getUserEmailsByUserids(Context ctx, String userIds) {
        String[] userids = null;
        String emails = "";
        String email = "";
        try {
            IPerson perservice = PersonFactory.getLocalInstance((Context)ctx);
            if (userIds.indexOf(";") > 0) {
                userids = userIds.split(";");
                int size1 = userids.length;
                for (int i = 0; i < size1; ++i) {
                    email = perservice.getPersonInfo((IObjectPK)new ObjectUuidPK(userids[i])).getEmail();
                    if (email == null) continue;
                    emails = emails + email + ";";
                }
            } else {
                email = perservice.getPersonInfo((IObjectPK)new ObjectUuidPK(userIds)).getEmail();
                if (email != null) {
                    emails = emails + email;
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return emails;
    }

    public static Vector getCPAllModule(Context ctx) {
        Vector<String> list = new Vector<String>();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select * from T_CP_SubSystem where fvisible =1");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            while (rs.next()) {
                list.add(rs.getString("FNumber"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String replaceName(String name) {
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = null;
        String newname = name;
        m = p.matcher(newname);
        newname = m.replaceAll("");
        return newname;
    }

    public static String replaceId(String id) {
        String newid = id;
        newid = DataTools.replace(newid, "+", "_1");
        newid = newid.replaceAll("=", "_2");
        newid = newid.replaceAll("/", "_3");
        return newid;
    }

    public static String replace(String source, String oldString, String newString) {
        int pos;
        StringBuffer output = new StringBuffer();
        int lengthOfSource = source.length();
        int lengthOfOld = oldString.length();
        int posStart = 0;
        while ((pos = source.indexOf(oldString, posStart)) >= 0) {
            output.append(source.substring(posStart, pos));
            output.append(newString);
            posStart = pos + lengthOfOld;
        }
        if (posStart < lengthOfSource) {
            output.append(source.substring(posStart));
        }
        return output.toString();
    }

    public static void checkPermission(Context ctx, String permissionItem) throws BOSException, EASBizException {
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        if (cuId == null || StringUtils.isEmpty((String)permissionItem)) {
            return;
        }
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK orgPK = new ObjectUuidPK(cuId);
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission(userPK, (IObjectPK)orgPK, permissionItem);
    }

    public static boolean isHasPermission(Context ctx, String permissionItem) {
        try {
            DataTools.checkPermission(ctx, permissionItem);
        }
        catch (PermissionServiceException e) {
            return false;
        }
        catch (PermItemException e) {
            return false;
        }
        catch (PermissionException e) {
            return false;
        }
        catch (EASBizException e) {
            return false;
        }
        catch (BOSException e) {
            return false;
        }
        return true;
    }
}

