/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.uc.service.qingqi;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.cp.uc.DataTools;
import com.kingdee.eas.cp.uc.service.AbstractIMServiceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import qflag.ucstar.manager.WebserviceManager;
import qflag.ucstar.webservice.UcstarWebservice;
import qflag.ucstar.webservice.bean.UCUserStateExt;

public class IMServiceQingQi
extends AbstractIMServiceBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.uc.service.qingqi.IMServiceQingQi");

    public IMServiceQingQi() {
        logger.info((Object)"IMServiceQingQi created!");
    }

    public IMServiceQingQi(Context ctx) {
        super(ctx);
        logger.info((Object)"IMServiceQingQi created!");
    }

    protected boolean checkIMEnable(String ip, String port) {
        logger.info((Object)"IMServiceQingQi checkIMEnable");
        boolean result = false;
        try {
            WebserviceManager.getInstance().bindWebService(ip, port);
            UcstarWebservice us = WebserviceManager.getInstance().getWebservice();
            us.getAllOnlineCount();
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"qingqi has error");
        }
        return result;
    }

    public List getMenu(Context ctx, String userIDs) {
        logger.info((Object)"IMServiceQingQi getMenu");
        LinkedList<Map> menuList = new LinkedList<Map>();
        if (userIDs == null || "".equals(userIDs)) {
            return menuList;
        }
        String receivers = this.getUserNameByUserID(ctx, userIDs).toLowerCase();
        String receiveremils = this.getUserEmailByUserID(ctx, userIDs);
        String serderId = "";
        String sender = "";
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            serderId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
            sender = this.getUserNameByUserID(ctx, serderId).toLowerCase();
        }
        boolean multiFlag = false;
        boolean onlineFlag = false;
        if (userIDs != null && !"".equals(userIDs) && userIDs.indexOf(";") > -1) {
            multiFlag = true;
        }
        Map sendmsg = this.getSendMsgMenu(sender, receivers, multiFlag, onlineFlag);
        Map sendSMS = this.getSendSMSMenu(sender, receivers, multiFlag, onlineFlag);
        Map sendMail = this.getSendMailMenu(sender, receiveremils, multiFlag, onlineFlag);
        HashMap<String, String> breakLine = new HashMap<String, String>();
        breakLine.put("menu_type", "1");
        Map info = this.getUserInfoMenu(serderId, userIDs, multiFlag, onlineFlag);
        menuList.add(sendmsg);
        menuList.add(sendSMS);
        menuList.add(sendMail);
        menuList.add(breakLine);
        menuList.add(info);
        return menuList;
    }

    private Map getSendMsgMenu(String sender, String receivers, boolean multiFlag, boolean onlineFlag) {
        String type = "0";
        String label = "\u53d1\u6d88\u606f";
        String disabled = "false";
        if (sender != null && sender.equals(receivers) || receivers == null || "".equals(receivers)) {
            disabled = "true";
        }
        String action = "";
        String url = "/easweb/cp/uc/ucstar_message.jsp?host=" + this.ip + "&port=" + this.port + "&username=" + sender + "&receivenames=" + receivers;
        Map menu = this.getMenuMap(type, label, disabled, action, url, "modal");
        return menu;
    }

    private Map getSendSMSMenu(String sender, String receivers, boolean multiFlag, boolean onlineFlag) {
        String type = "0";
        String label = "\u53d1\u77ed\u4fe1";
        String disabled = "false";
        if (sender != null && sender.equals(receivers) || receivers == null || "".equals(receivers)) {
            disabled = "true";
        }
        if (receivers.indexOf(",") > 0) {
            if (receivers.indexOf(sender) == 0) {
                receivers = receivers.substring(sender.length() + 1, receivers.length());
            } else if (receivers.indexOf(sender) > 0 && receivers.indexOf(sender) + sender.length() < receivers.length()) {
                receivers = receivers.replaceAll(sender + ",", "");
            } else if (receivers.indexOf(sender) + sender.length() == receivers.length()) {
                receivers = receivers.substring(0, receivers.indexOf(sender) - 1);
            }
        }
        String action = "";
        String url = "/easweb/cp/uc/ucstar_sms.jsp?host=" + this.ip + "&port=" + this.port + "&username=" + sender + "&receivenames=" + receivers;
        Map menu = this.getMenuMap(type, label, disabled, action, url, "modal");
        return menu;
    }

    private Map getSendMailMenu(String sender, String emails, boolean multiFlag, boolean onlineFlag) {
        String type = "0";
        String label = "\u53d1\u90ae\u4ef6";
        String disabled = "false";
        disabled = emails != null && !emails.equals("") ? "false" : "true";
        String action = "";
        String url = "/easweb/cp/uc/ucstar_email.jsp?emailaddress=mailto:" + emails;
        Map menu = this.getMenuMap(type, label, disabled, action, url, "modal");
        return menu;
    }

    private Map getUserInfoMenu(String sender, String receivers, boolean multiFlag, boolean onlineFlag) {
        String type = "0";
        String label = "\u4eba\u5458\u4fe1\u606f";
        String disabled = "false";
        if (multiFlag) {
            disabled = "true";
        }
        String action = "";
        String url = "";
        try {
            url = "/easweb/cp/uc/ImPersonInfo.jsp?userid=" + URLEncoder.encode(receivers, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Map menu = this.getMenuMap(type, label, disabled, action, url, "modal");
        return menu;
    }

    private Map getMenuMap(String type, String label, String disabled, String action, String url, String opentype) {
        HashMap<String, String> menu = new HashMap<String, String>();
        menu.put("menu_type", type);
        menu.put("menu_label", label);
        menu.put("menu_disabled", disabled);
        menu.put("menu_action", action);
        menu.put("menu_url", url);
        menu.put("menu_opentype", opentype);
        return menu;
    }

    public int getUserStatus(Context ctx, String userIDs) {
        logger.info((Object)"IMServiceQingQi getUserStatus");
        if (userIDs == null || "".equals(userIDs)) {
            return 7;
        }
        try {
            WebserviceManager.getInstance().bindWebService(this.ip, this.port);
            UcstarWebservice us = WebserviceManager.getInstance().getWebservice();
            String userNames = this.getUserNameByUserID(ctx, userIDs);
            boolean existFlag = false;
            UCUserStateExt[] userState = us.getUserStateByUserIds(userNames);
            if (userState != null && userState.length > 0) {
                if (userIDs.indexOf(";") < 0) {
                    if ("1".equals(userState[0].getState()) || "2".equals(userState[0].getState())) {
                        if (this.getUserGender(ctx, userIDs) == 1) {
                            return 1;
                        }
                        if (this.getUserGender(ctx, userIDs) == 2) {
                            return 2;
                        }
                    } else if ("0".equals(userState[0].getState())) {
                        if (this.getUserGender(ctx, userIDs) == 1) {
                            return 3;
                        }
                        if (this.getUserGender(ctx, userIDs) == 2) {
                            return 4;
                        }
                    } else if ("-1".equals(userState[0].getState())) {
                        return 7;
                    }
                } else {
                    int size = userState.length;
                    for (int n = 0; n < size; ++n) {
                        if ("1".equals(userState[n].getState()) || "2".equals(userState[n].getState())) {
                            return 5;
                        }
                        if ("-1".equals(userState[n].getState())) continue;
                        existFlag = true;
                    }
                }
            }
            if (existFlag) {
                return 6;
            }
            return 7;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"qingqi has error");
            return 7;
        }
    }

    private String getUserNameByUserID(Context ctx, String userIDs) {
        try {
            return DataTools.getUsernamesByUserids(ctx, userIDs);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getUserEmailByUserID(Context ctx, String userIDs) {
        return DataTools.getUserEmailsByUserids(ctx, userIDs);
    }

    private int getUserGender(Context ctx, String userID) {
        if (userID == null || "".equals(userID)) {
            return 1;
        }
        String oql = "select * where id='" + userID + "'";
        try {
            PersonCollection userInfoCol = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(oql);
            if (userInfoCol != null && userInfoCol.size() > 0 && userInfoCol.get(0).getGender() != null) {
                return userInfoCol.get(0).getGender().getValue();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u6839\u636e\u7528\u6237ID\u8f6c\u6362\u4e3ausername\u65f6\u53d1\u751f\u5f02\u5e38");
            e.printStackTrace();
        }
        return 1;
    }
}

