/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfm.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.form.model.command.BaseDataFilterArg;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.wfm.plugins.AbstractDetailBillPlugin;
import com.kingdee.eas.ep.CoreBillBaseCustomEntryInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CustomerDetailBillPlugin
extends AbstractDetailBillPlugin {
    @Override
    protected void initParams() {
        this.entryBosType = "2E009B57";
        this.entryTableName = "CT_WFM_CustomerMainKD_Entry1";
        this.billType = "customer";
        this.targetbidKey = "targetCustomerID";
        this.checkNameUrl = "/easweb/cp/wfm/customerInfoList.jsf";
    }

    @Override
    public void onLoad() {
        super.onLoad();
    }

    @Override
    public void doCustomOperation(String operation) throws EASBizException, BOSException {
        if ("checkName".equals(operation)) {
            CoreBillBaseCustomEntryInfo customInfo = (CoreBillBaseCustomEntryInfo)this.application.getBillModel().getBillValue();
            String name = customInfo.getString("name_l2");
            name = name == null ? "" : name;
            String url = "";
            try {
                url = this.checkNameUrl + "?name=" + URLEncoder.encode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            this.application.popupWindow(url, "openDialog", "update", "\u5ba2\u6237\u8be6\u7ec6\u4fe1\u606f", 750, 450);
        }
        super.doCustomOperation(operation);
    }

    @Override
    protected boolean validateBeforeSaveOrSubmit() {
        try {
            if (this.application.getValue("FIsInternalCompany", 0) != null && ((Boolean)this.application.getValue("FIsInternalCompany", 0)).booleanValue() && (StringUtils.isEmpty((String)String.valueOf(this.application.getValue("FInternalCompany", 0))) || "null".equalsIgnoreCase(String.valueOf(this.application.getValue("FInternalCompany", 0))))) {
                this.application.showMessage("\u96c6\u56e2\u5185\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            String standardid = String.valueOf(this.application.getValue("FEntryCategory", 0));
            String groupName = String.valueOf(this.application.getValue("FEntryStandard", 0));
            if (StringUtils.isEmpty((String)standardid) || "null".equalsIgnoreCase(standardid)) {
                this.application.showMessage(groupName + "\u7684\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.validateBeforeSaveOrSubmit();
    }

    @Override
    protected void afterSaveEntry(boolean isCreateNew) {
        super.afterSaveEntry(isCreateNew);
        this.application.lockElement("Fbtn3", isCreateNew);
    }

    public void onGetFieldFilter(BaseDataFilterArg arg) throws EASBizException, BOSException {
        if ("FEntryCategory".equalsIgnoreCase(arg.getKey())) {
            String oql = " CU.ID in (" + this.getCUIDCondition(this.getAllCUID(ContextUtil.getCurrentCtrlUnit((Context)this.application.getContext()))) + ")";
            try {
                String standardid = String.valueOf(this.application.getValue("FEntryStandardID", arg.getRowIndex()));
                oql = oql + " and GROUPSTANDARD.ID = '" + standardid + "'";
                this.application.setFieldFilter("FEntryCategory", oql);
                this.application.getContext().put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        super.onGetFieldFilter(arg);
    }

    @Override
    public void afterCreateNewData() throws EASBizException, BOSException {
        super.afterCreateNewData();
        this.builderData();
    }

    private void builderData() throws EASBizException, BOSException {
        CSSPGroupStandardCollection mgStandardColl = this.getCSSPGroupStandardCollection();
        if (mgStandardColl == null) {
            return;
        }
        int size = mgStandardColl.size();
        for (int n = 0; n < size; ++n) {
            this.application.getBillModel().createNewEntryRow("FCustomerCategoryEntry");
            this.application.setValue("FEntrySeq", (Object)new Integer(n + 1), n);
            this.application.setValue("FEntryStandard", (Object)mgStandardColl.get(n).getName(), n);
            this.application.setValue("FEntryStandardID", (Object)mgStandardColl.get(n).getId().toString(), n);
            this.application.setValue("FEntryCategory", null, n);
            this.application.setValue("FEntryCategoryName", null, n);
        }
    }

    private CSSPGroupStandardCollection getCSSPGroupStandardCollection() throws BOSException {
        CSSPGroupStandardCollection supplierGroupStandards = null;
        ICSSPGroupStandard iSupplierGroupStandard = CSSPGroupStandardFactory.getLocalInstance((Context)this.application.getContext());
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)ContextUtil.getCurrentCtrlUnit((Context)this.application.getContext()).getId().toString(), (String)ContextUtil.getCurrentCtrlUnit((Context)this.application.getContext()).getLongNumber()));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer("0"), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer("1"), CompareType.EQUALS));
        filterInfo.setMaskString("#0 or #1");
        evi.getFilter().mergeFilter(filterInfo, "and");
        SorterItemInfo sorterByBasic = new SorterItemInfo("isBasic");
        sorterByBasic.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterByBasic);
        supplierGroupStandards = iSupplierGroupStandard.getCSSPGroupStandardCollection(evi);
        return supplierGroupStandards;
    }

    private String getCUIDCondition(List ids) {
        String cuids = "";
        for (int i = 0; i < ids.size(); ++i) {
            cuids = i != 0 ? cuids + ",'" + ids.get(i) + "'" : "'" + ids.get(i) + "'";
        }
        return cuids;
    }

    private List getAllCUID(CtrlUnitInfo currentCU) {
        String currentCULongNumer = currentCU.getLongNumber();
        String currentCUID = currentCU.getId().toString();
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(this.getCUFilter(currentCUID, currentCULongNumer));
        SelectorItemCollection si = new SelectorItemCollection();
        si.add(new SelectorItemInfo("id"));
        ev.setSelector(si);
        ArrayList<String> cuIDs = new ArrayList<String>();
        try {
            CtrlUnitCollection ctrlUnitColl = CtrlUnitFactory.getLocalInstance((Context)this.application.getContext()).getCtrlUnitCollection(ev);
            int size = ctrlUnitColl.size();
            for (int i = 0; i < size; ++i) {
                cuIDs.add(ctrlUnitColl.get(i).getId().toString());
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return cuIDs;
    }

    private FilterInfo getCUFilter(String currentCUID, String currentCULongNumer) {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)currentCUID));
        String[] lnSecs = currentCULongNumer.split("!");
        int size = lnSecs.length;
        HashSet<String> lnUps = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size - 1; ++i) {
            if (i != 0) {
                sb.append("!");
            }
            sb.append(lnSecs[i]);
            lnUps.add(sb.toString());
        }
        if (lnUps.size() != 0) {
            fic.add(new FilterItemInfo("longNumber", lnUps, CompareType.INCLUDE));
            fi.setMaskString("#0 or #1");
        }
        return fi;
    }
}

