/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.wfm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.core.BusinessServiceFactory;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoFactory;
import com.kingdee.eas.base.form.extend.flow.DocumentInfoInfo;
import com.kingdee.eas.base.form.extend.flow.IDocumentInfo;
import com.kingdee.eas.base.form.extend.flow.WorkflowStatus;
import com.kingdee.eas.base.message.MsgSourceStatus;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.pc.ProcCatalogException;
import com.kingdee.eas.ep.CoreBillBaseCustomInfo;
import com.kingdee.eas.framework.BillBaseCommonInfo;
import com.kingdee.eas.framework.CoreBaseCommonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCommonInfo;
import com.kingdee.eas.framework.DataBaseCommonInfo;
import com.kingdee.eas.framework.ObjectBaseCommonInfo;
import com.kingdee.eas.framework.TreeBaseCommonInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CommonUtil {
    private static Logger logger = Logger.getLogger(CommonUtil.class);

    public static Map _getParams(Context ctx, List paramNumberList, String companyId) throws BOSException, EASBizException {
        HashMap paramMap = new HashMap();
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        String[] paramNumbers = null;
        int size = paramNumberList.size();
        if (paramNumberList != null && size > 0) {
            paramNumbers = new String[size];
            for (int i = 0; i < size; ++i) {
                paramNumbers[i] = (String)paramNumberList.get(i);
            }
            paramMap = iParam.getParamHashMap(paramNumbers, companyId);
        }
        return paramMap;
    }

    public static Object getParamByName(Context ctx, String companyId, String paramName) {
        Object param = null;
        ArrayList<String> paramNumberList = new ArrayList<String>();
        paramNumberList.add(paramName);
        try {
            Map params = CommonUtil._getParams(ctx, paramNumberList, companyId);
            if (params != null && params.get(paramName) != null) {
                param = params.get(paramName);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return param;
    }

    public static void checkFunctionPermission(Context ctx, String permissionItem) throws EASBizException, BOSException {
        String mainOrgId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        if (mainOrgId == null || StringUtils.isEmpty((String)permissionItem)) {
            return;
        }
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK orgPK = new ObjectUuidPK(mainOrgId);
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission(userPK, (IObjectPK)orgPK, permissionItem);
    }

    public static IObjectValue createNewData(Context ctx, String bosType) throws BOSException, EASBizException {
        IObjectValue objectValue = BusinessServiceFactory.getBusinessService().createNewObject(ctx, bosType);
        if (objectValue instanceof BillBaseCommonInfo) {
            ((BillBaseCommonInfo)objectValue).setBOSType(BOSObjectType.create((String)bosType));
            ((BillBaseCommonInfo)objectValue).setPKField("id");
        } else if (objectValue instanceof CoreBaseCommonInfo) {
            ((CoreBaseCommonInfo)objectValue).setBOSType(BOSObjectType.create((String)bosType));
            ((CoreBaseCommonInfo)objectValue).setPKField("id");
        } else if (objectValue instanceof ObjectBaseCommonInfo) {
            ((ObjectBaseCommonInfo)objectValue).setBOSType(BOSObjectType.create((String)bosType));
            ((ObjectBaseCommonInfo)objectValue).setPKField("id");
        } else if (objectValue instanceof DataBaseCommonInfo) {
            ((DataBaseCommonInfo)objectValue).setBOSType(BOSObjectType.create((String)bosType));
            ((DataBaseCommonInfo)objectValue).setPKField("id");
        } else if (objectValue instanceof CoreBillBaseCommonInfo) {
            ((CoreBillBaseCommonInfo)objectValue).setBOSType(BOSObjectType.create((String)bosType));
            ((CoreBillBaseCommonInfo)objectValue).setPKField("id");
        } else if (objectValue instanceof TreeBaseCommonInfo) {
            ((TreeBaseCommonInfo)objectValue).setBOSType(BOSObjectType.create((String)bosType));
            ((TreeBaseCommonInfo)objectValue).setPKField("id");
        } else if (objectValue instanceof CoreBillBaseCustomInfo) {
            ((CoreBillBaseCustomInfo)objectValue).setBOSType(BOSObjectType.create((String)bosType));
            ((CoreBillBaseCustomInfo)objectValue).setPKField("id");
        }
        return objectValue;
    }

    public static IObjectValue loadObjectValue(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("id");
        IObjectValue objectValue = DAOHelper.getDAO().load(ctx, id, sic);
        String bosType = BOSUuid.read((String)id).getType().toString();
        if (objectValue instanceof BillBaseCommonInfo) {
            ((BillBaseCommonInfo)objectValue).setBOSType(BOSObjectType.create((String)bosType));
            ((BillBaseCommonInfo)objectValue).setPKField("id");
        } else if (objectValue instanceof CoreBaseCommonInfo) {
            ((CoreBaseCommonInfo)objectValue).setBOSType(BOSObjectType.create((String)bosType));
            ((CoreBaseCommonInfo)objectValue).setPKField("id");
        } else if (objectValue instanceof ObjectBaseCommonInfo) {
            ((ObjectBaseCommonInfo)objectValue).setBOSType(BOSObjectType.create((String)bosType));
            ((ObjectBaseCommonInfo)objectValue).setPKField("id");
        } else if (objectValue instanceof DataBaseCommonInfo) {
            ((DataBaseCommonInfo)objectValue).setBOSType(BOSObjectType.create((String)bosType));
            ((DataBaseCommonInfo)objectValue).setPKField("id");
        } else if (objectValue instanceof CoreBillBaseCommonInfo) {
            ((CoreBillBaseCommonInfo)objectValue).setBOSType(BOSObjectType.create((String)bosType));
            ((CoreBillBaseCommonInfo)objectValue).setPKField("id");
        } else if (objectValue instanceof TreeBaseCommonInfo) {
            ((TreeBaseCommonInfo)objectValue).setBOSType(BOSObjectType.create((String)bosType));
            ((TreeBaseCommonInfo)objectValue).setPKField("id");
        } else if (objectValue instanceof CoreBillBaseCustomInfo) {
            ((CoreBillBaseCustomInfo)objectValue).setBOSType(BOSObjectType.create((String)bosType));
            ((CoreBillBaseCustomInfo)objectValue).setPKField("id");
        }
        return objectValue;
    }

    public static void modifyState(Context ctx, String billId, WorkflowStatus workflowStatus) throws EASBizException, BOSException {
        IObjectValue objValue = CommonUtil.loadObjectValue(ctx, billId);
        objValue.put("workflowStatus", (Object)new Integer(workflowStatus.getValue()));
        DAOHelper.getDAO().update(ctx, objValue);
        String oql = "select * where sourcePK='" + billId + "'";
        IDocumentInfo documentService = DocumentInfoFactory.getLocalInstance((Context)ctx);
        DocumentInfoInfo docInfo = documentService.getDocumentInfoInfo(oql);
        docInfo.setWorkflowStatus(workflowStatus);
        docInfo.setRequestTime((Date)new Timestamp(new Date().getTime()));
        documentService.update((IObjectPK)new ObjectUuidPK(docInfo.getId()), (CoreBaseInfo)docInfo);
    }

    public static Map sortByKey(Map map, final boolean reverse) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (reverse) {
                    return -((Comparable)((Map.Entry)o1).getKey()).compareTo(((Map.Entry)o2).getKey());
                }
                return ((Comparable)((Map.Entry)o1).getKey()).compareTo(((Map.Entry)o2).getKey());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Map sortByValue(Map map, final boolean reverse) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (reverse) {
                    return -((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue());
                }
                return ((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static String formatDate2String(Date date, String format) {
        if (StringUtils.isBlank((String)format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String result = sdf.format(date);
        return result;
    }

    public static ArrayList getMyCompletedProcess(Context ctx, Locale language, int pageCount, int pageNumber, String quickSearchSubject, String sortName, String sortType, String userID) throws BOSException, EASBizException {
        if (userID == null) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (userInfo == null) {
                return null;
            }
            userID = userInfo.getId().toString();
        }
        ArrayList<Object> list = null;
        Locale locale = ctx != null ? ctx.getLocale() : null;
        StringBuffer strCountSql = new StringBuffer();
        StringBuffer strSql = new StringBuffer();
        Object[] params = new String[]{userID};
        String strProcdefName = "FPROCDEFNAME_" + language.toString();
        String strInitiatorName = "FINITIATORNAME_" + language.toString();
        String strFPROCINSTTOPIC_ = "FPROCINSTTOPIC_" + language.toString();
        if (pageCount < 1) {
            pageCount = 1;
        }
        if (pageNumber < 1) {
            pageNumber = 20;
        }
        String filterTitle = "";
        if (null != quickSearchSubject && quickSearchSubject.length() != 0) {
            filterTitle = " and " + strFPROCINSTTOPIC_ + " like '%" + quickSearchSubject + "%' ";
        }
        strCountSql.append(" select count(*) NUM from t_wfr_procinstref a,T_WFR_PROCINST b  where a.FPROCINSTID = b.FPROCINSTID and a.ftype=1 and  (b.FSTATE = '");
        strCountSql.append("closed.completed");
        strCountSql.append("' or b.FSTATE = '");
        strCountSql.append("closed.terminated");
        strCountSql.append("' or b.FSTATE = '");
        strCountSql.append("closed");
        strCountSql.append("' or b.FSTATE = '");
        strCountSql.append("closed.aborted");
        strCountSql.append("') and b.FINITIATORID=?");
        strCountSql.append(filterTitle);
        strSql.append(" select TOP ").append(pageCount * pageNumber).append(" b.FPROCINSTID,b.").append(strProcdefName).append(", b.").append(strFPROCINSTTOPIC_).append(",b.FCREATEDTIME,b.FCOMLETETIME, b.FSTATE, a.frefid billId");
        strSql.append(" from t_wfr_procinstref a,T_WFR_PROCINST b  where a.FPROCINSTID = b.FPROCINSTID and a.ftype=1 and  (b.FSTATE = '");
        strSql.append("closed.completed");
        strSql.append("' or b.FSTATE = '");
        strSql.append("closed.terminated");
        strSql.append("' or b.FSTATE = '");
        strSql.append("closed");
        strSql.append("' or b.FSTATE = '");
        strSql.append("closed.aborted");
        strSql.append("') and b.FINITIATORID=?");
        strSql.append(filterTitle);
        if (sortName == null || sortName.length() == 0) {
            sortName = "b.FCOMLETETIME";
        }
        if (sortName.startsWith("b.FPROCDEFNAME_")) {
            sortName = "convert(varchar," + sortName + ")";
        }
        if (sortType == null || sortType.length() == 0) {
            sortType = "desc";
        }
        strSql.append(" order by ").append(sortName).append(" ").append(sortType);
        logger.debug((Object)("===countSql===getProcess====" + strCountSql.toString()));
        logger.debug((Object)("===strSql===getProcess====" + strSql.toString()));
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strCountSql.toString(), (Object[])params);
            if (rowSet != null) {
                list = new ArrayList<Object>();
                if (rowSet.next()) {
                    int n = rowSet.getInt("NUM");
                    list.add("" + n);
                }
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])params)) != null) {
                int nSize = (pageCount - 1) * pageNumber;
                for (int i = 0; i < nSize; ++i) {
                    if (rowSet.next()) continue;
                    return null;
                }
                String[] strProcId = null;
                Object tmp = null;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                for (int i = 0; i < pageNumber && rowSet.next(); ++i) {
                    strProcId = new String[]{rowSet.getString("FPROCINSTID"), rowSet.getString(strProcdefName), rowSet.getString(strFPROCINSTTOPIC_), null != rowSet.getDate("FCREATEDTIME") ? df.format(rowSet.getDate("FCREATEDTIME")) : "", null != rowSet.getDate("FCOMLETETIME") ? df.format(rowSet.getDate("FCOMLETETIME")) : "", WfState.getEnum((String)rowSet.getString("FSTATE")).getAlias(), rowSet.getString("billId")};
                    for (int j = 0; j < 7; ++j) {
                        if (strProcId[j] != null) continue;
                        strProcId[j] = "";
                    }
                    if (list == null) continue;
                    list.add(strProcId);
                }
            }
        }
        catch (Exception sqlException) {
            logger.info((Object)("\u83b7\u5f97\u6211\u7684\u5728\u529e\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f:" + sqlException.getMessage()));
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, (Throwable)sqlException);
        }
        return list;
    }

    private static String getMyAuditCountSql(String filterTitle, String moduleType) {
        StringBuffer strCountSql = new StringBuffer();
        strCountSql.append("select count(*) NUM from T_WFR_AssignDetail with(ReadPast) where FIsSendMsg=1");
        strCountSql.append(" and (FSTATE = ");
        strCountSql.append(4);
        strCountSql.append(" or FSTATE = ");
        strCountSql.append(8);
        strCountSql.append(" or FSTATE = ");
        strCountSql.append(16);
        strCountSql.append(")");
        strCountSql.append(" and FPERSONUSERID=?");
        strCountSql.append(filterTitle);
        if (null != moduleType && !"".equals(moduleType)) {
            strCountSql.append(" and (fbizpackage like '").append(moduleType).append(".%'").append(" or fbillentity like '").append(moduleType).append(".%')");
        }
        return strCountSql.toString();
    }

    private static String getMyAuditRecordsSql(int pageCount, int pageNumber, Locale language, String FSUBJECT_, String filterTitle, String moduleType) {
        String FInitiatorName_ = "FInitiatorName_" + language.toString();
        StringBuffer strSql = new StringBuffer();
        strSql.append("select TOP ").append(pageCount * pageNumber).append(" FASSIGNID as FID, 10 as FType, 0 as FBizType,").append(FInitiatorName_).append(",FPriority,10 as FStatus, FSTATE,").append(FSUBJECT_).append(",FCREATEDTIME as createdTime,FCREATEDTIME, FASSIGNID, FPERSONUSERID, FENDTIME from T_WFR_AssignDetail with(ReadPast) where FIsSendMsg=1");
        strSql.append(" and (FSTATE = ");
        strSql.append(4);
        strSql.append(" or FSTATE = ");
        strSql.append(8);
        strSql.append(" or FSTATE = ");
        strSql.append(16);
        strSql.append(")");
        strSql.append(" and FPERSONUSERID=?");
        strSql.append(filterTitle);
        if (null != moduleType && !"".equals(moduleType)) {
            strSql.append(" and (fbizpackage like '").append(moduleType).append(".%'").append(" or fbillentity like '").append(moduleType).append(".%')");
        }
        return strSql.toString();
    }

    private static ArrayList getMyAuditList(Context ctx, String strCountSql, String[] params, String strSql, int pageCount, int pageNumber, Locale locale) throws ProcCatalogException {
        ArrayList<Object> list = null;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strCountSql.toString(), (Object[])params);
            if (rowSet != null) {
                list = new ArrayList<Object>();
                if (rowSet.next()) {
                    int n = rowSet.getInt("NUM");
                    list.add("" + n);
                }
            }
            if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql.toString(), (Object[])params)) != null) {
                int nSize = (pageCount - 1) * pageNumber;
                for (int i = 0; i < nSize; ++i) {
                    if (rowSet.next()) continue;
                    return null;
                }
                String[] strProcId = null;
                Object tmp = null;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                int state = 0;
                String strState = "";
                for (int i = 0; i < pageNumber && rowSet.next(); ++i) {
                    strProcId = new String[8];
                    strProcId[0] = rowSet.getString(1);
                    strProcId[1] = rowSet.getString(4);
                    strProcId[2] = rowSet.getString(8);
                    strProcId[3] = null != rowSet.getDate(10) ? df.format(rowSet.getDate(10)) : "";
                    strProcId[4] = rowSet.getString(11);
                    state = rowSet.getInt(7);
                    if (state == 4 || state == 8 || state == 16) {
                        switch (state) {
                            case 4: {
                                strState = MsgSourceStatus.CANCELED.getAlias(locale);
                                break;
                            }
                            case 8: {
                                strState = MsgSourceStatus.REJECTED.getAlias(locale);
                                break;
                            }
                            case 16: {
                                strState = MsgSourceStatus.COMPLETED.getAlias(locale);
                                break;
                            }
                            default: {
                                strState = MsgSourceStatus.EMPTY.getAlias(locale);
                            }
                        }
                    }
                    strProcId[5] = strState;
                    strProcId[6] = "";
                    if (rowSet.getDate(13) != null) {
                        strProcId[7] = df.format(rowSet.getDate(13));
                    }
                    for (int j = 0; j < 8; ++j) {
                        if (strProcId[j] != null) continue;
                        strProcId[j] = "";
                    }
                    if (list == null) continue;
                    list.add(strProcId);
                }
            }
        }
        catch (Exception sqlException) {
            logger.info((Object)("\u83b7\u5f97\u6211\u7684\u5df2\u5ba1\u6279\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f:" + sqlException.getMessage()));
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, (Throwable)sqlException);
        }
        return list;
    }

    public static ArrayList getMyAuditProcess(Context ctx, Locale language, int pageCount, int pageNumber, String quickSearchSubject, String sortName, String sortType, String userID) throws BOSException, EASBizException {
        if (userID == null) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (userInfo == null) {
                return null;
            }
            userID = userInfo.getId().toString();
        }
        Locale locale = ctx != null ? ctx.getLocale() : null;
        StringBuffer strCountSql = new StringBuffer();
        StringBuffer strSql = new StringBuffer();
        String[] params = new String[]{userID};
        String FSUBJECT_ = "FSUBJECT_" + language.toString();
        String FInitiatorName_ = "FInitiatorName_" + language.toString();
        if (pageCount < 1) {
            pageCount = 1;
        }
        if (pageNumber < 1) {
            pageNumber = 20;
        }
        String filterTitle = "";
        if (null != quickSearchSubject && quickSearchSubject.length() != 0) {
            filterTitle = " and " + FSUBJECT_ + " like '%" + quickSearchSubject + "%' ";
        }
        strCountSql.append("select count(*) NUM from T_WFR_AssignDetail with(ReadPast) where FIsSendMsg=1");
        strCountSql.append(" and (FSTATE = ");
        strCountSql.append(4);
        strCountSql.append(" or FSTATE = ");
        strCountSql.append(8);
        strCountSql.append(" or FSTATE = ");
        strCountSql.append(16);
        strCountSql.append(")");
        strCountSql.append(" and FPERSONUSERID=?");
        strCountSql.append(filterTitle);
        strSql.append("select TOP ").append(pageCount * pageNumber).append(" FASSIGNID as FID, 10 as FType, 0 as FBizType,").append(FInitiatorName_).append(",FPriority,10 as FStatus, FSTATE,").append(FSUBJECT_).append(",FCREATEDTIME as createdTime,FCREATEDTIME, FASSIGNID, FPERSONUSERID, FENDTIME from T_WFR_AssignDetail with(ReadPast) where FIsSendMsg=1");
        strSql.append(" and (FSTATE = ");
        strSql.append(4);
        strSql.append(" or FSTATE = ");
        strSql.append(8);
        strSql.append(" or FSTATE = ");
        strSql.append(16);
        strSql.append(")");
        strSql.append(" and FPERSONUSERID=?");
        strSql.append(filterTitle);
        if (sortName == null || sortName.length() == 0) {
            sortName = "FENDTIME";
        }
        if (sortType == null || sortType.length() == 0) {
            sortType = "desc";
        }
        strSql.append(" order by ").append(sortName).append(" ").append(sortType);
        logger.debug((Object)("===countSql===getProcess====" + strCountSql.toString()));
        logger.debug((Object)("===strSql===getProcess====" + strSql.toString()));
        ArrayList list = CommonUtil.getMyAuditList(ctx, strCountSql.toString(), params, strSql.toString(), pageCount, pageNumber, locale);
        return list;
    }

    public static ArrayList getMyAuditProcess(Context ctx, Locale language, int pageCount, int pageNumber, String quickSearchSubject, String sortName, String sortType, String userID, String moduleType) throws BOSException, EASBizException {
        if (userID == null) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (userInfo == null) {
                return null;
            }
            userID = userInfo.getId().toString();
        }
        Locale locale = ctx != null ? ctx.getLocale() : null;
        StringBuffer strCountSql = new StringBuffer();
        StringBuffer strSql = new StringBuffer();
        String[] params = new String[]{userID};
        String FSUBJECT_ = "FSUBJECT_" + language.toString();
        String FInitiatorName_ = "FInitiatorName_" + language.toString();
        if (pageCount < 1) {
            pageCount = 1;
        }
        if (pageNumber < 1) {
            pageNumber = 20;
        }
        String filterTitle = "";
        if (null != quickSearchSubject && quickSearchSubject.length() != 0) {
            filterTitle = " and " + FSUBJECT_ + " like '%" + quickSearchSubject + "%' ";
        }
        strCountSql.append(CommonUtil.getMyAuditCountSql(filterTitle, moduleType));
        strSql.append(CommonUtil.getMyAuditRecordsSql(pageCount, pageNumber, language, FSUBJECT_, filterTitle, moduleType));
        if (sortName == null || sortName.length() == 0) {
            sortName = "FENDTIME";
        }
        if (sortType == null || sortType.length() == 0) {
            sortType = "desc";
        }
        strSql.append(" order by ").append(sortName).append(" ").append(sortType);
        ArrayList list = CommonUtil.getMyAuditList(ctx, strCountSql.toString(), params, strSql.toString(), pageCount, pageNumber, locale);
        return list;
    }
}

