/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.formularengine;

import com.kingdee.bos.bi.model.common.formularengine.expr.AbstractExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.CompositeExpr;
import com.kingdee.bos.bi.model.common.formularengine.expr.VarExpr;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FormularsLevelSortor {
    private List _vars = new ArrayList();
    private String[] _sortedVarNames;

    public void addVar(String varName, AbstractExpr expr) {
        this._vars.add(new VarWrapper(varName, expr));
    }

    public void sort() {
        int c = this._vars.size();
        for (int i = 0; i < c; ++i) {
            VarWrapper vw = (VarWrapper)this._vars.get(i);
            if (vw.getLevel() >= 0) continue;
            this.confirmLevel(vw);
        }
        Object[] vws = this._vars.toArray(new VarWrapper[0]);
        Arrays.sort(vws);
        this._sortedVarNames = new String[vws.length];
        for (int i = 0; i < this._sortedVarNames.length; ++i) {
            this._sortedVarNames[i] = ((VarWrapper)vws[i]).getVarName();
        }
    }

    public String[] getSortedVars() {
        return this._sortedVarNames;
    }

    private void pickAllVarsAtExpr(AbstractExpr expr, List result) {
        if (expr instanceof VarExpr) {
            result.add(expr);
        } else if (expr instanceof CompositeExpr) {
            this.pickAllVarsAtExpr(((CompositeExpr)expr).getLeftExpr(), result);
            this.pickAllVarsAtExpr(((CompositeExpr)expr).getRightExpr(), result);
        }
    }

    private int confirmLevel(VarWrapper vw) {
        AbstractExpr expr = vw.getExpr();
        if (vw.getLevel() == -100) {
            throw new RuntimeException("\u516c\u5f0f\u5b58\u5728\u76f8\u4e92\u4f9d\u8d56\uff1a" + vw.getVarName() + " = " + expr.getExprString());
        }
        if (expr == null) {
            vw.setLevel(0);
        } else {
            vw.setLevel(-100);
            ArrayList allVarsAtExpr = new ArrayList();
            this.pickAllVarsAtExpr(expr, allVarsAtExpr);
            int maxLevel = -1;
            int c = allVarsAtExpr.size();
            for (int i = 0; i < c; ++i) {
                int level;
                VarExpr varExpr = (VarExpr)allVarsAtExpr.get(i);
                String varName = varExpr.getVarName();
                if (varName.startsWith("[") && varName.endsWith("]")) {
                    varName = varName.substring(1, varName.length() - 1);
                }
                if ((level = this.getRelativeLevel(varName)) <= maxLevel) continue;
                maxLevel = level;
            }
            vw.setLevel(maxLevel + 1);
        }
        return vw.getLevel();
    }

    private int getRelativeLevel(String varName) {
        int c = this._vars.size();
        for (int i = 0; i < c; ++i) {
            VarWrapper vw = (VarWrapper)this._vars.get(i);
            if (!StringUtil.equals((String)varName, (String)vw.getVarName())) continue;
            if (vw.getLevel() >= 0) {
                return vw.getLevel();
            }
            return this.confirmLevel(vw);
        }
        return 0;
    }

    private static class VarWrapper
    implements Comparable {
        private String _var;
        private int _level = -1;
        private AbstractExpr _expr;

        public VarWrapper(String varName, AbstractExpr expr) {
            this._var = varName;
            this._expr = expr;
        }

        public String getVarName() {
            return this._var;
        }

        public int getLevel() {
            return this._level;
        }

        public void setLevel(int level) {
            this._level = level;
        }

        public AbstractExpr getExpr() {
            return this._expr;
        }

        public int compareTo(Object obj) {
            VarWrapper another = (VarWrapper)obj;
            return this.getLevel() - another.getLevel();
        }
    }
}

