/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.formularengine.oper;

import com.kingdee.bos.bi.model.common.formularengine.exception.DivisorZeroException;
import com.kingdee.bos.bi.model.common.formularengine.exception.FormulaComputingException;
import com.kingdee.bos.bi.model.common.formularengine.oper.AbstractOper;
import com.kingdee.bos.bi.model.common.formularengine.oper.IDualisticOper;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;

public class DualisticOper
extends AbstractOper
implements IDualisticOper {
    public static DualisticOper PLUS = new DualisticOper("+", 1, "\uff0b");
    public static DualisticOper MINUS = new DualisticOper("-", 1, "\uff0d");
    public static DualisticOper MULTIPLY = new DualisticOper("*", 2, "\u00d7");
    public static DualisticOper DIVIDE = new DualisticOper("/", 2, "\u00f7");

    protected DualisticOper(String key, int priority, String display) {
        super(key, priority, display);
    }

    @Override
    public Variant computing(Variant leftValue, Variant rightValue) throws FormulaComputingException {
        Variant result;
        block8: {
            if (!leftValue.isNumeric() || !rightValue.isNumeric()) {
                throw new FormulaComputingException("\u53c2\u4e0e\u8fd0\u7b97\u7684\u503c\u4e0d\u662f\u6570\u5b57\uff1a" + leftValue + " " + this.getOperString() + " " + rightValue);
            }
            result = new Variant(0);
            try {
                if (this == PLUS) {
                    leftValue.add(rightValue, result);
                    break block8;
                }
                if (this == MINUS) {
                    leftValue.subtract(rightValue, result);
                    break block8;
                }
                if (this == MULTIPLY) {
                    leftValue.multiply(rightValue, result);
                    break block8;
                }
                if (this == DIVIDE) {
                    if (rightValue.doubleValue() == 0.0) {
                        throw new DivisorZeroException();
                    }
                    leftValue.divide(rightValue, result);
                    break block8;
                }
                throw new FormulaComputingException("\u4e0d\u53ef\u8bc6\u522b\u7684\u8fd0\u7b97\u7c7b\u578b\uff1a" + this.getOperString());
            }
            catch (SyntaxErrorException ex) {
                throw new FormulaComputingException(ex);
            }
        }
        return result;
    }
}

