/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.condition;

import com.kingdee.eas.dynbusiness.condition.ColumnItem;
import com.kingdee.eas.dynbusiness.expression.ExpressionExecutor;
import com.kingdee.eas.dynbusiness.expression.ExpressionToken;
import com.kingdee.eas.dynbusiness.expression.IllegalExpressionException;
import com.kingdee.eas.dynbusiness.expression.VariableContainer;
import com.kingdee.eas.dynbusiness.expression.datameta.BaseDataMeta;
import com.kingdee.eas.dynbusiness.expression.datameta.Constant;
import com.kingdee.eas.dynbusiness.expression.datameta.Reference;
import com.kingdee.eas.dynbusiness.expression.datameta.Variable;
import com.kingdee.eas.dynbusiness.expression.op.Operator;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import com.kingdee.eas.dynbusiness.util.SortUtil;
import com.kingdee.eas.dynbusiness.util.ValueConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;

public final class ColumnExpressionParser {
    private ColumnItem item;
    private boolean isToSum;

    public ColumnExpressionParser(ColumnItem item) {
        this.item = item;
    }

    public void setToSum(boolean isToSum) {
        this.isToSum = isToSum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMulOrDivOperationForColumn() throws IllegalExpressionException {
        if (this.item.name == null) {
            return false;
        }
        String expression = this.item.name.trim();
        try {
            List expTokens = this.parseExpression(expression);
            boolean bl = this.hasMulOrDivOperationForColumn(expTokens);
            return bl;
        }
        finally {
            VariableContainer.removeVariableMap();
        }
    }

    private List parseExpression(String expression) throws IllegalExpressionException {
        ExpressionParser exprParser = ExpressionParser.getInstance();
        String[] vars = exprParser.splitVariables(expression);
        for (int i = 0; i < vars.length; ++i) {
            VariableContainer.addVariable(Variable.createVariable(vars[i], ValueConstants.ZERO));
        }
        ExpressionExecutor ee = new ExpressionExecutor();
        List expTokens = ee.analyze(expression);
        expTokens = ee.compile(expTokens);
        return expTokens;
    }

    private boolean hasMulOrDivOperationForColumn(List expTokens) throws IllegalExpressionException {
        Stack<ExpressionToken> compileStack = new Stack<ExpressionToken>();
        for (ExpressionToken expToken : expTokens) {
            if (ExpressionToken.ETokenType.ETOKEN_TYPE_CONSTANT == expToken.getTokenType()) {
                compileStack.push(expToken);
                continue;
            }
            if (ExpressionToken.ETokenType.ETOKEN_TYPE_VARIABLE == expToken.getTokenType()) {
                compileStack.push(expToken);
                continue;
            }
            if (ExpressionToken.ETokenType.ETOKEN_TYPE_OPERATOR == expToken.getTokenType()) {
                Operator operator = expToken.getOperator();
                int opType = operator.getOpType();
                ExpressionToken[] args = new ExpressionToken[opType];
                ExpressionToken argToken = null;
                for (int i = 0; i < opType; ++i) {
                    if (compileStack.empty()) {
                        throw new IllegalStateException("\u64cd\u4f5c\u7b26" + operator.getToken() + "\u627e\u4e0d\u5230\u76f8\u5e94\u7684\u53c2\u6570\uff0c\u6216\u53c2\u6570\u4e2a\u6570\u4e0d\u8db3;\u4f4d\u7f6e\uff1a" + expToken.getStartPosition());
                    }
                    args[i] = argToken = (ExpressionToken)compileStack.pop();
                }
                Constant[] constants = new Constant[args.length];
                for (int i = 0; i < args.length; ++i) {
                    constants[i] = this.createVaribleConstant(args[i]);
                }
                if ((operator.equals(Operator.MUTI) || operator.equals(Operator.DIV)) && (this.isBigDecimalVariable(args[0], constants[0]) || this.isBigDecimalVariable(args[1], constants[1]))) {
                    return true;
                }
                Reference ref = new Reference(expToken, constants);
                ExpressionToken resultToken = ExpressionToken.createReference(ref);
                compileStack.push(resultToken);
                continue;
            }
            if (ExpressionToken.ETokenType.ETOKEN_TYPE_SPLITOR != expToken.getTokenType()) continue;
            compileStack.push(expToken);
        }
        return false;
    }

    private Constant createVaribleConstant(ExpressionToken expToken) {
        if (ExpressionToken.ETokenType.ETOKEN_TYPE_VARIABLE != expToken.getTokenType()) {
            return expToken.getConstant();
        }
        Variable varWithValue = VariableContainer.getVariable(expToken.getVariable().getVariableName());
        if (varWithValue != null) {
            Constant c = new Constant(varWithValue.getDataType(), varWithValue.getDataValue());
            c.setFromVariable(true);
            return c;
        }
        throw new IllegalStateException("\u53d8\u91cf\"" + expToken.getVariable().getVariableName() + "\"\u4e0d\u662f\u4e0a\u4e0b\u6587\u5408\u6cd5\u53d8\u91cf");
    }

    private boolean isBigDecimalVariable(ExpressionToken expToken, Constant constant) {
        boolean isVariable;
        boolean isBigDecimal = this.isBigDecimalType(constant);
        if (!isBigDecimal) {
            return false;
        }
        boolean bl = isVariable = ExpressionToken.ETokenType.ETOKEN_TYPE_VARIABLE == expToken.getTokenType();
        if (isVariable) {
            return true;
        }
        if (expToken.getConstant() != null && expToken.getConstant().isReference()) {
            Constant[] constants = expToken.getConstant().getReference().getArgs();
            for (int i = 0; i < constants.length; ++i) {
                Constant c = constants[i];
                isVariable = c.isFromVariable();
                if (!isVariable) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBigDecimalType(Constant constant) {
        return BaseDataMeta.DataType.DATATYPE_BIGDECIMAL.equals(constant.getDataType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String parseColumnPression() throws IllegalExpressionException {
        if (this.item.name == null) {
            return null;
        }
        String expression = this.item.name.trim();
        try {
            List expTokens = this.parseExpression(expression);
            String string = this.attachColumnPressionExpression(expTokens);
            return string;
        }
        finally {
            VariableContainer.removeVariableMap();
        }
    }

    private String attachColumnPressionExpression(List expTokens) throws IllegalExpressionException {
        boolean convertToBase = this.item.isConvertToBase();
        ArrayList<Integer> left = new ArrayList<Integer>();
        ArrayList<Integer> right = new ArrayList<Integer>();
        TreeSet<ExpressionToken> varList = new TreeSet<ExpressionToken>();
        Stack<ExpressionToken> compileStack = new Stack<ExpressionToken>();
        for (ExpressionToken expToken : expTokens) {
            if (ExpressionToken.ETokenType.ETOKEN_TYPE_CONSTANT == expToken.getTokenType()) {
                compileStack.push(expToken);
                continue;
            }
            if (ExpressionToken.ETokenType.ETOKEN_TYPE_VARIABLE == expToken.getTokenType()) {
                compileStack.push(expToken);
                varList.add(expToken);
                continue;
            }
            if (ExpressionToken.ETokenType.ETOKEN_TYPE_OPERATOR == expToken.getTokenType()) {
                Operator operator = expToken.getOperator();
                int opType = operator.getOpType();
                ExpressionToken[] args = new ExpressionToken[opType];
                ExpressionToken argToken = null;
                for (int i = 0; i < opType; ++i) {
                    if (compileStack.empty()) {
                        throw new IllegalStateException("\u64cd\u4f5c\u7b26" + operator.getToken() + "\u627e\u4e0d\u5230\u76f8\u5e94\u7684\u53c2\u6570\uff0c\u6216\u53c2\u6570\u4e2a\u6570\u4e0d\u8db3;\u4f4d\u7f6e\uff1a" + expToken.getStartPosition());
                    }
                    args[i] = argToken = (ExpressionToken)compileStack.pop();
                }
                Constant[] constants = new Constant[args.length];
                for (int i = 0; i < args.length; ++i) {
                    constants[i] = this.createVaribleConstant(args[i]);
                }
                if ((operator.equals(Operator.MUTI) || operator.equals(Operator.DIV)) && (this.isBigDecimalVariable(args[0], constants[0]) || this.isBigDecimalVariable(args[1], constants[1]))) {
                    left.add(new Integer(expToken.getStartPosition()));
                    right.add(new Integer(expToken.getEndPosition()));
                }
                Reference ref = new Reference(expToken, constants);
                ExpressionToken resultToken = ExpressionToken.createReference(ref);
                compileStack.push(resultToken);
                continue;
            }
            if (ExpressionToken.ETokenType.ETOKEN_TYPE_SPLITOR != expToken.getTokenType()) continue;
            compileStack.push(expToken);
        }
        StringBuffer sb = new StringBuffer();
        Object[] sleft = SortUtil.sortArrayByIntValue(left.toArray(), true);
        Object[] sright = SortUtil.sortArrayByIntValue(right.toArray(), true);
        ExpressionToken[] vars = varList.toArray(new ExpressionToken[varList.size()]);
        String expression = this.item.name.trim();
        int idxLeft = 0;
        int idxRight = 0;
        int idx = 0;
        int idxVar = 0;
        int length = expression.length();
        int iLeft = 0;
        int iRight = 0;
        int iVar = 0;
        while (idx <= length) {
            iVar = idxVar < vars.length ? vars[idxVar].getStartPosition() : Integer.MAX_VALUE;
            int cr = this.whichIsMin(iVar, iLeft = idxLeft < sleft.length ? (Integer)sleft[idxLeft] : Integer.MAX_VALUE, iRight = idxRight < sright.length ? (Integer)sright[idxRight] : Integer.MAX_VALUE);
            if (cr == 0) {
                String var = vars[idxVar].getVariable().getVariableName();
                sb.append(expression.substring(idx, iVar));
                if (iVar == iLeft) {
                    sb.append(this.item.TRANSFUNC_PREFIX);
                    ++idxLeft;
                }
                sb.append(this.item.getRealExpression(var, this.isToSum, convertToBase));
                if (iVar == iRight) {
                    sb.append(this.item.TRANSFUNC_POSTFIX);
                    ++idxRight;
                }
                idx = iVar + var.length();
                ++idxVar;
            } else if (cr == 1) {
                sb.append(expression.substring(idx, iLeft));
                sb.append(this.item.TRANSFUNC_PREFIX);
                ++idxLeft;
                idx = iLeft;
            } else if (iRight != Integer.MAX_VALUE) {
                sb.append(expression.substring(idx, iRight + 1));
                sb.append(this.item.TRANSFUNC_POSTFIX);
                ++idxRight;
                idx = iRight + 1;
            }
            if (idxVar < vars.length || idxLeft < sleft.length || idxRight < sright.length) continue;
            break;
        }
        if (idx < length) {
            sb.append(expression.substring(idx));
        }
        return sb.toString();
    }

    private int whichIsMin(int iVar, int iLeft, int iRight) {
        if (iVar < iLeft) {
            return iVar < iRight ? 0 : 2;
        }
        return iLeft < iRight ? 1 : 2;
    }
}

