/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBusinessBatchBuild;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.IBusinessConfigItem;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.config.ActionItemList;
import com.kingdee.eas.dynbusiness.config.BOTProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.BOTProcessConfigItems;
import com.kingdee.eas.dynbusiness.config.BOTSourceItem;
import com.kingdee.eas.dynbusiness.config.BusinessProcessConfigItem;
import com.kingdee.eas.dynbusiness.config.ValueMappingItem;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.InitializationHelper;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class BOTProcessSubItem
implements IBusinessBatchHandle,
IBusinessBatchBuild,
IBusinessConfigItem {
    static final Logger logger = Logger.getLogger(BOTProcessSubItem.class);
    private String id;
    private String botMappingId;
    private BOSObjectType dstBosType;
    private Conditions preCondition;
    private ValueMappingItem mappingItem;
    private ActionItemList actionItems;
    private BOTProcessConfigItem parent;
    private BOTSourceItem sourceItem;
    private int seq;
    private String botResultCondition;
    private boolean isCheckFirst = false;
    private BOTProcessSubItem nextSubItem;
    private boolean isInitialized = false;
    private List selectorList;
    private boolean isTransform = true;

    public BOSObjectType getSrcBosType() {
        if (this.sourceItem.getKey() != null) {
            return this.parent.getDstBosType(this.sourceItem.getKey());
        }
        return BOSObjectType.create((String)this.parent.getParent().getBosType());
    }

    public void setTransform(boolean isTransform) {
        this.isTransform = isTransform;
    }

    public void setActionItems(ActionItemList actionItems) {
        this.actionItems = actionItems;
    }

    public String getBotMappingId() {
        return this.botMappingId;
    }

    public BOSObjectType getDstBosType() {
        return this.dstBosType;
    }

    public String getId() {
        return this.id;
    }

    public BOTProcessSubItem(BOTProcessConfigItem parent, String id, String botMappingId, BOSObjectType dstBosType) {
        this.parent = parent;
        this.id = id;
        this.botMappingId = botMappingId;
        this.dstBosType = dstBosType;
    }

    public Conditions getPreCondition() {
        return this.preCondition;
    }

    public void setPreCondition(Conditions preCondition) {
        this.preCondition = preCondition;
    }

    @Override
    public void handle(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (!this.isInitialized) {
            this.build(ctx);
        }
        if (!this.estimateConditionResult(batchResults)) {
            return;
        }
        IObjectCollection dataSources = null;
        List<IObjectCollection> sources = null;
        if (this.isTransform) {
            sources = this.sourceItem.loadSourceData(ctx, batchResults);
        } else {
            sources = new ArrayList(1);
            sources.add(batchResults.getObjCollection());
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (sources == null || sources.size() == 0) {
            return;
        }
        paramMap.put("_CTX", ctx);
        paramMap.put("_ENTRISENAME", BusinessProcessUtil.getEntityEntriesName(ctx, this.dstBosType));
        int size = sources.size();
        for (int idxOfSources = 0; idxOfSources < size; ++idxOfSources) {
            dataSources = (IObjectCollection)sources.get(idxOfSources);
            if (dataSources == null) continue;
            if (this.getSourceKey() != null) {
                BTPTransformResult srcTransformResult = batchResults.getTransformResult(this.getSourceKey());
                srcTransformResult.setBills(dataSources);
            } else {
                batchResults.setObjCollection(dataSources);
            }
            if (this.seq == 0 && !this.parent.preCondition(ctx, this, dataSources)) continue;
            this.sourceItem.prepareData(ctx, batchResults);
            CoreBillBaseCollection billCollection = new CoreBillBaseCollection();
            for (IObjectValue objValue : dataSources) {
                if (this.getPreCondition() != null && !this.getPreCondition().calculateResult(objValue, 0, paramMap, null)) continue;
                billCollection.add((CoreBillBaseInfo)objValue);
            }
            if (billCollection.size() == 0) continue;
            BTPTransformResult transformResult = null;
            if (this.isTransform) {
                IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                transformResult = this.getBotMappingId() != null ? iBTPManager.transform(billCollection, this.getDstBosType().toString(), (IObjectPK)new ObjectStringPK(this.getBotMappingId())) : iBTPManager.transform(billCollection, this.getDstBosType().toString());
            } else if (transformResult == null) {
                transformResult = new BTPTransformResult();
                transformResult.setBills(dataSources);
            }
            if (transformResult == null) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("BOT\u914d\u7f6e\u9879[" + this.parent.getName() + "]\u7684\u5b50\u9879" + this.id + "\u8f6c\u6362\u6210\u529f\uff01"));
            }
            batchResults.addTransformResult(this.getId(), transformResult);
            if (this.mappingItem != null) {
                if (this.getSourceKey() != null) {
                    BTPTransformResult srcTransformResult = batchResults.getTransformResult(this.getSourceKey());
                    srcTransformResult.setBills((IObjectCollection)billCollection);
                } else {
                    batchResults.setObjCollection((IObjectCollection)billCollection);
                }
                this.mappingItem.handle(ctx, batchResults);
            }
            if (this.actionItems == null) {
                return;
            }
            if (this.actionItems != null) {
                this.actionItems.handle(ctx, batchResults);
            }
            if (this.nextSubItem == null) continue;
            this.nextSubItem.handle(ctx, batchResults);
        }
    }

    private boolean estimateConditionResult(BatchActionResults batchResults) {
        boolean result = true;
        if (this.botResultCondition != null && this.botResultCondition.length() > 0) {
            return this.botResultCondition.equalsIgnoreCase("any") && batchResults.transformResultSize() > 0;
        }
        return result;
    }

    @Override
    public synchronized void build(Context ctx) throws BOSException {
        if (this.isInitialized) {
            return;
        }
        HashMap subEntities = new HashMap();
        this.selectorList = new ArrayList();
        BOSObjectType srcBosType = this.parent.getDstBosType(this.sourceItem.getKey());
        if (srcBosType == null) {
            this.isInitialized = true;
            return;
        }
        EntityObjectInfo srcEo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(srcBosType);
        InitializationHelper.preTreatingConds(ctx, this.preCondition, srcEo, subEntities, this.selectorList);
        this.isInitialized = true;
    }

    public List getSelectorList() {
        return this.selectorList;
    }

    public BOTProcessConfigItem getParent() {
        return this.parent;
    }

    public ValueMappingItem getMappingItem() {
        return this.mappingItem;
    }

    public void setMappingItem(ValueMappingItem mappingItem) {
        this.mappingItem = mappingItem;
    }

    public void setSourceItem(BOTSourceItem sourceItem) {
        this.sourceItem = sourceItem;
    }

    public void setCheckFirst(boolean isCheckFirst) {
        this.isCheckFirst = isCheckFirst;
    }

    public String getSourceKey() {
        return this.sourceItem.getKey();
    }

    public void setNextSubItem(BOTProcessSubItem nextSubItem) {
        this.nextSubItem = nextSubItem;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public int getSeq() {
        return this.seq;
    }

    public BOTSourceItem getSourceItem() {
        return this.sourceItem;
    }

    public void setBotResultCondition(String botResultCondition) {
        this.botResultCondition = botResultCondition;
    }

    public static BOTProcessSubItem defineBOTSubItem(String srcBosType, String dstBosType, String subItemId, String botpMapingId) {
        BusinessProcessConfigItem confItem = new BusinessProcessConfigItem();
        confItem.setBosType(srcBosType);
        BOTProcessConfigItems botItems = new BOTProcessConfigItems(ProcessorExecutionMode.MAIN);
        BOTProcessConfigItem botItem = new BOTProcessConfigItem("botp", confItem, "botp");
        BOTProcessSubItem subItem = new BOTProcessSubItem(botItem, subItemId, botpMapingId, BOSObjectType.create((String)dstBosType));
        BOTSourceItem sourceItem = new BOTSourceItem(subItem, "object");
        subItem.setSourceItem(sourceItem);
        ArrayList<BOTProcessSubItem> subBOTItems = new ArrayList<BOTProcessSubItem>();
        subBOTItems.add(subItem);
        botItem.setSubBOTItems(subBOTItems);
        botItems.add(botItem);
        confItem.setBotConfigItems(botItems);
        return subItem;
    }
}

