/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.dynbusiness.app.BusinessProcessorHelper;
import com.kingdee.eas.dynbusiness.condition.ColumnItem;
import com.kingdee.eas.dynbusiness.config.ColumnPair;
import com.kingdee.eas.dynbusiness.config.WriteBackConfigItem;
import com.kingdee.eas.dynbusiness.config.WriteBackSubItem;
import com.kingdee.eas.dynbusiness.util.ObjectListMap;
import com.kingdee.eas.dynbusiness.util.SqlBuilderHelper;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import java.util.Iterator;
import java.util.List;

public class OneToManyWriteBackSubItem
extends WriteBackSubItem {
    private String obtainDstTableDataSql;
    private String obtainSrcTableDataSql;
    private String writeBackOneByOneSql;

    public OneToManyWriteBackSubItem(WriteBackConfigItem parent, String id) {
        super(parent, id);
    }

    @Override
    public String buildWriteBackCheckSql(Context ctx) throws BOSException {
        return null;
    }

    @Override
    protected String buildDebugWriteBackDataSql(Context ctx) throws BOSException {
        return null;
    }

    @Override
    protected void buildWriteBackSqls(Context ctx) throws BOSException {
        super.buildWriteBackSqls(ctx);
        this.obtainSrcTableDataSql = this.buildObtainSrcTableDataSql(ctx);
        this.obtainDstTableDataSql = this.buildObtainDstTableDataSql(ctx);
        this.writeBackOneByOneSql = this.buildWriteBackOneByOneSql(ctx);
    }

    public ObjectListMap getVerificationPairs() {
        Iterator iter = this.columnPairs.iterator();
        ObjectListMap map = new ObjectListMap(2);
        while (iter.hasNext()) {
            ColumnPair pair = (ColumnPair)iter.next();
            if (pair.getVerificationColumn() != null) {
                if (map.containsKey(pair.getSrcColumn())) {
                    map.add(pair.getSrcColumn(), 0, pair);
                    continue;
                }
                map.put(pair.getSrcColumn(), pair);
                continue;
            }
            if (pair.getTransFromColumn() == null) continue;
            if (map.containsKey(pair.getTransFromColumn())) {
                map.add(pair.getTransFromColumn(), 1, pair);
                continue;
            }
            map.put(pair.getTransFromColumn(), new Object[]{null, pair});
        }
        ObjectListMap verificationMap = new ObjectListMap(2);
        for (Object key : map.keySet()) {
            ColumnPair pair = (ColumnPair)map.get(key, 0);
            if (pair == null) continue;
            verificationMap.put(pair.getVerificationColumn(), map.get(key));
        }
        return verificationMap;
    }

    private String buildObtainDstTableDataSql(Context ctx) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append("head");
        sb.append(".FID AS FHeadID, ");
        sb.append("entry");
        sb.append(".FID AS FEntryID, ");
        sb.append("entry");
        sb.append(".FSeq AS FSeq");
        for (ColumnPair pair : this.columnPairs) {
            sb.append(", ");
            sb.append("\r\n");
            sb.append("entry");
            sb.append(".");
            sb.append(pair.getDstColumn().getName());
        }
        sb.append("\r\n");
        sb.append("FROM ");
        sb.append(BusinessProcessorHelper.getEntryTableName((Context)ctx, (String)this.dstBillTypeId));
        sb.append(" ");
        sb.append("entry");
        sb.append("\r\n");
        sb.append("INNER JOIN ");
        sb.append(BusinessProcessorHelper.getHeadTableName((Context)ctx, (String)this.dstBillTypeId));
        sb.append(" ");
        sb.append("head");
        sb.append(" ON ");
        sb.append("head");
        sb.append(".FID=");
        sb.append("entry");
        sb.append(".FParentID ");
        sb.append("\r\n");
        sb.append("WHERE ");
        sb.append("entry");
        sb.append(".FID IN(");
        sb.append("???");
        sb.append(")");
        return sb.toString();
    }

    private String buildObtainSrcTableDataSql(Context ctx) throws BOSException {
        List sortColumns;
        String srcBillId0 = null;
        srcBillId0 = (String)this.getSrcBillIds().get(0);
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append("src");
        sb.append(".FID AS FHeadID, ");
        sb.append("srce");
        sb.append(".FID AS FEntryID");
        for (ColumnPair pair : this.columnPairs) {
            sb.append(", ");
            sb.append("\r\n");
            sb.append("srce");
            sb.append(".");
            sb.append(pair.getSrcColumn());
            if (pair.getVerificationColumn() == null) continue;
            sb.append(", ");
            sb.append("\r\n");
            sb.append("srce");
            sb.append(".");
            sb.append(pair.getVerificationColumn());
        }
        sb.append("\r\n");
        sb.append("FROM ");
        sb.append(BusinessProcessorHelper.getEntryTableName((Context)ctx, (String)srcBillId0));
        sb.append(" ");
        sb.append("srce");
        sb.append("\r\n");
        sb.append("INNER JOIN ");
        sb.append(BusinessProcessorHelper.getHeadTableName((Context)ctx, (String)srcBillId0));
        sb.append(" ");
        sb.append("src");
        sb.append(" ON ");
        sb.append("src");
        sb.append(".FID=");
        sb.append("srce");
        sb.append(".FParentID ");
        sb.append("WHERE ");
        sb.append("srce");
        sb.append(".FID IN(");
        sb.append("???");
        sb.append(")");
        if (this.getPolicy() != null && (sortColumns = this.getPolicy().getSortColumns()) != null) {
            int idx = 0;
            sb.append("ORDER BY ");
            for (ColumnItem citem : sortColumns) {
                if (idx > 0) {
                    sb.append(", ");
                }
                sb.append(citem.getAlias());
                sb.append(".");
                sb.append(citem.getName());
                sb.append(this.getPolicy().getSortTypes()[idx]);
                ++idx;
            }
        }
        return sb.toString();
    }

    @Override
    protected String buildObtainSrcIdSql(Context ctx) throws BOSException {
        boolean isHead = this.getParent().getParent().getActionLevel().equals((Object)ActionLevelEnum.HEAD);
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append("botpe");
        sb.append(".FSrcEntryID, ");
        sb.append("botpe");
        sb.append(".FDestEntryID");
        sb.append("\r\n");
        sb.append("FROM T_BOT_RelationEntry ");
        sb.append("botpe");
        sb.append("\r\n");
        sb.append("INNER JOIN T_BOT_Relation ");
        sb.append("botp");
        sb.append(" ON ");
        sb.append("botp");
        sb.append(".FID=");
        sb.append("botpe");
        sb.append(".FKeyID");
        sb.append("\r\n");
        sb.append("INNER JOIN ");
        sb.append(BusinessProcessorHelper.getEntryTableName((Context)ctx, (String)this.dstBillTypeId));
        sb.append(" ");
        sb.append("entry");
        sb.append(" ON ");
        sb.append("botpe");
        sb.append(".FDestEntryID=");
        sb.append("entry");
        sb.append(".FID ");
        sb.append("\r\n");
        sb.append("INNER JOIN ");
        sb.append(BusinessProcessorHelper.getHeadTableName((Context)ctx, (String)this.dstBillTypeId));
        sb.append(" ");
        sb.append("head");
        sb.append(" ON ");
        sb.append("head");
        sb.append(".FID=");
        sb.append("entry");
        sb.append(".FParentID ");
        sb.append("\r\n");
        sb.append(SqlBuilderHelper.buildWhereClause(this.getConditions(), isHead));
        sb.append("AND ");
        sb.append("botp");
        sb.append(".FSrcEntityID=?");
        return sb.toString();
    }

    private String buildWriteBackOneByOneSql(Context ctx) throws BOSException {
        StringBuffer sb = new StringBuffer();
        String srcBillId = null;
        srcBillId = this.getLevel() == 1 ? (String)this.getSrcBillIds().get(0) : (String)this.getSrcBillIds().get(this.getSrcBillIds().size() - 1);
        sb.append("UPDATE ");
        sb.append(BusinessProcessorHelper.getEntryTableName((Context)ctx, (String)srcBillId));
        sb.append("\r\n");
        sb.append("SET ");
        sb.append(this.getUpdColList(this.getColumnPairs()));
        sb.append("\r\n");
        sb.append("WHERE FID=?");
        return sb.toString();
    }

    private String getUpdColList(List columnPairList) {
        StringBuffer sb = new StringBuffer();
        int size = columnPairList.size();
        for (int i = 0; i < size; ++i) {
            ColumnPair pair = (ColumnPair)columnPairList.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(pair.getSrcColumn());
            sb.append("=?");
        }
        return sb.toString();
    }

    public String getObtainSrcTableDataSql() {
        return this.obtainSrcTableDataSql;
    }

    public String getObtainDstTableDataSql() {
        return this.obtainDstTableDataSql;
    }

    public String getWriteBackOneByOneSql() {
        return this.writeBackOneByOneSql;
    }
}

