/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.dynbusiness.config;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBusinessBatchBuild;
import com.kingdee.eas.dynbusiness.IBusinessBatchHandle;
import com.kingdee.eas.dynbusiness.condition.ConditionItem;
import com.kingdee.eas.dynbusiness.condition.IPropertySupport;
import com.kingdee.eas.dynbusiness.condition.PropertyItem;
import com.kingdee.eas.dynbusiness.config.BOTProcessSubItem;
import com.kingdee.eas.dynbusiness.config.BOTSourceItem;
import com.kingdee.eas.dynbusiness.config.Property;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.DataConverter;
import com.kingdee.eas.dynbusiness.util.InitializationHelper;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ValueMappingItem
implements IBusinessBatchHandle,
IBusinessBatchBuild {
    private List properties;
    private List values;
    private Object parent;
    private boolean isInSubItem;
    private boolean isInitialized = false;
    private List selectorList;

    @Override
    public void handle(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException {
        if (!this.isInitialized) {
            this.build(ctx);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("_CTX", ctx);
        if (this.isInSubItem) {
            BOTProcessSubItem subItem = (BOTProcessSubItem)this.parent;
            paramMap.put("_ENTRISENAME", BusinessProcessUtil.getEntityEntriesName(ctx, subItem.getDstBosType()));
            IObjectCollection dataSources = subItem.getSourceItem().getDataSource(batchResults);
            this.handleValueMapping(ctx, dataSources, batchResults.getTransformResult(subItem.getId()).getBills(), paramMap, subItem.getDstBosType());
        } else {
            BOTSourceItem souceItem = (BOTSourceItem)this.parent;
            BOSObjectType bosType = souceItem.getKey() != null ? souceItem.getParent().getParent().getDstBosType(souceItem.getKey()) : BOSObjectType.create((String)souceItem.getParent().getParent().getParent().getBosType());
            IObjectCollection dataSources = souceItem.getKey() == null ? batchResults.getObjCollection() : batchResults.getTransformResult(souceItem.getKey()).getBills();
            this.handleValueMapping(ctx, dataSources, dataSources, paramMap, bosType);
        }
    }

    @Override
    public synchronized void build(Context ctx) throws BOSException {
        if (this.isInitialized) {
            return;
        }
        HashMap subEntities = new HashMap();
        this.selectorList = new ArrayList();
        EntityObjectInfo srcEo = null;
        EntityObjectInfo dstEo = null;
        if (this.isInSubItem) {
            BOTProcessSubItem subItem = (BOTProcessSubItem)this.parent;
            srcEo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(subItem.getSrcBosType());
            dstEo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(subItem.getDstBosType());
        } else {
            BOTSourceItem souceItem = (BOTSourceItem)this.parent;
            srcEo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(souceItem.getParent().getSrcBosType());
            dstEo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(souceItem.getParent().getDstBosType());
        }
        for (ConditionItem item : this.values) {
            InitializationHelper.preTreatingConditionItem(ctx, srcEo, subEntities, this.selectorList, item);
        }
        for (Property property : this.properties) {
            if (property.getName().startsWith("[")) continue;
            property.setPropInfo(BusinessProcessUtil.getPropertyInfo(dstEo, property.getName(), property.getName().split("\\."), subEntities));
        }
        this.isInitialized = true;
    }

    public void resetTempValue(IObjectCollection oldCollection, IObjectCollection newCollection) {
        if (oldCollection == null || oldCollection.size() == 0) {
            return;
        }
        Iterator iter = this.properties.iterator();
        ArrayList<String> tempProperties = new ArrayList<String>();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            if (!property.getName().startsWith("[")) continue;
            tempProperties.add(property.getName().substring(1, property.getName().length() - 1));
        }
        if (tempProperties.size() == 0) {
            return;
        }
        Object[] arrayProps = tempProperties.toArray();
        int size = oldCollection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue oldValue = oldCollection.getObject(i);
            IObjectValue newValue = newCollection.getObject(i);
            for (int j = 0; j < arrayProps.length; ++j) {
                newValue.put((String)arrayProps[j], oldValue.get((String)arrayProps[j]));
            }
        }
    }

    private void handleValueMapping(Context ctx, IObjectCollection dataSources, IObjectCollection dstCollection, Map paramMap, BOSObjectType dstBosType) throws EASBizException, BOSException {
        if (this.properties == null || this.properties.size() == 0) {
            return;
        }
        String dstEntriesName = (String)paramMap.get("_ENTRISENAME");
        boolean oneToone = false;
        if (dataSources.size() == dstCollection.size()) {
            oneToone = true;
        }
        int size = dstCollection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objValue = dstCollection.getObject(i);
            int idxOfProp = 0;
            int valueSize = this.values.size();
            for (int idxOfValue = 0; idxOfValue < valueSize; ++idxOfValue) {
                ConditionItem valueItem = (ConditionItem)this.values.get(idxOfValue);
                Object value = null;
                if (valueItem instanceof IPropertySupport) {
                    BOSObjectType bosType;
                    IObjectValue srcObjValue;
                    IObjectValue iObjectValue = srcObjValue = oneToone ? dataSources.getObject(i) : dataSources.getObject(0);
                    if (valueItem instanceof PropertyItem && (bosType = ((PropertyItem)valueItem).getBosType()) != null && bosType.equals((Object)dstBosType)) {
                        String entriesName = BusinessProcessUtil.getEntityEntriesName(ctx, bosType);
                        paramMap.put("_ENTRISENAME", entriesName);
                        srcObjValue = objValue;
                    }
                    value = ((IPropertySupport)((Object)valueItem)).getValue(srcObjValue, 0, paramMap, null);
                } else {
                    value = valueItem.getName();
                }
                if (value == null) {
                    ++idxOfProp;
                    continue;
                }
                if (value instanceof Object[]) {
                    idxOfProp = this.mappingArrayValue(ctx, objValue, this.properties, idxOfProp, (Object[])value, dstEntriesName, paramMap);
                    continue;
                }
                Property property = (Property)this.properties.get(idxOfProp++);
                this.setObjValue(ctx, objValue, property, value, dstEntriesName, 0);
            }
        }
    }

    private int mappingArrayValue(Context ctx, IObjectValue objValue, List properties, int idxOfProp, Object[] values, String dstEntriesName, Map paramMap) throws BOSException, EASBizException {
        String entryName = (String)paramMap.get("_ENTRISENAME") + ".";
        Property property = (Property)properties.get(idxOfProp);
        if (property.getName().startsWith(entryName)) {
            IObjectCollection collection = (IObjectCollection)objValue.get((String)paramMap.get("_ENTRISENAME"));
            if (collection == null || collection.size() == 0) {
                return ++idxOfProp;
            }
            int size = collection.size();
            for (int i = 0; i < values.length && i < size; ++i) {
                Object value = values[i];
                if (value == null) continue;
                this.setObjValue(ctx, collection.getObject(i), property, value, dstEntriesName, 1);
            }
            return ++idxOfProp;
        }
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value == null) continue;
            property = (Property)properties.get(idxOfProp++);
            this.setObjValue(ctx, objValue, property, value, dstEntriesName, 0);
        }
        return idxOfProp;
    }

    public List getSelectorList(Context ctx) throws BOSException {
        if (!this.isInitialized) {
            this.build(ctx);
        }
        return this.selectorList;
    }

    public ValueMappingItem(Object parent, List properties, List values) {
        this.parent = parent;
        this.properties = properties;
        this.values = values;
        this.isInSubItem = parent instanceof BOTProcessSubItem;
    }

    private void setObjValue(Context ctx, IObjectValue objValue, Property property, Object value, String dstEntriesName, int level) throws BOSException, EASBizException {
        DataType dataType = property.getDataType();
        String[] splits = property.getSplits();
        if (level == 0 && splits.length > 1 && splits[0].equals(dstEntriesName)) {
            IObjectCollection entries = (IObjectCollection)objValue.get(dstEntriesName);
            if (entries == null) {
                return;
            }
            int size = entries.size();
            for (int idxOfEntry = 0; idxOfEntry < size; ++idxOfEntry) {
                this.setObjValue(ctx, entries.getObject(idxOfEntry), property, value, dstEntriesName, level + 1);
            }
            return;
        }
        String key = splits[level];
        if (DataType.ENUM.equals((Object)dataType)) {
            if (!(value instanceof String)) {
                return;
            }
            BizEnumInfo enumInfo = ((OwnPropertyInfo)property.getPropInfo()).getEnumType();
            if (enumInfo.getDataType().equals((Object)BizEnumValueType.INTEGER)) {
                objValue.put(key, (Object)Integer.valueOf((String)value));
            } else if (enumInfo.getDataType().equals((Object)BizEnumValueType.INTEGER)) {
                objValue.put(key, value);
            }
        } else if (dataType != null && value instanceof String) {
            try {
                Object result = DataConverter.stringConvert((String)value, dataType, null);
                if (dataType.equals((Object)DataType.OBJECTPK)) {
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    objValue.put(key, BusinessProcessUtil.getLinkObject(ctx, property.getPropInfo(), (IObjectPK)result, selector));
                }
                objValue.put(key, result);
            }
            catch (DataConverter.DataConvertException e) {
                throw new BOSException((Throwable)e);
            }
        } else if (key.startsWith("[")) {
            key = key.substring(1, key.length() - 1);
            objValue.put(key, value);
        } else if (dataType.equals((Object)DataType.STRING) && !(value instanceof String)) {
            objValue.put(key, (Object)value.toString());
        } else {
            objValue.put(key, value);
        }
    }
}

